{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTau: TFloatTime;
    procedure SetTau(const Value: TFloatTime);
    function GetTolerance: Single;
    procedure SetTolerance(const Value: Single);
    function GetOrder: Integer;
    procedure SetOrder(const Value: Integer);
  public
    property Tau: TFloatTime read GetTau write SetTau;
    property Tolerance: Single read GetTolerance write SetTolerance;
    property Order: Integer read GetOrder write SetOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractDamperNode ----------------------------------------------- }

function TAbstractDamperNode.GetTau: TFloatTime;
begin
  Result := FdTau.Value;
end;

procedure TAbstractDamperNode.SetTau(const Value: TFloatTime);
begin
  FdTau.Send(Value);
end;

function TAbstractDamperNode.GetTolerance: Single;
begin
  Result := FdTolerance.Value;
end;

procedure TAbstractDamperNode.SetTolerance(const Value: Single);
begin
  FdTolerance.Send(Value);
end;

function TAbstractDamperNode.GetOrder: Integer;
begin
  Result := FdOrder.Value;
end;

procedure TAbstractDamperNode.SetOrder(const Value: Integer);
begin
  FdOrder.Send(Value);
end;

{$endif read_implementation}
