#ifndef _SEETA_COMMON_ALIGNMENT_H
#define _SEETA_COMMON_ALIGNMENT_H
#include <cstdint>

/**
 * \brief ʱ㷨
 */
enum SAMPLING_TYPE
{
	LINEAR,	///< Բ
	BICUBIC	///< Cubic 
};

/**
 * \brief ڱԵʱıԵ㷨
 */
enum PADDING_TYPE
{
    ZERO_PADDING,           ///< 0 
    NEAREST_PADDING,        ///< 
};

/**
 * \brief ͨüӿ
 * \param image_data ͼ  height * width * channels ĴֽڱʾĻҶֵ0  255
 * \param image_width ͼƬ
 * \param image_height ͼƬ߶
 * \param image_channels ͼƬͨɫͼƬһΪ 3ҶͼƬһΪ 1
 * \param crop_data ͼCrop õݣ[crop_width + pad_left + pad_right, crop_height + pad_top + pad_bottom, image_channels] С
 * \param crop_width ȣڱ׼ȡĿȣ\b ͼĿȣpadӰ
 * \param crop_height ߶ȣڱ׼ȡĸ߶ȣ\b ͼĸ߶ȣpadӰ
 * \param points λ㣬 {(x1, y1), (x2, y2), ...} ĸʽ
 * \param points_num 
 * \param mean_shape ƽģͣ {(x1, y1), (x2, y2), ...} ĸʽ
 * \param mean_shape_width ƽģ͵Ŀ
 * \param mean_shape_height ƽģ͵ĸ߶
 * \param pad_top չΪʾ
 * \param pad_bottom չΪʾ
 * \param pad_left չΪʾ
 * \param pad_right չΪʾ
 * \param final_points üӦ꣬ {(x1, y1), (x2, y2), ...} ĸʽ
 * \param type ʱֵʹõķ
 * \return üǷɹ
 * \note üСΪ [crop_width + pad_left + pad_right, crop_height + pad_top + pad_bottom] ĴС
 */
bool face_crop_core(
	const uint8_t *image_data, int image_width, int image_height, int image_channels,
	uint8_t *crop_data, int crop_width, int crop_height,
	const float *points, int points_num,
	const float *mean_shape, int mean_shape_width, int mean_shape_height,
	int pad_top = 0, int pad_bottom = 0, int pad_left = 0, int pad_right = 0,
	float *final_points = nullptr,
	SAMPLING_TYPE type = LINEAR);

bool face_crop_core_ex(
    const uint8_t *image_data, int image_width, int image_height, int image_channels,
    uint8_t *crop_data, int crop_width, int crop_height,
    const float *points, int points_num,
    const float *mean_shape, int mean_shape_width, int mean_shape_height,
    int pad_top = 0, int pad_bottom = 0, int pad_left = 0, int pad_right = 0,
    float *final_points = nullptr,
    SAMPLING_TYPE type = LINEAR,
    PADDING_TYPE ptype = ZERO_PADDING);

#endif // _SEETA_COMMON_ALIGNMENT_H
