/*
 * Simulator of microcontrollers (glob_r800.cc)
 *
 * Copyright (C) 2024 Drotos Daniel
 * 
 * To contact author send email to dr.dkdb@gmail.com
 *
 */

/* This file is part of microcontroller simulator: ucsim.

UCSIM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

UCSIM is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with UCSIM; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA. */
/*@1@*/

#include "glob.h"

// ready till C8

#define T(a,b) ((a<<8)+b)

u16_t r800_ttab_00[256]= {
  /*           0  1  2   3      4   5  6  7      8  9  a  b      c  d  e  f */
    /*0*/      1, 3, 2,  1,     1,  1, 2, 1,     1, 1, 2, 1,     1, 1, 2, 1,
    /*1*/ T(3,2), 3, 2,  1,     1,  1, 2, 1,     3, 1, 2, 1,     1, 1, 2, 1,
    /*2*/ T(3,2), 3, 5,  1,     1,  1, 2, 1,T(3,2), 1, 5, 1,     1, 1, 2, 1,
    /*3*/ T(3,2), 3, 4,  1,     4,  4, 3, 1,T(3,2), 1, 4, 1,     1, 1, 2, 1,
    /*4*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 1, 1, 1,     1, 1, 2, 1,
    /*5*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 1, 1, 1,     1, 1, 2, 1,
    /*6*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 1, 1, 1,     1, 1, 2, 1,
    /*7*/      2, 2, 2,  2,     2,  2, 2, 2,     1, 1, 1, 1,     1, 1, 2, 1,
    /*         0  1  2   3      4   5  6  7      8  9  a  b      c  d  e  f */
    /*8*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 4, 4, 4,     4, 4, 2, 4,
    /*9*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 1, 1, 1,     1, 1, 2, 1,
    /*a*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 1, 1, 1,     1, 1, 2, 1,
    /*b*/      1, 1, 1,  1,     1,  1, 2, 1,     1, 1, 1, 1,     1, 1, 2, 1,
    /*c*/ T(3,1), 3, 3,  3,T(5,3),  4, 2, 4,T(3,1), 3, 3, 0,T(5,3), 5, 2, 4,
    /*d*/ T(3,1), 3, 3,  3,T(5,3),  4, 2, 4,T(3,1), 1, 3, 3,T(5,3), 0, 2, 4,
    /*e*/ T(3,1), 3, 3,  5,T(5,3),  4, 2, 4,T(3,1), 1, 3, 1,T(5,3), 0, 2, 4,
    /*f*/ T(3,1), 3, 3,  2,T(5,3),  4, 2, 4,T(3,1), 1, 3, 1,T(5,3), 0, 2, 4
    /*         0  1  2   3      4   5  6  7      8  9  a  b      c  d  e  f */
};

u16_t r800_ttab_ed[256]= {
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*0*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*1*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*2*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*3*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*4*/  3,  3,  2,  6,  2,  5,  3,  2,  3,  3,  2,  5,  0, 14,  0,  2,
  /*5*/  3,  3,  2,  6,  0,  0,  3,  2,  3,  3,  2,  6,  0,  0,  3,  2,
  /*6*/  3,  3,  2, 20,  0,  0,  0,  5,  3,  3,  2, 20,  0,  0,  0,  5,
  /*7*/  3, 12,  2,  6,  0,  0,  0,  0,  3,  3,  2,  6,  0,  0,  0,  0,
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*8*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*9*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*a*/  4,  4,  4,  4,  0,  0,  0,  0,  4,  4,  4,  4,  0,  0,  0,  0,

  /*b*/  4, T(4,3),T(21,16), T(4,3), 0, 0, 0, 0,
         4,      5,  T(4,3), T(4,3), 0, 0, 0, 0,
  
  /*c*/  0, 14,  0, 36,  0,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,
  /*d*/  0, 14,  0, 36,  0,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,
  /*e*/  0, 14,  0, 36,  0,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,
  /*f*/  0, 14,  0, 36,  0,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
};

u16_t r800_ttab_cb[256]= {
  /*    0  1  2  3  4  5   6  7  8  9  a  b  c  d   e  f */
  /*0*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*1*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*2*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*3*/ 8, 8, 8, 8, 8, 8, 15, 8, 2, 2, 2, 2, 2, 2,  5, 2,
  /*4*/ 2, 2, 2, 2, 2, 2,  3, 2, 2, 2, 2, 2, 2, 2,  3, 2,
  /*5*/ 2, 2, 2, 2, 2, 2,  3, 2, 2, 2, 2, 2, 2, 2,  3, 2,
  /*6*/ 2, 2, 2, 2, 2, 2,  3, 2, 2, 2, 2, 2, 2, 2,  3, 2,
  /*7*/ 2, 2, 2, 2, 2, 2,  3, 2, 2, 2, 2, 2, 2, 2,  3, 2,
  /*    0  1  2  3  4  5   6  7  8  9  a  b  c  d   e  f */
  /*8*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*9*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*a*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*b*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*c*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*d*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*e*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2,
  /*f*/ 2, 2, 2, 2, 2, 2,  5, 2, 2, 2, 2, 2, 2, 2,  5, 2
  /*    0  1  2  3  4  5   6  7  8  9  a  b  c  d   e  f */
};

u16_t r800_ttab_dd[256]= {
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*0*/  0,  0,  0,  0,  2,  2,  0,  0,  0,  2,  0,  0,  2,  2,  0,  0,
  /*1*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,
  /*2*/  0,  4,  6,  2,  8,  8,  3,  0,  0,  2,  6,  2,  8,  8,  3,  0,
  /*3*/  0,  0,  0,  0,  7,  7,  5,  0,  0,  2,  0,  0,  0,  0,  0,  0,
  /*4*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*5*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*6*/  2,  2,  8,  8,  8,  8,  5,  8,  2,  2,  8,  8,  8,  8,  5,  8,
  /*7*/  5,  5,  5,  5,  5,  5,  0,  5,  2,  2,  0,  0,  8,  8,  5,  0,
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*8*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*9*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*a*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*b*/  2,  2,  0,  0,  8,  8,  5,  0,  5,  0,  0,  0,  8,  8,  5,  0,
  /*c*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*d*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*e*/  0,  4,  0,  6,  0,  5,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,
  /*f*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
};

u16_t r800_ttab_fd[256]= {
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*0*/  0,  0,  0,  0,  2,  2,  0,  0,  0,  2,  0,  0,  2,  2,  0,  0,
  /*1*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,
  /*2*/  0,  4,  6,  2,  8,  8,  3,  0,  0,  2,  6,  2,  8,  8,  3,  0,
  /*3*/  0,  0,  0,  0,  7,  7,  5,  0,  0,  2,  0,  0,  0,  0,  0,  0,
  /*4*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*5*/  2,  2,  0,  0,  8,  8,  5,  2,  2,  0,  0,  0,  8,  8,  5,  0,
  /*6*/  2,  2,  8,  8,  8,  8,  5,  8,  2,  2,  8,  8,  8,  8,  5,  8,
  /*7*/  5,  5,  5,  5,  5,  5,  0,  5,  2,  2,  0,  0,  8,  8,  5,  0,
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*8*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*9*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*a*/  2,  2,  0,  0,  8,  8,  5,  0,  2,  2,  0,  0,  8,  8,  5,  0,
  /*b*/  2,  2,  0,  0,  8,  8,  5,  0,  5,  0,  0,  0,  8,  8,  5,  0,
  /*c*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*d*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  /*e*/  0,  4,  0,  6,  0,  5,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,
  /*f*/  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
};

u16_t r800_ttab_ddcb[256]= {
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*0*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*1*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*2*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*3*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*4*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*5*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*6*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*7*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*8*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*9*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*a*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*b*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*c*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*d*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*e*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*f*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
};

u16_t r800_ttab_fdcb[256]= {
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*0*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*1*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*2*/ 23, 23, 23, 23, 23, 23,  7, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*3*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,  7, 23,
  /*4*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*5*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*6*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*7*/ 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20, 20,  5, 20,
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
  /*8*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*9*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*a*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*b*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*c*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*d*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*e*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
  /*f*/ 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23
  /*     0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
};

#undef T


/* End of z80.src/glob_r800.cc */
