// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Align, Buildable, Container, IconSize, Orientable, Orientation, ReliefStyle, ResizeMode,
    ToolItem, ToolShell, ToolbarStyle, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkToolbar")]
    pub struct Toolbar(Object<ffi::GtkToolbar, ffi::GtkToolbarClass>) @extends Container, Widget, @implements Buildable, Orientable, ToolShell;

    match fn {
        type_ => || ffi::gtk_toolbar_get_type(),
    }
}

impl Toolbar {
    pub const NONE: Option<&'static Toolbar> = None;

    #[doc(alias = "gtk_toolbar_new")]
    pub fn new() -> Toolbar {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_toolbar_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Toolbar`] objects.
    ///
    /// This method returns an instance of [`ToolbarBuilder`](crate::builders::ToolbarBuilder) which can be used to create [`Toolbar`] objects.
    pub fn builder() -> ToolbarBuilder {
        ToolbarBuilder::new()
    }
}

impl Default for Toolbar {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Toolbar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ToolbarBuilder {
    builder: glib::object::ObjectBuilder<'static, Toolbar>,
}

impl ToolbarBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn icon_size(self, icon_size: IconSize) -> Self {
        Self {
            builder: self.builder.property("icon-size", icon_size),
        }
    }

    pub fn icon_size_set(self, icon_size_set: bool) -> Self {
        Self {
            builder: self.builder.property("icon-size-set", icon_size_set),
        }
    }

    pub fn show_arrow(self, show_arrow: bool) -> Self {
        Self {
            builder: self.builder.property("show-arrow", show_arrow),
        }
    }

    pub fn toolbar_style(self, toolbar_style: ToolbarStyle) -> Self {
        Self {
            builder: self.builder.property("toolbar-style", toolbar_style),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn orientation(self, orientation: Orientation) -> Self {
        Self {
            builder: self.builder.property("orientation", orientation),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Toolbar`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Toolbar {
        self.builder.build()
    }
}

pub trait ToolbarExt: 'static {
    #[doc(alias = "gtk_toolbar_get_drop_index")]
    #[doc(alias = "get_drop_index")]
    fn drop_index(&self, x: i32, y: i32) -> i32;

    #[doc(alias = "gtk_toolbar_get_icon_size")]
    #[doc(alias = "get_icon_size")]
    fn icon_size(&self) -> IconSize;

    #[doc(alias = "gtk_toolbar_get_item_index")]
    #[doc(alias = "get_item_index")]
    fn item_index(&self, item: &impl IsA<ToolItem>) -> i32;

    #[doc(alias = "gtk_toolbar_get_n_items")]
    #[doc(alias = "get_n_items")]
    fn n_items(&self) -> i32;

    #[doc(alias = "gtk_toolbar_get_nth_item")]
    #[doc(alias = "get_nth_item")]
    fn nth_item(&self, n: i32) -> Option<ToolItem>;

    #[doc(alias = "gtk_toolbar_get_relief_style")]
    #[doc(alias = "get_relief_style")]
    fn relief_style(&self) -> ReliefStyle;

    #[doc(alias = "gtk_toolbar_get_show_arrow")]
    #[doc(alias = "get_show_arrow")]
    fn shows_arrow(&self) -> bool;

    #[doc(alias = "gtk_toolbar_get_style")]
    #[doc(alias = "get_style")]
    fn style(&self) -> ToolbarStyle;

    #[doc(alias = "gtk_toolbar_insert")]
    fn insert(&self, item: &impl IsA<ToolItem>, pos: i32);

    #[doc(alias = "gtk_toolbar_set_drop_highlight_item")]
    fn set_drop_highlight_item(&self, tool_item: Option<&impl IsA<ToolItem>>, index_: i32);

    #[doc(alias = "gtk_toolbar_set_icon_size")]
    fn set_icon_size(&self, icon_size: IconSize);

    #[doc(alias = "gtk_toolbar_set_show_arrow")]
    fn set_show_arrow(&self, show_arrow: bool);

    #[doc(alias = "gtk_toolbar_set_style")]
    fn set_style(&self, style: ToolbarStyle);

    #[doc(alias = "gtk_toolbar_unset_icon_size")]
    fn unset_icon_size(&self);

    #[doc(alias = "gtk_toolbar_unset_style")]
    fn unset_style(&self);

    #[doc(alias = "icon-size-set")]
    fn is_icon_size_set(&self) -> bool;

    #[doc(alias = "icon-size-set")]
    fn set_icon_size_set(&self, icon_size_set: bool);

    #[doc(alias = "toolbar-style")]
    fn toolbar_style(&self) -> ToolbarStyle;

    #[doc(alias = "toolbar-style")]
    fn set_toolbar_style(&self, toolbar_style: ToolbarStyle);

    fn item_expands<T: IsA<crate::Widget>>(&self, item: &T) -> bool;

    fn set_item_expand<T: IsA<crate::Widget>>(&self, item: &T, expand: bool);

    fn item_is_homogeneous<T: IsA<crate::Widget>>(&self, item: &T) -> bool;

    fn set_item_homogeneous<T: IsA<crate::Widget>>(&self, item: &T, homogeneous: bool);

    #[doc(alias = "focus-home-or-end")]
    fn connect_focus_home_or_end<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_focus_home_or_end(&self, focus_home: bool) -> bool;

    #[doc(alias = "orientation-changed")]
    fn connect_orientation_changed<F: Fn(&Self, Orientation) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "popup-context-menu")]
    fn connect_popup_context_menu<F: Fn(&Self, i32, i32, i32) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "style-changed")]
    fn connect_style_changed<F: Fn(&Self, ToolbarStyle) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-size")]
    fn connect_icon_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-size-set")]
    fn connect_icon_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-arrow")]
    fn connect_show_arrow_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "toolbar-style")]
    fn connect_toolbar_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Toolbar>> ToolbarExt for O {
    fn drop_index(&self, x: i32, y: i32) -> i32 {
        unsafe { ffi::gtk_toolbar_get_drop_index(self.as_ref().to_glib_none().0, x, y) }
    }

    fn icon_size(&self) -> IconSize {
        unsafe {
            from_glib(ffi::gtk_toolbar_get_icon_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn item_index(&self, item: &impl IsA<ToolItem>) -> i32 {
        unsafe {
            ffi::gtk_toolbar_get_item_index(
                self.as_ref().to_glib_none().0,
                item.as_ref().to_glib_none().0,
            )
        }
    }

    fn n_items(&self) -> i32 {
        unsafe { ffi::gtk_toolbar_get_n_items(self.as_ref().to_glib_none().0) }
    }

    fn nth_item(&self, n: i32) -> Option<ToolItem> {
        unsafe {
            from_glib_none(ffi::gtk_toolbar_get_nth_item(
                self.as_ref().to_glib_none().0,
                n,
            ))
        }
    }

    fn relief_style(&self) -> ReliefStyle {
        unsafe {
            from_glib(ffi::gtk_toolbar_get_relief_style(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_arrow(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_toolbar_get_show_arrow(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn style(&self) -> ToolbarStyle {
        unsafe { from_glib(ffi::gtk_toolbar_get_style(self.as_ref().to_glib_none().0)) }
    }

    fn insert(&self, item: &impl IsA<ToolItem>, pos: i32) {
        unsafe {
            ffi::gtk_toolbar_insert(
                self.as_ref().to_glib_none().0,
                item.as_ref().to_glib_none().0,
                pos,
            );
        }
    }

    fn set_drop_highlight_item(&self, tool_item: Option<&impl IsA<ToolItem>>, index_: i32) {
        unsafe {
            ffi::gtk_toolbar_set_drop_highlight_item(
                self.as_ref().to_glib_none().0,
                tool_item.map(|p| p.as_ref()).to_glib_none().0,
                index_,
            );
        }
    }

    fn set_icon_size(&self, icon_size: IconSize) {
        unsafe {
            ffi::gtk_toolbar_set_icon_size(self.as_ref().to_glib_none().0, icon_size.into_glib());
        }
    }

    fn set_show_arrow(&self, show_arrow: bool) {
        unsafe {
            ffi::gtk_toolbar_set_show_arrow(self.as_ref().to_glib_none().0, show_arrow.into_glib());
        }
    }

    fn set_style(&self, style: ToolbarStyle) {
        unsafe {
            ffi::gtk_toolbar_set_style(self.as_ref().to_glib_none().0, style.into_glib());
        }
    }

    fn unset_icon_size(&self) {
        unsafe {
            ffi::gtk_toolbar_unset_icon_size(self.as_ref().to_glib_none().0);
        }
    }

    fn unset_style(&self) {
        unsafe {
            ffi::gtk_toolbar_unset_style(self.as_ref().to_glib_none().0);
        }
    }

    fn is_icon_size_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "icon-size-set")
    }

    fn set_icon_size_set(&self, icon_size_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "icon-size-set", icon_size_set)
    }

    fn toolbar_style(&self) -> ToolbarStyle {
        glib::ObjectExt::property(self.as_ref(), "toolbar-style")
    }

    fn set_toolbar_style(&self, toolbar_style: ToolbarStyle) {
        glib::ObjectExt::set_property(self.as_ref(), "toolbar-style", toolbar_style)
    }

    fn item_expands<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "expand",
        )
    }

    fn set_item_expand<T: IsA<crate::Widget>>(&self, item: &T, expand: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "expand",
            &expand,
        )
    }

    fn item_is_homogeneous<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "homogeneous",
        )
    }

    fn set_item_homogeneous<T: IsA<crate::Widget>>(&self, item: &T, homogeneous: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "homogeneous",
            &homogeneous,
        )
    }

    fn connect_focus_home_or_end<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn focus_home_or_end_trampoline<
            P: IsA<Toolbar>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkToolbar,
            focus_home: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Toolbar::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(focus_home),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"focus-home-or-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    focus_home_or_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_focus_home_or_end(&self, focus_home: bool) -> bool {
        self.emit_by_name("focus-home-or-end", &[&focus_home])
    }

    fn connect_orientation_changed<F: Fn(&Self, Orientation) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn orientation_changed_trampoline<
            P: IsA<Toolbar>,
            F: Fn(&P, Orientation) + 'static,
        >(
            this: *mut ffi::GtkToolbar,
            orientation: ffi::GtkOrientation,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Toolbar::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(orientation),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"orientation-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    orientation_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_context_menu<
        F: Fn(&Self, i32, i32, i32) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn popup_context_menu_trampoline<
            P: IsA<Toolbar>,
            F: Fn(&P, i32, i32, i32) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkToolbar,
            x: libc::c_int,
            y: libc::c_int,
            button: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Toolbar::from_glib_borrow(this).unsafe_cast_ref(),
                x,
                y,
                button,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"popup-context-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    popup_context_menu_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_changed<F: Fn(&Self, ToolbarStyle) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn style_changed_trampoline<
            P: IsA<Toolbar>,
            F: Fn(&P, ToolbarStyle) + 'static,
        >(
            this: *mut ffi::GtkToolbar,
            style: ffi::GtkToolbarStyle,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Toolbar::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(style),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"style-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    style_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_size_trampoline<P: IsA<Toolbar>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkToolbar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Toolbar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_size_set_trampoline<
            P: IsA<Toolbar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkToolbar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Toolbar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-size-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_arrow_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_arrow_trampoline<P: IsA<Toolbar>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkToolbar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Toolbar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-arrow\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_arrow_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_toolbar_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_toolbar_style_trampoline<
            P: IsA<Toolbar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkToolbar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Toolbar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::toolbar-style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_toolbar_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Toolbar {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Toolbar")
    }
}
