// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Align, Buildable, Container, Justification, Label, Misc, Widget};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkAccelLabel")]
    pub struct AccelLabel(Object<ffi::GtkAccelLabel, ffi::GtkAccelLabelClass>) @extends Label, Misc, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_accel_label_get_type(),
    }
}

impl AccelLabel {
    pub const NONE: Option<&'static AccelLabel> = None;

    #[doc(alias = "gtk_accel_label_new")]
    pub fn new(string: &str) -> AccelLabel {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_accel_label_new(string.to_glib_none().0)).unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`AccelLabel`] objects.
    ///
    /// This method returns an instance of [`AccelLabelBuilder`](crate::builders::AccelLabelBuilder) which can be used to create [`AccelLabel`] objects.
    pub fn builder() -> AccelLabelBuilder {
        AccelLabelBuilder::new()
    }
}

impl Default for AccelLabel {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AccelLabel`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AccelLabelBuilder {
    builder: glib::object::ObjectBuilder<'static, AccelLabel>,
}

impl AccelLabelBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accel_closure(self, accel_closure: &glib::Closure) -> Self {
        Self {
            builder: self
                .builder
                .property("accel-closure", accel_closure.clone()),
        }
    }

    pub fn accel_widget(self, accel_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("accel-widget", accel_widget.clone().upcast()),
        }
    }

    pub fn angle(self, angle: f64) -> Self {
        Self {
            builder: self.builder.property("angle", angle),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn ellipsize(self, ellipsize: pango::EllipsizeMode) -> Self {
        Self {
            builder: self.builder.property("ellipsize", ellipsize),
        }
    }

    pub fn justify(self, justify: Justification) -> Self {
        Self {
            builder: self.builder.property("justify", justify),
        }
    }

    pub fn label(self, label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("label", label.into()),
        }
    }

    pub fn lines(self, lines: i32) -> Self {
        Self {
            builder: self.builder.property("lines", lines),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn mnemonic_widget(self, mnemonic_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonic-widget", mnemonic_widget.clone().upcast()),
        }
    }

    pub fn pattern(self, pattern: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("pattern", pattern.into()),
        }
    }

    pub fn selectable(self, selectable: bool) -> Self {
        Self {
            builder: self.builder.property("selectable", selectable),
        }
    }

    pub fn single_line_mode(self, single_line_mode: bool) -> Self {
        Self {
            builder: self.builder.property("single-line-mode", single_line_mode),
        }
    }

    pub fn track_visited_links(self, track_visited_links: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("track-visited-links", track_visited_links),
        }
    }

    pub fn use_markup(self, use_markup: bool) -> Self {
        Self {
            builder: self.builder.property("use-markup", use_markup),
        }
    }

    pub fn use_underline(self, use_underline: bool) -> Self {
        Self {
            builder: self.builder.property("use-underline", use_underline),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn wrap(self, wrap: bool) -> Self {
        Self {
            builder: self.builder.property("wrap", wrap),
        }
    }

    pub fn wrap_mode(self, wrap_mode: pango::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    pub fn yalign(self, yalign: f32) -> Self {
        Self {
            builder: self.builder.property("yalign", yalign),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`AccelLabel`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> AccelLabel {
        self.builder.build()
    }
}

pub trait AccelLabelExt: 'static {
    #[doc(alias = "gtk_accel_label_get_accel")]
    #[doc(alias = "get_accel")]
    fn accel(&self) -> (u32, gdk::ModifierType);

    #[doc(alias = "gtk_accel_label_get_accel_widget")]
    #[doc(alias = "get_accel_widget")]
    fn accel_widget(&self) -> Option<Widget>;

    #[doc(alias = "gtk_accel_label_get_accel_width")]
    #[doc(alias = "get_accel_width")]
    fn accel_width(&self) -> u32;

    #[doc(alias = "gtk_accel_label_refetch")]
    fn refetch(&self) -> bool;

    #[doc(alias = "gtk_accel_label_set_accel")]
    fn set_accel(&self, accelerator_key: u32, accelerator_mods: gdk::ModifierType);

    #[doc(alias = "gtk_accel_label_set_accel_closure")]
    fn set_accel_closure(&self, accel_closure: Option<&glib::Closure>);

    #[doc(alias = "gtk_accel_label_set_accel_widget")]
    fn set_accel_widget(&self, accel_widget: Option<&impl IsA<Widget>>);

    #[doc(alias = "accel-closure")]
    fn accel_closure(&self) -> Option<glib::Closure>;

    #[doc(alias = "accel-closure")]
    fn connect_accel_closure_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "accel-widget")]
    fn connect_accel_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<AccelLabel>> AccelLabelExt for O {
    fn accel(&self) -> (u32, gdk::ModifierType) {
        unsafe {
            let mut accelerator_key = mem::MaybeUninit::uninit();
            let mut accelerator_mods = mem::MaybeUninit::uninit();
            ffi::gtk_accel_label_get_accel(
                self.as_ref().to_glib_none().0,
                accelerator_key.as_mut_ptr(),
                accelerator_mods.as_mut_ptr(),
            );
            (
                accelerator_key.assume_init(),
                from_glib(accelerator_mods.assume_init()),
            )
        }
    }

    fn accel_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_accel_label_get_accel_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn accel_width(&self) -> u32 {
        unsafe { ffi::gtk_accel_label_get_accel_width(self.as_ref().to_glib_none().0) }
    }

    fn refetch(&self) -> bool {
        unsafe { from_glib(ffi::gtk_accel_label_refetch(self.as_ref().to_glib_none().0)) }
    }

    fn set_accel(&self, accelerator_key: u32, accelerator_mods: gdk::ModifierType) {
        unsafe {
            ffi::gtk_accel_label_set_accel(
                self.as_ref().to_glib_none().0,
                accelerator_key,
                accelerator_mods.into_glib(),
            );
        }
    }

    fn set_accel_closure(&self, accel_closure: Option<&glib::Closure>) {
        unsafe {
            ffi::gtk_accel_label_set_accel_closure(
                self.as_ref().to_glib_none().0,
                accel_closure.to_glib_none().0,
            );
        }
    }

    fn set_accel_widget(&self, accel_widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_accel_label_set_accel_widget(
                self.as_ref().to_glib_none().0,
                accel_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn accel_closure(&self) -> Option<glib::Closure> {
        glib::ObjectExt::property(self.as_ref(), "accel-closure")
    }

    fn connect_accel_closure_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accel_closure_trampoline<
            P: IsA<AccelLabel>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAccelLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AccelLabel::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accel-closure\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accel_closure_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_accel_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accel_widget_trampoline<
            P: IsA<AccelLabel>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAccelLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AccelLabel::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accel-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accel_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for AccelLabel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("AccelLabel")
    }
}
