description("Test rgba() color parsing results");

var ctx = document.createElement('canvas').getContext('2d');

function parse(rgba) {
    ctx.globalCompositeOperation = 'copy';
    ctx.fillStyle = '#666';
    ctx.fillStyle = rgba;
    ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);
    var idata = ctx.getImageData(0, 0, 1, 1);
    var data = idata.data;
    return "RGBA[" + data[0] + ", " + data[1] + ", " + data[2] + ", " + data[3] + "]";
}

shouldBe("parse('rgba(0.9.9%, 0%, 0%, 1)')", "'RGBA[102, 102, 102, 255]'");
shouldBe("parse('rgba(0, 0.., 0, 1)')", "'RGBA[102, 102, 102, 255]'");
shouldBe("parse('rgba(10%, .%, 0%, 1)')", "'RGBA[102, 102, 102, 255]'");
shouldBe("parse('rgba(13.37%1337%, 5%, 50.0%, 1)')", "'RGBA[102, 102, 102, 255]'");
shouldBe("parse('rgba(%, 50%, 50.0%, 1)')", "'RGBA[102, 102, 102, 255]'");
shouldBe("parse('rgba(50.0%, 50%, a%, 1)')", "'RGBA[102, 102, 102, 255]'");
shouldBe("parse('rgba(500%, 0%, 0%, 1)')", "'RGBA[255, 0, 0, 255]'");
shouldBe("parse('rgba(100%, 100%, 100%, 1)')", "'RGBA[255, 255, 255, 255]'");
shouldBe("parse('rgba(10.5%, 80%, 70%, 1)')", "'RGBA[26, 204, 179, 255]'");
shouldBe("parse('rgba(0%, 0%, 0%, 1)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(50.0%, 50.0%, 50.0%, 1)')", "'RGBA[128, 128, 128, 255]'");
shouldBe("parse('rgba(100%, 100%, 100%, 1)')", "'RGBA[255, 255, 255, 255]'");
shouldBe("parse('rgba(10.5%, 80%, 70%, 1)')", "'RGBA[26, 204, 179, 255]'");
shouldBe("parse('rgba(55.5%, 0.5%, 110%, 1)')", "'RGBA[142, 1, 255, 255]'");
shouldBe("parse('rgba(60.59998%, 0.59999%, 110.12345%, 1)')", "'RGBA[155, 1, 255, 255]'");
shouldBe("parse('rgba(10.999%, 0.999%, 0.000009%, 1)')", "'RGBA[28, 2, 0, 255]'");
shouldBe("parse('rgba(79.99999%, 99.99999%, 500%, 1)')", "'RGBA[204, 255, 255, 255]'");
shouldBe("parse('rgba(0, 0, 0, -0.10)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, -5.0)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, 5.0)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, -1)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, 0)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, 2)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, 2.0)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, 0.0)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, 00.0)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, 0.00)')", "'RGBA[0, 0, 0, 0]'");
shouldBe("parse('rgba(0, 0, 0, .1)')", "'RGBA[0, 0, 0, 25]'");
shouldBe("parse('rgba(0, 0, 0, .2)')", "'RGBA[0, 0, 0, 51]'");
shouldBe("parse('rgba(0, 0, 0, .3)')", "'RGBA[0, 0, 0, 76]'");
shouldBe("parse('rgba(0, 0, 0, .4)')", "'RGBA[0, 0, 0, 102]'");
shouldBe("parse('rgba(0, 0, 0, .5)')", "'RGBA[0, 0, 0, 127]'");
shouldBe("parse('rgba(0, 0, 0, .6)')", "'RGBA[0, 0, 0, 153]'");
shouldBe("parse('rgba(0, 0, 0, .7)')", "'RGBA[0, 0, 0, 179]'");
shouldBe("parse('rgba(0, 0, 0, .8)')", "'RGBA[0, 0, 0, 204]'");
shouldBe("parse('rgba(0, 0, 0, .9)')", "'RGBA[0, 0, 0, 230]'");
shouldBe("parse('rgba(0, 0, 0, 0.1)')", "'RGBA[0, 0, 0, 25]'");
shouldBe("parse('rgba(0, 0, 0, 0.2)')", "'RGBA[0, 0, 0, 51]'");
shouldBe("parse('rgba(0, 0, 0, 0.3)')", "'RGBA[0, 0, 0, 76]'");
shouldBe("parse('rgba(0, 0, 0, 0.4)')", "'RGBA[0, 0, 0, 102]'");
shouldBe("parse('rgba(0, 0, 0, 0.5)')", "'RGBA[0, 0, 0, 127]'");
shouldBe("parse('rgba(0, 0, 0, 0.6)')", "'RGBA[0, 0, 0, 153]'");
shouldBe("parse('rgba(0, 0, 0, 0.7)')", "'RGBA[0, 0, 0, 179]'");
shouldBe("parse('rgba(0, 0, 0, 0.8)')", "'RGBA[0, 0, 0, 204]'");
shouldBe("parse('rgba(0, 0, 0, 0.9)')", "'RGBA[0, 0, 0, 230]'");
shouldBe("parse('rgba(0, 0, 0, 1.0)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, 0.10)')", "'RGBA[0, 0, 0, 25]'");
shouldBe("parse('rgba(0, 0, 0, 0.20)')", "'RGBA[0, 0, 0, 51]'");
shouldBe("parse('rgba(0, 0, 0, 0.30)')", "'RGBA[0, 0, 0, 76]'");
shouldBe("parse('rgba(0, 0, 0, 0.40)')", "'RGBA[0, 0, 0, 102]'");
shouldBe("parse('rgba(0, 0, 0, 0.50)')", "'RGBA[0, 0, 0, 127]'");
shouldBe("parse('rgba(0, 0, 0, 0.60)')", "'RGBA[0, 0, 0, 153]'");
shouldBe("parse('rgba(0, 0, 0, 0.70)')", "'RGBA[0, 0, 0, 179]'");
shouldBe("parse('rgba(0, 0, 0, 0.80)')", "'RGBA[0, 0, 0, 204]'");
shouldBe("parse('rgba(0, 0, 0, 0.90)')", "'RGBA[0, 0, 0, 230]'");
shouldBe("parse('rgba(0, 0, 0, 1.00)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, .10)')", "'RGBA[0, 0, 0, 25]'");
shouldBe("parse('rgba(0, 0, 0, .20)')", "'RGBA[0, 0, 0, 51]'");
shouldBe("parse('rgba(0, 0, 0, .30)')", "'RGBA[0, 0, 0, 76]'");
shouldBe("parse('rgba(0, 0, 0, .40)')", "'RGBA[0, 0, 0, 102]'");
shouldBe("parse('rgba(0, 0, 0, .50)')", "'RGBA[0, 0, 0, 127]'");
shouldBe("parse('rgba(0, 0, 0, .60)')", "'RGBA[0, 0, 0, 153]'");
shouldBe("parse('rgba(0, 0, 0, .70)')", "'RGBA[0, 0, 0, 179]'");
shouldBe("parse('rgba(0, 0, 0, .80)')", "'RGBA[0, 0, 0, 204]'");
shouldBe("parse('rgba(0, 0, 0, .90)')", "'RGBA[0, 0, 0, 230]'");
shouldBe("parse('rgba(0, 0, 0, 0.10000000000000000000000)')", "'RGBA[0, 0, 0, 25]'");
shouldBe("parse('rgba(0, 0, 0, 0.20000000000000000000000)')", "'RGBA[0, 0, 0, 51]'");
shouldBe("parse('rgba(0, 0, 0, 0.30000000000000000000000)')", "'RGBA[0, 0, 0, 76]'");
shouldBe("parse('rgba(0, 0, 0, 0.40000000000000000000000)')", "'RGBA[0, 0, 0, 102]'");
shouldBe("parse('rgba(0, 0, 0, 0.50000000000000000000000)')", "'RGBA[0, 0, 0, 127]'");
shouldBe("parse('rgba(0, 0, 0, 0.60000000000000000000000)')", "'RGBA[0, 0, 0, 153]'");
shouldBe("parse('rgba(0, 0, 0, 0.70000000000000000000000)')", "'RGBA[0, 0, 0, 179]'");
shouldBe("parse('rgba(0, 0, 0, 0.80000000000000000000000)')", "'RGBA[0, 0, 0, 204]'");
shouldBe("parse('rgba(0, 0, 0, 0.90000000000000000000000)')", "'RGBA[0, 0, 0, 230]'");
shouldBe("parse('rgba(0, 0, 0, 1.00000000000000000000000)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, 0.990)')", "'RGBA[0, 0, 0, 253]'");
shouldBe("parse('rgba(0, 0, 0, 0.991)')", "'RGBA[0, 0, 0, 253]'");
shouldBe("parse('rgba(0, 0, 0, 0.992)')", "'RGBA[0, 0, 0, 253]'");
shouldBe("parse('rgba(0, 0, 0, 0.993)')", "'RGBA[0, 0, 0, 254]'");
shouldBe("parse('rgba(0, 0, 0, 0.994)')", "'RGBA[0, 0, 0, 254]'");
shouldBe("parse('rgba(0, 0, 0, 0.995)')", "'RGBA[0, 0, 0, 254]'");
shouldBe("parse('rgba(0, 0, 0, 0.996)')", "'RGBA[0, 0, 0, 254]'");
shouldBe("parse('rgba(0, 0, 0, 0.997)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, 0.998)')", "'RGBA[0, 0, 0, 255]'");
shouldBe("parse('rgba(0, 0, 0, 0.999)')", "'RGBA[0, 0, 0, 255]'");
