package coremodules

import (
        "bytes"
        "strings"
        "testing"
        "github.com/spf13/cobra"
)

func CobraExeCaller(t *testing.T, root *cobra.Command, args []string) (string, error) {
        buf := new(bytes.Buffer)
        root.SetOutput(buf)
        root.SetArgs(args)
        _, err := root.ExecuteC()
        return buf.String(), err
}

func TestDeepinSystemFixPkg(t *testing.T) {

        Caller := func(root *cobra.Command, args ...string) {
                out, err := CobraExeCaller(t, root, args)
                t.Log(out)
                if err != nil {
                        t.Errorf("Calling command without subcommands should not have error: %v", err)
                }
        }

        //t.SkipNow()

	t.Run("deepin-system-fixpkg:check --check-config -d",func (t *testing.T) {
		Argv := strings.Split("check --check-config -d", " ")
		Caller(rootCmd, Argv...)
	})

	t.Run("deepin-system-fixpkg:fix --fix-config -d",func (t *testing.T) {
		Argv := strings.Split("fix --fix-config -d", " ")
		Caller(rootCmd, Argv...)
	})
}