package coremodules

import (
	"fmt"

	"github.com/heysion/deepin-system-update-tools/internal/controller/fixpkg"
	"github.com/heysion/deepin-system-update-tools/pkg/log"
	"github.com/heysion/deepin-system-update-tools/pkg/utils/ecode"
	"github.com/spf13/cobra"
)

// versionCmd represents the version command
var checkConfig bool
var fixCheck = &cobra.Command{
	Use:   "check",
	Short: "Check system update",
	Long:  `Check system update with rules that pre/mid/post-check.`,
	Run: func(cmd *cobra.Command, args []string) {
		// log.Debugf("check")
		// log.Debugf("config:%s", ConfigCfg)

		if checkConfig {
			if err := fixpkg.CheckConfig(); err != nil {
				log.Errorf("fixpkg check: %v", err)
				CheckRetMsg.SetErrorExtMsg(ecode.CHK_ERROR, ecode.PKG_CHK_CONFIG_ERROR, fmt.Sprintf("fix/check dpkg config: %v", err))
				return
			} else {
				log.Infof("fixpkg check not found error")
				return
			}
		} else {
			// check all depends
			if err := fixpkg.CheckDpkgListStat(); err != nil {
				CheckRetMsg.SetErrorExtMsg(ecode.CHK_ERROR, ecode.CHK_PKG_DEPEND_ERROR, fmt.Sprintf("fix/check dpkg state: %v", err))
				return
			}

		}
	},
}

func init() {
	rootCmd.AddCommand(fixCheck)
	fixCheck.Flags().BoolVarP(&checkConfig, "check-config", "", false, "check package configure falt")
}
