#ifndef REPORTEVENT_H
#define REPORTEVENT_H

#include <string>
#include <functional>
#include "boost/serialization/singleton.hpp"
#include "eventlog_stub.h"

using namespace std;
//using InitCallBack = std::function<void(bool)>;

class ReportEvent : public boost::serialization::singleton<ReportEvent>
{
public:
    ReportEvent();
    ~ReportEvent();

    bool Init();

    // void InitAsync(const std::function<void(bool)> &cb);

    void Stop();

    void PostEvent(const string &packagename, const string &evdata);

    void SendEvent(const string &packagename, const string &evdata);

private:
    // void GetBusProxyAsync(void *p);

    bool GetBusProxy();

    void FreeBusProxy();

    // static void OnAsyncInitableReady(GObject *source_object, GAsyncResult *res, gpointer user_data);

    static void OnNameAppeared(GDBusConnection *connection,
                               const gchar     *name,
                               const gchar     *name_owner,
                               gpointer         user_data);

    static void OnNameVanished(GDBusConnection *connection,
                               const gchar     *name,
                               gpointer         user_data);

    static void* LoopWatch(void *p);

private:
    EventLog1   *m_busproxy;
    guint       m_watchid;
    GMainLoop   *m_mainloop;
    pthread_t   m_pthrd;
    //std::function<void(bool)> m_callback;
};

#endif // REPORTEVENT_H
