% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_to_signatures.R
\name{fit_to_signatures}
\alias{fit_to_signatures}
\title{Find optimal nonnegative linear combination of mutation signatures to
reconstruct the mutation matrix.}
\usage{
fit_to_signatures(mut_matrix, signatures)
}
\arguments{
\item{mut_matrix}{mutation count matrix (dimensions: x mutation types
X n samples)}

\item{signatures}{Signature matrix (dimensions: x mutation types
X n signatures)}
}
\value{
Named list with signature contributions and reconstructed
mutation matrix
}
\description{
Find the linear combination of mutation signatures that most closely
reconstructs the mutation matrix by solving the nonnegative least-squares
constraints problem.
}
\examples{

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Get signatures
signatures <- get_known_signatures()

## Perform the fitting
fit_res <- fit_to_signatures(mut_mat, signatures)

## This will also work for indels and dbs.
## An example is given for indels

## Get The indel counts
## See 'count_indel_contexts()' for more info on how to do this.
indel_counts <- readRDS(system.file("states/blood_indel_counts.rds",
  package = "MutationalPatterns"
))

## Get signatures
signatures <- get_known_signatures("indel")

fit_to_signatures(indel_counts, signatures)
}
\seealso{
\code{\link{mut_matrix}},\code{\link{fit_to_signatures_strict}},\code{\link{fit_to_signatures_bootstrapped}}
}
