/**
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var truncateMiddle = require( './../lib' );

var str = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.';
var out = truncateMiddle( str, 15 );
console.log( out );
// => 'Lorem ... elit.'

str = 'To be or not to be, that is the question';
out = truncateMiddle( str, 19, '|' );
console.log( out );
// => 'To be or | question'

str = 'The quick fox jumps over the lazy dog.';
out = truncateMiddle( str, 28, '...' );
console.log( out );
// => 'The quick fox...he lazy dog.'

str = '🐺 Wolf Brothers 🐺';
out = truncateMiddle( str, 7 );
console.log( out );
// => '🐺 ... 🐺'

str = '🐺 Wolf Pack 🐺';
out = truncateMiddle( str, 7, '🐺🐺🐺' );
console.log( out );
// => '🐺 🐺🐺🐺 🐺'
