import React, { Component } from 'react';
import { Tabs } from '@redux-devtools/ui';
import Connection from './Connection';
import Themes from './Themes';
import StateTree from './StateTree';

interface State {
  selected: string;
}

// eslint-disable-next-line @typescript-eslint/ban-types
export default class Settings extends Component<{}, State> {
  tabs = [
    { name: 'Connection', component: Connection },
    { name: 'Themes', component: Themes },
    { name: 'State Tree', component: StateTree },
  ];
  state: State = { selected: 'Connection' };

  handleSelect = (selected: string) => {
    this.setState({ selected });
  };

  render() {
    return (
      // eslint-disable-next-line @typescript-eslint/ban-types
      <Tabs<{}>
        tabs={this.tabs as any}
        selected={this.state.selected}
        onClick={this.handleSelect}
      />
    );
  }
}
