MODULE MANINP;

% Author: James H. Davenport.

% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
%    * Redistributions of source code must retain the relevant copyright
%      notice, this list of conditions and the following disclaimer.
%    * Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNERS OR
% CONTRIBUTORS
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.
%


FLUID '(INTVAR);

SYMBOLIC PROCEDURE FINDMANINPARM PLACES;
BEGIN
  SCALAR SQRTS,VARS,U;
  SQRTS:=SQRTSINPLACES PLACES;
LOOP:
  IF NULL SQRTS THEN RETURN NIL;
  VARS:=GETVARIABLES SIMP ARGOF CAR SQRTS;
INNERLOOP:
  IF NULL VARS
    THEN <<
      SQRTS:=CDR SQRTS;
      GO TO LOOP >>;
  U:=CAR VARS;
  VARS:=CDR VARS;
  IF U EQ INTVAR
    THEN GO TO INNERLOOP;
  IF ATOM U
    THEN RETURN U;
  IF CAR U EQ 'SQRT
    THEN << U:=SIMP ARGOF U;
            VARS:=VARSINSF(NUMR U,VARSINSF(DENR U,VARS));
            GO TO INNERLOOP >>;
  INTERR "Unrecognised differentiation candidate"
  END;

ENDMODULE;

END;
