/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_WMJACK_PRIVATE_H
#define DTK_WMJACK_PRIVATE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "dtk_wmjack.h"

// window
typedef int (*InitBackendPtr)();
typedef void (*DestroyBackendPtr)();

typedef int (*MaximizeWindowPtr)(WindowId /*wid*/);
typedef int (*MinimizeWindowPtr)(WindowId wid);
typedef int (*RestoreWindowPtr)(WindowId wid);
typedef char *(*GetWindowTextPtr)(WindowId wid);
typedef Size (*GetWindowSizePtr)(WindowId wid);
typedef Position (*GetWindowPositionPtr)(WindowId wid);
typedef WindowId (*GetActiveWindowIDPtr)();
typedef WindowId (*GetDesktopWindowIDPtr)();
typedef int (*GetWindowChildrenPtr)(WindowId wid, WindowId **pChildIDs);
typedef Position (*GetPointerPositionPtr)();
typedef void (*FreeWindowListPtr)(WindowId *windownlist);
typedef struct dtk_array *(*GetAllWindowStatesPtr)();
typedef WindowState *(*GetWindowStatePtr)(WindowId wid);
typedef int (*GetWindowPIDPtr)(WindowId wid);
typedef WindowId (*GetWindowFromPointPtr)();
typedef void (*ShowSplitMenuPtr)(int x, int y, int width, int height, WindowId wid);
typedef void (*HideSplitMenuPtr)(bool delay, WindowId wid);
typedef char *(*GetRendererStringPtr)();
typedef WindowState (*GetSpecificWindowStatePtr)(uint32_t wid);
typedef int (*GetAllWindowStatesListPtr)(WindowState **states);

typedef struct Dtk_WmJack
{
    void *backend;
    char *xdgSessionType;
    bool isWayland;
    void *userData;

    // init and destory
    InitBackendPtr InitBackend;
    DestroyBackendPtr DestroyBackend;

    // window
    MaximizeWindowPtr MaximizeWindow;
    MinimizeWindowPtr MinimizeWindow;
    RestoreWindowPtr RestoreWindow;
    GetWindowTextPtr GetWindowText;
    GetWindowSizePtr GetWindowSize;
    GetWindowPositionPtr GetWindowPosition;
    GetActiveWindowIDPtr GetActiveWindowID;
    GetDesktopWindowIDPtr GetDesktopWindowID;
    GetWindowChildrenPtr GetWindowChildren;
    GetPointerPositionPtr GetPointerPosition;
    FreeWindowListPtr FreeWindowList;
    GetAllWindowStatesPtr GetAllWindowStates;
    GetWindowStatePtr GetWindowState;
    GetWindowPIDPtr GetWindowPID;
    GetWindowFromPointPtr GetWindowFromPoint;
    ShowSplitMenuPtr ShowSplitMenu;
    HideSplitMenuPtr HideSplitMenu;
    GetRendererStringPtr GetRendererString;
    GetSpecificWindowStatePtr GetSpecificWindowState;
    GetAllWindowStatesListPtr GetAllWindowStatesList;
} DtkWmJack;

typedef struct Dtk_WmJack *DtkWmJackPtr;
extern DtkWmJackPtr pWmJack;

#ifdef __cplusplus
}
#endif

#endif