/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DWMJACK_H
#define DWMJACK_H

#include <QObject>
#include <dtk_wmjack.h>

class DWMJack : public QObject
{
    Q_OBJECT
public:
    explicit DWMJack(QObject *parent = nullptr);

    /**
     * @brief get the window effect switch status.
     * @return true open, false close
     */
    bool GetCompositorSwitchStatus(void);

    /**
     * @brief Maximize Window.
     * @param wid: window ID
     * @return 0 success, -1 failure
     */
    int MaximizeWindow(WindowId wid);

    /**
     * @brief Show Multitask View.
     * @return 0 success, -1 failure
     */
    int ToggleMultitaskView();

    /**
     * @brief Minimize Window.
     * @param wid: window ID
     * @return 0 success, -1 failure
     */
    int MinimizeWindow(WindowId wid);

    /**
     * @brief Get Window Title.
     * @param wid: window ID
     * @return -1 failure, otherwise success
     */
    char * GetWindowText(WindowId wid);

    /**
     * @brief Get Window Size.
     * @param wid: window ID
     * @return x:-1,y:-1 failure, otherwise success
     */
    Size GetWindowSize(WindowId wid);

    /**
     * @brief Get Window Position.
     * @param wid: window ID
     * @return w:-1,h:-1 failure, otherwise success
     */
    Position GetWindowPosition(WindowId wid);

    /**
     * @brief Get Active Window ID.
     * @return 0 failure, otherwise success
     */
    WindowId GetActiveWindowID();

    /**
     * @brief Get Desktop Window ID.
     * @return 0 failure, otherwise success
     */
    WindowId GetDesktopWindowID();

    /**
     * @brief Get Window Title.
     * @param wid: window ID
     * @param pChildIDs: child data
     * @return -1 failure, otherwise success
     */
    int GetWindowChildren(WindowId wid, WindowId **pChildIDs);

    /**
     * @brief Get Mouse Position.
     * @return w:-1,h:-1 failure, otherwise success
     */
    Position GetPointerPosition();

    /**
     * @brief free data.
     * @param windownlist: windowlist
     */
    void FreeWindowList(WindowId *windownlist);

    /**
     * @brief Get Window PID.
     * @param wid: window ID
     * @return -1 failure, otherwise success
     */
    int GetWindowPID(WindowId wid);

signals:

public slots:
};

#endif // DWMJACK_H