// SPDX-FileCopyrightText: 2011 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef X11CLIPBOARD_H
#define X11CLIPBOARD_H

#include <string>
#include <map>
#include <sched.h>

using namespace std;

class SystemClipboard;
class XwlDataBridge;
class ClipData;
class X11Clipboard
{
public:
    explicit X11Clipboard(SystemClipboard *clipboard);
    virtual ~X11Clipboard();

    void initConnect();

    void initXwl();
    void setDataToClipboard(ClipData *vClip);
    void clearClipboard();
private:
    SystemClipboard *m_systemclipboard;
    XwlDataBridge    *m_XwlDataBrige;
    pthread_t        m_xwldispatch;
};

#endif // COPYCLIENT_H
