// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Buildable;
use Justification;
use Menu;
use Misc;
use MovementStep;
use Widget;
use ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use libc;
use pango;
use signal::Inhibit;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct Label(Object<ffi::GtkLabel, ffi::GtkLabelClass>): Misc, Widget, Buildable;

    match fn {
        get_type => || ffi::gtk_label_get_type(),
    }
}

impl Label {
    pub fn new<'a, P: Into<Option<&'a str>>>(str: P) -> Label {
        assert_initialized_main_thread!();
        let str = str.into();
        let str = str.to_glib_none();
        unsafe {
            Widget::from_glib_none(ffi::gtk_label_new(str.0)).downcast_unchecked()
        }
    }

    pub fn new_with_mnemonic<'a, P: Into<Option<&'a str>>>(str: P) -> Label {
        assert_initialized_main_thread!();
        let str = str.into();
        let str = str.to_glib_none();
        unsafe {
            Widget::from_glib_none(ffi::gtk_label_new_with_mnemonic(str.0)).downcast_unchecked()
        }
    }
}

pub trait LabelExt {
    fn get_angle(&self) -> f64;

    fn get_attributes(&self) -> Option<pango::AttrList>;

    fn get_current_uri(&self) -> Option<String>;

    fn get_ellipsize(&self) -> pango::EllipsizeMode;

    fn get_justify(&self) -> Justification;

    fn get_label(&self) -> Option<String>;

    fn get_layout(&self) -> Option<pango::Layout>;

    fn get_layout_offsets(&self) -> (i32, i32);

    fn get_line_wrap(&self) -> bool;

    fn get_line_wrap_mode(&self) -> pango::WrapMode;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_lines(&self) -> i32;

    fn get_max_width_chars(&self) -> i32;

    fn get_mnemonic_keyval(&self) -> u32;

    fn get_mnemonic_widget(&self) -> Option<Widget>;

    fn get_selectable(&self) -> bool;

    fn get_selection_bounds(&self) -> Option<(i32, i32)>;

    fn get_single_line_mode(&self) -> bool;

    fn get_text(&self) -> Option<String>;

    fn get_track_visited_links(&self) -> bool;

    fn get_use_markup(&self) -> bool;

    fn get_use_underline(&self) -> bool;

    fn get_width_chars(&self) -> i32;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_xalign(&self) -> f32;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_yalign(&self) -> f32;

    fn select_region(&self, start_offset: i32, end_offset: i32);

    fn set_angle(&self, angle: f64);

    fn set_attributes<'a, P: Into<Option<&'a pango::AttrList>>>(&self, attrs: P);

    fn set_ellipsize(&self, mode: pango::EllipsizeMode);

    fn set_justify(&self, jtype: Justification);

    fn set_label(&self, str: &str);

    fn set_line_wrap(&self, wrap: bool);

    fn set_line_wrap_mode(&self, wrap_mode: pango::WrapMode);

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn set_lines(&self, lines: i32);

    fn set_markup(&self, str: &str);

    fn set_markup_with_mnemonic(&self, str: &str);

    fn set_max_width_chars(&self, n_chars: i32);

    fn set_mnemonic_widget<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, widget: Q);

    fn set_pattern(&self, pattern: &str);

    fn set_selectable(&self, setting: bool);

    fn set_single_line_mode(&self, single_line_mode: bool);

    fn set_text(&self, str: &str);

    fn set_text_with_mnemonic(&self, str: &str);

    fn set_track_visited_links(&self, track_links: bool);

    fn set_use_markup(&self, setting: bool);

    fn set_use_underline(&self, setting: bool);

    fn set_width_chars(&self, n_chars: i32);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_xalign(&self, xalign: f32);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_yalign(&self, yalign: f32);

    fn get_property_cursor_position(&self) -> i32;

    fn get_property_selection_bound(&self) -> i32;

    fn get_property_wrap(&self) -> bool;

    fn set_property_wrap(&self, wrap: bool);

    fn get_property_wrap_mode(&self) -> pango::WrapMode;

    fn set_property_wrap_mode(&self, wrap_mode: pango::WrapMode);

    fn connect_activate_current_link<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_current_link(&self);

    fn connect_activate_link<F: Fn(&Self, &str) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_copy_clipboard(&self);

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool);

    fn connect_populate_popup<F: Fn(&Self, &Menu) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_angle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_justify_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn connect_property_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_mnemonic_keyval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_mnemonic_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_selectable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_selection_bound_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_single_line_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_track_visited_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_use_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_yalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Label> + IsA<glib::object::Object> + glib::object::ObjectExt> LabelExt for O {
    fn get_angle(&self) -> f64 {
        unsafe {
            ffi::gtk_label_get_angle(self.to_glib_none().0)
        }
    }

    fn get_attributes(&self) -> Option<pango::AttrList> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_attributes(self.to_glib_none().0))
        }
    }

    fn get_current_uri(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_current_uri(self.to_glib_none().0))
        }
    }

    fn get_ellipsize(&self) -> pango::EllipsizeMode {
        unsafe {
            from_glib(ffi::gtk_label_get_ellipsize(self.to_glib_none().0))
        }
    }

    fn get_justify(&self) -> Justification {
        unsafe {
            from_glib(ffi::gtk_label_get_justify(self.to_glib_none().0))
        }
    }

    fn get_label(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_label(self.to_glib_none().0))
        }
    }

    fn get_layout(&self) -> Option<pango::Layout> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_layout(self.to_glib_none().0))
        }
    }

    fn get_layout_offsets(&self) -> (i32, i32) {
        unsafe {
            let mut x = mem::uninitialized();
            let mut y = mem::uninitialized();
            ffi::gtk_label_get_layout_offsets(self.to_glib_none().0, &mut x, &mut y);
            (x, y)
        }
    }

    fn get_line_wrap(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_line_wrap(self.to_glib_none().0))
        }
    }

    fn get_line_wrap_mode(&self) -> pango::WrapMode {
        unsafe {
            from_glib(ffi::gtk_label_get_line_wrap_mode(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_lines(&self) -> i32 {
        unsafe {
            ffi::gtk_label_get_lines(self.to_glib_none().0)
        }
    }

    fn get_max_width_chars(&self) -> i32 {
        unsafe {
            ffi::gtk_label_get_max_width_chars(self.to_glib_none().0)
        }
    }

    fn get_mnemonic_keyval(&self) -> u32 {
        unsafe {
            ffi::gtk_label_get_mnemonic_keyval(self.to_glib_none().0)
        }
    }

    fn get_mnemonic_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_mnemonic_widget(self.to_glib_none().0))
        }
    }

    fn get_selectable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_selectable(self.to_glib_none().0))
        }
    }

    fn get_selection_bounds(&self) -> Option<(i32, i32)> {
        unsafe {
            let mut start = mem::uninitialized();
            let mut end = mem::uninitialized();
            let ret = from_glib(ffi::gtk_label_get_selection_bounds(self.to_glib_none().0, &mut start, &mut end));
            if ret { Some((start, end)) } else { None }
        }
    }

    fn get_single_line_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_single_line_mode(self.to_glib_none().0))
        }
    }

    fn get_text(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_text(self.to_glib_none().0))
        }
    }

    fn get_track_visited_links(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_track_visited_links(self.to_glib_none().0))
        }
    }

    fn get_use_markup(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_use_markup(self.to_glib_none().0))
        }
    }

    fn get_use_underline(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_use_underline(self.to_glib_none().0))
        }
    }

    fn get_width_chars(&self) -> i32 {
        unsafe {
            ffi::gtk_label_get_width_chars(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_xalign(&self) -> f32 {
        unsafe {
            ffi::gtk_label_get_xalign(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_yalign(&self) -> f32 {
        unsafe {
            ffi::gtk_label_get_yalign(self.to_glib_none().0)
        }
    }

    fn select_region(&self, start_offset: i32, end_offset: i32) {
        unsafe {
            ffi::gtk_label_select_region(self.to_glib_none().0, start_offset, end_offset);
        }
    }

    fn set_angle(&self, angle: f64) {
        unsafe {
            ffi::gtk_label_set_angle(self.to_glib_none().0, angle);
        }
    }

    fn set_attributes<'a, P: Into<Option<&'a pango::AttrList>>>(&self, attrs: P) {
        let attrs = attrs.into();
        let attrs = attrs.to_glib_none();
        unsafe {
            ffi::gtk_label_set_attributes(self.to_glib_none().0, attrs.0);
        }
    }

    fn set_ellipsize(&self, mode: pango::EllipsizeMode) {
        unsafe {
            ffi::gtk_label_set_ellipsize(self.to_glib_none().0, mode.to_glib());
        }
    }

    fn set_justify(&self, jtype: Justification) {
        unsafe {
            ffi::gtk_label_set_justify(self.to_glib_none().0, jtype.to_glib());
        }
    }

    fn set_label(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_label(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_line_wrap(&self, wrap: bool) {
        unsafe {
            ffi::gtk_label_set_line_wrap(self.to_glib_none().0, wrap.to_glib());
        }
    }

    fn set_line_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        unsafe {
            ffi::gtk_label_set_line_wrap_mode(self.to_glib_none().0, wrap_mode.to_glib());
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn set_lines(&self, lines: i32) {
        unsafe {
            ffi::gtk_label_set_lines(self.to_glib_none().0, lines);
        }
    }

    fn set_markup(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_markup(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_markup_with_mnemonic(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_markup_with_mnemonic(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_max_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_label_set_max_width_chars(self.to_glib_none().0, n_chars);
        }
    }

    fn set_mnemonic_widget<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, widget: Q) {
        let widget = widget.into();
        let widget = widget.to_glib_none();
        unsafe {
            ffi::gtk_label_set_mnemonic_widget(self.to_glib_none().0, widget.0);
        }
    }

    fn set_pattern(&self, pattern: &str) {
        unsafe {
            ffi::gtk_label_set_pattern(self.to_glib_none().0, pattern.to_glib_none().0);
        }
    }

    fn set_selectable(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_selectable(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_single_line_mode(&self, single_line_mode: bool) {
        unsafe {
            ffi::gtk_label_set_single_line_mode(self.to_glib_none().0, single_line_mode.to_glib());
        }
    }

    fn set_text(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_text(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_text_with_mnemonic(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_text_with_mnemonic(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_track_visited_links(&self, track_links: bool) {
        unsafe {
            ffi::gtk_label_set_track_visited_links(self.to_glib_none().0, track_links.to_glib());
        }
    }

    fn set_use_markup(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_use_markup(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_use_underline(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_use_underline(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_label_set_width_chars(self.to_glib_none().0, n_chars);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_xalign(&self, xalign: f32) {
        unsafe {
            ffi::gtk_label_set_xalign(self.to_glib_none().0, xalign);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_yalign(&self, yalign: f32) {
        unsafe {
            ffi::gtk_label_set_yalign(self.to_glib_none().0, yalign);
        }
    }

    fn get_property_cursor_position(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "cursor-position".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_selection_bound(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "selection-bound".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_wrap(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "wrap".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_wrap(&self, wrap: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "wrap".to_glib_none().0, Value::from(&wrap).to_glib_none().0);
        }
    }

    fn get_property_wrap_mode(&self) -> pango::WrapMode {
        unsafe {
            let mut value = Value::from_type(<pango::WrapMode as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "wrap-mode".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "wrap-mode".to_glib_none().0, Value::from(&wrap_mode).to_glib_none().0);
        }
    }

    fn connect_activate_current_link<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "activate-current-link",
                transmute(activate_current_link_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_activate_current_link(&self) {
        let _ = self.emit("activate-current-link", &[]).unwrap();
    }

    fn connect_activate_link<F: Fn(&Self, &str) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &str) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "activate-link",
                transmute(activate_link_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "copy-clipboard",
                transmute(copy_clipboard_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_copy_clipboard(&self) {
        let _ = self.emit("copy-clipboard", &[]).unwrap();
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, MovementStep, i32, bool) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "move-cursor",
                transmute(move_cursor_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        let _ = self.emit("move-cursor", &[&step, &count, &extend_selection]).unwrap();
    }

    fn connect_populate_popup<F: Fn(&Self, &Menu) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Menu) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "populate-popup",
                transmute(populate_popup_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_angle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::angle",
                transmute(notify_angle_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::attributes",
                transmute(notify_attributes_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::cursor-position",
                transmute(notify_cursor_position_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::ellipsize",
                transmute(notify_ellipsize_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_justify_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::justify",
                transmute(notify_justify_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::label",
                transmute(notify_label_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn connect_property_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::lines",
                transmute(notify_lines_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::max-width-chars",
                transmute(notify_max_width_chars_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_mnemonic_keyval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::mnemonic-keyval",
                transmute(notify_mnemonic_keyval_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_mnemonic_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::mnemonic-widget",
                transmute(notify_mnemonic_widget_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pattern",
                transmute(notify_pattern_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_selectable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::selectable",
                transmute(notify_selectable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_selection_bound_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::selection-bound",
                transmute(notify_selection_bound_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_single_line_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::single-line-mode",
                transmute(notify_single_line_mode_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_track_visited_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::track-visited-links",
                transmute(notify_track_visited_links_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::use-markup",
                transmute(notify_use_markup_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_use_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::use-underline",
                transmute(notify_use_underline_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::width-chars",
                transmute(notify_width_chars_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::wrap",
                transmute(notify_wrap_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::wrap-mode",
                transmute(notify_wrap_mode_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::xalign",
                transmute(notify_xalign_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_yalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::yalign",
                transmute(notify_yalign_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn activate_current_link_trampoline<P>(this: *mut ffi::GtkLabel, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn activate_link_trampoline<P>(this: *mut ffi::GtkLabel, uri: *mut libc::c_char, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Label> {
    let f: &&(Fn(&P, &str) -> Inhibit + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked(), &String::from_glib_none(uri)).to_glib()
}

unsafe extern "C" fn copy_clipboard_trampoline<P>(this: *mut ffi::GtkLabel, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn move_cursor_trampoline<P>(this: *mut ffi::GtkLabel, step: ffi::GtkMovementStep, count: libc::c_int, extend_selection: glib_ffi::gboolean, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P, MovementStep, i32, bool) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked(), from_glib(step), count, from_glib(extend_selection))
}

unsafe extern "C" fn populate_popup_trampoline<P>(this: *mut ffi::GtkLabel, menu: *mut ffi::GtkMenu, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P, &Menu) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(menu))
}

unsafe extern "C" fn notify_angle_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_attributes_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_cursor_position_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_ellipsize_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_justify_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_label_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_10", feature = "dox"))]
unsafe extern "C" fn notify_lines_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_max_width_chars_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_mnemonic_keyval_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_mnemonic_widget_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pattern_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_selectable_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_selection_bound_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_single_line_mode_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_track_visited_links_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_use_markup_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_use_underline_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_width_chars_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_wrap_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_wrap_mode_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_xalign_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_yalign_trampoline<P>(this: *mut ffi::GtkLabel, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Label> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Label::from_glib_borrow(this).downcast_unchecked())
}
