// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use ArrowType;
use Buildable;
use Misc;
use ShadowType;
use Widget;
use ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct Arrow(Object<ffi::GtkArrow, ffi::GtkArrowClass>): Misc, Widget, Buildable;

    match fn {
        get_type => || ffi::gtk_arrow_get_type(),
    }
}

impl Arrow {
    #[cfg_attr(feature = "v3_14", deprecated)]
    pub fn new(arrow_type: ArrowType, shadow_type: ShadowType) -> Arrow {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_arrow_new(arrow_type.to_glib(), shadow_type.to_glib())).downcast_unchecked()
        }
    }
}

pub trait ArrowExt {
    #[cfg_attr(feature = "v3_14", deprecated)]
    fn set(&self, arrow_type: ArrowType, shadow_type: ShadowType);

    fn get_property_arrow_type(&self) -> ArrowType;

    fn set_property_arrow_type(&self, arrow_type: ArrowType);

    fn get_property_shadow_type(&self) -> ShadowType;

    fn set_property_shadow_type(&self, shadow_type: ShadowType);

    fn connect_property_arrow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Arrow> + IsA<glib::object::Object>> ArrowExt for O {
    fn set(&self, arrow_type: ArrowType, shadow_type: ShadowType) {
        unsafe {
            ffi::gtk_arrow_set(self.to_glib_none().0, arrow_type.to_glib(), shadow_type.to_glib());
        }
    }

    fn get_property_arrow_type(&self) -> ArrowType {
        unsafe {
            let mut value = Value::from_type(<ArrowType as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "arrow-type".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_arrow_type(&self, arrow_type: ArrowType) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "arrow-type".to_glib_none().0, Value::from(&arrow_type).to_glib_none().0);
        }
    }

    fn get_property_shadow_type(&self) -> ShadowType {
        unsafe {
            let mut value = Value::from_type(<ShadowType as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "shadow-type".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_shadow_type(&self, shadow_type: ShadowType) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "shadow-type".to_glib_none().0, Value::from(&shadow_type).to_glib_none().0);
        }
    }

    fn connect_property_arrow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::arrow-type",
                transmute(notify_arrow_type_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::shadow-type",
                transmute(notify_shadow_type_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_arrow_type_trampoline<P>(this: *mut ffi::GtkArrow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Arrow> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Arrow::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_shadow_type_trampoline<P>(this: *mut ffi::GtkArrow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Arrow> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Arrow::from_glib_borrow(this).downcast_unchecked())
}
