#!/usr/bin/env python

# -*- coding: utf8 -*-

#***********************************************************************
# pysycache : a program for learn to use the mouse
# Copyright (C) 2005-2007 Vincent DEROO (vincent.pysycache@free.fr) 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software 
# Foundation, Inc. : 
# 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
#***********************************************************************


import sys
import os
import pygame
import const
import datas
from pygame.locals import *
from pysyclasses import *


class BtnDirectory(pygame.sprite.Sprite):
	"""This class is for the menus buttons"""
	def __init__(self, id, dirname, text, rng):
		pygame.sprite.Sprite.__init__(self) 				#call Sprite intializer
#		(shortname, extension) = os.path.splitext(filename) 
		self.image, self.rect = datas.Load_image("images", "fond-directory.png")
		
		
#		text = font.render(username, 1, textcolor).convert_alpha()
#		(larg, haut) = text.get_size()
		self.image.blit(text, (2, 0))


#		(shortname, extension) = os.path.splitext(filename) 
#		self.imagename = shortname
		self.rect.left = 87
		self.rect.top = 97 + 27 * rng
		self.left = self.rect.left
		self.top = self.rect.top
		self.id = id
#		self.actif = False		#pour les gros boutons et activer l'evt click
		(self.largeur, self.hauteur) = self.image.get_size()



class BtnIhm:
	imagename = ""
	left = 0
	top = 0
	largeur = 0
	hauteur = 0
	id = 0


#*******************************************************************************
# adaptation of a discussion   (Timothy Downs)
#   http://permalink.gmane.org/gmane.comp.python.pygame/4366
# the message must be in UTF
#*******************************************************************************
def display_box(screen, title, message, WithButtons, Left = -1, Top = 0):
	"Print a message in a box in the middle of the screen"
	myfont = os.path.join(const.GRepPysycache, 'fonts', const.GFontName).encode(const.GConsoleLocale)

	font = pygame.font.Font(myfont, 20)
	textcolor = 46, 113, 169
	bgcolor = 128, 186, 234

	imgtext, rectext = datas.Load_image("images", "input-text.png")
	#titre
	text = font.render(title, 1, textcolor).convert_alpha()
	(larg, haut) = text.get_size()
	imgtext.blit(text, (int((420 - larg) / 2), 5 ))

	#texte pour expliquer la validation
	valid = datas.GetTextInLang("VALID0", "and press ENTER")
	text = font.render(valid, 1, textcolor).convert_alpha()
	(larg, haut) = text.get_size()
	imgbtn, recbtn = datas.Load_image("images", "btn-enter.png")
	imgtext.blit(imgbtn, (295, 120))
	imgtext.blit(text, (15, 130 ))

	#boutons
	if WithButtons == 1:
		(larg, haut) = imgtext.get_size()
		imgbtn, recbtn = datas.Load_image("images", "apply.png")
		imgtext.blit(imgbtn, (larg - 136, 140))
		imgbtn, recbtn = datas.Load_image("images", "cancel.png")
		imgtext.blit(imgbtn, (larg - 296, 140))
	
	
	if len(message) != 0:
		text = font.render(message, 1, textcolor).convert_alpha()
		imgtext.blit(text, (15, 40))

	(larg, haut) = imgtext.get_size()
	if Left == -1:
		#on centre la boite
		screen.blit(imgtext, (int((800 - larg) / 2), int(( 600 - haut) / 2) + 2 ))
	else:
		screen.blit(imgtext, (Left, Top))


#*******************************************************************************
# return a name in UTF-8
#        a name in the locale  
#        a return code : 0 if escape/cancel
#                        1 if OK
#*******************************************************************************
def ShowInputBox(title, defaultvalue = "", maxlength = 40, WithButtons = 0, Left = -1, Top=0):
	screen = pygame.display.get_surface()  
	imgtext, rectext = datas.Load_image("images", "input-text.png")
	(x, y) = imgtext.get_size()
	returnvalue = 1

	pygame.event.clear()
	oldsouris = const.GTypeSouris
	const.GTypeSouris = const.EVENT_NOVENT

	if WithButtons == 1 :
		const.GLstSouris.empty()
		const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
		for o in const.GLstSouris.sprites():
			o.move(const.Gbackground_image, int((800 + x) / 2), int((600 + y) / 2), int((800 - x) / 2), int( (600 - y )/ 2) )
		const.GLstSouris.draw(screen)

	textutf = defaultvalue				#texte en utf-8
	textscr = defaultvalue			#texte a l'ecran (en locale)

	display_box(screen, title, textutf, WithButtons, Left, Top)

	pygame.display.update()

	running = 1
	while running:
		datas.Temporisation()

		for event in pygame.event.get():
			if event.type == QUIT:
				returnvalue = 0
				running = 0
				break
			elif event.type == KEYUP:
				if event.key == K_ESCAPE:
					returnvalue = 0
					running = 0
					break
			elif event.type == MOUSEMOTION:
				if WithButtons == 1:
					screen = pygame.display.get_surface()
					event0 = event.pos[0] 
					event1 = event.pos[1] 

					#redessin de la souris a sa position actuelle
					const.GMaSourisCurrentPositionX = event0 
					const.GMaSourisCurrentPositionY = event1 
					for o in const.GLstSouris.sprites():
						o.move(const.Gbackground_image, int((800 + x) / 2), int((600 + y) / 2), int((800 - x) / 2), int( (600 - y )/ 2) )

					const.GLstSouris.draw(screen)
#			return True
			elif event.type == KEYDOWN:
				if event.key == K_BACKSPACE:
					textscr = textscr[0:-1]
					
#					textutf = textscr   #.decode(const.GConsoleLocale)  #.encode("utf-8")
					textutf = textscr.decode(const.GConsoleLocale, "ignore")

#					if const.GConsoleLocale == 'UTF-8':
#						toto = textscr         #.decode(const.GConsoleLocale)
#					else:
#						toto = textscr.decode(const.GConsoleLocale)
#					text = ''
#					for i in range(0, len(toto)):
#						if const.GConsoleLocale == 'UTF-8':
#							text += toto[i].encode("utf-8")
#						else:
#							text += toto[i].encode("utf-8")
					display_box(screen, title, textutf, WithButtons, Left, Top)
				elif event.key == K_RETURN:
					const.GTypeSouris = oldsouris
					running = 0
					break
				else:
					if event.key >= 30:
						if len(textscr) < maxlength :
#OK							if const.GConsoleLocale == 'UTF-8':
#OK								textscr += event.unicode
#OK							else:
#OK								textscr += event.unicode.encode(const.GConsoleLocale, "ignore")
							textscr += event.unicode.encode(const.GConsoleLocale, "ignore")

#							if const.GConsoleLocale == 'UTF-8':
#								text += event.unicode.encode("utf-8")file:/home/vincent
#							else:
#								text += event.unicode.encode("utf-8")			#pour la sauvegarde dans le fichier

#OK							textutf = textscr   #.decode(const.GConsoleLocale)
							textutf = textscr.decode(const.GConsoleLocale, "ignore")
							display_box(screen, title, textutf, WithButtons, Left, Top)

		pygame.display.update()

	pygame.event.clear()
	const.GTypeSouris = oldsouris

	return textutf, textscr, returnvalue



#*******************************************************************************
# TypeButtons : 1 : OK
#               2 : Oui - Non
#               3 : OK - Cancel
#*******************************************************************************
def ShowMessageBox(title, TypeButtons = 1, Left = -1, Top=0):
	screen = pygame.display.get_surface()  
	imgtext, rectext = datas.Load_image("images", "messagebox.png")
	(x, y) = imgtext.get_size()
	returnvalue = 1

	pygame.event.clear()
	oldsouris = const.GTypeSouris
	const.GTypeSouris = const.EVENT_NOVENT

	myfont = os.path.join(const.GRepPysycache, 'fonts', const.GFontName).encode(const.GConsoleLocale)
	font = pygame.font.Font(myfont, 20)
	textcolor = 46, 113, 169
	bgcolor = 128, 186, 234

	#titre
	text = font.render(title, 1, textcolor).convert_alpha()
	(larg, haut) = text.get_size()
	imgtext.blit(text, (int((420 - larg) / 2), 5 ))

	libel = datas.GetTextInLang("DEL0", "Do you confirm the deletion of the")
	text = font.render(libel, 1, textcolor).convert_alpha()
	imgtext.blit(text, (20, 40 ))
	libel = datas.GetTextInLang("DEL1", "selected user ?")
	text = font.render(libel, 1, textcolor).convert_alpha()
	imgtext.blit(text, (20, 70 ))

	const.Gbackground_image.blit(imgtext, (150 + const.MARGELEFT, 170 + const.MARGETOP ) )
	screen.blit(imgtext, (150 + const.MARGELEFT, 170 + const.MARGETOP ) )

	const.GTabBtnIhm[:] = []
	if TypeButtons == 1 :
		tab = BtnIhm()
		tab.left = 150 + const.MARGELEFT + 140
		tab.top =  170 + const.MARGETOP + 130
		tab.largeur = 140
		tab.hauteur = 40
		tab.imagename = 'btn-ok.png'
		tab.id = 14
		const.GTabBtnIhm.append(tab)
	elif TypeButtons == 2 :
		tab = BtnIhm()
		tab.left = 150 + const.MARGELEFT + 35
		tab.top =  170 + const.MARGETOP + 130
		tab.largeur = 140
		tab.hauteur = 40
		tab.imagename = 'btn-ok.png'
		tab.id = 14
		const.GTabBtnIhm.append(tab)
		tab = BtnIhm()
		tab.left = 150 + const.MARGELEFT + 210
		tab.top =  170 + const.MARGETOP + 130
		tab.largeur = 140
		tab.hauteur = 40
		tab.imagename = 'btn-cancel.png'
		tab.id = 15
		const.GTabBtnIhm.append(tab)

	for btn in const.GTabBtnIhm:
		imgtmp, recttmp = datas.Load_image("images", btn.imagename)
		if btn.id == 14 :
			libel = datas.GetTextInLang("OK", "OK")
		elif btn.id == 15 :
			libel = datas.GetTextInLang("NON", "No")
		text = font.render(libel, 1, textcolor).convert_alpha()
		imgtmp.blit(text, (40, 5 ))
		const.Gbackground_image.blit(imgtmp, (btn.left, btn.top))
		screen.blit(imgtmp, (btn.left, btn.top))

	const.GLstSouris.empty()
	const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
	for o in const.GLstSouris.sprites():
		o.move(const.Gbackground_image, 150 + const.MARGELEFT + 451, 170 + const.MARGETOP + 210, 150 + const.MARGELEFT, 170 + const.MARGETOP )
	const.GLstSouris.draw(screen)
	pygame.display.update((150 + const.MARGELEFT, 170 + const.MARGETOP, 470, 230 ))

	running = 1
	while running:
		datas.Temporisation()

		for event in pygame.event.get():
			if event.type == QUIT:
				returnvalue = 0
				running = 0
				break
			elif event.type == KEYUP:
				if event.key == K_ESCAPE:
					returnvalue = 0
					running = 0
					break
			elif event.type == MOUSEMOTION:
				event0 = event.pos[0] 
				event1 = event.pos[1] 

				#redessin de la souris a sa position actuelle
				const.GMaSourisCurrentPositionX = event0 
				const.GMaSourisCurrentPositionY = event1 
				for o in const.GLstSouris.sprites():
					o.move(const.Gbackground_image, 150 + const.MARGELEFT + 420, 170 + const.MARGETOP + 160, 150 + const.MARGELEFT, 170 + const.MARGETOP )

				const.GLstSouris.draw(screen)

				pygame.display.update((150 + const.MARGELEFT, 170 + const.MARGETOP, 470, 230 ))
			elif event.type == MOUSEBUTTONUP:
				#*************************** evenement clic ************************
				event0 = event.pos[0]
				event1 = event.pos[1]

				#recherche si est un bouton de menu
				for obj in const.GTabBtnIhm:
					if ( event0  >= obj.left ) & ( event0 <= obj.left + obj.largeur ) & ( event1 >= obj.top  ) & ( event1 <= obj.top + obj.hauteur ) :
						if obj.id == 14 : 
							#OK
							pass
						if obj.id == 15 : 
							returnvalue = 0
							#cancel
						running = 0
						break

	pygame.event.clear()
	const.GTypeSouris = oldsouris

	return returnvalue


#*******************************************************************************
#
#*******************************************************************************
def SearchAllDirectories():
	const.GTabDirectories[:] = []

	datas.DebugMessage("")
	datas.DebugMessage("Search directories in %s " % const.GCurrentDirectory)
	tab = BtnIhm()
	tab.imagename = ".."
	const.GTabDirectories.append(("..", tab))

	for f in os.listdir(const.GCurrentDirectory):
		if os.path.isdir(os.path.join(const.GCurrentDirectory, f)) == True:
			tab = BtnIhm()
			tab.imagename = f
			const.GTabDirectories.append((f, tab))

	const.GTabDirectories.sort()
	const.GFirstDirectory = 0


#*******************************************************************************
#
#*******************************************************************************
def ShowListDirectories():
	screen = pygame.display.get_surface()  
	imgtmp, recttmp = datas.Load_image("images", "input-file.png")
	const.Gbackground_image.blit(imgtmp , (0, 0)) 

	myfont = os.path.join(const.GRepPysycache, 'fonts', const.GFontName).encode(const.GConsoleLocale)
	font = pygame.font.Font(myfont, 18)
	textcolor = 46, 113, 169
	bgcolor = 128, 186, 234

	text = font.render(const.GCurrentDirectory, 1, textcolor).convert_alpha()
	(larg, haut) = text.get_size()
	if larg > 460 :
		tr2 = pygame.Rect([0, 0, 460, haut] )
		const.Gbackground_image.blit(text, (70 + const.MARGELEFT + 10, 40 + const.MARGETOP + 5 ), tr2)
	else:
		const.Gbackground_image.blit(text, (70 + const.MARGELEFT + 10, 40 + const.MARGETOP + 5 ))

	for btn in const.GTabBtnIhm:
		imgtmp, recttmp = datas.Load_image("images", btn.imagename)
		if btn.id == 14 :
			libel = datas.GetTextInLang("OK", "OK")
			text = font.render(libel, 1, textcolor).convert_alpha()
			imgtmp.blit(text, (40, 5 ))
		elif btn.id == 15 :
			libel = datas.GetTextInLang("CANC", "Cancel")
			text = font.render(libel, 1, textcolor).convert_alpha()
			imgtmp.blit(text, (40, 5 ))

		const.Gbackground_image.blit(imgtmp, (btn.left, btn.top))

	rng = 0
	for tab12 in const.GTabDirectories:
		if rng >= const.GFirstDirectory :
			tab = tab12[1]
#			text = font.render(unicode(tab.imagename, const.GConsoleLocale), 1, textcolor).convert_alpha()
#			text = font.render(tab.imagename.decode(const.GConsoleLocale, "ignore"), 1, textcolor).convert_alpha()
			text = font.render(tab.imagename, 1, textcolor).convert_alpha()
			
			tab.left = 87
			tab.top = 97 + 27 * (rng - const.GFirstDirectory)
			tab.id = id
			tab.hauteur = 27
			tab.largeur = 453
			const.Gbackground_image.blit(text, (tab.left, tab.top))
		rng += 1
		if rng >= const.GFirstDirectory + 12 :
			break
		
		
	screen.blit(const.Gbackground_image, (0, 0))
	pygame.display.update()
		



#*******************************************************************************
#    
#*******************************************************************************
def ShowFileBox(dirname, TypeButtons = 1, Left = -1, Top=0):
	screen = pygame.display.get_surface()  
	imgtext, rectext = datas.Load_image("images", "input-file.png")
	(x, y) = imgtext.get_size()
	returnvalue = 1

	pygame.event.clear()
	oldsouris = const.GTypeSouris
	const.GTypeSouris = const.EVENT_NOVENT

	myfont = os.path.join(const.GRepPysycache, 'fonts', const.GFontName).encode(const.GConsoleLocale)
	font = pygame.font.Font(myfont, 20)
	textcolor = 46, 113, 169
	bgcolor = 128, 186, 234

	#titre
#	if os.path.isdir(const.GRepUsersPysycache) == False:
#		dirname = const.GRepPysycache

#	libel = datas.GetTextInLang("DEL0", "Do you confirm the deletion of the")
#	text = font.render(libel, 1, textcolor).convert_alpha()
#	imgtext.blit(text, (20, 40 ))
#	libel = datas.GetTextInLang("DEL1", "selected user ?")
#	text = font.render(libel, 1, textcolor).cgtext.blit(text, (20, 70 ))


	const.Gbackground_image.blit(imgtext, (0, 0 ) )
	screen.blit(imgtext, (0, 0) )

	#--------------------------------- les boutons  ----------------------------
	const.GTabBtnIhm[:] = []
	tab = BtnIhm()
	tab.left = const.MARGELEFT + 130 
	tab.top = const.MARGETOP + 65 + 380
	tab.largeur = 140
	tab.hauteur = 40
	tab.imagename = 'btn-ok.png'
	tab.id = 14
	const.GTabBtnIhm.append(tab)
	
	tab = BtnIhm()
	tab.left = const.MARGELEFT + 270 + 55
	tab.top = const.MARGETOP + 65 + 380
	tab.largeur = 140
	tab.hauteur = 40
	tab.imagename = 'btn-cancel.png'
	tab.id = 15
	const.GTabBtnIhm.append(tab)
	
	tab = BtnIhm()
	tab.left = const.MARGELEFT + 538
	tab.top = const.MARGETOP + 91
	tab.largeur = 36
	tab.hauteur = 36
	tab.imagename = 'btn-haut.png'
	tab.id = 16
	const.GTabBtnIhm.append(tab)
	
	tab = BtnIhm()
	tab.left = const.MARGELEFT + 538
	tab.top = const.MARGETOP + 398
	tab.largeur = 36
	tab.hauteur = 36
	tab.imagename = 'btn-bas.png'
	tab.id = 17
	const.GTabBtnIhm.append(tab)

	#--------------------------- les repertoires -------------------------------
	const.GCurrentDirectory = dirname
	SearchAllDirectories()
	ShowListDirectories()

	const.GLstSouris.empty()
	const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
	for o in const.GLstSouris.sprites():
		o.move(const.Gbackground_image)
	const.GLstSouris.draw(screen)

	pygame.display.update()

	running = 1
	while running:
		datas.Temporisation()

		for event in pygame.event.get():
			if event.type == QUIT:
				returnvalue = 0
				running = 0
				break
			elif event.type == KEYUP:
				if event.key == K_ESCAPE:
					returnvalue = 0
					running = 0
					break
			elif event.type == MOUSEMOTION:
				event0 = event.pos[0] 
				event1 = event.pos[1] 

				#redessin de la souris a sa position actuelle
				const.GMaSourisCurrentPositionX = event0 
				const.GMaSourisCurrentPositionY = event1 
				for o in const.GLstSouris.sprites():
					o.move(const.Gbackground_image)

				const.GLstSouris.draw(screen)

				pygame.display.update()
				break
			elif event.type == MOUSEBUTTONUP:
				#*************************** evenement clic ************************
				event0 = event.pos[0]
				event1 = event.pos[1]

				#-------------- recherche si est un bouton de menu -------------
				for obj in const.GTabBtnIhm :
					if ( event0 >= obj.left ) & ( event0 <= obj.left + obj.largeur ) & ( event1 >= obj.top  ) & ( event1 <= obj.top + obj.hauteur ) :
						if obj.id == 14 : 
							#OK
							running = 0
							returnvalue = 1
						elif obj.id == 15 : 
							#cancel
							returnvalue = 0
							running = 0
							const.GCurrentDirectory = dirname
						elif obj.id == 16 : 
							#haut
							const.GFirstDirectory  = const.GFirstDirectory - 1
							if const.GFirstDirectory < 0 :
								const.GFirstDirectory = 0
							ShowListDirectories()
							const.GLstSouris.draw(screen)
							pygame.display.update()
						elif obj.id == 17 : 
							#bas
							const.GFirstDirectory  += 1
							if const.GFirstDirectory > len(const.GTabDirectories) - 12 :
								const.GFirstDirectory = len(const.GTabDirectories) - 12
							ShowListDirectories()
							const.GLstSouris.draw(screen)
							pygame.display.update()
						break

				#--------------- recherche si est un repertoire -----------------
				for tab12 in const.GTabDirectories:
					obj = tab12[1]
					if ( event0 >= obj.left ) & ( event0 <= obj.left + obj.largeur ) & ( event1 >= obj.top  ) & ( event1 <= obj.top + obj.hauteur ) :
						const.GCurrentDirectory = os.path.join(const.GCurrentDirectory, obj.imagename)
						(f1, f2) = os.path.split(const.GCurrentDirectory)
						if f2 == ".." :
							(f1b, f2) = os.path.split(f1)
							const.GCurrentDirectory = f1b
						SearchAllDirectories()
						ShowListDirectories()
						const.GLstSouris.draw(screen)
						pygame.display.update()

	pygame.event.clear()
	const.GTypeSouris = oldsouris

	return returnvalue
