package org.codehaus.plexus.maven.plugin;

import java.util.List;

/*
 * The MIT License
 * 
 * Copyright (c) 2004-2006, The Codehaus
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.metadata.MetadataGenerator;

/**
 * Base class for Plexus Metadata mojos.
 *
 * @author Jason van Zyl
 */
public abstract class AbstractDescriptorMojo
    extends AbstractMojo
{

    /**
     * Current project
     */
    @Parameter( defaultValue = "${project}", required = true, readonly = true )
    protected MavenProject mavenProject;

    /**
     * The file encoding of the source files.
     * 
     * @parameter default-value="${project.build.sourceEncoding}"
     */
    @Parameter( defaultValue = "${project.build.sourceEncoding}" )
    protected String sourceEncoding;

    /**
     * The extractors to use. By default all available extractors will be used.
     * <p>
     * Known extractors:
     * <ul>
     * <li>source</li>
     * <li>class</li>
     * </ul>
     * </p>
     */
    @Parameter
    protected List<String> extractors;
    
    @Component
    protected MavenProjectHelper mavenProjectHelper;

    @Component
    protected MetadataGenerator metadataGenerator;
}
