# Check for libdc1394-2 (Only in Linux, there is no
#  Windows version yet...)
# ===================================================
SET(CMAKE_MRPT_HAS_LIBDC1394_2 0)
SET(CMAKE_MRPT_HAS_LIBDC1394_2_SYSTEM 0)

# DISABLE_LIBDC1394
# ---------------------
OPTION(DISABLE_LIBDC1394 "Force not using libdc1394" "OFF")
MARK_AS_ADVANCED(DISABLE_LIBDC1394)
IF(NOT DISABLE_LIBDC1394)


# Invoke pkg-config for getting the configuration:
IF(PKG_CONFIG_FOUND)
	PKG_CHECK_MODULES(LIBDC1394_2 ${_QUIET} libdc1394-2)
	IF (LIBDC1394_2_FOUND)
		SET(CMAKE_MRPT_HAS_LIBDC1394_2 1)
		SET(CMAKE_MRPT_HAS_LIBDC1394_2_SYSTEM 1)
		#MESSAGE(STATUS "LIBDC1394_2_LIBRARIES    : ${LIBDC1394_2_LIBRARIES}")
		#MESSAGE(STATUS "LIBDC1394_2_INCLUDE_DIRS : ${LIBDC1394_2_INCLUDE_DIRS}")
		#MESSAGE(STATUS "LIBDC1394_2_LIBRARY_DIRS : ${LIBDC1394_2_LIBRARY_DIRS}")
		#MESSAGE(STATUS "LIBDC1394_2_LDFLAGS      : ${LIBDC1394_2_LDFLAGS}")
	ELSE(LIBDC1394_2_FOUND)
		SET(CMAKE_MRPT_HAS_LIBDC1394_2 0)
	ENDIF (LIBDC1394_2_FOUND)
ENDIF(PKG_CONFIG_FOUND)

ENDIF(NOT DISABLE_LIBDC1394)

