
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*******************************************************************************
*                  Copyright (c) 1991 - 2001 Gemplus
*
* Name        : GemDef.h
*
* Description : General definition for GEMPLUS programs.
*
* Release     : 4.31.001
*
* Last Modif  : 13/10/97: V4.31.001  
*               11/04/97: V4.20.000 - Modify conditionnal compilation for 
*                                     Borland compatibility..
*               22/04/96: V4.20.000 - Update structure for 32 bits alignement.
* 	             01/12/95: V4.10.001 - Update to new Gemplus 4.10 Version.
*               15/06/95: V4.01.002
*               06/07/94: V4.00.000
*
********************************************************************************
*
* Warning     :
*
* Remark      :
*
*******************************************************************************/

/*------------------------------------------------------------------------------
Name definition:
   _GEMDEF_H is used to avoid multiple inclusion.
------------------------------------------------------------------------------*/
#ifndef _GEMDEF_H
#define _GEMDEF_H

/*------------------------------------------------------------------------------
Compatibility section:
   G_WINDOWS must be defined for Windows target.
      This can be made
         - by the addition of #include <windows.h> before this file inclusion or
         - by added /DG_WINDOWS as a compilation flag.
------------------------------------------------------------------------------*/
#ifndef G_WINDOWS

#ifdef _INC_WINDOWS
#define G_WINDOWS
#endif

#ifdef __WINDOWS_H
#define G_WINDOWS
#endif

#ifdef _WINDOWS_
#define G_WINDOWS
#endif

#endif

/*------------------------------------------------------------------------------
   G_DECL is used for function declaration to be adapted to target OS. Today,
      only Windows 3.1 and DOS are supported by this file.
------------------------------------------------------------------------------*/
#ifdef G_WINDOWS

#define G_DECL FAR PASCAL

#else

#define G_DECL

#endif
/*------------------------------------------------------------------------------
   G_FAR and G_HUGE are defined to prepare development under 32 bits 
      environment. They are adapted for Borland and Microsoft compilers.
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
   - Borland Turbo C version < 4.10
------------------------------------------------------------------------------*/
#ifdef __TURBOC__

#if __TURBOC__ < 0x410

#define __far  far
#define _far   far
#define __huge huge
#define _huge  huge

#endif

#else

/*------------------------------------------------------------------------------
   - Microsoft C version < 7
------------------------------------------------------------------------------*/
#ifdef _MSC_VER

#if _MSC_VER < 700
#define __far  _far
#define __huge _huge
#endif

/*------------------------------------------------------------------------------
   - Others cases
------------------------------------------------------------------------------*/
#else
#define __far  far
#define _far   far
#define __huge huge
#define _huge  huge
#endif

#endif

/*------------------------------------------------------------------------------
   - Windows 32 bits
------------------------------------------------------------------------------*/
#ifdef WIN32

#define G_FAR
#define G_HUGE

#else

/*------------------------------------------------------------------------------
   - Unix systems
------------------------------------------------------------------------------*/
#ifdef G_UNIX

#define G_FAR
#define G_HUGE

// typedef int HANDLE;
//typedef long LONG;

#define NOPARITY	0
#define ODDPARITY	8
#define EVENPARITY	24

#define ONESTOPBIT	1
#define TWOSTOPBITS	2

#else

/*------------------------------------------------------------------------------
   - OS/2 systems
------------------------------------------------------------------------------*/
#ifdef G_OS2

#define G_FAR
#define G_HUGE
typedef int HANDLE;

#define NOPARITY	0
#define ODDPARITY	1
#define EVENPARITY	2
#define MARKPARITY	3
#define SPACEPARITY	4

#define ONESTOPBIT	1
#define ONEHALFSTOPBIT	2
#define TWOSTOPBITS	3

/*------------------------------------------------------------------------------
   - Others cases
------------------------------------------------------------------------------*/
#else

#define G_FAR  __far
#define G_HUGE __huge

#endif							/*
								 * #ifdef G_OS2 
								 */

#endif							/*
								 * #ifdef G_UNIX 
								 */

#endif							/*
								 * #ifdef WIN32 
								 */

/*------------------------------------------------------------------------------
Type definitions:
------------------------------------------------------------------------------*/

/*
#ifndef G_WINDOWS
#ifndef BYTE
typedef unsigned char BYTE;
#define _BYTE
#endif
typedef unsigned short WORD;
#ifdef G_UNIX
// typedef unsigned int    DWORD;
#define _DWORD
#else							// G_UNIX
typedef unsigned long DWORD;
#endif							// G_UNIX
typedef unsigned short HINSTANCE;
#endif
*/

typedef unsigned char WORD8;
typedef unsigned short WORD16;
#ifdef G_UNIX
typedef unsigned int WORD32;
#else							/*
								 * G_UNIX 
								 */
typedef unsigned long WORD32;
#endif							/*
								 * G_UNIX 
								 */

typedef signed char INT8;
typedef signed short INT16;
typedef signed short INTEGER;
#ifdef G_UNIX
typedef signed int INT32;
#else							/*
								 * G_UNIX 
								 */
typedef signed int INT32;
#endif							/*
								 * G_UNIX 
								 */

#if !defined (G_WINDOWS) && !defined (G_OS2) && !defined (G_UNIX)
typedef signed short BOOL;
#endif

#ifdef G_OS2
typedef unsigned int UINT;
#endif

#ifndef FALSE
#define FALSE           0
#endif
#ifndef TRUE
#define TRUE            1
#endif

/*------------------------------------------------------------------------------
   TLV_TYPE structure holds:
      - a type field   (T) which indicates the V field type:
      - a length field (L) which indicates the size of the V field, in  bytes.
      - a value field  (V) which is the data part of the message.
------------------------------------------------------------------------------*/
typedef struct
{
	WORD8 T;
	WORD8 L;
	void G_FAR *V;

}
TLV_TYPE;

/*------------------------------------------------------------------------------
Constant definitions:
   EOS is the End Of String character.
   MAX_FILE_NAME is the maximal length for a full file name, with path.
   MAX_LINE_LENGTH is the maximal length for an ASCII line in our configuration
      files.
------------------------------------------------------------------------------*/
#define EOS                     '\0'
#define MAX_FILE_NAME           129
#define MAX_LINE_LENGTH         120

#define OFF                      0
#define ON                       1
#define CLEAR                    2

#ifndef NULL
#define NULL                     0
#endif

#endif
