#!/usr/bin/perl

use strict;
use 5.6.0;
use warnings;

use IO::Dir;
use File::Spec;
use POSIX;

my $dirname = shift or die "No test directory supplied\n";

my $dir = new IO::Dir $dirname or die "Failed to open dir $dirname: $!\n";
my @tests;
push @tests, $_ while defined($_ = $dir->read);
undef $dir;

@tests = grep {-d $_} map {File::Spec->catdir($dirname, $_)} grep {!/^\./ and !/~$/} @tests;

my $passed = 0;
my $failed = 0;

foreach my $test (sort @tests)
  {
    print "Processing $test...\n";
    system('./run_test.pl', $test);
    die "Failed to run run-test.pl $test: $!" if $? == -1;

    $? == 0 ? $passed++ : $failed++;
    print "Test $test failed\n" if $? != 0;
  }

print '-' x 72 . "\n";

my $total = scalar @tests;
my $percent = $passed * 100 / $total;
printf '%d/%d (%d%%) tests passed' . "\n", $passed, $total, $percent;

exit 1 if $passed < $total;
