/* Exec Fenix DLL
 * Copyright (C) 2004 Álvaro Vilanova Vidal 
 * Modified & reduced by Pablo Navarro, compatible with Linux
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

//------------------------------------------------------------------------------
// LAST RELEASE VERSION: 0.4a
// FENIX COMPATIBILITY: 0.84+
// LAST UPDATE: 04/07/2007
//------------------------------------------------------------------------------

#include <fenix/fxdll.h>

/* PluginVersion is used to identify the plugin structures against which
 * we're linking to prevent potential mismatches and segmentation faults
 */
unsigned int PluginVersion = FXDLL_VERSION;

//------------------------------------------------------------------------------
// FUNCTION: ShellEx
// VER: 1.0
// LAST UPDATE: 04/07/2007
// EXP: This function open any document.
//------------------------------------------------------------------------------
int _ShellEx(INSTANCE * my, int * params)
{
	const char * CmdLine = string_get(params[0]); 
	if(!system(CmdLine))
	{
		return -1;
	}
	return 0;
}
//------------------------------------------------------------------------------

//REGISTER FUCTIONS-------------------------------------------------------------
FENIX_MainDLL RegisterFunctions (COMMON_PARAMS) 
{

	FENIX_DLLImport
	
	FENIX_export ("SHELL","S",TYPE_DWORD,_ShellEx);

}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
