/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_mech_mouse.h"

struct sig_mech_mouse *
sig_mech_mouse_create(const char *name)
{
	struct sig_mech_mouse *c;
	char n[1000];

	c = shm_alloc(sizeof(*c));
	assert(c);

	sprintf(n, "%s-button0", name);
	c->button0 = sig_boolean_create(n);
	sprintf(n, "%s-button1", name);
	c->button1 = sig_boolean_create(n);
	sprintf(n, "%s-button2", name);
	c->button2 = sig_boolean_create(n);
	sprintf(n, "%s-button3", name);
	c->button3 = sig_boolean_create(n);
	sprintf(n, "%s-button4", name);
	c->button4 = sig_boolean_create(n);
	sprintf(n, "%s-wheel0", name);
	c->wheel0 = sig_integer_create(n);
	sprintf(n, "%s-wheel1", name);
	c->wheel1 = sig_integer_create(n);
	sprintf(n, "%s-wheel2", name);
	c->wheel2 = sig_integer_create(n);

	return c;
}

void
sig_mech_mouse_destroy(struct sig_mech_mouse *sig)
{
	assert(sig);
	/* assert(sig->type == ...); FIXME */

	sig_boolean_destroy(sig->button0);
	sig_boolean_destroy(sig->button1);
	sig_boolean_destroy(sig->button2);
	sig_boolean_destroy(sig->button3);
	sig_boolean_destroy(sig->button4);
	sig_integer_destroy(sig->wheel0);
	sig_integer_destroy(sig->wheel1);
	sig_integer_destroy(sig->wheel2);

	shm_free(sig);
}

void
sig_mech_mouse_suspend(struct sig_mech_mouse *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
	
	sig_boolean_suspend(b->button0, fSig);
	sig_boolean_suspend(b->button1, fSig);
	sig_boolean_suspend(b->button2, fSig);
	sig_boolean_suspend(b->button3, fSig);
	sig_boolean_suspend(b->button4, fSig);
	sig_integer_suspend(b->wheel0, fSig);
	sig_integer_suspend(b->wheel1, fSig);
	sig_integer_suspend(b->wheel2, fSig);
}

void
sig_mech_mouse_resume(struct sig_mech_mouse *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
	
	sig_boolean_resume(b->button0, fSig);
	sig_boolean_resume(b->button1, fSig);
	sig_boolean_resume(b->button2, fSig);
	sig_boolean_resume(b->button3, fSig);
	sig_boolean_resume(b->button4, fSig);
	sig_integer_resume(b->wheel0, fSig);
	sig_integer_resume(b->wheel1, fSig);
	sig_integer_resume(b->wheel2, fSig);
}
