/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __XML_SVG_H_INCLUDED
#define __XML_SVG_H_INCLUDED

#include <stdio.h>

struct xml_svg_path {
	struct xml_svg_path *prev;
	struct xml_svg_path *next;

	char type;
	union {
		struct {
			double rx, ry;
			double angle;
			int large_arc;
			int sweep;
			double x1, y1;
		} a;
		struct {
			double xa, ya;
			double xb, yb;
			double x1, y1;
		} c;
		struct {
			double x1, y1;
		} l;
		struct {
			double x, y;
		} m;
		struct {
			double x, y;
		} z;
	};
};

struct xml_svg {
	struct xml_svg *prev;
	struct xml_svg *next;

	enum {
		XML_SVG,
		XML_SVG_CIRCLE,
		XML_SVG_G,
		XML_SVG_IMAGE,
		XML_SVG_LINE,
		XML_SVG_PATH,
		XML_SVG_RECT,
		XML_SVG_TEXT,
		XML_SVG_TITLE,
	} type;
	int ignore; /* Not used. */

	char *alignment_baseline;
	char *display;
	int fill;
	char *font_family;
	char *fill_rule;
	double font_size;
	char *font_stretch;
	char *font_style;
	char *font_variant;
	char *font_weight;
	char *id;
	char *inkscape_groupmode;
	int stroke;
	char *stroke_linecap;
	char *stroke_linejoin;
	char *stroke_opacity;
	double stroke_width;
	char *text_align;
	char *vertical_align;
	char *text_anchor;
	char *text_decoration;
	char *text_indent;
	double transform[3][3];

	union {
		struct {
			double width, height;
			struct xml_svg *first;
			struct xml_svg *last;
		} svg;
		struct {
			double cx, cy;
			double r;
		} circle;
		struct {
			struct xml_svg *first;
			struct xml_svg *last;
		} g;
		struct {
			double x, y;
			double width, height;
			char *xlink_href;
			char *sodipodi_absref;
		} image;
		struct {
			double x1, y1;
			double x2, y2;
		} line;
		struct {
			char *sodipodi_type;
			double sodipodi_cx;
			double sodipodi_cy;
			double sodipodi_rx;
			double sodipodi_ry;
			struct xml_svg_path *first;
			struct xml_svg_path *last;
		} path;
		struct {
			double x, y;
			double width, height;
			double rx, ry;
		} rect;
		struct {
			double x, y;
			const char *str;
		} text;
		struct {
			const char *str;
		} title;
	};
};

extern struct xml_svg *
xml_svg_circle_alloc(double x, double y, double radius);
extern struct xml_svg *
xml_svg_image_alloc(double x, double y, double width, double height,
		const char *href);
extern struct xml_svg *
xml_svg_line_alloc(double x0, double y0, double x1, double y1);
extern struct xml_svg *
xml_svg_text_alloc(double x, double y, const char *str);

extern struct xml_svg *
xml_svg_alloc(double width, double height);

extern void
xml_svg_color_argb_set(int *varp, int a, int r, int g, int b);
extern void
xml_svg_length_set(double *varp, double val);
extern void
xml_svg_string_set(char **varp, const char *val);
extern void
xml_svg_transform_matrix(double new[3][3], double old[3][3],
		double m[3][3]);
extern void
xml_svg_transform_translate(double new[3][3], double old[3][3],
		double dx, double dy);
extern void
xml_svg_transform_rotate(double new[3][3], double old[3][3],
		double angle, double dx, double dy);

extern void
xml_svg_append(struct xml_svg *s0, struct xml_svg *s1);

extern struct xml_svg *
xml_svg_read(FILE *fp);
extern int
xml_svg_write(FILE *fp, struct xml_svg *svg);

#endif /* __XML_SVG_H_INCLUDED */
