/*
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <string.h>

#include "list.h"
#include "simsetup.h"
#include "structure.h"

struct simsetup	simsetup;

struct structure_component *
simsetup_for_component(const char *name)
{
	struct structure_component *comp;

	list_Foreach(&simsetup.comps, comp) {
		if (strcmp(comp->name, name) == 0) break;
	}
	return comp;
}

const char *
simsetup_get(const char *node, const char *key)
{
	struct structure_component *comp;
	struct structure_keyval *keyval;

	list_Foreach(&simsetup.comps, comp) {
		if (strcmp(comp->name, node) == 0) break;
	}
	if (! comp) return NULL;

	list_Foreach(&comp->simsetups, keyval) {
		if (strcmp(keyval->name, key) == 0) break;
	}
	if (!keyval) return NULL;
	return keyval->value;
}
