/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "ps2_gen_mouse_4_gui.h"

#ifdef HAVE_GTK
#include "ps2_gen_mouse_4_gui_gtk.h"
#endif

void *
ps2_gen_mouse_4_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_ps2_conn *port_ps2,
	struct sig_integer *port_deltax,
	struct sig_integer *port_deltay,
	struct sig_integer *port_deltaz,
	struct sig_boolean *port_button1,
	struct sig_boolean *port_button2,
	struct sig_boolean *port_button3,
	struct sig_boolean *port_button4,
	struct sig_boolean *port_button5
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return ps2_gen_mouse_4_gui_gtk_create(page, name,
				port_manage,
				port_ps2,
				port_deltax,
				port_deltay,
				port_deltaz,
				port_button1,
				port_button2,
				port_button3,
				port_button4,
				port_button5);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
ps2_gen_mouse_4_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ps2_gen_mouse_4_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ps2_gen_mouse_4_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ps2_gen_mouse_4_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ps2_gen_mouse_4_gui_resume(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ps2_gen_mouse_4_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
