#include "FuseCreateAndOpenTest.h"

using ::testing::_;

int FuseCreateAndOpenTest::CreateAndOpenFile(const char *filename, int flags) {
  int fd = CreateAndOpenFileAllowError(filename, flags);
  EXPECT_GE(fd, 0);
  return fd;
}

int FuseCreateAndOpenTest::CreateAndOpenFileReturnError(const char *filename, int flags) {
  int fd = CreateAndOpenFileAllowError(filename, flags);
  if (fd >= 0) {
    return 0;
  } else {
    return -fd;
  }
}

int FuseCreateAndOpenTest::CreateAndOpenFileAllowError(const char *filename, int flags) {
  auto fs = TestFS();

  auto realpath = fs->mountDir() / filename;
  int fd = ::open(realpath.c_str(), flags | O_CREAT, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
  if (fd >= 0) {
    return fd;
  } else {
    return -errno;
  }
}
