#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PanedW.h>
#include <Xm/DialogS.h>
#include <Xm/Separator.h>

#include "XrMisc.h"

/* ARGSUSED */
static void
DestroyParentCallback (w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtDestroyWidget (XtParent (w));
}

/* ARGSUSED */
static void
SetDialogPosition(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	Position	x, y, x1, y1;
	Dimension	twidth, width, theight, height;
	Widget		top = XtParent(w);

	XtVaGetValues (top,
		XmNx,		&x,
		XmNy,		&y,
		XmNwidth,	&twidth,
		XmNheight,	&theight,
		NULL);

	XtVaGetValues (w,
		XmNy,		&x1,
		XmNy,		&y1,
		XmNwidth,	&width,
		XmNheight,	&height,
		NULL);

	if (x1 != 0 && y1 != 0)
		return;

	XtVaSetValues (w,
		XmNx,		x + (twidth - width) / 2,
		XmNy,		y + (theight - height) / 2,
		NULL);

}

/*
 *  This procedure builds an dialog box action area based on a list of
 *  buttons passed to it.  This code is based on the example in chapter 7 of
 *  the O'Reilly & Associates Volume 6 by Dan Heller.
 */

Widget
CreateButtonArea (name, parent, buttons, num_buttons, tightness, default_button)
char		*name;
Widget		parent;
ActionAreaButton	*buttons;
int		num_buttons;
int		tightness;
int		default_button;
{

	Widget		button_area, widget;
	register int	i;
	Dimension	height, h;

	button_area = XtVaCreateWidget (name, xmFormWidgetClass, parent,
		XmNfractionBase,	tightness * num_buttons - 1,
		XmNskipAdjust,		True,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNrightAttachment,	XmATTACH_FORM,
		NULL);

	for (i=0; i<num_buttons; ++i) {

		widget = XtVaCreateManagedWidget (buttons[i].name,
		    xmPushButtonWidgetClass, button_area,
		    XmNleftAttachment,	i ? XmATTACH_POSITION : XmATTACH_FORM,
		    XmNleftPosition,	tightness * i,
		    XmNtopAttachment,	XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_FORM,
		    XmNrightAttachment,
			i != num_buttons-1 ? XmATTACH_POSITION : XmATTACH_FORM,
		    XmNrightPosition,	tightness * i + tightness - 1,
		    XmNshowAsDefault,	i == default_button,
		    XmNdefaultButtonShadowThickness, 1,
		    NULL);

		if (buttons[i].callback)
			XtAddCallback (widget, XmNactivateCallback,
				buttons[i].callback, buttons[i].client_data);

		if (i == default_button) {
			XtVaGetValues (button_area,
				XmNmarginHeight,	&h,
				NULL);
			XtVaGetValues (widget,
				XmNheight,		&height,
				NULL);
			height += 2 * h;
			XtVaSetValues (button_area,
				XmNdefaultButton,	widget,
				NULL);
		}

	}

	XtManageChild (button_area);

	return button_area;
}

Widget
CreateExtendedFormDialog(name, parent, content_widget, buttons, num_buttons,
default_button)	
char		*name;
Widget		parent;
Widget		*content_widget;
ActionAreaButton *buttons;
int		num_buttons;
int		default_button;
{

	Widget		dialog, board, sep, form, action_area, *children;
	Cardinal	num_children;

	dialog = XtVaCreatePopupShell (name, xmDialogShellWidgetClass,
		parent,
		NULL);

	board = XtVaCreateWidget (name, xmFormWidgetClass, dialog,
		NULL);

	XtAddCallback (board, XmNdestroyCallback, DestroyParentCallback, NULL);

	action_area = CreateButtonArea ("button_area", board, buttons,
		num_buttons, 10, default_button);

	sep = XtVaCreateManagedWidget ("separator", xmSeparatorWidgetClass,
		board,
		XmNbottomAttachment,	XmATTACH_WIDGET,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNrightAttachment,	XmATTACH_FORM,
		XmNbottomWidget,	action_area,
		NULL);

	form = XtVaCreateWidget ("content_area", xmFormWidgetClass, board,
		XmNbottomAttachment,	XmATTACH_WIDGET,
		XmNbottomWidget,	sep,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNrightAttachment,	XmATTACH_FORM,
		XmNtopAttachment,	XmATTACH_FORM,
		NULL);

	*content_widget = form;

	XtAddCallback (dialog, XmNpopupCallback, SetDialogPosition, 0);

	return board;
}	

