/* Generated from dutch.sbl by Snowball 3.0.0 - https://snowballstem.org/ */

#include <xapian/stem.h>

#define SNOWBALL_RUNTIME_THROW_EXCEPTIONS
#include "languages/snowball_runtime.h"

namespace Xapian::Internal::Snowball {

class Dutch : public Xapian::StemImplementation {
  public:
    struct SN_local {
        struct SN_env z;
        int i_p2;
        int i_p1;
        bool b_GE_removed;
        symbol * s_ch;
    };

  private:
    SN_local zlocal = {};

    void close_env() {
        struct SN_env * z = &(zlocal.z);
        lose_s(((SN_local *)z)->s_ch);
        lose_s(z->p);
    }

    static int stem(struct SN_env * z);

  public:
    Dutch() {
        struct SN_env * z = &(zlocal.z);
        z->p = create_s();
        try {
            ((SN_local *)z)->s_ch = create_s();
        } catch (...) {
            close_env();
            throw;
        }
    }

    ~Dutch() {
        close_env();
    }

    std::string operator()(const std::string& word) override {
        struct SN_env* z = &(zlocal.z);
        const symbol* s = reinterpret_cast<const symbol*>(word.data());
        replace_s(z, 0, z->l, word.size(), s);
        z->c = 0;
        Xapian::Internal::Snowball::Dutch::stem(z);
        return std::string(reinterpret_cast<const char*>(z->p), SIZE(z->p));
    }

    bool use_proper_noun_heuristic() const override {
        return true;
    }

    std::string get_description() const override {
        return "dutch";
    }
};

}
