//////////////////////////////////////////////////////////////////////////////
// graphics command file for asymptote (automatically generated by TOPCOM)
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// begin node type section:
//////////////////////////////////////////////////////////////////////////////
struct node_type {
  int[]   labelset;
  int[][] partialtriang;
  void operator init(int[] init_labelset, int[][] init_partialtriang) {
    labelset      = copy(init_labelset) ;
    partialtriang = copy(init_partialtriang);
  }
  int length() {
    return labelset.length;
  }
};
//////////////////////////////////////////////////////////////////////////////
// end node type section.
//////////////////////////////////////////////////////////////////////////////

import Combinatorial_Geometry;
import palette;

usepackage("amsmath");
usepackage("amsthm");
usepackage("bclogo");

locale("C");

string filename_postfix = "_";

node_type[][][] tree_nodes;
int[][][][]   tree_arcs;
int[][][]     deadend_nodes;
int[][][]     earlydeadend_nodes;
int[][][]     veryearlydeadend_nodes;
int[][][]     missingvolume_nodes;
int[][][]     notnew_nodes;
int[][][]     solution_nodes;
bool draw_graphics = false;
real size_x = 10;
real size_y = 10;
real center_x = 0;
real center_y = 0;
real scale_symbols = size_x / (18pt);
real thicklinewidth = size_x * 0.05pt;
real thinlinewidth = size_x * 0.02pt;

//////////////////////////////////////////////////////////////////////////////
// begin of vertices section (indices of vertices go here):
//////////////////////////////////////////////////////////////////////////////

int[] A_extremepoints = {0,1,2};

/////////////////////////////////////////////////////////////////////////////
// end of vertices section.
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// begin of points section (coordinates of points go here):
//////////////////////////////////////////////////////////////////////////////

pair[] point_coords = {(-2, -1300077228592327/1125899906842624), (2, -1300077228592327/1125899906842624), (0, 1300077228592327/562949953421312), (-1/2, -1300077228592327/4503599627370496), (1/2, -1300077228592327/4503599627370496), (0, 1300077228592327/2251799813685248)};

real max_x = point_coords[0].x;
real min_x = point_coords[0].x;
real max_y = point_coords[0].y;
real min_y = point_coords[0].y;

for (int i = 1; i < point_coords.length; ++i) {
  if (point_coords[i].x > max_x) {
    max_x = point_coords[i].x;
  }
  if (point_coords[i].x < min_x) {
    min_x = point_coords[i].x;
  }
  if (point_coords[i].y > max_y) {
    max_y = point_coords[i].y;
  }
  if (point_coords[i].y < min_y) {
    min_y = point_coords[i].y;
  }
}

real coord_size_x = (max_x - min_x);
real coord_size_y = (max_y - min_y);
real scale_pointconf = size_x / coord_size_x;
center_x = scale_pointconf * ((max_x + min_x) / 2);
center_y = scale_pointconf * ((max_y + min_y) / 2);
scale_symbols = size_x / (18pt);
thicklinewidth = size_x * 0.05pt;
thinlinewidth = size_x * 0.02pt;

default_pointconf_pen = default_pointconf_pen + linewidth(thicklinewidth);
secondary_pointconf_pen = secondary_pointconf_pen + linewidth(thinlinewidth);

pointconf A = shift(-center_x, -center_y) * scale(scale_pointconf) * pointconf(L=Label("", align=S), coords=point_coords, extremepoints=A_extremepoints, start_label=0);
pointconf A_scaled = scale(10) * pointconf(A, copy=true);

picture pointconf_pic;

A_scaled.draw(pic=pointconf_pic);
shipout("TOPCOM" + filename_postfix + "points", pointconf_pic);

//////////////////////////////////////////////////////////////////////////////
// end of points section.
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// begin of size correction if points are drawn as nodes:
//////////////////////////////////////////////////////////////////////////////
size_y = scale_pointconf * coord_size_y;
/////////////////////////////////////////////////////////////////////////////
// end of size correction if points are drawn as nodes.
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// new worker:
//////////////////////////////////////////////////////////////////////////////
tree_nodes.push(new node_type[][]);
tree_arcs.push(new int[][][]);
deadend_nodes.push(new int[][]);
earlydeadend_nodes.push(new int[][]);
veryearlydeadend_nodes.push(new int[][]);
missingvolume_nodes.push(new int[][]);
notnew_nodes.push(new int[][]);
solution_nodes.push(new int[][]);
//////////////////////////////////////////////////////////////////////////////
// end new worker.
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// new run for worker 0:
//////////////////////////////////////////////////////////////////////////////
tree_nodes[0].push(new node_type[]);
tree_arcs[0].push(new int[][]);
deadend_nodes[0].push(new int[]);
earlydeadend_nodes[0].push(new int[]);
veryearlydeadend_nodes[0].push(new int[]);
missingvolume_nodes[0].push(new int[]);
notnew_nodes[0].push(new int[]);
solution_nodes[0].push(new int[]);
//////////////////////////////////////////////////////////////////////////////
// end new run for worker 0.
//////////////////////////////////////////////////////////////////////////////

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {}, new int[][] {}));
// end new partial triangulation node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {0}, new int[][] {{0,1,2}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 1});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(1);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1}, new int[][] {{0,1,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 2});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4}, new int[][] {{0,1,3},{0,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {2, 3});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,10}, new int[][] {{0,1,3},{0,2,3},{1,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {3, 4});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(4);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11}, new int[][] {{0,1,3},{0,2,3},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {3, 5});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {5, 6});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13,16}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4},{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {6, 7});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(7);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13,17}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {6, 8});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13,17,18}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4},{2,3,5},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {8, 9});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13,17,18,19}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4},{2,3,5},{2,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {9, 10});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(10);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13,17,19}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4},{2,3,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {8, 11});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(11);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,13,18}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{1,3,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {6, 12});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(12);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,11,16}, new int[][] {{0,1,3},{0,2,3},{1,2,4},{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {5, 13});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(13);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12}, new int[][] {{0,1,3},{0,2,3},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {3, 14});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,13}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {14, 15});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,13,15}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,4},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {15, 16});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,13,15,17}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,4},{1,4,5},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {16, 17});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,13,15,17,19}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,4},{1,4,5},{2,3,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {17, 18});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(18);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,13,15,19}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,4},{1,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {16, 19});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(19);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,13,17}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,4},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {15, 20});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(20);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,14}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {14, 21});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,14,17}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,3,5},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {21, 22});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(22);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,12,15}, new int[][] {{0,1,3},{0,2,3},{1,2,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {14, 23});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(23);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,13}, new int[][] {{0,1,3},{0,2,3},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {3, 24});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,13,15}, new int[][] {{0,1,3},{0,2,3},{1,3,4},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {24, 25});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(25);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,13,16}, new int[][] {{0,1,3},{0,2,3},{1,3,4},{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {24, 26});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(26);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,14}, new int[][] {{0,1,3},{0,2,3},{1,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {3, 27});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(27);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,4,15}, new int[][] {{0,1,3},{0,2,3},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {3, 28});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(28);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6}, new int[][] {{0,1,3},{0,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {2, 29});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8}, new int[][] {{0,1,3},{0,2,5},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {29, 30});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,11}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {30, 31});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,11,13}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,4},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {31, 32});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,11,13,18}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,4},{1,3,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {32, 33});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,11,13,18,19}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,4},{1,3,4},{2,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {33, 34});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(34);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,11,13,19}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,4},{1,3,4},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {32, 35});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(35);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,11,18}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {31, 36});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(36);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {30, 37});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12,13}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {37, 38});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12,13,15}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5},{1,3,4},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {38, 39});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12,13,15,19}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5},{1,3,4},{1,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {39, 40});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(40);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12,13,19}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5},{1,3,4},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {38, 41});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(41);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12,14}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5},{1,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {37, 42});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(42);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,12,15}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,2,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {37, 43});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(43);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,13}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {30, 44});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,13,15}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,3,4},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {44, 45});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(45);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,13,18}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,3,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {44, 46});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(46);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,14}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {30, 47});
// end new extension arc.

// begin new deadend node:
deadend_nodes[0][0].push(47);
// end new deadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,8,15}, new int[][] {{0,1,3},{0,2,5},{0,3,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {30, 48});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(48);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,6,11}, new int[][] {{0,1,3},{0,2,5},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {29, 49});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(49);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,8}, new int[][] {{0,1,3},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {2, 50});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(50);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {1,10}, new int[][] {{0,1,3},{1,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {2, 51});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(51);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2}, new int[][] {{0,1,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 52});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4}, new int[][] {{0,1,4},{0,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 53});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7}, new int[][] {{0,1,4},{0,2,3},{0,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {53, 54});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {54, 55});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11,16}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4},{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {55, 56});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(56);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11,17}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {55, 57});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11,17,18}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4},{2,3,5},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {57, 58});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11,17,18,19}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4},{2,3,5},{2,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {58, 59});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(59);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11,17,19}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4},{2,3,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {57, 60});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(60);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,11,18}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {55, 61});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(61);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,12}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {54, 62});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,12,15}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {62, 63});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,12,15,17}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,5},{1,4,5},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {63, 64});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,12,15,17,19}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,5},{1,4,5},{2,3,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {64, 65});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(65);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,12,15,19}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,5},{1,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {63, 66});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(66);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,12,17}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,2,5},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {62, 67});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(67);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,15}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {54, 68});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(68);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,7,16}, new int[][] {{0,1,4},{0,2,3},{0,3,4},{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {54, 69});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(69);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,4,11}, new int[][] {{0,1,4},{0,2,3},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {53, 70});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(70);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,5}, new int[][] {{0,1,4},{0,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 71});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,5,11}, new int[][] {{0,1,4},{0,2,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {71, 72});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(72);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6}, new int[][] {{0,1,4},{0,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 73});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7}, new int[][] {{0,1,4},{0,2,5},{0,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {73, 74});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {74, 75});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,11}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {75, 76});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,11,18}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {76, 77});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,11,18,19}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,4},{2,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {77, 78});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(78);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,11,19}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,4},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {76, 79});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(79);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,12}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {75, 80});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,12,15}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {80, 81});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,12,15,19}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,5},{1,4,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {81, 82});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(82);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,12,19}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,2,5},{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {80, 83});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(83);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,15}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {75, 84});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(84);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,8,18}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{0,3,5},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {75, 85});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(85);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,7,11}, new int[][] {{0,1,4},{0,2,5},{0,3,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {74, 86});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(86);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,8}, new int[][] {{0,1,4},{0,2,5},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {73, 87});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(87);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9}, new int[][] {{0,1,4},{0,2,5},{0,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {73, 88});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9,11}, new int[][] {{0,1,4},{0,2,5},{0,4,5},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {88, 89});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9,11,18}, new int[][] {{0,1,4},{0,2,5},{0,4,5},{1,2,4},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {89, 90});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(90);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9,12}, new int[][] {{0,1,4},{0,2,5},{0,4,5},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {88, 91});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9,12,15}, new int[][] {{0,1,4},{0,2,5},{0,4,5},{1,2,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {91, 92});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(92);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9,15}, new int[][] {{0,1,4},{0,2,5},{0,4,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {88, 93});
// end new extension arc.

// begin new deadend node:
deadend_nodes[0][0].push(93);
// end new deadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,9,18}, new int[][] {{0,1,4},{0,2,5},{0,4,5},{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {88, 94});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(94);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,6,11}, new int[][] {{0,1,4},{0,2,5},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {73, 95});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(95);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,7}, new int[][] {{0,1,4},{0,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 96});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,7,8}, new int[][] {{0,1,4},{0,3,4},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {96, 97});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(97);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,7,11}, new int[][] {{0,1,4},{0,3,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {96, 98});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(98);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,8}, new int[][] {{0,1,4},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 99});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(99);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,9}, new int[][] {{0,1,4},{0,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 100});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(100);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {2,11}, new int[][] {{0,1,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {52, 101});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(101);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {3}, new int[][] {{0,1,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 102});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {3,6}, new int[][] {{0,1,5},{0,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {102, 103});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {3,6,12}, new int[][] {{0,1,5},{0,2,5},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {103, 104});
// end new extension arc.

// begin new solution node:
solution_nodes[0][0].push(104);
// end new solution node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {3,12}, new int[][] {{0,1,5},{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {102, 105});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(105);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {4}, new int[][] {{0,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 106});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {4,7}, new int[][] {{0,2,3},{0,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {106, 107});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(107);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {4,10}, new int[][] {{0,2,3},{1,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {106, 108});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(108);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {5}, new int[][] {{0,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 109});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(109);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6}, new int[][] {{0,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 110});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6,7}, new int[][] {{0,2,5},{0,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {110, 111});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6,7,8}, new int[][] {{0,2,5},{0,3,4},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {111, 112});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(112);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6,7,11}, new int[][] {{0,2,5},{0,3,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {111, 113});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(113);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6,8}, new int[][] {{0,2,5},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {110, 114});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(114);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6,9}, new int[][] {{0,2,5},{0,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {110, 115});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(115);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {6,11}, new int[][] {{0,2,5},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {110, 116});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(116);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {7}, new int[][] {{0,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 117});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {7,8}, new int[][] {{0,3,4},{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {117, 118});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(118);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {7,11}, new int[][] {{0,3,4},{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {117, 119});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(119);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {8}, new int[][] {{0,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 120});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(120);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {9}, new int[][] {{0,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 121});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(121);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {10}, new int[][] {{1,2,3}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 122});
// end new extension arc.

// begin new deadend node:
deadend_nodes[0][0].push(122);
// end new deadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {11}, new int[][] {{1,2,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 123});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {11,13}, new int[][] {{1,2,4},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {123, 124});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(124);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {11,16}, new int[][] {{1,2,4},{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {123, 125});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(125);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {12}, new int[][] {{1,2,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 126});
// end new extension arc.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {12,13}, new int[][] {{1,2,5},{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {126, 127});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(127);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {12,14}, new int[][] {{1,2,5},{1,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {126, 128});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(128);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {12,15}, new int[][] {{1,2,5},{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {126, 129});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(129);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {12,17}, new int[][] {{1,2,5},{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {126, 130});
// end new extension arc.

// begin new veryearlydeadend node:
veryearlydeadend_nodes[0][0].push(130);
// end new veryearlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {13}, new int[][] {{1,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 131});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(131);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {14}, new int[][] {{1,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 132});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(132);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {15}, new int[][] {{1,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 133});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(133);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {16}, new int[][] {{2,3,4}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 134});
// end new extension arc.

// begin new deadend node:
deadend_nodes[0][0].push(134);
// end new deadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {17}, new int[][] {{2,3,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 135});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(135);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {18}, new int[][] {{2,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 136});
// end new extension arc.

// begin new earlydeadend node:
earlydeadend_nodes[0][0].push(136);
// end new earlydeadend node.

// begin new partial triangulation node:
tree_nodes[0][0].push(node_type(new int[] {19}, new int[][] {{3,4,5}}));
// end new partial triangulation node.

// begin new extension arc:
tree_arcs[0][0].push(new int[] {0, 137});
// end new extension arc.

// begin new deadend node:
deadend_nodes[0][0].push(137);
// end new deadend node.

//////////////////////////////////////////////////////////////////////////////
// begin of drawing parameters section:
//////////////////////////////////////////////////////////////////////////////
picture tree_pic;

real x_pos = 0;
real y_pos = 0;

pair[][][] node_pos;

real maxelmno = 0;
for (int workerID = 0; workerID < tree_nodes.length; ++workerID) {
  for (int runID = 0; runID < tree_nodes[workerID].length; ++runID) {
    for (int nodeID = 0; nodeID < tree_nodes[workerID][runID].length; ++nodeID) {
      if (tree_nodes[workerID][runID][nodeID].length() > maxelmno) {
        maxelmno = tree_nodes[workerID][runID][nodeID].length();
      }
    }
  }
}

for (int workerID = 0; workerID < tree_nodes.length; ++workerID) {
  node_pos.push(new pair[][]);
  for (int runID = 0; runID < tree_nodes[workerID].length; ++runID) {
    node_pos[workerID].push(new pair[]);
    for (int nodeID = 0; nodeID < tree_nodes[workerID][runID].length; ++nodeID) {
      y_pos = 2 * size_y * tree_nodes[workerID][runID][nodeID].length() - workerID * (maxelmno + 2) * 2 * size_y;
      x_pos = x_pos + 2 * size_x;
      pair new_pos = (x_pos, y_pos);
      node_pos[workerID][runID].push(new_pos);
    }
    x_pos = x_pos + 2 * size_x;
  }
  x_pos = node_pos[0][0][tree_nodes[0][0].length - 1].x  + 2 * size_x;
}
//////////////////////////////////////////////////////////////////////////////
// end of drawing parameters section.
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// begin of drawing definitions section:
//////////////////////////////////////////////////////////////////////////////
void draw_node(picture pic, int workerID, int runID, int nodeID) {
  pair new_pos = node_pos[workerID][runID][nodeID];
  int[][] partialtriang = tree_nodes[workerID][runID][nodeID].partialtriang;
  pointconf A_shifted = pointconf(A, copy=true);
  A_shifted = shift(new_pos) * A_shifted;
  A_shifted.draw_polygon(pic=tree_pic, pointconf_fillpen=default_pointconf_fillpen + opacity(0.95));
  for (int[] simplex : partialtriang) {
    pointconf pt = pointconf(A_shifted, cell=simplex, extremepoints=simplex);
    pt.draw_polygon(pic=tree_pic,
	             pointconf_pen=secondary_pointconf_pen,
                    pointconf_fillpen=secondary_pointconf_fillpen + opacity(1));
  }
}
//////////////////////////////////////////////////////////////////////////////
// end of drawing defintions section.
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// begin of drawings section:
//////////////////////////////////////////////////////////////////////////////

for (int workerID = 0; workerID < tree_arcs.length; ++workerID) {
  for (int runID = 0; runID < tree_arcs[workerID].length; ++runID) {
    for (int[] arc : tree_arcs[workerID][runID]) {
      draw(pic=tree_pic,
	          shift(0, size_y/2) * node_pos[workerID][runID][arc[0]]--shift(0, -size_y/2) * node_pos[workerID][runID][arc[1]],
	          p=heavygray + linewidth(thinlinewidth));
    }
  }
}

for (int workerID = 0; workerID < tree_nodes.length; ++workerID) {
  for (int runID = 0; runID < tree_nodes[workerID].length; ++runID) {
    for (int nodeID = 0; nodeID < tree_nodes[workerID][runID].length; ++nodeID) {
      draw_node(pic=tree_pic, workerID=workerID, runID=runID, nodeID=nodeID);
    }
  }
}

for (int workerID = 0; workerID < deadend_nodes.length; ++workerID) {
  for (int runID = 0; runID < deadend_nodes[workerID].length; ++runID) {
    for (int deadend_index : deadend_nodes[workerID][runID]) {
      pair new_pos = shift(0, 0.5 * size_y) * node_pos[workerID][runID][deadend_index];
      label(pic=tree_pic, L=scale(scale_symbols) * "\bcinterdit", position=new_pos, align=N/10);
    }
  }
}

for (int workerID = 0; workerID < earlydeadend_nodes.length; ++workerID) {
  for (int runID = 0; runID < earlydeadend_nodes[workerID].length; ++runID) {
    for (int early_index : earlydeadend_nodes[workerID][runID]) {
      pair new_pos = shift(0, 0.5 * size_y) * node_pos[workerID][runID][early_index];
      label(pic=tree_pic, L=scale(scale_symbols) * "\bclampe", position=new_pos, align=N/10);
    }
  }
}

for (int workerID = 0; workerID < veryearlydeadend_nodes.length; ++workerID) {
  for (int runID = 0; runID < veryearlydeadend_nodes[workerID].length; ++runID) {
    for (int veryearly_index : veryearlydeadend_nodes[workerID][runID]) {
      pair new_pos = shift(0, 0.5 * size_y) * node_pos[workerID][runID][veryearly_index];
      label(pic=tree_pic, L=scale(scale_symbols) * "\bcdanger", position=new_pos, align=N/10);
    }
  }
}

for (int workerID = 0; workerID < missingvolume_nodes.length; ++workerID) {
  for (int runID = 0; runID < missingvolume_nodes[workerID].length; ++runID) {
    for (int missingvolume_index : missingvolume_nodes[workerID][runID]) {
      pair new_pos = shift(0, 0.5 * size_y) * node_pos[workerID][runID][missingvolume_index];
      label(pic=tree_pic, L=scale(scale_symbols) * "\bctetraedre", position=new_pos, align=N/10);
    }
  }
}

for (int workerID = 0; workerID < notnew_nodes.length; ++workerID) {
  for (int runID = 0; runID < notnew_nodes[workerID].length; ++runID) {
    for (int notnew_index : notnew_nodes[workerID][runID]) {
      pair new_pos = shift(0, 0.5 * size_y) * node_pos[workerID][runID][notnew_index];
      label(pic=tree_pic, L=scale(scale_symbols) * "\bcrecyclage", position=new_pos, align=N/10);
    }
  }
}

for (int workerID = 0; workerID < solution_nodes.length; ++workerID) {
  for (int runID = 0; runID < solution_nodes[workerID].length; ++runID) {
    for (int triang_index : solution_nodes[workerID][runID]) {
      pair new_pos = shift(0, 0.5 * size_y) * node_pos[workerID][runID][triang_index];
      label(pic=tree_pic, L=scale(scale_symbols) * "\bctrefle", position=new_pos, align=N/10);
    }
  }
}

picture statistics_pic;

real stats_pos_x = 0;
real stats_pos_y = 0;

int cnt = 0;
for (int workerID = 0; workerID < solution_nodes.length; ++workerID) {
  for (int runID = 0; runID < solution_nodes[workerID].length; ++runID) {
    for (int i = 0; i < solution_nodes[workerID][runID].length; ++i) {
      stats_pos_x += 1 * size_x;
      pair new_pos = (stats_pos_x, stats_pos_y);
      label(pic=statistics_pic, L=scale(scale_symbols) * "\bctrefle", position=new_pos, align=Center);
      ++cnt;
    }
  }
}
if (cnt > 0) {
  stats_pos_x += 1 * size_x;
  pair new_pos = (stats_pos_x, stats_pos_y);
  label(pic=statistics_pic, L=scale(scale_symbols) * format("%d", cnt), position=new_pos, align=E/10);
  stats_pos_y -= 1.5 * size_x;
}

stats_pos_x = 0;

cnt = 0;
for (int workerID = 0; workerID < deadend_nodes.length; ++workerID) {
  for (int runID = 0; runID < deadend_nodes[workerID].length; ++runID) {
    for (int i = 0; i < deadend_nodes[workerID][runID].length; ++i) {
      stats_pos_x += 1 * size_x;
      pair new_pos = (stats_pos_x, stats_pos_y);
      label(pic=statistics_pic, L=scale(scale_symbols) * "\bcinterdit", position=new_pos, align=Center);
      ++cnt;
    }
  }
}
if (cnt > 0) {
  stats_pos_x += 1 * size_x;
  pair new_pos = (stats_pos_x, stats_pos_y);
  label(pic=statistics_pic, L=scale(scale_symbols) * format("%d", cnt), position=new_pos, align=E/10);
  stats_pos_y -= 1.5 * size_x;
}

stats_pos_x = 0;

cnt = 0;
for (int workerID = 0; workerID < earlydeadend_nodes.length; ++workerID) {
  for (int runID = 0; runID < earlydeadend_nodes[workerID].length; ++runID) {
    for (int i = 0; i < earlydeadend_nodes[workerID][runID].length; ++i) {
      stats_pos_x += 1 * size_x;
      pair new_pos = (stats_pos_x, stats_pos_y);
      label(pic=statistics_pic, L=scale(scale_symbols) * "\bclampe", position=new_pos, align=Center);
      ++cnt;
    }
  }
}
if (cnt > 0) {
  stats_pos_x += 1 * size_x;
  pair new_pos = (stats_pos_x, stats_pos_y);
  label(pic=statistics_pic, L=scale(scale_symbols) * format("%d", cnt), position=new_pos, align=E/10);
  stats_pos_y -= 1.5 * size_x;
}

stats_pos_x = 0;

cnt = 0;
for (int workerID = 0; workerID < veryearlydeadend_nodes.length; ++workerID) {
  for (int runID = 0; runID < veryearlydeadend_nodes[workerID].length; ++runID) {
    for (int i = 0; i < veryearlydeadend_nodes[workerID][runID].length; ++i) {
      stats_pos_x += 1 * size_x;
      pair new_pos = (stats_pos_x, stats_pos_y);
      label(pic=statistics_pic, L=scale(scale_symbols) * "\bcdanger", position=new_pos, align=Center);
      ++cnt;
    }
  }
}
if (cnt > 0) {
  stats_pos_x += 1 * size_x;
  pair new_pos = (stats_pos_x, stats_pos_y);
  label(pic=statistics_pic, L=scale(scale_symbols) * format("%d", cnt), position=new_pos, align=E/10);
  stats_pos_y -= 1.5 * size_x;
}

stats_pos_x = 0;

cnt = 0;
for (int workerID = 0; workerID < missingvolume_nodes.length; ++workerID) {
  for (int runID = 0; runID < missingvolume_nodes[workerID].length; ++runID) {
    for (int i = 0; i < missingvolume_nodes[workerID][runID].length; ++i) {
      stats_pos_x += 1 * size_x;
      pair new_pos = (stats_pos_x, stats_pos_y);
      label(pic=statistics_pic, L=scale(scale_symbols) * "\bctetraedre", position=new_pos, align=Center);
      ++cnt;
    }
  }
}
if (cnt > 0) {
  stats_pos_x += 1 * size_x;
  pair new_pos = (stats_pos_x, stats_pos_y);
  label(pic=statistics_pic, L=scale(scale_symbols) * format("%d", cnt), position=new_pos, align=E/10);
  stats_pos_y -= 1.5 * size_x;
}

stats_pos_x = 0;

cnt = 0;
for (int workerID = 0; workerID < notnew_nodes.length; ++workerID) {
  for (int runID = 0; runID < notnew_nodes[workerID].length; ++runID) {
    for (int i = 0; i < notnew_nodes[workerID][runID].length; ++i) {
      stats_pos_x += 1 * size_x;
      pair new_pos = (stats_pos_x, stats_pos_y);
      label(pic=statistics_pic, L=scale(scale_symbols) * "\bcrecyclage", position=new_pos, align=Center);
      ++cnt;
    }
  }
}
if (cnt > 0) {
  stats_pos_x += 1 * size_x;
  pair new_pos = (stats_pos_x, stats_pos_y);
  label(pic=statistics_pic, L=scale(scale_symbols) * format("%d", cnt), position=new_pos, align=E/10);
}

shipout("TOPCOM" + filename_postfix + "tree_graph", tree_pic);
shipout("TOPCOM" + filename_postfix + "statistics", statistics_pic);

//////////////////////////////////////////////////////////////////////////////
// end of drawings section.
//////////////////////////////////////////////////////////////////////////////

// eof
