
# Copyright 2026 Free Software Foundation, Inc.

# This is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#   
# You should have received a copy of the GNU General Public License
# along with this file.  If not, see <http://www.gnu.org/licenses/>.

my $prepend_file_name_counter;
sub _test_prepend_number_prepend_counter($) {
  my $file_name = shift;
  if ($file_name !~ /^[0-9]+-/) {
    $prepend_file_name_counter++;
    $file_name = "${prepend_file_name_counter}-${file_name}";
  }
  return $file_name;
}

sub test_prepend_number_node_file_name {
  my ($converter, $element, $file_name) = @_;
  return _test_prepend_number_prepend_counter($file_name);
}

texinfo_register_file_id_setting_function('node_file_name',
                                        \&test_prepend_number_node_file_name);

sub test_prepend_number_redirection_file_names {
  my ($converter, $target_element, $filename, $node_redirection_filename,
     $reference_redirection_files) = @_;
  my $added_redirection_file
    = _test_prepend_number_prepend_counter($node_redirection_filename);
  return @$reference_redirection_files
    if ($added_redirection_file eq $filename);
  foreach my $redirection_file (@$reference_redirection_files) {
    if ($added_redirection_file eq $redirection_file) {
      return @$reference_redirection_files;
    }
  }
  my @result = (@$reference_redirection_files, $added_redirection_file);
  return @$reference_redirection_files, $added_redirection_file;
}

texinfo_register_file_id_setting_function('redirection_file_names',
                                  \&test_prepend_number_redirection_file_names);

sub test_prepend_number_init {
  $prepend_file_name_counter = 0;
}
texinfo_register_handler('init', \&test_prepend_number_init);

1;
