## TFSA-2021-178: Undefined behavior via `nullptr` reference binding in sparse matrix multiplication

### CVE Number
CVE-2021-41219

### Impact
The [code for sparse matrix multiplication](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/kernels/sparse_matmul_op.cc#L954-L1086) is vulnerable to undefined behavior via binding a reference to `nullptr`:

```python
import tensorflow as tf

tf.raw_ops.SparseMatMul(
  a=[[1.0,1.0,1.0]],
  b=[[],[],[]],
  transpose_a=False,
  transpose_b=False,
  a_is_sparse=False,
  b_is_sparse=True)
```

This occurs whenever the dimensions of `a` or `b` are 0 or less. In the case on one of these is 0, an empty output tensor should be allocated (to conserve the invariant that output tensors are always allocated when the operation is successful) but nothing should be written to it (that is, we should return early from the kernel implementation). Otherwise, attempts to write to this empty tensor would result in heap OOB access.

### Patches
We have patched the issue in GitHub commit [e6cf28c72ba2eb949ca950d834dd6d66bb01cfae](https://github.com/tensorflow/tensorflow/commit/e6cf28c72ba2eb949ca950d834dd6d66bb01cfae).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
