use indieweb::http::Client;
use serde::Serialize;
use url::Url;

#[derive(Serialize)]
pub struct DiscoverResult {
    pub url: String,
    pub endpoint: Option<String>,
}

pub async fn run(client: &impl Client, url: &Url) -> miette::Result<DiscoverResult> {
    match indieweb::standards::webmention::endpoint_for(client, url).await {
        Ok(endpoint) => Ok(DiscoverResult {
            url: url.to_string(),
            endpoint: Some(endpoint.to_string()),
        }),
        Err(_) => Ok(DiscoverResult {
            url: url.to_string(),
            endpoint: None,
        }),
    }
}
