#include <Rinternals.h>
#include <libxml/xmlversion.h>
#include <libxml/xmlerror.h>
#include <libxml/parser.h>
#include <string.h>

/* * *
 * Author: Nick Wellnhofer <wellnhofer@aevum.de>
 * Date:   Tue, 24 Oct 2023 15:02:36 +0200
 * https://github.com/GNOME/libxml2/commit/61034116d0a3c8b295c6137956adc3ae55720711
 *
 * error: Make more xmlError structs constant
 */
#if defined(LIBXML_VERSION) && (LIBXML_VERSION >= 21200)
void handleStructuredError(void* userData, const xmlError* error) {
#else
void handleStructuredError(void* userData, xmlError* error) {
#endif

  int len = strlen(error->message);
  if(len > 2){
    error->message[len-1] = '\0';
  }

  //Workaround for https://github.com/r-lib/xml2/issues/458
#ifdef __APPLE__
  xmlParserCtxt *ctxt = error->ctxt;
  static unsigned char icns[5] = { 'i', 'c', 'n', 's', '\0' };
  if(error->code == XML_ERR_DOCUMENT_EMPTY && ctxt->input && ctxt->input->base && xmlStrcmp(ctxt->input->base, icns) == 0){
    return;
  }
#endif

  if (error->level <= 2) {
    Rf_warning("%s [%i]", error->message, (int) error->code);
  } else {
    Rf_error("%s [%i]", error->message, (int) error->code);
  }
}

void handleGenericError(void *ctx, const char *fmt, ...){
  char buffer[BUFSIZ];
  va_list arg;

  if (fmt == NULL) fmt = "(null)";

  va_start(arg, fmt);
  vsnprintf(buffer, BUFSIZ, fmt, arg);
  Rf_error("%s", buffer);
}

void init_libxml2_library(void) {
  // Check that header and libs are compatible
  LIBXML_TEST_VERSION

  xmlInitParser();
  xmlSetStructuredErrorFunc(NULL, handleStructuredError);
  xmlSetGenericErrorFunc(NULL, handleGenericError);
}

