% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{fontsize}
\alias{fontsize}
\title{Set font size}
\usage{
fontsize(x, i = NULL, j = NULL, size = 11, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{size}{integer value (points)}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
Change the font size of selected rows and columns of a flextable.
}
\examples{
ft <- flextable(head(iris))
ft <- fontsize(ft, size = 14, part = "header")
ft <- fontsize(ft, size = 14, j = 2)
ft <- fontsize(ft, size = 7, j = 3)
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
