import OCP.DE
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import OCP.Resource
import OCP.TColStd
import OCP.XSControl
import OCP.TopoDS
import OCP.Standard
import OCP.TDocStd
import OCP.NCollection
__all__  = [
"DE_ConfigurationContext",
"DE_ConfigurationNode",
"DE_Provider",
"DE_ShapeFixConfigurationNode",
"DE_ShapeFixParameters",
"DE_Wrapper"
]
class DE_ConfigurationContext(OCP.Standard.Standard_Transient):
    """
    Provides convenient interface to resource file Allows loading of the resource file and getting attributes' values starting from some scope, for example if scope is defined as "ToV4" and requested parameter is "exec.op", value of "ToV4.exec.op" parameter from the resource file will be returned
    """
    def BooleanVal(self,theParam : OCP.TCollection.TCollection_AsciiString,theDefValue : bool,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Gets value of parameter as being of specific type
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetBoolean(self,theParam : OCP.TCollection.TCollection_AsciiString,theValue : bool,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Gets value of parameter as being of specific type
        """
    def GetInteger(self,theParam : OCP.TCollection.TCollection_AsciiString,theValue : int,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Gets value of parameter as being of specific type
        """
    def GetInternalMap(self) -> OCP.Resource.Resource_DataMapOfAsciiStringAsciiString: 
        """
        Gets internal resource map
        """
    def GetReal(self,theParam : OCP.TCollection.TCollection_AsciiString,theValue : float,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Gets value of parameter as being of specific type
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetString(self,theParam : OCP.TCollection.TCollection_AsciiString,theValue : OCP.TCollection.TCollection_AsciiString,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Gets value of parameter as being of specific type
        """
    def GetStringSeq(self,theParam : OCP.TCollection.TCollection_AsciiString,theValue : OCP.TColStd.TColStd_ListOfAsciiString,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Gets value of parameter as being of specific type
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IntegerVal(self,theParam : OCP.TCollection.TCollection_AsciiString,theDefValue : int,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> int: 
        """
        Gets value of parameter as being of specific type
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsParamSet(self,theParam : OCP.TCollection.TCollection_AsciiString,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Checks for existing the parameter name
        """
    def Load(self,theConfiguration : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Import the custom configuration Save all parameters with their values.
        """
    def LoadFile(self,theFile : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Import the resource file. Save all parameters with their values.
        """
    def LoadStr(self,theResource : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Import the resource string. Save all parameters with their values.
        """
    def RealVal(self,theParam : OCP.TCollection.TCollection_AsciiString,theDefValue : float,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> float: 
        """
        Gets value of parameter as being of specific type
        """
    def StringVal(self,theParam : OCP.TCollection.TCollection_AsciiString,theDefValue : OCP.TCollection.TCollection_AsciiString,theScope : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets value of parameter as being of specific type
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class DE_ConfigurationNode(OCP.Standard.Standard_Transient):
    """
    Base class to work with CAD transfer properties. Stores the necessary settings for a single Provider type. Configures and creates special provider to transfer CAD files.
    """
    def BuildProvider(self) -> DE_Provider: 
        """
        Creates new provider for the own format
        """
    def CheckContent(self,theBuffer : OCP.NCollection.NCollection_Buffer) -> bool: 
        """
        Checks the file content to verify a format
        """
    def CheckExtension(self,theExtension : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Checks the file extension to verify a format
        """
    def Copy(self) -> DE_ConfigurationNode: 
        """
        Copies values of all fields
        """
    def CustomActivation(self,arg0 : OCP.TColStd.TColStd_ListOfAsciiString) -> None: 
        """
        Custom function to activate commercial DE component. The input is special sequence of values that described in specific component documentation. Order is important. Each component can have own way of activation.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetExtensions(self) -> OCP.TColStd.TColStd_ListOfAsciiString: 
        """
        Gets list of supported file extensions
        """
    def GetFormat(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets CAD format name of associated provider
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetVendor(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets provider's vendor name of associated provider
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEnabled(self) -> bool: 
        """
        Gets the provider loading status
        """
    def IsExportSupported(self) -> bool: 
        """
        Checks the export supporting
        """
    def IsImportSupported(self) -> bool: 
        """
        Checks the import supporting
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @overload
    def Load(self,theResourcePath : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Updates values according the resource file

        Updates values according the resource
        """
    @overload
    def Load(self,theResource : DE_ConfigurationContext) -> bool: ...
    @overload
    def Save(self,theResourcePath : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Writes configuration to the resource file

        Writes configuration to the string
        """
    @overload
    def Save(self) -> OCP.TCollection.TCollection_AsciiString: ...
    def SetEnabled(self,theIsLoaded : bool) -> None: 
        """
        Sets the provider loading status
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLoad(self,theToImport : bool,theToKeep : bool) -> bool: 
        """
        Update loading status. Checking for the ability to read and write.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theConfigurationNode : DE_ConfigurationNode) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class DE_Provider(OCP.Standard.Standard_Transient):
    """
    Base class to make transfer process. Reads or Writes specialized CAD files into/from OCCT. Each operation needs the Configuration Node.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetFormat(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets CAD format name of associated provider
        """
    def GetNode(self) -> DE_ConfigurationNode: 
        """
        Gets internal configuration node
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetVendor(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets provider's vendor name of associated provider
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Reads a CAD file, according internal configuration

        Reads a CAD file, according internal configuration

        Reads a CAD file, according internal configuration

        Reads a CAD file, according internal configuration
        """
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    def SetNode(self,theNode : DE_ConfigurationNode) -> None: 
        """
        Sets internal configuration node
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Writes a CAD file, according internal configuration

        Writes a CAD file, according internal configuration

        Writes a CAD file, according internal configuration

        Writes a CAD file, according internal configuration
        """
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theNode : DE_ConfigurationNode) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class DE_ShapeFixConfigurationNode(DE_ConfigurationNode, OCP.Standard.Standard_Transient):
    """
    Base class to work with shape healing parameters for child classes.
    """
    def BuildProvider(self) -> DE_Provider: 
        """
        Creates new provider for the own format
        """
    def CheckContent(self,theBuffer : OCP.NCollection.NCollection_Buffer) -> bool: 
        """
        Checks the file content to verify a format
        """
    def CheckExtension(self,theExtension : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Checks the file extension to verify a format
        """
    def Copy(self) -> DE_ConfigurationNode: 
        """
        Copies values of all fields
        """
    def CustomActivation(self,arg0 : OCP.TColStd.TColStd_ListOfAsciiString) -> None: 
        """
        Custom function to activate commercial DE component. The input is special sequence of values that described in specific component documentation. Order is important. Each component can have own way of activation.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetExtensions(self) -> OCP.TColStd.TColStd_ListOfAsciiString: 
        """
        Gets list of supported file extensions
        """
    def GetFormat(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets CAD format name of associated provider
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetVendor(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Gets provider's vendor name of associated provider
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEnabled(self) -> bool: 
        """
        Gets the provider loading status
        """
    def IsExportSupported(self) -> bool: 
        """
        Checks the export supporting
        """
    def IsImportSupported(self) -> bool: 
        """
        Checks the import supporting
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Load(self,theResource : DE_ConfigurationContext) -> bool: 
        """
        Updates values according the resource
        """
    def Save(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Writes configuration to the string
        """
    def SetEnabled(self,theIsLoaded : bool) -> None: 
        """
        Sets the provider loading status
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLoad(self,theToImport : bool,theToKeep : bool) -> bool: 
        """
        Update loading status. Checking for the ability to read and write.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theConfigurationNode : DE_ShapeFixConfigurationNode) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    @property
    def ShapeFixParameters(self) -> DE_ShapeFixParameters:
        """
        :type: DE_ShapeFixParameters
        """
    @ShapeFixParameters.setter
    def ShapeFixParameters(self, arg0: DE_ShapeFixParameters) -> None:
        pass
    pass
class DE_ShapeFixParameters():
    """
    Struct for shape healing parameters storage
    """
    class FixMode_e():
        """
        Enum, classifying a type of value for parameters

        Members:

          FixOrNot

          NotFix

          Fix
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        Fix: OCP.DE.FixMode_e # value = <FixMode_e.Fix: 1>
        FixOrNot: OCP.DE.FixMode_e # value = <FixMode_e.FixOrNot: -1>
        NotFix: OCP.DE.FixMode_e # value = <FixMode_e.NotFix: 0>
        __entries: dict # value = {'FixOrNot': (<FixMode_e.FixOrNot: -1>, None), 'NotFix': (<FixMode_e.NotFix: 0>, None), 'Fix': (<FixMode_e.Fix: 1>, None)}
        __members__: dict # value = {'FixOrNot': <FixMode_e.FixOrNot: -1>, 'NotFix': <FixMode_e.NotFix: 0>, 'Fix': <FixMode_e.Fix: 1>}
        pass
    def __init__(self) -> None: ...
    @property
    def DetalizationLevel(self) -> OCP.TopAbs.TopAbs_ShapeEnum:
        """
        :type: OCP.TopAbs.TopAbs_ShapeEnum
        """
    @DetalizationLevel.setter
    def DetalizationLevel(self, arg0: OCP.TopAbs.TopAbs_ShapeEnum) -> None:
        pass
    Fix: OCP.DE.FixMode_e # value = <FixMode_e.Fix: 1>
    FixOrNot: OCP.DE.FixMode_e # value = <FixMode_e.FixOrNot: -1>
    NotFix: OCP.DE.FixMode_e # value = <FixMode_e.NotFix: 0>
    pass
class DE_Wrapper(OCP.Standard.Standard_Transient):
    """
    The main class for working with CAD file exchange. Loads and Saves special CAD transfer property. Consolidates all supported Formats and Vendors. Automatically recognizes CAD format and uses the preferred existed Vendor. Note: If Vendor's format is not binded, the configuration loading doesn't affect on its property.
    """
    def Bind(self,theNode : DE_ConfigurationNode) -> bool: 
        """
        Creates new node copy and adds to the map
        """
    @overload
    def ChangePriority(self,theFormat : OCP.TCollection.TCollection_AsciiString,theVendorPriority : OCP.TColStd.TColStd_ListOfAsciiString,theToDisable : bool=False) -> None: 
        """
        Changes provider priority to one format if it exists

        Changes provider priority to all loaded nodes
        """
    @overload
    def ChangePriority(self,theVendorPriority : OCP.TColStd.TColStd_ListOfAsciiString,theToDisable : bool=False) -> None: ...
    def Copy(self) -> DE_Wrapper: 
        """
        Copies values of all fields
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Find(self,theFormat : OCP.TCollection.TCollection_AsciiString,theVendor : OCP.TCollection.TCollection_AsciiString,theNode : DE_ConfigurationNode) -> bool: 
        """
        Finds a node associated with input format and vendor
        """
    def FindProvider(self,thePath : OCP.TCollection.TCollection_AsciiString,theToImport : bool,theProvider : DE_Provider) -> bool: 
        """
        Find available provider from the configuration. If there are several providers, choose the one with the highest priority.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    @staticmethod
    def GlobalLoadMutex_s() -> OCP.Standard.Standard_Mutex: ...
    @staticmethod
    def GlobalWrapper_s() -> DE_Wrapper: 
        """
        Gets global configuration singleton. If wrapper is not set, create it by default as base class object.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def KeepUpdates(self) -> bool: 
        """
        Gets flag that keeps changes on configuration nodes which are being updated, false by default
        """
    @overload
    def Load(self,theResource : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theIsRecursive : bool=True) -> bool: 
        """
        Updates values according the resource file

        Updates values according the resource
        """
    @overload
    def Load(self,theResource : DE_ConfigurationContext,theIsRecursive : bool=True) -> bool: ...
    def Nodes(self) -> Any: 
        """
        Gets format map, contains vendor map with nodes
        """
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Reads a CAD file, according internal configuration

        Reads a CAD file, according internal configuration

        Reads a CAD file, according internal configuration

        Reads a CAD file, according internal configuration
        """
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Read(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Save(self,theResourcePath : OCP.TCollection.TCollection_AsciiString,theIsRecursive : bool=True,theFormats : OCP.TColStd.TColStd_ListOfAsciiString=OCP.TColStd.TColStd_ListOfAsciiString,theVendors : OCP.TColStd.TColStd_ListOfAsciiString=OCP.TColStd.TColStd_ListOfAsciiString) -> bool: 
        """
        Writes configuration to the resource file

        Writes configuration to the string
        """
    @overload
    def Save(self,theIsRecursive : bool=True,theFormats : OCP.TColStd.TColStd_ListOfAsciiString=OCP.TColStd.TColStd_ListOfAsciiString,theVendors : OCP.TColStd.TColStd_ListOfAsciiString=OCP.TColStd.TColStd_ListOfAsciiString) -> OCP.TCollection.TCollection_AsciiString: ...
    @staticmethod
    def SetGlobalWrapper_s(theWrapper : DE_Wrapper) -> None: 
        """
        Sets global configuration singleton
        """
    def SetKeepUpdates(self,theToKeepUpdates : bool) -> None: 
        """
        Sets flag that keeps changes on configuration nodes which are being updated, false by default
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnBind(self,theNode : DE_ConfigurationNode) -> bool: 
        """
        Removes node with the same type from the map
        """
    def UpdateLoad(self,theToForceUpdate : bool=False) -> None: 
        """
        Updates all registered nodes, all changes will be saved in nodes
        """
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Writes a CAD file, according internal configuration

        Writes a CAD file, according internal configuration

        Writes a CAD file, according internal configuration

        Writes a CAD file, according internal configuration
        """
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theDocument : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theWS : OCP.XSControl.XSControl_WorkSession,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Write(self,thePath : OCP.TCollection.TCollection_AsciiString,theShape : OCP.TopoDS.TopoDS_Shape,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theWrapper : DE_Wrapper) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
