# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import VectorQueryKind, VectorThresholdKind

if TYPE_CHECKING:
    from .. import models as _models


class AutocompleteItem(_Model):
    """The result of Autocomplete requests.

    :ivar text: The completed term. Required.
    :vartype text: str
    :ivar query_plus_text: The query along with the completed term. Required.
    :vartype query_plus_text: str
    """

    text: str = rest_field(visibility=["read"])
    """The completed term. Required."""
    query_plus_text: str = rest_field(name="queryPlusText", visibility=["read"])
    """The query along with the completed term. Required."""


class AutocompleteResult(_Model):
    """The result of Autocomplete query.

    :ivar coverage: A value indicating the percentage of the index that was considered by the
     autocomplete request, or null if minimumCoverage was not specified in the request.
    :vartype coverage: float
    :ivar results: The list of returned Autocompleted items. Required.
    :vartype results: list[~azure.search.documents.models.AutocompleteItem]
    """

    coverage: Optional[float] = rest_field(name="@search.coverage", visibility=["read"])
    """A value indicating the percentage of the index that was considered by the autocomplete request,
     or null if minimumCoverage was not specified in the request."""
    results: list["_models.AutocompleteItem"] = rest_field(name="value", visibility=["read"])
    """The list of returned Autocompleted items. Required."""


class DebugInfo(_Model):
    """Contains debugging information that can be used to further explore your search results.

    :ivar query_rewrites: Contains debugging information specific to query rewrites.
    :vartype query_rewrites: ~azure.search.documents.models.QueryRewritesDebugInfo
    """

    query_rewrites: Optional["_models.QueryRewritesDebugInfo"] = rest_field(name="queryRewrites", visibility=["read"])
    """Contains debugging information specific to query rewrites."""


class DocumentDebugInfo(_Model):
    """Contains debugging information that can be used to further explore your search results.

    :ivar semantic: Contains debugging information specific to semantic ranking requests.
    :vartype semantic: ~azure.search.documents.models.SemanticDebugInfo
    :ivar vectors: Contains debugging information specific to vector and hybrid search.
    :vartype vectors: ~azure.search.documents.models.VectorsDebugInfo
    :ivar inner_hits: Contains debugging information specific to vectors matched within a
     collection of complex types.
    :vartype inner_hits: dict[str,
     list[~azure.search.documents.models.QueryResultDocumentInnerHit]]
    """

    semantic: Optional["_models.SemanticDebugInfo"] = rest_field(visibility=["read"])
    """Contains debugging information specific to semantic ranking requests."""
    vectors: Optional["_models.VectorsDebugInfo"] = rest_field(visibility=["read"])
    """Contains debugging information specific to vector and hybrid search."""
    inner_hits: Optional[dict[str, list["_models.QueryResultDocumentInnerHit"]]] = rest_field(
        name="innerHits", visibility=["read"]
    )
    """Contains debugging information specific to vectors matched within a collection of complex
     types."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: dict[str, any]
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[dict[str, Any]] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.search.documents.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.search.documents.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.search.documents.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FacetResult(_Model):
    """A single bucket of a facet query result. Reports the number of documents with a field value
    falling within a particular range or having a particular value or interval.

    :ivar count: The approximate count of documents falling within the bucket described by this
     facet.
    :vartype count: int
    :ivar avg: The resulting total avg for the facet when a avg metric is requested.
    :vartype avg: float
    :ivar min: The resulting total min for the facet when a min metric is requested.
    :vartype min: float
    :ivar max: The resulting total max for the facet when a max metric is requested.
    :vartype max: float
    :ivar sum: The resulting total sum for the facet when a sum metric is requested.
    :vartype sum: float
    :ivar cardinality: The resulting total cardinality for the facet when a cardinality metric is
     requested.
    :vartype cardinality: int
    :ivar facets: The nested facet query results for the search operation, organized as a
     collection of buckets for each faceted field; null if the query did not contain any nested
     facets.
    :vartype facets: dict[str, list[~azure.search.documents.models.FacetResult]]
    """

    count: Optional[int] = rest_field(visibility=["read"])
    """The approximate count of documents falling within the bucket described by this facet."""
    avg: Optional[float] = rest_field(visibility=["read"])
    """The resulting total avg for the facet when a avg metric is requested."""
    min: Optional[float] = rest_field(visibility=["read"])
    """The resulting total min for the facet when a min metric is requested."""
    max: Optional[float] = rest_field(visibility=["read"])
    """The resulting total max for the facet when a max metric is requested."""
    sum: Optional[float] = rest_field(visibility=["read"])
    """The resulting total sum for the facet when a sum metric is requested."""
    cardinality: Optional[int] = rest_field(visibility=["read"])
    """The resulting total cardinality for the facet when a cardinality metric is requested."""
    facets: Optional[dict[str, list["_models.FacetResult"]]] = rest_field(name="@search.facets", visibility=["read"])
    """The nested facet query results for the search operation, organized as a collection of buckets
     for each faceted field; null if the query did not contain any nested facets."""


class HybridSearch(_Model):
    """TThe query parameters to configure hybrid search behaviors.

    :ivar max_text_recall_size: Determines the maximum number of documents to be retrieved by the
     text query portion of a hybrid search request. Those documents will be combined with the
     documents matching the vector queries to produce a single final list of results. Choosing a
     larger maxTextRecallSize value will allow retrieving and paging through more documents (using
     the top and skip parameters), at the cost of higher resource utilization and higher latency.
     The value needs to be between 1 and 10,000. Default is 1000.
    :vartype max_text_recall_size: int
    :ivar count_and_facet_mode: Determines whether the count and facets should includes all
     documents that matched the search query, or only the documents that are retrieved within the
     'maxTextRecallSize' window. Known values are: "countRetrievableResults" and "countAllResults".
    :vartype count_and_facet_mode: str or ~azure.search.documents.models.HybridCountAndFacetMode
    """

    max_text_recall_size: Optional[int] = rest_field(
        name="maxTextRecallSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines the maximum number of documents to be retrieved by the text query portion of a
     hybrid search request. Those documents will be combined with the documents matching the vector
     queries to produce a single final list of results. Choosing a larger maxTextRecallSize value
     will allow retrieving and paging through more documents (using the top and skip parameters), at
     the cost of higher resource utilization and higher latency. The value needs to be between 1 and
     10,000. Default is 1000."""
    count_and_facet_mode: Optional[Union[str, "_models.HybridCountAndFacetMode"]] = rest_field(
        name="countAndFacetMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines whether the count and facets should includes all documents that matched the search
     query, or only the documents that are retrieved within the 'maxTextRecallSize' window. Known
     values are: \"countRetrievableResults\" and \"countAllResults\"."""

    @overload
    def __init__(
        self,
        *,
        max_text_recall_size: Optional[int] = None,
        count_and_facet_mode: Optional[Union[str, "_models.HybridCountAndFacetMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexAction(_Model):
    """Represents an index action that operates on a document.

    :ivar action_type: The operation to perform on a document in an indexing batch. Known values
     are: "upload", "merge", "mergeOrUpload", and "delete".
    :vartype action_type: str or ~azure.search.documents.models.IndexActionType
    """

    action_type: Optional[Union[str, "_models.IndexActionType"]] = rest_field(
        name="@search.action", visibility=["read", "create", "update", "delete", "query"]
    )
    """The operation to perform on a document in an indexing batch. Known values are: \"upload\",
     \"merge\", \"mergeOrUpload\", and \"delete\"."""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.IndexActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexDocumentsBatch(_Model):
    """Contains a batch of document write actions to send to the index.

    :ivar actions: The actions in the batch. Required.
    :vartype actions: list[~azure.search.documents.models.IndexAction]
    """

    actions: list["_models.IndexAction"] = rest_field(
        name="value", visibility=["read", "create", "update", "delete", "query"]
    )
    """The actions in the batch. Required."""

    @overload
    def __init__(
        self,
        *,
        actions: list["_models.IndexAction"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexDocumentsResult(_Model):
    """Response containing the status of operations for all documents in the indexing request.

    :ivar results: The list of status information for each document in the indexing request.
     Required.
    :vartype results: list[~azure.search.documents.models.IndexingResult]
    """

    results: list["_models.IndexingResult"] = rest_field(name="value", visibility=["read"])
    """The list of status information for each document in the indexing request. Required."""


class IndexingResult(_Model):
    """Status of an indexing operation for a single document.

    :ivar key: The key of a document that was in the indexing request. Required.
    :vartype key: str
    :ivar error_message: The error message explaining why the indexing operation failed for the
     document identified by the key; null if indexing succeeded.
    :vartype error_message: str
    :ivar succeeded: A value indicating whether the indexing operation succeeded for the document
     identified by the key. Required.
    :vartype succeeded: bool
    :ivar status_code: The status code of the indexing operation. Possible values include: 200 for
     a successful update or delete, 201 for successful document creation, 400 for a malformed input
     document, 404 for document not found, 409 for a version conflict, 422 when the index is
     temporarily unavailable, or 503 for when the service is too busy. Required.
    :vartype status_code: int
    """

    key: str = rest_field(visibility=["read"])
    """The key of a document that was in the indexing request. Required."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """The error message explaining why the indexing operation failed for the document identified by
     the key; null if indexing succeeded."""
    succeeded: bool = rest_field(name="status", visibility=["read"])
    """A value indicating whether the indexing operation succeeded for the document identified by the
     key. Required."""
    status_code: int = rest_field(name="statusCode", visibility=["read"])
    """The status code of the indexing operation. Possible values include: 200 for a successful update
     or delete, 201 for successful document creation, 400 for a malformed input document, 404 for
     document not found, 409 for a version conflict, 422 when the index is temporarily unavailable,
     or 503 for when the service is too busy. Required."""


class LookupDocument(_Model):
    """A document retrieved via a document lookup operation."""


class QueryAnswerResult(_Model):
    """An answer is a text passage extracted from the contents of the most relevant documents that
    matched the query. Answers are extracted from the top search results. Answer candidates are
    scored and the top answers are selected.

    :ivar score: The score value represents how relevant the answer is to the query relative to
     other answers returned for the query.
    :vartype score: float
    :ivar key: The key of the document the answer was extracted from.
    :vartype key: str
    :ivar text: The text passage extracted from the document contents as the answer.
    :vartype text: str
    :ivar highlights: Same text passage as in the Text property with highlighted text phrases most
     relevant to the query.
    :vartype highlights: str
    """

    score: Optional[float] = rest_field(visibility=["read"])
    """The score value represents how relevant the answer is to the query relative to other answers
     returned for the query."""
    key: Optional[str] = rest_field(visibility=["read"])
    """The key of the document the answer was extracted from."""
    text: Optional[str] = rest_field(visibility=["read"])
    """The text passage extracted from the document contents as the answer."""
    highlights: Optional[str] = rest_field(visibility=["read"])
    """Same text passage as in the Text property with highlighted text phrases most relevant to the
     query."""


class QueryCaptionResult(_Model):
    """Captions are the most representative passages from the document relatively to the search query.
    They are often used as document summary. Captions are only returned for queries of type
    ``semantic``.

    :ivar text: A representative text passage extracted from the document most relevant to the
     search query.
    :vartype text: str
    :ivar highlights: Same text passage as in the Text property with highlighted phrases most
     relevant to the query.
    :vartype highlights: str
    """

    text: Optional[str] = rest_field(visibility=["read"])
    """A representative text passage extracted from the document most relevant to the search query."""
    highlights: Optional[str] = rest_field(visibility=["read"])
    """Same text passage as in the Text property with highlighted phrases most relevant to the query."""


class QueryResultDocumentInnerHit(_Model):
    """Detailed scoring information for an individual element of a complex collection.

    :ivar ordinal: Position of this specific matching element within it's original collection.
     Position starts at 0.
    :vartype ordinal: int
    :ivar vectors: Detailed scoring information for an individual element of a complex collection
     that matched a vector query.
    :vartype vectors: list[dict[str, ~azure.search.documents.models.SingleVectorFieldResult]]
    """

    ordinal: Optional[int] = rest_field(visibility=["read"])
    """Position of this specific matching element within it's original collection. Position starts at
     0."""
    vectors: Optional[list[dict[str, "_models.SingleVectorFieldResult"]]] = rest_field(visibility=["read"])
    """Detailed scoring information for an individual element of a complex collection that matched a
     vector query."""


class QueryResultDocumentRerankerInput(_Model):
    """The raw concatenated strings that were sent to the semantic enrichment process.

    :ivar title: The raw string for the title field that was used for semantic enrichment.
    :vartype title: str
    :ivar content: The raw concatenated strings for the content fields that were used for semantic
     enrichment.
    :vartype content: str
    :ivar keywords: The raw concatenated strings for the keyword fields that were used for semantic
     enrichment.
    :vartype keywords: str
    """

    title: Optional[str] = rest_field(visibility=["read"])
    """The raw string for the title field that was used for semantic enrichment."""
    content: Optional[str] = rest_field(visibility=["read"])
    """The raw concatenated strings for the content fields that were used for semantic enrichment."""
    keywords: Optional[str] = rest_field(visibility=["read"])
    """The raw concatenated strings for the keyword fields that were used for semantic enrichment."""


class QueryResultDocumentSemanticField(_Model):
    """Description of fields that were sent to the semantic enrichment process, as well as how they
    were used.

    :ivar name: The name of the field that was sent to the semantic enrichment process.
    :vartype name: str
    :ivar state: The way the field was used for the semantic enrichment process (fully used,
     partially used, or unused). Known values are: "used", "unused", and "partial".
    :vartype state: str or ~azure.search.documents.models.SemanticFieldState
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the field that was sent to the semantic enrichment process."""
    state: Optional[Union[str, "_models.SemanticFieldState"]] = rest_field(visibility=["read"])
    """The way the field was used for the semantic enrichment process (fully used, partially used, or
     unused). Known values are: \"used\", \"unused\", and \"partial\"."""


class QueryResultDocumentSubscores(_Model):
    """The breakdown of subscores between the text and vector query components of the search query for
    this document. Each vector query is shown as a separate object in the same order they were
    received.

    :ivar text: The BM25 or Classic score for the text portion of the query.
    :vartype text: ~azure.search.documents.models.TextResult
    :ivar vectors: The vector similarity and.
    :vartype vectors: list[dict[str, ~azure.search.documents.models.SingleVectorFieldResult]]
    :ivar document_boost: The BM25 or Classic score for the text portion of the query.
    :vartype document_boost: float
    """

    text: Optional["_models.TextResult"] = rest_field(visibility=["read"])
    """The BM25 or Classic score for the text portion of the query."""
    vectors: Optional[list[dict[str, "_models.SingleVectorFieldResult"]]] = rest_field(visibility=["read"])
    """The vector similarity and."""
    document_boost: Optional[float] = rest_field(name="documentBoost", visibility=["read"])
    """The BM25 or Classic score for the text portion of the query."""


class QueryRewritesDebugInfo(_Model):
    """Contains debugging information specific to query rewrites.

    :ivar text: List of query rewrites generated for the text query.
    :vartype text: ~azure.search.documents.models.QueryRewritesValuesDebugInfo
    :ivar vectors: List of query rewrites generated for the vectorizable text queries.
    :vartype vectors: list[~azure.search.documents.models.QueryRewritesValuesDebugInfo]
    """

    text: Optional["_models.QueryRewritesValuesDebugInfo"] = rest_field(visibility=["read"])
    """List of query rewrites generated for the text query."""
    vectors: Optional[list["_models.QueryRewritesValuesDebugInfo"]] = rest_field(visibility=["read"])
    """List of query rewrites generated for the vectorizable text queries."""


class QueryRewritesValuesDebugInfo(_Model):
    """Contains debugging information specific to query rewrites.

    :ivar input_query: The input text to the generative query rewriting model. There may be cases
     where the user query and the input to the generative model are not identical.
    :vartype input_query: str
    :ivar rewrites: List of query rewrites.
    :vartype rewrites: list[str]
    """

    input_query: Optional[str] = rest_field(name="inputQuery", visibility=["read"])
    """The input text to the generative query rewriting model. There may be cases where the user query
     and the input to the generative model are not identical."""
    rewrites: Optional[list[str]] = rest_field(visibility=["read"])
    """List of query rewrites."""


class SearchDocumentsResult(_Model):
    """Response containing search results from an index.

    :ivar count: The total count of results found by the search operation, or null if the count was
     not requested. If present, the count may be greater than the number of results in this
     response. This can happen if you use the $top or $skip parameters, or if the query can't return
     all the requested documents in a single response.
    :vartype count: int
    :ivar coverage: A value indicating the percentage of the index that was included in the query,
     or null if minimumCoverage was not specified in the request.
    :vartype coverage: float
    :ivar facets: The facet query results for the search operation, organized as a collection of
     buckets for each faceted field; null if the query did not include any facet expressions.
    :vartype facets: dict[str, list[~azure.search.documents.models.FacetResult]]
    :ivar answers: The answers query results for the search operation; null if the answers query
     parameter was not specified or set to 'none'.
    :vartype answers: list[~azure.search.documents.models.QueryAnswerResult]
    :ivar debug_info: Debug information that applies to the search results as a whole.
    :vartype debug_info: ~azure.search.documents.models.DebugInfo
    :ivar next_page_parameters: Continuation JSON payload returned when the query can't return all
     the requested results in a single response. You can use this JSON along with.
    :vartype next_page_parameters: ~azure.search.documents.models.SearchRequest
    :ivar results: The sequence of results returned by the query. Required.
    :vartype results: list[~azure.search.documents.models.SearchResult]
    :ivar next_link: Continuation URL returned when the query can't return all the requested
     results in a single response. You can use this URL to formulate another GET or POST Search
     request to get the next part of the search response. Make sure to use the same verb (GET or
     POST) as the request that produced this response.
    :vartype next_link: str
    :ivar semantic_partial_response_reason: Reason that a partial response was returned for a
     semantic ranking request. Known values are: "maxWaitExceeded", "capacityOverloaded", and
     "transient".
    :vartype semantic_partial_response_reason: str or
     ~azure.search.documents.models.SemanticErrorReason
    :ivar semantic_partial_response_type: Type of partial response that was returned for a semantic
     ranking request. Known values are: "baseResults" and "rerankedResults".
    :vartype semantic_partial_response_type: str or
     ~azure.search.documents.models.SemanticSearchResultsType
    :ivar semantic_query_rewrites_result_type: Type of query rewrite that was used to retrieve
     documents. "originalQueryOnly"
    :vartype semantic_query_rewrites_result_type: str or
     ~azure.search.documents.models.SemanticQueryRewritesResultType
    """

    count: Optional[int] = rest_field(name="@odata.count", visibility=["read"])
    """The total count of results found by the search operation, or null if the count was not
     requested. If present, the count may be greater than the number of results in this response.
     This can happen if you use the $top or $skip parameters, or if the query can't return all the
     requested documents in a single response."""
    coverage: Optional[float] = rest_field(name="@search.coverage", visibility=["read"])
    """A value indicating the percentage of the index that was included in the query, or null if
     minimumCoverage was not specified in the request."""
    facets: Optional[dict[str, list["_models.FacetResult"]]] = rest_field(name="@search.facets", visibility=["read"])
    """The facet query results for the search operation, organized as a collection of buckets for each
     faceted field; null if the query did not include any facet expressions."""
    answers: Optional[list["_models.QueryAnswerResult"]] = rest_field(name="@search.answers", visibility=["read"])
    """The answers query results for the search operation; null if the answers query parameter was not
     specified or set to 'none'."""
    debug_info: Optional["_models.DebugInfo"] = rest_field(name="@search.debug", visibility=["read"])
    """Debug information that applies to the search results as a whole."""
    next_page_parameters: Optional["_models.SearchRequest"] = rest_field(
        name="@search.nextPageParameters", visibility=["read"]
    )
    """Continuation JSON payload returned when the query can't return all the requested results in a
     single response. You can use this JSON along with."""
    results: list["_models.SearchResult"] = rest_field(name="value", visibility=["read"])
    """The sequence of results returned by the query. Required."""
    next_link: Optional[str] = rest_field(name="@odata.nextLink", visibility=["read"])
    """Continuation URL returned when the query can't return all the requested results in a single
     response. You can use this URL to formulate another GET or POST Search request to get the next
     part of the search response. Make sure to use the same verb (GET or POST) as the request that
     produced this response."""
    semantic_partial_response_reason: Optional[Union[str, "_models.SemanticErrorReason"]] = rest_field(
        name="@search.semanticPartialResponseReason", visibility=["read"]
    )
    """Reason that a partial response was returned for a semantic ranking request. Known values are:
     \"maxWaitExceeded\", \"capacityOverloaded\", and \"transient\"."""
    semantic_partial_response_type: Optional[Union[str, "_models.SemanticSearchResultsType"]] = rest_field(
        name="@search.semanticPartialResponseType", visibility=["read"]
    )
    """Type of partial response that was returned for a semantic ranking request. Known values are:
     \"baseResults\" and \"rerankedResults\"."""
    semantic_query_rewrites_result_type: Optional[Union[str, "_models.SemanticQueryRewritesResultType"]] = rest_field(
        name="@search.semanticQueryRewritesResultType", visibility=["read"]
    )
    """Type of query rewrite that was used to retrieve documents. \"originalQueryOnly\""""


class SearchRequest(_Model):
    """Parameters for filtering, sorting, faceting, paging, and other search query behaviors.

    :ivar include_total_count: A value that specifies whether to fetch the total count of results.
     Default is false. Setting this value to true may have a performance impact. Note that the count
     returned is an approximation.
    :vartype include_total_count: bool
    :ivar facets: The list of facet expressions to apply to the search query. Each facet expression
     contains a field name, optionally followed by a comma-separated list of name:value pairs.
    :vartype facets: list[str]
    :ivar filter: The OData $filter expression to apply to the search query.
    :vartype filter: str
    :ivar highlight_fields: The comma-separated list of field names to use for hit highlights. Only
     searchable fields can be used for hit highlighting.
    :vartype highlight_fields: list[str]
    :ivar highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. Default is &lt;/em&gt;.
    :vartype highlight_post_tag: str
    :ivar highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. Default is &lt;em&gt;.
    :vartype highlight_pre_tag: str
    :ivar minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by a search query in order for the query to be reported as a success. This
     parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 100.
    :vartype minimum_coverage: float
    :ivar order_by: The comma-separated list of OData $orderby expressions by which to sort the
     results. Each expression can be either a field name or a call to either the geo.distance() or
     the search.score() functions. Each expression can be followed by asc to indicate ascending, or
     desc to indicate descending. The default is ascending order. Ties will be broken by the match
     scores of documents. If no $orderby is specified, the default sort order is descending by
     document match score. There can be at most 32 $orderby clauses.
    :vartype order_by: list[str]
    :ivar query_type: A value that specifies the syntax of the search query. The default is
     'simple'. Use 'full' if your query uses the Lucene query syntax. Known values are: "simple",
     "full", and "semantic".
    :vartype query_type: str or ~azure.search.documents.models.QueryType
    :ivar scoring_statistics: A value that specifies whether we want to calculate scoring
     statistics (such as document frequency) globally for more consistent scoring, or locally, for
     lower latency. The default is 'local'. Use 'global' to aggregate scoring statistics globally
     before scoring. Using global scoring statistics can increase latency of search queries. Known
     values are: "local" and "global".
    :vartype scoring_statistics: str or ~azure.search.documents.models.ScoringStatistics
    :ivar session_id: A value to be used to create a sticky session, which can help getting more
     consistent results. As long as the same sessionId is used, a best-effort attempt will be made
     to target the same replica set. Be wary that reusing the same sessionID values repeatedly can
     interfere with the load balancing of the requests across replicas and adversely affect the
     performance of the search service. The value used as sessionId cannot start with a '_'
     character.
    :vartype session_id: str
    :ivar scoring_parameters: The list of parameter values to be used in scoring functions (for
     example, referencePointParameter) using the format name-values. For example, if the scoring
     profile defines a function with a parameter called 'mylocation' the parameter string would be
     "mylocation--122.2,44.8" (without the quotes).
    :vartype scoring_parameters: list[str]
    :ivar scoring_profile: The name of a scoring profile to evaluate match scores for matching
     documents in order to sort the results.
    :vartype scoring_profile: str
    :ivar debug: Enables a debugging tool that can be used to further explore your reranked
     results. Known values are: "disabled", "semantic", "vector", "queryRewrites", "innerHits", and
     "all".
    :vartype debug: str or ~azure.search.documents.models.QueryDebugMode
    :ivar search_text: A full-text search query expression; Use "*" or omit this parameter to match
     all documents.
    :vartype search_text: str
    :ivar search_fields: The comma-separated list of field names to which to scope the full-text
     search. When using fielded search (fieldName:searchExpression) in a full Lucene query, the
     field names of each fielded search expression take precedence over any field names listed in
     this parameter.
    :vartype search_fields: list[str]
    :ivar search_mode: A value that specifies whether any or all of the search terms must be
     matched in order to count the document as a match. Known values are: "any" and "all".
    :vartype search_mode: str or ~azure.search.documents.models.SearchMode
    :ivar query_language: A value that specifies the language of the search query. Known values
     are: "none", "en-us", "en-gb", "en-in", "en-ca", "en-au", "fr-fr", "fr-ca", "de-de", "es-es",
     "es-mx", "zh-cn", "zh-tw", "pt-br", "pt-pt", "it-it", "ja-jp", "ko-kr", "ru-ru", "cs-cz",
     "nl-be", "nl-nl", "hu-hu", "pl-pl", "sv-se", "tr-tr", "hi-in", "ar-sa", "ar-eg", "ar-ma",
     "ar-kw", "ar-jo", "da-dk", "no-no", "bg-bg", "hr-hr", "hr-ba", "ms-my", "ms-bn", "sl-sl",
     "ta-in", "vi-vn", "el-gr", "ro-ro", "is-is", "id-id", "th-th", "lt-lt", "uk-ua", "lv-lv",
     "et-ee", "ca-es", "fi-fi", "sr-ba", "sr-me", "sr-rs", "sk-sk", "nb-no", "hy-am", "bn-in",
     "eu-es", "gl-es", "gu-in", "he-il", "ga-ie", "kn-in", "ml-in", "mr-in", "fa-ae", "pa-in",
     "te-in", and "ur-pk".
    :vartype query_language: str or ~azure.search.documents.models.QueryLanguage
    :ivar query_speller: A value that specifies the type of the speller to use to spell-correct
     individual search query terms. Known values are: "none" and "lexicon".
    :vartype query_speller: str or ~azure.search.documents.models.QuerySpellerType
    :ivar select: The comma-separated list of fields to retrieve. If unspecified, all fields marked
     as retrievable in the schema are included.
    :vartype select: list[str]
    :ivar skip: The number of search results to skip. This value cannot be greater than 100,000. If
     you need to scan documents in sequence, but cannot use skip due to this limitation, consider
     using orderby on a totally-ordered key and filter with a range query instead.
    :vartype skip: int
    :ivar top: The number of search results to retrieve. This can be used in conjunction with $skip
     to implement client-side paging of search results. If results are truncated due to server-side
     paging, the response will include a continuation token that can be used to issue another Search
     request for the next page of results.
    :vartype top: int
    :ivar semantic_configuration_name: The name of a semantic configuration that will be used when
     processing documents for queries of type semantic.
    :vartype semantic_configuration_name: str
    :ivar semantic_error_handling: Allows the user to choose whether a semantic call should fail
     completely (default / current behavior), or to return partial results. Known values are:
     "partial" and "fail".
    :vartype semantic_error_handling: str or ~azure.search.documents.models.SemanticErrorMode
    :ivar semantic_max_wait_in_milliseconds: Allows the user to set an upper bound on the amount of
     time it takes for semantic enrichment to finish processing before the request fails.
    :vartype semantic_max_wait_in_milliseconds: int
    :ivar semantic_query: Allows setting a separate search query that will be solely used for
     semantic reranking, semantic captions and semantic answers. Is useful for scenarios where there
     is a need to use different queries between the base retrieval and ranking phase, and the L2
     semantic phase.
    :vartype semantic_query: str
    :ivar answers: A value that specifies whether answers should be returned as part of the search
     response. Known values are: "none" and "extractive".
    :vartype answers: str or ~azure.search.documents.models.QueryAnswerType
    :ivar captions: A value that specifies whether captions should be returned as part of the
     search response. Known values are: "none" and "extractive".
    :vartype captions: str or ~azure.search.documents.models.QueryCaptionType
    :ivar query_rewrites: A value that specifies whether query rewrites should be generated to
     augment the search query. Known values are: "none" and "generative".
    :vartype query_rewrites: str or ~azure.search.documents.models.QueryRewritesType
    :ivar semantic_fields: The comma-separated list of field names used for semantic ranking.
    :vartype semantic_fields: list[str]
    :ivar vector_queries: The query parameters for vector and hybrid search queries.
    :vartype vector_queries: list[~azure.search.documents.models.VectorQuery]
    :ivar vector_filter_mode: Determines whether or not filters are applied before or after the
     vector search is performed. Default is 'preFilter' for new indexes. Known values are:
     "postFilter", "preFilter", and "strictPostFilter".
    :vartype vector_filter_mode: str or ~azure.search.documents.models.VectorFilterMode
    :ivar hybrid_search: The query parameters to configure hybrid search behaviors.
    :vartype hybrid_search: ~azure.search.documents.models.HybridSearch
    """

    include_total_count: Optional[bool] = rest_field(
        name="count", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies whether to fetch the total count of results. Default is false. Setting
     this value to true may have a performance impact. Note that the count returned is an
     approximation."""
    facets: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of facet expressions to apply to the search query. Each facet expression contains a
     field name, optionally followed by a comma-separated list of name:value pairs."""
    filter: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The OData $filter expression to apply to the search query."""
    highlight_fields: Optional[list[str]] = rest_field(
        name="highlight", visibility=["read", "create", "update", "delete", "query"], format="commaDelimited"
    )
    """The comma-separated list of field names to use for hit highlights. Only searchable fields can
     be used for hit highlighting."""
    highlight_post_tag: Optional[str] = rest_field(
        name="highlightPostTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """A string tag that is appended to hit highlights. Must be set with highlightPreTag. Default is
     &lt;/em&gt;."""
    highlight_pre_tag: Optional[str] = rest_field(
        name="highlightPreTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """A string tag that is prepended to hit highlights. Must be set with highlightPostTag. Default is
     &lt;em&gt;."""
    minimum_coverage: Optional[float] = rest_field(
        name="minimumCoverage", visibility=["read", "create", "update", "delete", "query"]
    )
    """A number between 0 and 100 indicating the percentage of the index that must be covered by a
     search query in order for the query to be reported as a success. This parameter can be useful
     for ensuring search availability even for services with only one replica. The default is 100."""
    order_by: Optional[list[str]] = rest_field(
        name="orderby", visibility=["read", "create", "update", "delete", "query"], format="commaDelimited"
    )
    """The comma-separated list of OData $orderby expressions by which to sort the results. Each
     expression can be either a field name or a call to either the geo.distance() or the
     search.score() functions. Each expression can be followed by asc to indicate ascending, or desc
     to indicate descending. The default is ascending order. Ties will be broken by the match scores
     of documents. If no $orderby is specified, the default sort order is descending by document
     match score. There can be at most 32 $orderby clauses."""
    query_type: Optional[Union[str, "_models.QueryType"]] = rest_field(
        name="queryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies the syntax of the search query. The default is 'simple'. Use 'full' if
     your query uses the Lucene query syntax. Known values are: \"simple\", \"full\", and
     \"semantic\"."""
    scoring_statistics: Optional[Union[str, "_models.ScoringStatistics"]] = rest_field(
        name="scoringStatistics", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies whether we want to calculate scoring statistics (such as document
     frequency) globally for more consistent scoring, or locally, for lower latency. The default is
     'local'. Use 'global' to aggregate scoring statistics globally before scoring. Using global
     scoring statistics can increase latency of search queries. Known values are: \"local\" and
     \"global\"."""
    session_id: Optional[str] = rest_field(name="sessionId", visibility=["read", "create", "update", "delete", "query"])
    """A value to be used to create a sticky session, which can help getting more consistent results.
     As long as the same sessionId is used, a best-effort attempt will be made to target the same
     replica set. Be wary that reusing the same sessionID values repeatedly can interfere with the
     load balancing of the requests across replicas and adversely affect the performance of the
     search service. The value used as sessionId cannot start with a '_' character."""
    scoring_parameters: Optional[list[str]] = rest_field(
        name="scoringParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of parameter values to be used in scoring functions (for example,
     referencePointParameter) using the format name-values. For example, if the scoring profile
     defines a function with a parameter called 'mylocation' the parameter string would be
     \"mylocation--122.2,44.8\" (without the quotes)."""
    scoring_profile: Optional[str] = rest_field(
        name="scoringProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of a scoring profile to evaluate match scores for matching documents in order to sort
     the results."""
    debug: Optional[Union[str, "_models.QueryDebugMode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables a debugging tool that can be used to further explore your reranked results. Known
     values are: \"disabled\", \"semantic\", \"vector\", \"queryRewrites\", \"innerHits\", and
     \"all\"."""
    search_text: Optional[str] = rest_field(name="search", visibility=["read", "create", "update", "delete", "query"])
    """A full-text search query expression; Use \"*\" or omit this parameter to match all documents."""
    search_fields: Optional[list[str]] = rest_field(
        name="searchFields", visibility=["read", "create", "update", "delete", "query"], format="commaDelimited"
    )
    """The comma-separated list of field names to which to scope the full-text search. When using
     fielded search (fieldName:searchExpression) in a full Lucene query, the field names of each
     fielded search expression take precedence over any field names listed in this parameter."""
    search_mode: Optional[Union[str, "_models.SearchMode"]] = rest_field(
        name="searchMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies whether any or all of the search terms must be matched in order to count
     the document as a match. Known values are: \"any\" and \"all\"."""
    query_language: Optional[Union[str, "_models.QueryLanguage"]] = rest_field(
        name="queryLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies the language of the search query. Known values are: \"none\", \"en-us\",
     \"en-gb\", \"en-in\", \"en-ca\", \"en-au\", \"fr-fr\", \"fr-ca\", \"de-de\", \"es-es\",
     \"es-mx\", \"zh-cn\", \"zh-tw\", \"pt-br\", \"pt-pt\", \"it-it\", \"ja-jp\", \"ko-kr\",
     \"ru-ru\", \"cs-cz\", \"nl-be\", \"nl-nl\", \"hu-hu\", \"pl-pl\", \"sv-se\", \"tr-tr\",
     \"hi-in\", \"ar-sa\", \"ar-eg\", \"ar-ma\", \"ar-kw\", \"ar-jo\", \"da-dk\", \"no-no\",
     \"bg-bg\", \"hr-hr\", \"hr-ba\", \"ms-my\", \"ms-bn\", \"sl-sl\", \"ta-in\", \"vi-vn\",
     \"el-gr\", \"ro-ro\", \"is-is\", \"id-id\", \"th-th\", \"lt-lt\", \"uk-ua\", \"lv-lv\",
     \"et-ee\", \"ca-es\", \"fi-fi\", \"sr-ba\", \"sr-me\", \"sr-rs\", \"sk-sk\", \"nb-no\",
     \"hy-am\", \"bn-in\", \"eu-es\", \"gl-es\", \"gu-in\", \"he-il\", \"ga-ie\", \"kn-in\",
     \"ml-in\", \"mr-in\", \"fa-ae\", \"pa-in\", \"te-in\", and \"ur-pk\"."""
    query_speller: Optional[Union[str, "_models.QuerySpellerType"]] = rest_field(
        name="speller", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies the type of the speller to use to spell-correct individual search query
     terms. Known values are: \"none\" and \"lexicon\"."""
    select: Optional[list[str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="commaDelimited"
    )
    """The comma-separated list of fields to retrieve. If unspecified, all fields marked as
     retrievable in the schema are included."""
    skip: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of search results to skip. This value cannot be greater than 100,000. If you need to
     scan documents in sequence, but cannot use skip due to this limitation, consider using orderby
     on a totally-ordered key and filter with a range query instead."""
    top: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of search results to retrieve. This can be used in conjunction with $skip to
     implement client-side paging of search results. If results are truncated due to server-side
     paging, the response will include a continuation token that can be used to issue another Search
     request for the next page of results."""
    semantic_configuration_name: Optional[str] = rest_field(
        name="semanticConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of a semantic configuration that will be used when processing documents for queries of
     type semantic."""
    semantic_error_handling: Optional[Union[str, "_models.SemanticErrorMode"]] = rest_field(
        name="semanticErrorHandling", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows the user to choose whether a semantic call should fail completely (default / current
     behavior), or to return partial results. Known values are: \"partial\" and \"fail\"."""
    semantic_max_wait_in_milliseconds: Optional[int] = rest_field(
        name="semanticMaxWaitInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows the user to set an upper bound on the amount of time it takes for semantic enrichment to
     finish processing before the request fails."""
    semantic_query: Optional[str] = rest_field(
        name="semanticQuery", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows setting a separate search query that will be solely used for semantic reranking,
     semantic captions and semantic answers. Is useful for scenarios where there is a need to use
     different queries between the base retrieval and ranking phase, and the L2 semantic phase."""
    answers: Optional[Union[str, "_models.QueryAnswerType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies whether answers should be returned as part of the search response. Known
     values are: \"none\" and \"extractive\"."""
    captions: Optional[Union[str, "_models.QueryCaptionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies whether captions should be returned as part of the search response.
     Known values are: \"none\" and \"extractive\"."""
    query_rewrites: Optional[Union[str, "_models.QueryRewritesType"]] = rest_field(
        name="queryRewrites", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that specifies whether query rewrites should be generated to augment the search query.
     Known values are: \"none\" and \"generative\"."""
    semantic_fields: Optional[list[str]] = rest_field(
        name="semanticFields", visibility=["read", "create", "update", "delete", "query"], format="commaDelimited"
    )
    """The comma-separated list of field names used for semantic ranking."""
    vector_queries: Optional[list["_models.VectorQuery"]] = rest_field(
        name="vectorQueries", visibility=["read", "create", "update", "delete", "query"]
    )
    """The query parameters for vector and hybrid search queries."""
    vector_filter_mode: Optional[Union[str, "_models.VectorFilterMode"]] = rest_field(
        name="vectorFilterMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines whether or not filters are applied before or after the vector search is performed.
     Default is 'preFilter' for new indexes. Known values are: \"postFilter\", \"preFilter\", and
     \"strictPostFilter\"."""
    hybrid_search: Optional["_models.HybridSearch"] = rest_field(
        name="hybridSearch", visibility=["read", "create", "update", "delete", "query"]
    )
    """The query parameters to configure hybrid search behaviors."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        include_total_count: Optional[bool] = None,
        facets: Optional[list[str]] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        highlight_fields: Optional[list[str]] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        query_type: Optional[Union[str, "_models.QueryType"]] = None,
        scoring_statistics: Optional[Union[str, "_models.ScoringStatistics"]] = None,
        session_id: Optional[str] = None,
        scoring_parameters: Optional[list[str]] = None,
        scoring_profile: Optional[str] = None,
        debug: Optional[Union[str, "_models.QueryDebugMode"]] = None,
        search_text: Optional[str] = None,
        search_fields: Optional[list[str]] = None,
        search_mode: Optional[Union[str, "_models.SearchMode"]] = None,
        query_language: Optional[Union[str, "_models.QueryLanguage"]] = None,
        query_speller: Optional[Union[str, "_models.QuerySpellerType"]] = None,
        select: Optional[list[str]] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        semantic_configuration_name: Optional[str] = None,
        semantic_error_handling: Optional[Union[str, "_models.SemanticErrorMode"]] = None,
        semantic_max_wait_in_milliseconds: Optional[int] = None,
        semantic_query: Optional[str] = None,
        answers: Optional[Union[str, "_models.QueryAnswerType"]] = None,
        captions: Optional[Union[str, "_models.QueryCaptionType"]] = None,
        query_rewrites: Optional[Union[str, "_models.QueryRewritesType"]] = None,
        semantic_fields: Optional[list[str]] = None,
        vector_queries: Optional[list["_models.VectorQuery"]] = None,
        vector_filter_mode: Optional[Union[str, "_models.VectorFilterMode"]] = None,
        hybrid_search: Optional["_models.HybridSearch"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchResult(_Model):
    """Contains a document found by a search query, plus associated metadata.

    :ivar score: The relevance score of the document compared to other documents returned by the
     query. Required.
    :vartype score: float
    :ivar reranker_score: The relevance score computed by the semantic ranker for the top search
     results. Search results are sorted by the RerankerScore first and then by the Score.
     RerankerScore is only returned for queries of type 'semantic'.
    :vartype reranker_score: float
    :ivar reranker_boosted_score: The relevance score computed by boosting the Reranker Score.
     Search results are sorted by the RerankerScore/RerankerBoostedScore based on
     useScoringProfileBoostedRanking in the Semantic Config. RerankerBoostedScore is only returned
     for queries of type 'semantic'.
    :vartype reranker_boosted_score: float
    :ivar highlights: Text fragments from the document that indicate the matching search terms,
     organized by each applicable field; null if hit highlighting was not enabled for the query.
    :vartype highlights: dict[str, list[str]]
    :ivar captions: Captions are the most representative passages from the document relatively to
     the search query. They are often used as document summary. Captions are only returned for
     queries of type 'semantic'.
    :vartype captions: list[~azure.search.documents.models.QueryCaptionResult]
    :ivar document_debug_info: Contains debugging information that can be used to further explore
     your search results.
    :vartype document_debug_info: ~azure.search.documents.models.DocumentDebugInfo
    """

    score: float = rest_field(name="@search.score", visibility=["read"])
    """The relevance score of the document compared to other documents returned by the query.
     Required."""
    reranker_score: Optional[float] = rest_field(name="@search.rerankerScore", visibility=["read"])
    """The relevance score computed by the semantic ranker for the top search results. Search results
     are sorted by the RerankerScore first and then by the Score. RerankerScore is only returned for
     queries of type 'semantic'."""
    reranker_boosted_score: Optional[float] = rest_field(name="@search.rerankerBoostedScore", visibility=["read"])
    """The relevance score computed by boosting the Reranker Score. Search results are sorted by the
     RerankerScore/RerankerBoostedScore based on useScoringProfileBoostedRanking in the Semantic
     Config. RerankerBoostedScore is only returned for queries of type 'semantic'."""
    highlights: Optional[dict[str, list[str]]] = rest_field(name="@search.highlights", visibility=["read"])
    """Text fragments from the document that indicate the matching search terms, organized by each
     applicable field; null if hit highlighting was not enabled for the query."""
    captions: Optional[list["_models.QueryCaptionResult"]] = rest_field(name="@search.captions", visibility=["read"])
    """Captions are the most representative passages from the document relatively to the search query.
     They are often used as document summary. Captions are only returned for queries of type
     'semantic'."""
    document_debug_info: Optional["_models.DocumentDebugInfo"] = rest_field(
        name="@search.documentDebugInfo", visibility=["read"]
    )
    """Contains debugging information that can be used to further explore your search results."""


class VectorThreshold(_Model):
    """The threshold used for vector queries.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SearchScoreThreshold, VectorSimilarityThreshold

    :ivar kind: Type of threshold. Required. Known values are: "vectorSimilarity" and
     "searchScore".
    :vartype kind: str or ~azure.search.documents.models.VectorThresholdKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Type of threshold. Required. Known values are: \"vectorSimilarity\" and \"searchScore\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchScoreThreshold(VectorThreshold, discriminator="searchScore"):
    """The results of the vector query will filter based on the '.

    :ivar value: The threshold will filter based on the '. Required.
    :vartype value: float
    :ivar kind: The kind of threshold used to filter vector queries. Required. The results of the
     vector query will filter based on the '@search.score' value. Note this is the @search.score
     returned as part of the search response. The threshold direction will be chosen for higher
     @search.score.
    :vartype kind: str or ~azure.search.documents.models.SEARCH_SCORE
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The threshold will filter based on the '. Required."""
    kind: Literal[VectorThresholdKind.SEARCH_SCORE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of threshold used to filter vector queries. Required. The results of the vector query
     will filter based on the '@search.score' value. Note this is the @search.score returned as part
     of the search response. The threshold direction will be chosen for higher @search.score."""

    @overload
    def __init__(
        self,
        *,
        value: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorThresholdKind.SEARCH_SCORE  # type: ignore


class SemanticDebugInfo(_Model):
    """Contains debugging information specific to semantic ranking requests.

    :ivar title_field: The title field that was sent to the semantic enrichment process, as well as
     how it was used.
    :vartype title_field: ~azure.search.documents.models.QueryResultDocumentSemanticField
    :ivar content_fields: The content fields that were sent to the semantic enrichment process, as
     well as how they were used.
    :vartype content_fields: list[~azure.search.documents.models.QueryResultDocumentSemanticField]
    :ivar keyword_fields: The keyword fields that were sent to the semantic enrichment process, as
     well as how they were used.
    :vartype keyword_fields: list[~azure.search.documents.models.QueryResultDocumentSemanticField]
    :ivar reranker_input: The raw concatenated strings that were sent to the semantic enrichment
     process.
    :vartype reranker_input: ~azure.search.documents.models.QueryResultDocumentRerankerInput
    """

    title_field: Optional["_models.QueryResultDocumentSemanticField"] = rest_field(
        name="titleField", visibility=["read"]
    )
    """The title field that was sent to the semantic enrichment process, as well as how it was used."""
    content_fields: Optional[list["_models.QueryResultDocumentSemanticField"]] = rest_field(
        name="contentFields", visibility=["read"]
    )
    """The content fields that were sent to the semantic enrichment process, as well as how they were
     used."""
    keyword_fields: Optional[list["_models.QueryResultDocumentSemanticField"]] = rest_field(
        name="keywordFields", visibility=["read"]
    )
    """The keyword fields that were sent to the semantic enrichment process, as well as how they were
     used."""
    reranker_input: Optional["_models.QueryResultDocumentRerankerInput"] = rest_field(
        name="rerankerInput", visibility=["read"]
    )
    """The raw concatenated strings that were sent to the semantic enrichment process."""


class SingleVectorFieldResult(_Model):
    """A single vector field result. Both.

    :ivar search_score: The.
    :vartype search_score: float
    :ivar vector_similarity: The vector similarity score for this document. Note this is the
     canonical definition of similarity metric, not the 'distance' version. For example, cosine
     similarity instead of cosine distance.
    :vartype vector_similarity: float
    """

    search_score: Optional[float] = rest_field(name="searchScore", visibility=["read"])
    """The."""
    vector_similarity: Optional[float] = rest_field(name="vectorSimilarity", visibility=["read"])
    """The vector similarity score for this document. Note this is the canonical definition of
     similarity metric, not the 'distance' version. For example, cosine similarity instead of cosine
     distance."""


class SuggestDocumentsResult(_Model):
    """Response containing suggestion query results from an index.

    :ivar results: The sequence of results returned by the query. Required.
    :vartype results: list[~azure.search.documents.models.SuggestResult]
    :ivar coverage: A value indicating the percentage of the index that was included in the query,
     or null if minimumCoverage was not set in the request.
    :vartype coverage: float
    """

    results: list["_models.SuggestResult"] = rest_field(name="value", visibility=["read"])
    """The sequence of results returned by the query. Required."""
    coverage: Optional[float] = rest_field(name="@search.coverage", visibility=["read"])
    """A value indicating the percentage of the index that was included in the query, or null if
     minimumCoverage was not set in the request."""


class SuggestResult(_Model):
    """A result containing a document found by a suggestion query, plus associated metadata.

    :ivar text: The text of the suggestion result. Required.
    :vartype text: str
    """

    text: str = rest_field(name="@search.text", visibility=["read"])
    """The text of the suggestion result. Required."""


class TextResult(_Model):
    """The BM25 or Classic score for the text portion of the query.

    :ivar search_score: The BM25 or Classic score for the text portion of the query.
    :vartype search_score: float
    """

    search_score: Optional[float] = rest_field(name="searchScore", visibility=["read"])
    """The BM25 or Classic score for the text portion of the query."""


class VectorQuery(_Model):
    """The query parameters for vector and hybrid search queries.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VectorizableImageBinaryQuery, VectorizableImageUrlQuery, VectorizableTextQuery, VectorizedQuery

    :ivar k_nearest_neighbors: Number of nearest neighbors to return as top hits.
    :vartype k_nearest_neighbors: int
    :ivar fields: Vector Fields of type Collection(Edm.Single) to be included in the vector
     searched.
    :vartype fields: str
    :ivar exhaustive: When true, triggers an exhaustive k-nearest neighbor search across all
     vectors within the vector index. Useful for scenarios where exact matches are critical, such as
     determining ground truth values.
    :vartype exhaustive: bool
    :ivar oversampling: Oversampling factor. Minimum value is 1. It overrides the
     'defaultOversampling' parameter configured in the index definition. It can be set only when
     'rerankWithOriginalVectors' is true. This parameter is only permitted when a compression method
     is used on the underlying vector field.
    :vartype oversampling: float
    :ivar weight: Relative weight of the vector query when compared to other vector query and/or
     the text query within the same search request. This value is used when combining the results of
     multiple ranking lists produced by the different vector queries and/or the results retrieved
     through the text query. The higher the weight, the higher the documents that matched that query
     will be in the final ranking. Default is 1.0 and the value needs to be a positive number larger
     than zero.
    :vartype weight: float
    :ivar threshold: The threshold used for vector queries. Note this can only be set if all
     'fields' use the same similarity metric.
    :vartype threshold: ~azure.search.documents.models.VectorThreshold
    :ivar filter_override: The OData filter expression to apply to this specific vector query. If
     no filter expression is defined at the vector level, the expression defined in the top level
     filter parameter is used instead.
    :vartype filter_override: str
    :ivar per_document_vector_limit: Controls how many vectors can be matched from each document in
     a vector search query. Setting it to 1 ensures at most one vector per document is matched,
     guaranteeing results come from distinct documents. Setting it to 0 (unlimited) allows multiple
     relevant vectors from the same document to be matched. Default is 0.
    :vartype per_document_vector_limit: int
    :ivar kind: Type of query. Required. Known values are: "vector", "text", "imageUrl", and
     "imageBinary".
    :vartype kind: str or ~azure.search.documents.models.VectorQueryKind
    """

    __mapping__: dict[str, _Model] = {}
    k_nearest_neighbors: Optional[int] = rest_field(
        name="k", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of nearest neighbors to return as top hits."""
    fields: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Vector Fields of type Collection(Edm.Single) to be included in the vector searched."""
    exhaustive: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """When true, triggers an exhaustive k-nearest neighbor search across all vectors within the
     vector index. Useful for scenarios where exact matches are critical, such as determining ground
     truth values."""
    oversampling: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling' parameter
     configured in the index definition. It can be set only when 'rerankWithOriginalVectors' is
     true. This parameter is only permitted when a compression method is used on the underlying
     vector field."""
    weight: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Relative weight of the vector query when compared to other vector query and/or the text query
     within the same search request. This value is used when combining the results of multiple
     ranking lists produced by the different vector queries and/or the results retrieved through the
     text query. The higher the weight, the higher the documents that matched that query will be in
     the final ranking. Default is 1.0 and the value needs to be a positive number larger than zero."""
    threshold: Optional["_models.VectorThreshold"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The threshold used for vector queries. Note this can only be set if all 'fields' use the same
     similarity metric."""
    filter_override: Optional[str] = rest_field(
        name="filterOverride", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OData filter expression to apply to this specific vector query. If no filter expression is
     defined at the vector level, the expression defined in the top level filter parameter is used
     instead."""
    per_document_vector_limit: Optional[int] = rest_field(
        name="perDocumentVectorLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls how many vectors can be matched from each document in a vector search query. Setting
     it to 1 ensures at most one vector per document is matched, guaranteeing results come from
     distinct documents. Setting it to 0 (unlimited) allows multiple relevant vectors from the same
     document to be matched. Default is 0."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Type of query. Required. Known values are: \"vector\", \"text\", \"imageUrl\", and
     \"imageBinary\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        k_nearest_neighbors: Optional[int] = None,
        fields: Optional[str] = None,
        exhaustive: Optional[bool] = None,
        oversampling: Optional[float] = None,
        weight: Optional[float] = None,
        threshold: Optional["_models.VectorThreshold"] = None,
        filter_override: Optional[str] = None,
        per_document_vector_limit: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VectorizableImageBinaryQuery(VectorQuery, discriminator="imageBinary"):
    """The query parameters to use for vector search when a base 64 encoded binary of an image that
    needs to be vectorized is provided.

    :ivar k_nearest_neighbors: Number of nearest neighbors to return as top hits.
    :vartype k_nearest_neighbors: int
    :ivar fields: Vector Fields of type Collection(Edm.Single) to be included in the vector
     searched.
    :vartype fields: str
    :ivar exhaustive: When true, triggers an exhaustive k-nearest neighbor search across all
     vectors within the vector index. Useful for scenarios where exact matches are critical, such as
     determining ground truth values.
    :vartype exhaustive: bool
    :ivar oversampling: Oversampling factor. Minimum value is 1. It overrides the
     'defaultOversampling' parameter configured in the index definition. It can be set only when
     'rerankWithOriginalVectors' is true. This parameter is only permitted when a compression method
     is used on the underlying vector field.
    :vartype oversampling: float
    :ivar weight: Relative weight of the vector query when compared to other vector query and/or
     the text query within the same search request. This value is used when combining the results of
     multiple ranking lists produced by the different vector queries and/or the results retrieved
     through the text query. The higher the weight, the higher the documents that matched that query
     will be in the final ranking. Default is 1.0 and the value needs to be a positive number larger
     than zero.
    :vartype weight: float
    :ivar threshold: The threshold used for vector queries. Note this can only be set if all
     'fields' use the same similarity metric.
    :vartype threshold: ~azure.search.documents.models.VectorThreshold
    :ivar filter_override: The OData filter expression to apply to this specific vector query. If
     no filter expression is defined at the vector level, the expression defined in the top level
     filter parameter is used instead.
    :vartype filter_override: str
    :ivar per_document_vector_limit: Controls how many vectors can be matched from each document in
     a vector search query. Setting it to 1 ensures at most one vector per document is matched,
     guaranteeing results come from distinct documents. Setting it to 0 (unlimited) allows multiple
     relevant vectors from the same document to be matched. Default is 0.
    :vartype per_document_vector_limit: int
    :ivar base64_image: The base 64 encoded binary of an image to be vectorized to perform a vector
     search query.
    :vartype base64_image: str
    :ivar kind: The kind of vector query being performed. Required. Vector query where a base 64
     encoded binary of an image that needs to be vectorized is provided.
    :vartype kind: str or ~azure.search.documents.models.IMAGE_BINARY
    """

    base64_image: Optional[str] = rest_field(
        name="base64Image", visibility=["read", "create", "update", "delete", "query"]
    )
    """The base 64 encoded binary of an image to be vectorized to perform a vector search query."""
    kind: Literal[VectorQueryKind.IMAGE_BINARY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of vector query being performed. Required. Vector query where a base 64 encoded binary
     of an image that needs to be vectorized is provided."""

    @overload
    def __init__(
        self,
        *,
        k_nearest_neighbors: Optional[int] = None,
        fields: Optional[str] = None,
        exhaustive: Optional[bool] = None,
        oversampling: Optional[float] = None,
        weight: Optional[float] = None,
        threshold: Optional["_models.VectorThreshold"] = None,
        filter_override: Optional[str] = None,
        per_document_vector_limit: Optional[int] = None,
        base64_image: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorQueryKind.IMAGE_BINARY  # type: ignore


class VectorizableImageUrlQuery(VectorQuery, discriminator="imageUrl"):
    """The query parameters to use for vector search when an url that represents an image value that
    needs to be vectorized is provided.

    :ivar k_nearest_neighbors: Number of nearest neighbors to return as top hits.
    :vartype k_nearest_neighbors: int
    :ivar fields: Vector Fields of type Collection(Edm.Single) to be included in the vector
     searched.
    :vartype fields: str
    :ivar exhaustive: When true, triggers an exhaustive k-nearest neighbor search across all
     vectors within the vector index. Useful for scenarios where exact matches are critical, such as
     determining ground truth values.
    :vartype exhaustive: bool
    :ivar oversampling: Oversampling factor. Minimum value is 1. It overrides the
     'defaultOversampling' parameter configured in the index definition. It can be set only when
     'rerankWithOriginalVectors' is true. This parameter is only permitted when a compression method
     is used on the underlying vector field.
    :vartype oversampling: float
    :ivar weight: Relative weight of the vector query when compared to other vector query and/or
     the text query within the same search request. This value is used when combining the results of
     multiple ranking lists produced by the different vector queries and/or the results retrieved
     through the text query. The higher the weight, the higher the documents that matched that query
     will be in the final ranking. Default is 1.0 and the value needs to be a positive number larger
     than zero.
    :vartype weight: float
    :ivar threshold: The threshold used for vector queries. Note this can only be set if all
     'fields' use the same similarity metric.
    :vartype threshold: ~azure.search.documents.models.VectorThreshold
    :ivar filter_override: The OData filter expression to apply to this specific vector query. If
     no filter expression is defined at the vector level, the expression defined in the top level
     filter parameter is used instead.
    :vartype filter_override: str
    :ivar per_document_vector_limit: Controls how many vectors can be matched from each document in
     a vector search query. Setting it to 1 ensures at most one vector per document is matched,
     guaranteeing results come from distinct documents. Setting it to 0 (unlimited) allows multiple
     relevant vectors from the same document to be matched. Default is 0.
    :vartype per_document_vector_limit: int
    :ivar url: The URL of an image to be vectorized to perform a vector search query.
    :vartype url: str
    :ivar kind: The kind of vector query being performed. Required. Vector query where an url that
     represents an image value that needs to be vectorized is provided.
    :vartype kind: str or ~azure.search.documents.models.IMAGE_URL
    """

    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of an image to be vectorized to perform a vector search query."""
    kind: Literal[VectorQueryKind.IMAGE_URL] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of vector query being performed. Required. Vector query where an url that represents
     an image value that needs to be vectorized is provided."""

    @overload
    def __init__(
        self,
        *,
        k_nearest_neighbors: Optional[int] = None,
        fields: Optional[str] = None,
        exhaustive: Optional[bool] = None,
        oversampling: Optional[float] = None,
        weight: Optional[float] = None,
        threshold: Optional["_models.VectorThreshold"] = None,
        filter_override: Optional[str] = None,
        per_document_vector_limit: Optional[int] = None,
        url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorQueryKind.IMAGE_URL  # type: ignore


class VectorizableTextQuery(VectorQuery, discriminator="text"):
    """The query parameters to use for vector search when a text value that needs to be vectorized is
    provided.

    :ivar k_nearest_neighbors: Number of nearest neighbors to return as top hits.
    :vartype k_nearest_neighbors: int
    :ivar fields: Vector Fields of type Collection(Edm.Single) to be included in the vector
     searched.
    :vartype fields: str
    :ivar exhaustive: When true, triggers an exhaustive k-nearest neighbor search across all
     vectors within the vector index. Useful for scenarios where exact matches are critical, such as
     determining ground truth values.
    :vartype exhaustive: bool
    :ivar oversampling: Oversampling factor. Minimum value is 1. It overrides the
     'defaultOversampling' parameter configured in the index definition. It can be set only when
     'rerankWithOriginalVectors' is true. This parameter is only permitted when a compression method
     is used on the underlying vector field.
    :vartype oversampling: float
    :ivar weight: Relative weight of the vector query when compared to other vector query and/or
     the text query within the same search request. This value is used when combining the results of
     multiple ranking lists produced by the different vector queries and/or the results retrieved
     through the text query. The higher the weight, the higher the documents that matched that query
     will be in the final ranking. Default is 1.0 and the value needs to be a positive number larger
     than zero.
    :vartype weight: float
    :ivar threshold: The threshold used for vector queries. Note this can only be set if all
     'fields' use the same similarity metric.
    :vartype threshold: ~azure.search.documents.models.VectorThreshold
    :ivar filter_override: The OData filter expression to apply to this specific vector query. If
     no filter expression is defined at the vector level, the expression defined in the top level
     filter parameter is used instead.
    :vartype filter_override: str
    :ivar per_document_vector_limit: Controls how many vectors can be matched from each document in
     a vector search query. Setting it to 1 ensures at most one vector per document is matched,
     guaranteeing results come from distinct documents. Setting it to 0 (unlimited) allows multiple
     relevant vectors from the same document to be matched. Default is 0.
    :vartype per_document_vector_limit: int
    :ivar text: The text to be vectorized to perform a vector search query. Required.
    :vartype text: str
    :ivar query_rewrites: Can be configured to let a generative model rewrite the query before
     sending it to be vectorized. Known values are: "none" and "generative".
    :vartype query_rewrites: str or ~azure.search.documents.models.QueryRewritesType
    :ivar kind: The kind of vector query being performed. Required. Vector query where a text value
     that needs to be vectorized is provided.
    :vartype kind: str or ~azure.search.documents.models.TEXT
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text to be vectorized to perform a vector search query. Required."""
    query_rewrites: Optional[Union[str, "_models.QueryRewritesType"]] = rest_field(
        name="queryRewrites", visibility=["read", "create", "update", "delete", "query"]
    )
    """Can be configured to let a generative model rewrite the query before sending it to be
     vectorized. Known values are: \"none\" and \"generative\"."""
    kind: Literal[VectorQueryKind.TEXT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of vector query being performed. Required. Vector query where a text value that needs
     to be vectorized is provided."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        k_nearest_neighbors: Optional[int] = None,
        fields: Optional[str] = None,
        exhaustive: Optional[bool] = None,
        oversampling: Optional[float] = None,
        weight: Optional[float] = None,
        threshold: Optional["_models.VectorThreshold"] = None,
        filter_override: Optional[str] = None,
        per_document_vector_limit: Optional[int] = None,
        query_rewrites: Optional[Union[str, "_models.QueryRewritesType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorQueryKind.TEXT  # type: ignore


class VectorizedQuery(VectorQuery, discriminator="vector"):
    """The query parameters to use for vector search when a raw vector value is provided.

    :ivar k_nearest_neighbors: Number of nearest neighbors to return as top hits.
    :vartype k_nearest_neighbors: int
    :ivar fields: Vector Fields of type Collection(Edm.Single) to be included in the vector
     searched.
    :vartype fields: str
    :ivar exhaustive: When true, triggers an exhaustive k-nearest neighbor search across all
     vectors within the vector index. Useful for scenarios where exact matches are critical, such as
     determining ground truth values.
    :vartype exhaustive: bool
    :ivar oversampling: Oversampling factor. Minimum value is 1. It overrides the
     'defaultOversampling' parameter configured in the index definition. It can be set only when
     'rerankWithOriginalVectors' is true. This parameter is only permitted when a compression method
     is used on the underlying vector field.
    :vartype oversampling: float
    :ivar weight: Relative weight of the vector query when compared to other vector query and/or
     the text query within the same search request. This value is used when combining the results of
     multiple ranking lists produced by the different vector queries and/or the results retrieved
     through the text query. The higher the weight, the higher the documents that matched that query
     will be in the final ranking. Default is 1.0 and the value needs to be a positive number larger
     than zero.
    :vartype weight: float
    :ivar threshold: The threshold used for vector queries. Note this can only be set if all
     'fields' use the same similarity metric.
    :vartype threshold: ~azure.search.documents.models.VectorThreshold
    :ivar filter_override: The OData filter expression to apply to this specific vector query. If
     no filter expression is defined at the vector level, the expression defined in the top level
     filter parameter is used instead.
    :vartype filter_override: str
    :ivar per_document_vector_limit: Controls how many vectors can be matched from each document in
     a vector search query. Setting it to 1 ensures at most one vector per document is matched,
     guaranteeing results come from distinct documents. Setting it to 0 (unlimited) allows multiple
     relevant vectors from the same document to be matched. Default is 0.
    :vartype per_document_vector_limit: int
    :ivar vector: The vector representation of a search query. Required.
    :vartype vector: list[float]
    :ivar kind: The kind of vector query being performed. Required. Vector query where a raw vector
     value is provided.
    :vartype kind: str or ~azure.search.documents.models.VECTOR
    """

    vector: list[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The vector representation of a search query. Required."""
    kind: Literal[VectorQueryKind.VECTOR] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of vector query being performed. Required. Vector query where a raw vector value is
     provided."""

    @overload
    def __init__(
        self,
        *,
        vector: list[float],
        k_nearest_neighbors: Optional[int] = None,
        fields: Optional[str] = None,
        exhaustive: Optional[bool] = None,
        oversampling: Optional[float] = None,
        weight: Optional[float] = None,
        threshold: Optional["_models.VectorThreshold"] = None,
        filter_override: Optional[str] = None,
        per_document_vector_limit: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorQueryKind.VECTOR  # type: ignore


class VectorsDebugInfo(_Model):
    """ "Contains debugging information specific to vector and hybrid search.").

    :ivar subscores: The breakdown of subscores of the document prior to the chosen result set
     fusion/combination method such as RRF.
    :vartype subscores: ~azure.search.documents.models.QueryResultDocumentSubscores
    """

    subscores: Optional["_models.QueryResultDocumentSubscores"] = rest_field(visibility=["read"])
    """The breakdown of subscores of the document prior to the chosen result set fusion/combination
     method such as RRF."""


class VectorSimilarityThreshold(VectorThreshold, discriminator="vectorSimilarity"):
    """The results of the vector query will be filtered based on the vector similarity metric. Note
    this is the canonical definition of similarity metric, not the 'distance' version. The
    threshold direction (larger or smaller) will be chosen automatically according to the metric
    used by the field.

    :ivar value: The threshold will filter based on the similarity metric value. Note this is the
     canonical definition of similarity metric, not the 'distance' version. The threshold direction
     (larger or smaller) will be chosen automatically according to the metric used by the field.
     Required.
    :vartype value: float
    :ivar kind: The kind of threshold used to filter vector queries. Required. The results of the
     vector query will be filtered based on the vector similarity metric. Note this is the canonical
     definition of similarity metric, not the 'distance' version. The threshold direction (larger or
     smaller) will be chosen automatically according to the metric used by the field.
    :vartype kind: str or ~azure.search.documents.models.VECTOR_SIMILARITY
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The threshold will filter based on the similarity metric value. Note this is the canonical
     definition of similarity metric, not the 'distance' version. The threshold direction (larger or
     smaller) will be chosen automatically according to the metric used by the field. Required."""
    kind: Literal[VectorThresholdKind.VECTOR_SIMILARITY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of threshold used to filter vector queries. Required. The results of the vector query
     will be filtered based on the vector similarity metric. Note this is the canonical definition
     of similarity metric, not the 'distance' version. The threshold direction (larger or smaller)
     will be chosen automatically according to the metric used by the field."""

    @overload
    def __init__(
        self,
        *,
        value: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorThresholdKind.VECTOR_SIMILARITY  # type: ignore
