# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AdditionalCapabilities(_Model):
    """Enables or disables a capability on the virtual machine or virtual machine scale set.

    :ivar ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
     storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
     set only if this property is enabled.
    :vartype ultra_ssd_enabled: bool
    :ivar hibernation_enabled: The flag that enables or disables hibernation capability on the VM.
    :vartype hibernation_enabled: bool
    """

    ultra_ssd_enabled: Optional[bool] = rest_field(
        name="ultraSSDEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The flag that enables or disables a capability to have one or more managed data disks with
     UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type
     UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this
     property is enabled."""
    hibernation_enabled: Optional[bool] = rest_field(
        name="hibernationEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The flag that enables or disables hibernation capability on the VM."""

    @overload
    def __init__(
        self,
        *,
        ultra_ssd_enabled: Optional[bool] = None,
        hibernation_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdditionalUnattendContent(_Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file,
    which is used by Windows Setup. Contents are defined by setting name, component name, and the
    pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
     "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.computebulkactions.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :vartype content: str
    """

    pass_name: Optional[Literal["OobeSystem"]] = rest_field(
        name="passName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The pass name. Currently, the only allowable value is OobeSystem. Default value is
     \"OobeSystem\"."""
    component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = rest_field(
        name="componentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
     Default value is \"Microsoft-Windows-Shell-Setup\"."""
    setting_name: Optional[Union[str, "_models.SettingNames"]] = rest_field(
        name="settingName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the name of the setting to which the content applies. Possible values are:
     FirstLogonCommands and AutoLogon. Known values are: \"AutoLogon\" and \"FirstLogonCommands\"."""
    content: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the XML formatted content that is added to the unattend.xml file for the specified
     path and component. The XML must be less than 4KB and must include the root element for the
     setting or feature that is being inserted."""

    @overload
    def __init__(
        self,
        *,
        pass_name: Optional[Literal["OobeSystem"]] = None,
        component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AllInstancesDown(_Model):
    """Specifies if Scheduled Events should be auto-approved when all instances are down.

    :ivar automatically_approve: Specifies if Scheduled Events should be auto-approved when all
     instances are down. Its default value is true.
    :vartype automatically_approve: bool
    """

    automatically_approve: Optional[bool] = rest_field(
        name="automaticallyApprove", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies if Scheduled Events should be auto-approved when all instances are down. Its default
     value is true."""

    @overload
    def __init__(
        self,
        *,
        automatically_approve: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApiEntityReference(_Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/..."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApiError(_Model):
    """ApiError for Fleet.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The API error details.
    :vartype details: list[~azure.mgmt.computebulkactions.models.ApiErrorBase]
    :ivar innererror: The API inner error.
    :vartype innererror: ~azure.mgmt.computebulkactions.models.InnerError
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the particular error."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error message."""
    details: Optional[list["_models.ApiErrorBase"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The API error details."""
    innererror: Optional["_models.InnerError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The API inner error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[list["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApiErrorBase(_Model):
    """API error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the particular error."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error message."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationProfile(_Model):
    """Contains the list of gallery applications that should be made available to the VM.

    :ivar gallery_applications: Specifies the gallery applications that should be made available to
     the VM.
    :vartype gallery_applications: list[~azure.mgmt.computebulkactions.models.VMGalleryApplication]
    """

    gallery_applications: Optional[list["_models.VMGalleryApplication"]] = rest_field(
        name="galleryApplications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the gallery applications that should be made available to the VM."""

    @overload
    def __init__(
        self,
        *,
        gallery_applications: Optional[list["_models.VMGalleryApplication"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BootDiagnostics(_Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot
    to diagnose VM status. You can easily view the output of your console log. Azure also enables
    you to see a screenshot of the VM from the hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage
     will be used.
    :vartype storage_uri: str
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether boot diagnostics should be enabled on the Virtual Machine."""
    storage_uri: Optional[str] = rest_field(
        name="storageUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """Uri of the storage account to use for placing the console output and screenshot. If storageUri
     is not specified while enabling boot diagnostics, managed storage will be used."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        storage_uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CancelOperationsRequest(_Model):
    """This is the request to cancel running operations in bulkactions using the operation ids.

    :ivar operation_ids: The list of operation ids to cancel operations on. Required.
    :vartype operation_ids: list[str]
    :ivar correlationid: CorrelationId item. Required.
    :vartype correlationid: str
    """

    operation_ids: list[str] = rest_field(
        name="operationIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of operation ids to cancel operations on. Required."""
    correlationid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item. Required."""

    @overload
    def __init__(
        self,
        *,
        operation_ids: list[str],
        correlationid: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CancelOperationsResponse(_Model):
    """This is the response from a cancel operations request.

    :ivar results: An array of resource operations that were successfully cancelled. Required.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    results: list["_models.ResourceOperation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of resource operations that were successfully cancelled. Required."""

    @overload
    def __init__(
        self,
        *,
        results: list["_models.ResourceOperation"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapacityReservationProfile(_Model):
    """The parameters of a capacity reservation Profile.

    :ivar capacity_reservation_group: Specifies the capacity reservation group resource id that
     should be used for allocating the virtual machine provided enough capacity has been reserved.
     Please refer to `https://aka.ms/CapacityReservation <https://aka.ms/CapacityReservation>`_ for
     more details.
    :vartype capacity_reservation_group: ~azure.mgmt.computebulkactions.models.SubResource
    """

    capacity_reservation_group: Optional["_models.SubResource"] = rest_field(
        name="capacityReservationGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the capacity reservation group resource id that should be used for allocating the
     virtual machine provided enough capacity has been reserved. Please refer to
     `https://aka.ms/CapacityReservation <https://aka.ms/CapacityReservation>`_ for more details."""

    @overload
    def __init__(
        self,
        *,
        capacity_reservation_group: Optional["_models.SubResource"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputeProfile(_Model):
    """Compute Profile to configure the Virtual Machines.

    :ivar virtual_machine_profile: Base Virtual Machine Profile Properties to be specified
     according to
     "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachine.json#/definitions/VirtualMachineProperties".
     Required.
    :vartype virtual_machine_profile: ~azure.mgmt.computebulkactions.models.VirtualMachineProfile
    :ivar extensions: Virtual Machine Extensions Array to be specified according to
     "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachine.json#/definitions/VirtualMachineExtension".
    :vartype extensions: list[~azure.mgmt.computebulkactions.models.VirtualMachineExtension]
    :ivar compute_api_version: Specifies the Microsoft.Compute API version to use when creating
     underlying Virtual Machines. The default value will be the latest supported computeApiVersion
     by LaunchBulkInstancesOperation.
    :vartype compute_api_version: str
    """

    virtual_machine_profile: "_models.VirtualMachineProfile" = rest_field(
        name="virtualMachineProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base Virtual Machine Profile Properties to be specified according to
     \"specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachine.json#/definitions/VirtualMachineProperties\".
     Required."""
    extensions: Optional[list["_models.VirtualMachineExtension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Virtual Machine Extensions Array to be specified according to
     \"specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachine.json#/definitions/VirtualMachineExtension\"."""
    compute_api_version: Optional[str] = rest_field(
        name="computeApiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machines.
     The default value will be the latest supported computeApiVersion by
     LaunchBulkInstancesOperation."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine_profile: "_models.VirtualMachineProfile",
        extensions: Optional[list["_models.VirtualMachineExtension"]] = None,
        compute_api_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CreateResourceOperationResponse(_Model):
    """The response from a create request.

    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the request.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the operation response. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of resources used in the request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the request eg westus. Required."""
    results: Optional[list["_models.ResourceOperation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results from the request."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[list["_models.ResourceOperation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataDisk(_Model):
    """Describes a data disk.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.computebulkactions.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.computebulkactions.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. Possible values are: None, ReadOnly,
     ReadWrite. The defaulting behavior is: None for Standard storage. ReadOnly for Premium storage.
     Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.computebulkactions.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machine disk should be created. Possible values
     are Attach, FromImage, Empty, Copy, Restore. Required. Known values are: "FromImage", "Empty",
     "Attach", "Copy", and "Restore".
    :vartype create_option: str or ~azure.mgmt.computebulkactions.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is
     the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.computebulkactions.models.ManagedDiskParameters
    :ivar source_resource: The source resource identifier. It can be a snapshot, or disk restore
     point from which to create a disk.
    :vartype source_resource: ~azure.mgmt.computebulkactions.models.ApiEntityReference
    :ivar to_be_detached: Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset.
    :vartype to_be_detached: bool
    :ivar detach_option: Specifies the detach behavior to be used while detaching a disk or which
     is already in the process of detachment from the virtual machine. Supported values:
     ForceDetach. This feature is still in preview. To force-detach a data disk update toBeDetached
     to 'true' along with setting detachOption: 'ForceDetach'. "ForceDetach"
    :vartype detach_option: str or ~azure.mgmt.computebulkactions.models.DiskDetachOptionTypes
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VM
     deletion. Possible values are: Delete, Detach. The default value is set to Detach. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computebulkactions.models.DiskDeleteOptionTypes
    """

    lun: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the logical unit number of the data disk. This value is used to identify data disks
     within the VM and therefore must be unique for each data disk attached to a VM. Required."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The disk name."""
    vhd: Optional["_models.VirtualHardDisk"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The virtual hard disk."""
    image: Optional["_models.VirtualHardDisk"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The source user image virtual hard disk. The virtual hard disk will be copied before being
     attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive
     must not exist."""
    caching: Optional[Union[str, "_models.CachingTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the caching requirements. Possible values are: None, ReadOnly, ReadWrite. The
     defaulting behavior is: None for Standard storage. ReadOnly for Premium storage. Known values
     are: \"None\", \"ReadOnly\", and \"ReadWrite\"."""
    write_accelerator_enabled: Optional[bool] = rest_field(
        name="writeAcceleratorEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether writeAccelerator should be enabled or disabled on the disk."""
    create_option: Union[str, "_models.DiskCreateOptionTypes"] = rest_field(
        name="createOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies how the virtual machine disk should be created. Possible values are Attach,
     FromImage, Empty, Copy, Restore. Required. Known values are: \"FromImage\", \"Empty\",
     \"Attach\", \"Copy\", and \"Restore\"."""
    disk_size_gb: Optional[int] = rest_field(
        name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite
     the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of
     bytes x 1024^3 for the disk and the value cannot be larger than 1023."""
    managed_disk: Optional["_models.ManagedDiskParameters"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""
    source_resource: Optional["_models.ApiEntityReference"] = rest_field(
        name="sourceResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source resource identifier. It can be a snapshot, or disk restore point from which to
     create a disk."""
    to_be_detached: Optional[bool] = rest_field(
        name="toBeDetached", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset."""
    detach_option: Optional[Union[str, "_models.DiskDetachOptionTypes"]] = rest_field(
        name="detachOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the detach behavior to be used while detaching a disk or which is already in the
     process of detachment from the virtual machine. Supported values: ForceDetach. This feature is
     still in preview. To force-detach a data disk update toBeDetached to 'true' along with setting
     detachOption: 'ForceDetach'. \"ForceDetach\""""
    delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = rest_field(
        name="deleteOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether data disk should be deleted or detached upon VM deletion. Possible values
     are: Delete, Detach. The default value is set to Detach. Known values are: \"Delete\" and
     \"Detach\"."""

    @overload
    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        source_resource: Optional["_models.ApiEntityReference"] = None,
        to_be_detached: Optional[bool] = None,
        detach_option: Optional[Union[str, "_models.DiskDetachOptionTypes"]] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeallocateResourceOperationResponse(_Model):
    """The response from a deallocate request.

    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the request.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the operation response. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of resources used in the request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the request eg westus. Required."""
    results: Optional[list["_models.ResourceOperation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results from the request."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[list["_models.ResourceOperation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeleteResourceOperationResponse(_Model):
    """The response from a delete request.

    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the request.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the operation response. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of resources used in the request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the request eg westus. Required."""
    results: Optional[list["_models.ResourceOperation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results from the request."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[list["_models.ResourceOperation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiagnosticsProfile(_Model):
    """Specifies the boot diagnostic settings state. Minimum compute api-version: 2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified
     then ensure that the storage account is in the same region and subscription as the VM. You can
     easily view the output of your console log. Azure also enables you to see a screenshot of the
     VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.computebulkactions.models.BootDiagnostics
    """

    boot_diagnostics: Optional["_models.BootDiagnostics"] = rest_field(
        name="bootDiagnostics", visibility=["read", "create", "update", "delete", "query"]
    )
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot
     to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage
     account is in the same region and subscription as the VM. You can easily view the output of
     your console log. Azure also enables you to see a screenshot of the VM from the hypervisor."""

    @overload
    def __init__(
        self,
        *,
        boot_diagnostics: Optional["_models.BootDiagnostics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiffDiskSettings(_Model):
    """Describes the parameters of ephemeral disk settings that can be specified for operating system
    disk. Note: The ephemeral disk settings can only be specified for managed disk.

    :ivar option: Specifies the ephemeral disk settings for operating system disk. "Local"
    :vartype option: str or ~azure.mgmt.computebulkactions.models.DiffDiskOptions
    :ivar placement: Specifies the ephemeral disk placement for operating system disk. Possible
     values are: CacheDisk, ResourceDisk, NvmeDisk. The defaulting behavior is: CacheDisk if one is
     configured for the VM size otherwise ResourceDisk or NvmeDisk is used. Minimum api-version for
     NvmeDisk: 2024-03-01. Known values are: "CacheDisk", "ResourceDisk", and "NvmeDisk".
    :vartype placement: str or ~azure.mgmt.computebulkactions.models.DiffDiskPlacement
    """

    option: Optional[Union[str, "_models.DiffDiskOptions"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral disk settings for operating system disk. \"Local\""""
    placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral disk placement for operating system disk. Possible values are:
     CacheDisk, ResourceDisk, NvmeDisk. The defaulting behavior is: CacheDisk if one is configured
     for the VM size otherwise ResourceDisk or NvmeDisk is used. Minimum api-version for NvmeDisk:
     2024-03-01. Known values are: \"CacheDisk\", \"ResourceDisk\", and \"NvmeDisk\"."""

    @overload
    def __init__(
        self,
        *,
        option: Optional[Union[str, "_models.DiffDiskOptions"]] = None,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubResource(_Model):
    """Describes a reference to a sub-resource.

    :ivar id: The ID of the sub-resource.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the sub-resource."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskEncryptionSetParameters(SubResource):
    """Describes the parameter of customer managed disk encryption set resource id that can be
    specified for disk. **Note:** The disk encryption set resource id can only be specified for
    managed disk. Please refer `https://aka.ms/mdssewithcmkoverview
    <https://aka.ms/mdssewithcmkoverview>`_ for more details.

    :ivar id: The ID of the sub-resource.
    :vartype id: str
    """

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskEncryptionSettings(_Model):
    """Describes a Encryption Settings for a Disk.

    :ivar disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :vartype disk_encryption_key: ~azure.mgmt.computebulkactions.models.KeyVaultSecretReference
    :ivar key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :vartype key_encryption_key: ~azure.mgmt.computebulkactions.models.KeyVaultKeyReference
    :ivar enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :vartype enabled: bool
    """

    disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = rest_field(
        name="diskEncryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the location of the disk encryption key, which is a Key Vault Secret."""
    key_encryption_key: Optional["_models.KeyVaultKeyReference"] = rest_field(
        name="keyEncryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the location of the key encryption key in Key Vault."""
    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies whether disk encryption should be enabled on the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionIdentity(_Model):
    """Specifies the Managed Identity used by ADE to get access token for keyvault operations.

    :ivar user_assigned_identity_resource_id: Specifies ARM Resource ID of one of the user
     identities associated with the VM.
    :vartype user_assigned_identity_resource_id: str
    """

    user_assigned_identity_resource_id: Optional[str] = rest_field(
        name="userAssignedIdentityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies ARM Resource ID of one of the user identities associated with the VM."""

    @overload
    def __init__(
        self,
        *,
        user_assigned_identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.computebulkactions.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.computebulkactions.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.computebulkactions.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EventGridAndResourceGraph(_Model):
    """Specifies eventGridAndResourceGraph related Scheduled Event related configurations.

    :ivar enable: Specifies if event grid and resource graph is enabled for Scheduled event related
     configurations.
    :vartype enable: bool
    :ivar scheduled_events_api_version: Specifies the api-version to determine which Scheduled
     Events configuration schema version will be delivered.
    :vartype scheduled_events_api_version: str
    """

    enable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies if event grid and resource graph is enabled for Scheduled event related
     configurations."""
    scheduled_events_api_version: Optional[str] = rest_field(
        name="scheduledEventsApiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the api-version to determine which Scheduled Events configuration schema version will
     be delivered."""

    @overload
    def __init__(
        self,
        *,
        enable: Optional[bool] = None,
        scheduled_events_api_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecuteCreateRequest(_Model):
    """The ExecuteCreateRequest request for create operations.

    :ivar resource_config_parameters: resource creation payload. Required.
    :vartype resource_config_parameters:
     ~azure.mgmt.computebulkactions.models.ResourceProvisionPayload
    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computebulkactions.models.ExecutionParameters
    :ivar correlationid: CorrelationId item.
    :vartype correlationid: str
    """

    resource_config_parameters: "_models.ResourceProvisionPayload" = rest_field(
        name="resourceConfigParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """resource creation payload. Required."""
    execution_parameters: "_models.ExecutionParameters" = rest_field(
        name="executionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution parameters for the request. Required."""
    correlationid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item."""

    @overload
    def __init__(
        self,
        *,
        resource_config_parameters: "_models.ResourceProvisionPayload",
        execution_parameters: "_models.ExecutionParameters",
        correlationid: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecuteDeallocateRequest(_Model):
    """The ExecuteDeallocateRequest request for executeDeallocate operations.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computebulkactions.models.ExecutionParameters
    :ivar resources: The resources for the request.
    :vartype resources: ~azure.mgmt.computebulkactions.models.Resources
    :ivar correlationid: CorrelationId item. Required.
    :vartype correlationid: str
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(
        name="executionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution parameters for the request. Required."""
    resources: Optional["_models.Resources"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resources for the request."""
    correlationid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item. Required."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        correlationid: str,
        resources: Optional["_models.Resources"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecuteDeleteRequest(_Model):
    """The ExecuteDeleteRequest for delete VM operation.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computebulkactions.models.ExecutionParameters
    :ivar resources: The resources for the request.
    :vartype resources: ~azure.mgmt.computebulkactions.models.Resources
    :ivar correlationid: CorrelationId item. Required.
    :vartype correlationid: str
    :ivar force_deletion: Forced delete resource item.
    :vartype force_deletion: bool
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(
        name="executionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution parameters for the request. Required."""
    resources: Optional["_models.Resources"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resources for the request."""
    correlationid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item. Required."""
    force_deletion: Optional[bool] = rest_field(
        name="forceDeletion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Forced delete resource item."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        correlationid: str,
        resources: Optional["_models.Resources"] = None,
        force_deletion: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecuteHibernateRequest(_Model):
    """The ExecuteHibernateRequest request for executeHibernate operations.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computebulkactions.models.ExecutionParameters
    :ivar resources: The resources for the request.
    :vartype resources: ~azure.mgmt.computebulkactions.models.Resources
    :ivar correlationid: CorrelationId item. Required.
    :vartype correlationid: str
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(
        name="executionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution parameters for the request. Required."""
    resources: Optional["_models.Resources"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resources for the request."""
    correlationid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item. Required."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        correlationid: str,
        resources: Optional["_models.Resources"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecuteStartRequest(_Model):
    """The ExecuteStartRequest request for executeStart operations.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computebulkactions.models.ExecutionParameters
    :ivar resources: The resources for the request.
    :vartype resources: ~azure.mgmt.computebulkactions.models.Resources
    :ivar correlationid: CorrelationId item. Required.
    :vartype correlationid: str
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(
        name="executionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution parameters for the request. Required."""
    resources: Optional["_models.Resources"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resources for the request."""
    correlationid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item. Required."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        correlationid: str,
        resources: Optional["_models.Resources"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecutionParameters(_Model):
    """Extra details needed to run the user's request.

    :ivar optimization_preference: Details that could optimize the user's request. Known values
     are: "Cost", "Availability", and "CostAvailabilityBalanced".
    :vartype optimization_preference: str or
     ~azure.mgmt.computebulkactions.models.OptimizationPreference
    :ivar retry_policy: Retry policy the user can pass.
    :vartype retry_policy: ~azure.mgmt.computebulkactions.models.RetryPolicy
    """

    optimization_preference: Optional[Union[str, "_models.OptimizationPreference"]] = rest_field(
        name="optimizationPreference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details that could optimize the user's request. Known values are: \"Cost\", \"Availability\",
     and \"CostAvailabilityBalanced\"."""
    retry_policy: Optional["_models.RetryPolicy"] = rest_field(
        name="retryPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retry policy the user can pass."""

    @overload
    def __init__(
        self,
        *,
        optimization_preference: Optional[Union[str, "_models.OptimizationPreference"]] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetOperationStatusRequest(_Model):
    """This is the request to get operation status using operationids.

    :ivar operation_ids: The list of operation ids to get the status of. Required.
    :vartype operation_ids: list[str]
    :ivar correlationid: CorrelationId item. Required.
    :vartype correlationid: str
    """

    operation_ids: list[str] = rest_field(
        name="operationIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of operation ids to get the status of. Required."""
    correlationid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CorrelationId item. Required."""

    @overload
    def __init__(
        self,
        *,
        operation_ids: list[str],
        correlationid: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetOperationStatusResponse(_Model):
    """This is the response from a get operations status request.

    :ivar results: An array of resource operations based on their operation ids. Required.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    results: list["_models.ResourceOperation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of resource operations based on their operation ids. Required."""

    @overload
    def __init__(
        self,
        *,
        results: list["_models.ResourceOperation"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HibernateResourceOperationResponse(_Model):
    """The response from a Hibernate request.

    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the request.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the operation response. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of resources used in the request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the request eg westus. Required."""
    results: Optional[list["_models.ResourceOperation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results from the request."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[list["_models.ResourceOperation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HostEndpointSettings(_Model):
    """Specifies particular host endpoint settings.

    :ivar mode: Specifies the execution mode. In Audit mode, the system acts as if it is enforcing
     the access control policy, including emitting access denial entries in the logs but it does not
     actually deny any requests to host endpoints. In Enforce mode, the system will enforce the
     access control and it is the recommended mode of operation. Known values are: "Audit",
     "Enforce", and "Disabled".
    :vartype mode: str or ~azure.mgmt.computebulkactions.models.Modes
    :ivar in_vm_access_control_profile_reference_id: Specifies the InVMAccessControlProfileVersion
     resource id in the format of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
    :vartype in_vm_access_control_profile_reference_id: str
    """

    mode: Optional[Union[str, "_models.Modes"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the access
     control policy, including emitting access denial entries in the logs but it does not actually
     deny any requests to host endpoints. In Enforce mode, the system will enforce the access
     control and it is the recommended mode of operation. Known values are: \"Audit\", \"Enforce\",
     and \"Disabled\"."""
    in_vm_access_control_profile_reference_id: Optional[str] = rest_field(
        name="inVMAccessControlProfileReferenceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the InVMAccessControlProfileVersion resource id in the format of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.Modes"]] = None,
        in_vm_access_control_profile_reference_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations. NOTE: Image reference publisher and offer can only be set when you create
    the scale set.

    :ivar id: The ID of the sub-resource.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available. Please do not use field 'version' for gallery
     image deployment, gallery image should always use 'id' field for deployment, to use 'latest'
     version of gallery image, just set
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
     in the 'id' field without version input.
    :vartype version: str
    :ivar shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment.
     This can be fetched from shared gallery image GET call.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: Specified the community gallery image unique id for vm
     deployment. This can be fetched from community gallery image GET call.
    :vartype community_gallery_image_id: str
    """

    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image publisher."""
    offer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the offer of the platform image or marketplace image used to create the virtual
     machine."""
    sku: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image SKU."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the version of the platform image or marketplace image used to create the virtual
     machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are
     decimal numbers. Specify 'latest' to use the latest version of an image available at deploy
     time. Even if you use 'latest', the VM image will not automatically update after deploy time
     even if a new version becomes available. Please do not use field 'version' for gallery image
     deployment, gallery image should always use 'id' field for deployment, to use 'latest' version
     of gallery image, just set
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
     in the 'id' field without version input."""
    shared_gallery_image_id: Optional[str] = rest_field(
        name="sharedGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specified the shared gallery image unique id for vm deployment. This can be fetched from shared
     gallery image GET call."""
    community_gallery_image_id: Optional[str] = rest_field(
        name="communityGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specified the community gallery image unique id for vm deployment. This can be fetched from
     community gallery image GET call."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerError(_Model):
    """Inner error details.

    :ivar exception_type: The exception type.
    :vartype exception_type: str
    :ivar error_detail: The internal error message or exception dump.
    :vartype error_detail: str
    """

    exception_type: Optional[str] = rest_field(
        name="exceptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The exception type."""
    error_detail: Optional[str] = rest_field(
        name="errorDetail", visibility=["read", "create", "update", "delete", "query"]
    )
    """The internal error message or exception dump."""

    @overload
    def __init__(
        self,
        *,
        exception_type: Optional[str] = None,
        error_detail: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultKeyReference(_Model):
    """Describes a reference to Key Vault Key.

    :ivar key_url: The URL referencing a key encryption key in Key Vault. Required.
    :vartype key_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the key. Required.
    :vartype source_vault: ~azure.mgmt.computebulkactions.models.SubResource
    """

    key_url: str = rest_field(name="keyUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL referencing a key encryption key in Key Vault. Required."""
    source_vault: "_models.SubResource" = rest_field(
        name="sourceVault", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative URL of the Key Vault containing the key. Required."""

    @overload
    def __init__(
        self,
        *,
        key_url: str,
        source_vault: "_models.SubResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultSecretReference(_Model):
    """Describes a reference to Key Vault Secret.

    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.computebulkactions.models.SubResource
    """

    secret_url: str = rest_field(name="secretUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL referencing a secret in a Key Vault. Required."""
    source_vault: "_models.SubResource" = rest_field(
        name="sourceVault", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative URL of the Key Vault containing the secret. Required."""

    @overload
    def __init__(
        self,
        *,
        secret_url: str,
        source_vault: "_models.SubResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LaunchBulkInstancesOperationProperties(_Model):
    """Details of the LaunchBulkInstancesOperation.

    :ivar provisioning_state: The status of the last operation. Known values are: "Creating",
     "Succeeded", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.computebulkactions.models.ProvisioningState
    :ivar capacity: Total capacity to achieve. It can be in terms of VMs or vCPUs. Required.
    :vartype capacity: int
    :ivar capacity_type: Specifies capacity type for launching instances. It can be in terms of VMs
     or vCPUs. Known values are: "VM" and "VCpu".
    :vartype capacity_type: str or ~azure.mgmt.computebulkactions.models.CapacityType
    :ivar priority_profile: Configuration Options for Regular or Spot instances in
     LaunchBulkInstancesOperation. Required.
    :vartype priority_profile: ~azure.mgmt.computebulkactions.models.PriorityProfile
    :ivar vm_sizes_profile: List of VM sizes supported for LaunchBulkInstancesOperation.
    :vartype vm_sizes_profile: list[~azure.mgmt.computebulkactions.models.VmSizeProfile]
    :ivar vm_attributes: Attributes to launch instances.
    :vartype vm_attributes: ~azure.mgmt.computebulkactions.models.VMAttributes
    :ivar compute_profile: Compute Profile to configure the Virtual Machines. Required.
    :vartype compute_profile: ~azure.mgmt.computebulkactions.models.ComputeProfile
    :ivar zone_allocation_policy: Zone Allocation Policy for launching instances.
    :vartype zone_allocation_policy: ~azure.mgmt.computebulkactions.models.ZoneAllocationPolicy
    :ivar retry_policy: Retry policy the user can pass.
    :vartype retry_policy: ~azure.mgmt.computebulkactions.models.RetryPolicy
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Creating\", \"Succeeded\", \"Failed\",
     \"Deleting\", and \"Canceled\"."""
    capacity: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Total capacity to achieve. It can be in terms of VMs or vCPUs. Required."""
    capacity_type: Optional[Union[str, "_models.CapacityType"]] = rest_field(
        name="capacityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies capacity type for launching instances. It can be in terms of VMs or vCPUs. Known
     values are: \"VM\" and \"VCpu\"."""
    priority_profile: "_models.PriorityProfile" = rest_field(
        name="priorityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration Options for Regular or Spot instances in LaunchBulkInstancesOperation. Required."""
    vm_sizes_profile: Optional[list["_models.VmSizeProfile"]] = rest_field(
        name="vmSizesProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of VM sizes supported for LaunchBulkInstancesOperation."""
    vm_attributes: Optional["_models.VMAttributes"] = rest_field(
        name="vmAttributes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Attributes to launch instances."""
    compute_profile: "_models.ComputeProfile" = rest_field(
        name="computeProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Compute Profile to configure the Virtual Machines. Required."""
    zone_allocation_policy: Optional["_models.ZoneAllocationPolicy"] = rest_field(
        name="zoneAllocationPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Zone Allocation Policy for launching instances."""
    retry_policy: Optional["_models.RetryPolicy"] = rest_field(
        name="retryPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retry policy the user can pass."""

    @overload
    def __init__(
        self,
        *,
        capacity: int,
        priority_profile: "_models.PriorityProfile",
        compute_profile: "_models.ComputeProfile",
        capacity_type: Optional[Union[str, "_models.CapacityType"]] = None,
        vm_sizes_profile: Optional[list["_models.VmSizeProfile"]] = None,
        vm_attributes: Optional["_models.VMAttributes"] = None,
        zone_allocation_policy: Optional["_models.ZoneAllocationPolicy"] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LinuxConfiguration(_Model):
    """Specifies the Linux operating system settings on the virtual machine. For a list of supported
    Linux distributions, see `Linux on Azure-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.computebulkactions.models.SshConfiguration
    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. When this property is not specified in the request body, default behavior is
     to set it to true. This will ensure that VM Agent is installed on the VM so that extensions can
     be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Linux.
    :vartype patch_settings: ~azure.mgmt.computebulkactions.models.LinuxPatchSettings
    :ivar enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is enabled
     for the Linux virtual machine. Default value is false.
    :vartype enable_vm_agent_platform_updates: bool
    """

    disable_password_authentication: Optional[bool] = rest_field(
        name="disablePasswordAuthentication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether password authentication should be disabled."""
    ssh: Optional["_models.SshConfiguration"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the ssh key configuration for a Linux OS."""
    provision_vm_agent: Optional[bool] = rest_field(
        name="provisionVMAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether virtual machine agent should be provisioned on the virtual machine. When this
     property is not specified in the request body, default behavior is to set it to true. This will
     ensure that VM Agent is installed on the VM so that extensions can be added to the VM later."""
    patch_settings: Optional["_models.LinuxPatchSettings"] = rest_field(
        name="patchSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """[Preview Feature] Specifies settings related to VM Guest Patching on Linux."""
    enable_vm_agent_platform_updates: Optional[bool] = rest_field(
        name="enableVMAgentPlatformUpdates", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether VMAgent Platform Updates is enabled for the Linux virtual machine. Default
     value is false."""

    @overload
    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        patch_settings: Optional["_models.LinuxPatchSettings"] = None,
        enable_vm_agent_platform_updates: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LinuxPatchSettings(_Model):
    """Specifies settings related to VM Guest Patching on Linux.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br
     /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching
     configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be
     automatically updated by the platform. The property provisionVMAgent must be true. Known values
     are: "ImageDefault" and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.computebulkactions.models.LinuxVMGuestPatchMode
    :ivar assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
     machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing
     of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform
     will trigger periodic patch assessments. The property provisionVMAgent must be true. Known
     values are: "ImageDefault" and "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.computebulkactions.models.LinuxPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest Patching on Linux.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.computebulkactions.models.LinuxVMGuestPatchAutomaticByPlatformSettings
    """

    patch_mode: Optional[Union[str, "_models.LinuxVMGuestPatchMode"]] = rest_field(
        name="patchMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated
     to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values
     are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is
     used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated
     by the platform. The property provisionVMAgent must be true. Known values are: \"ImageDefault\"
     and \"AutomaticByPlatform\"."""
    assessment_mode: Optional[Union[str, "_models.LinuxPatchAssessmentMode"]] = rest_field(
        name="assessmentMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br />
     Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments
     on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic
     patch assessments. The property provisionVMAgent must be true. Known values are:
     \"ImageDefault\" and \"AutomaticByPlatform\"."""
    automatic_by_platform_settings: Optional["_models.LinuxVMGuestPatchAutomaticByPlatformSettings"] = rest_field(
        name="automaticByPlatformSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux."""

    @overload
    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.LinuxVMGuestPatchMode"]] = None,
        assessment_mode: Optional[Union[str, "_models.LinuxPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.LinuxVMGuestPatchAutomaticByPlatformSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LinuxVMGuestPatchAutomaticByPlatformSettings(_Model):  # pylint: disable=name-too-long
    """Specifies additional settings to be applied when patch mode AutomaticByPlatform is selected in
    Linux patch settings.

    :ivar reboot_setting: Specifies the reboot setting for all AutomaticByPlatform patch
     installation operations. Known values are: "Unknown", "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or
     ~azure.mgmt.computebulkactions.models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting
    :ivar bypass_platform_safety_checks_on_user_schedule: Enables customer to schedule patching
     without accidental upgrades.
    :vartype bypass_platform_safety_checks_on_user_schedule: bool
    """

    reboot_setting: Optional[Union[str, "_models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting"]] = rest_field(
        name="rebootSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations. Known
     values are: \"Unknown\", \"IfRequired\", \"Never\", and \"Always\"."""
    bypass_platform_safety_checks_on_user_schedule: Optional[bool] = rest_field(
        name="bypassPlatformSafetyChecksOnUserSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables customer to schedule patching without accidental upgrades."""

    @overload
    def __init__(
        self,
        *,
        reboot_setting: Optional[Union[str, "_models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting"]] = None,
        bypass_platform_safety_checks_on_user_schedule: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computebulkactions.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computebulkactions.models.SystemData
    """


class LocationBasedLaunchBulkInstancesOperation(ProxyResource):  # pylint: disable=name-too-long
    """Location based type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computebulkactions.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.computebulkactions.models.LaunchBulkInstancesOperationProperties
    :ivar zones: Zones in which the LaunchBulkInstancesOperation is available.
    :vartype zones: list[str]
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.computebulkactions.models.ManagedServiceIdentity
    :ivar plan: Details of the resource plan.
    :vartype plan: ~azure.mgmt.computebulkactions.models.Plan
    """

    properties: Optional["_models.LaunchBulkInstancesOperationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Zones in which the LaunchBulkInstancesOperation is available."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    plan: Optional["_models.Plan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the resource plan."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.LaunchBulkInstancesOperationProperties"] = None,
        zones: Optional[list[str]] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        plan: Optional["_models.Plan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :ivar id: The ID of the sub-resource.
    :vartype id: str
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.computebulkactions.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set: ~azure.mgmt.computebulkactions.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.computebulkactions.models.VMDiskSecurityProfile
    """

    storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = rest_field(
        name="storageAccountType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used
     with data disks, it cannot be used with OS Disk. Known values are: \"Standard_LRS\",
     \"Premium_LRS\", \"StandardSSD_LRS\", \"UltraSSD_LRS\", \"Premium_ZRS\", \"StandardSSD_ZRS\",
     and \"PremiumV2_LRS\"."""
    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(
        name="diskEncryptionSet", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the customer managed disk encryption set resource id for the managed disk."""
    security_profile: Optional["_models.VMDiskSecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security profile for the managed disk."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.computebulkactions.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.computebulkactions.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :ivar id: The ID of the sub-resource.
    :vartype id: str
    :ivar properties: Describes a network interface reference properties.
    :vartype properties: ~azure.mgmt.computebulkactions.models.NetworkInterfaceReferenceProperties
    """

    properties: Optional["_models.NetworkInterfaceReferenceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes a network interface reference properties."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        properties: Optional["_models.NetworkInterfaceReferenceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceReferenceProperties(_Model):
    """Describes a network interface reference properties.

    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computebulkactions.models.DeleteOptions
    """

    primary: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the primary network interface in case the virtual machine has more than 1 network
     interface."""
    delete_option: Optional[Union[str, "_models.DeleteOptions"]] = rest_field(
        name="deleteOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify what happens to the network interface when the VM is deleted. Known values are:
     \"Delete\" and \"Detach\"."""

    @overload
    def __init__(
        self,
        *,
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkProfile(_Model):
    """Specifies the network interfaces or the networking configuration of the virtual machine.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.computebulkactions.models.NetworkInterfaceReference]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations. Known values are: "2020-11-01"
     and "2022-11-01".
    :vartype network_api_version: str or ~azure.mgmt.computebulkactions.models.NetworkApiVersion
    :ivar network_interface_configurations: Specifies the networking configurations that will be
     used to create the virtual machine networking resources.
    :vartype network_interface_configurations:
     list[~azure.mgmt.computebulkactions.models.VirtualMachineNetworkInterfaceConfiguration]
    """

    network_interfaces: Optional[list["_models.NetworkInterfaceReference"]] = rest_field(
        name="networkInterfaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the list of resource Ids for the network interfaces associated with the virtual
     machine."""
    network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = rest_field(
        name="networkApiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """specifies the Microsoft.Network API version used when creating networking resources in the
     Network Interface Configurations. Known values are: \"2020-11-01\" and \"2022-11-01\"."""
    network_interface_configurations: Optional[list["_models.VirtualMachineNetworkInterfaceConfiguration"]] = (
        rest_field(name="networkInterfaceConfigurations", visibility=["read", "create", "update", "delete", "query"])
    )
    """Specifies the networking configurations that will be used to create the virtual machine
     networking resources."""

    @overload
    def __init__(
        self,
        *,
        network_interfaces: Optional[list["_models.NetworkInterfaceReference"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        network_interface_configurations: Optional[list["_models.VirtualMachineNetworkInterfaceConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.computebulkactions.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.computebulkactions.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.computebulkactions.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for an operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperationStatusResult(_Model):
    """The current status of an async operation.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.computebulkactions.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.computebulkactions.models.ErrorDetail
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified ID for the async operation."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the async operation."""
    status: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation status. Required."""
    percent_complete: Optional[float] = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Percent of the operation that is complete."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the operation."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the operation."""
    operations: Optional[list["_models.OperationStatusResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The operations list."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If present, details of the operation error."""
    resource_id: Optional[str] = rest_field(name="resourceId", visibility=["read"])
    """Fully qualified ID of the resource against which the original async operation was started."""

    @overload
    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[list["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OSDisk(_Model):
    """Specifies information about the operating system disk used by the virtual machine. For more
    information about disks, see `About disks and VHDs for Azure virtual machines
    <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. Possible values are: Windows,
     Linux. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.computebulkactions.models.OperatingSystemTypes
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk. Minimum compute
     api-version: 2015-06-15.
    :vartype encryption_settings: ~azure.mgmt.computebulkactions.models.DiskEncryptionSettings
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.computebulkactions.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.computebulkactions.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. Possible values are: None, ReadOnly,
     ReadWrite. The defaulting behavior is: None for Standard storage. ReadOnly for Premium storage.
     Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.computebulkactions.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk
     used by the virtual machine.
    :vartype diff_disk_settings: ~azure.mgmt.computebulkactions.models.DiffDiskSettings
    :ivar create_option: Specifies how the virtual machine disk should be created. Possible values
     are Attach, FromImage. If you are using a platform image, you should also use the
     imageReference element described above. If you are using a marketplace image, you should also
     use the plan element previously described. Required. Known values are: "FromImage", "Empty",
     "Attach", "Copy", and "Restore".
    :vartype create_option: str or ~azure.mgmt.computebulkactions.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is
     the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.computebulkactions.models.ManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VM deletion.
     Possible values are: Delete, Detach. The default value is set to Detach. For an ephemeral OS
     Disk, the default value is set to Delete. The user cannot change the delete option for an
     ephemeral OS Disk. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computebulkactions.models.DiskDeleteOptionTypes
    """

    os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """This property allows you to specify the type of the OS that is included in the disk if creating
     a VM from user-image or a specialized VHD. Possible values are: Windows, Linux. Known values
     are: \"Windows\" and \"Linux\"."""
    encryption_settings: Optional["_models.DiskEncryptionSettings"] = rest_field(
        name="encryptionSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the encryption settings for the OS Disk. Minimum compute api-version: 2015-06-15."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The disk name."""
    vhd: Optional["_models.VirtualHardDisk"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The virtual hard disk."""
    image: Optional["_models.VirtualHardDisk"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The source user image virtual hard disk. The virtual hard disk will be copied before being
     attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive
     must not exist."""
    caching: Optional[Union[str, "_models.CachingTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the caching requirements. Possible values are: None, ReadOnly, ReadWrite. The
     defaulting behavior is: None for Standard storage. ReadOnly for Premium storage. Known values
     are: \"None\", \"ReadOnly\", and \"ReadWrite\"."""
    write_accelerator_enabled: Optional[bool] = rest_field(
        name="writeAcceleratorEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether writeAccelerator should be enabled or disabled on the disk."""
    diff_disk_settings: Optional["_models.DiffDiskSettings"] = rest_field(
        name="diffDiskSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral Disk Settings for the operating system disk used by the virtual
     machine."""
    create_option: Union[str, "_models.DiskCreateOptionTypes"] = rest_field(
        name="createOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies how the virtual machine disk should be created. Possible values are Attach,
     FromImage. If you are using a platform image, you should also use the imageReference element
     described above. If you are using a marketplace image, you should also use the plan element
     previously described. Required. Known values are: \"FromImage\", \"Empty\", \"Attach\",
     \"Copy\", and \"Restore\"."""
    disk_size_gb: Optional[int] = rest_field(
        name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite
     the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of
     bytes x 1024^3 for the disk and the value cannot be larger than 1023."""
    managed_disk: Optional["_models.ManagedDiskParameters"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""
    delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = rest_field(
        name="deleteOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are:
     Delete, Detach. The default value is set to Detach. For an ephemeral OS Disk, the default value
     is set to Delete. The user cannot change the delete option for an ephemeral OS Disk. Known
     values are: \"Delete\" and \"Detach\"."""

    @overload
    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OSImageNotificationProfile(_Model):
    """Profile for the OS Image Scheduled event.

    :ivar not_before_timeout: Length of time a Virtual Machine being reimaged or having its OS
     upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto
     approved (timed out). The configuration is specified in ISO 8601 format, and the value must be
     15 minutes (PT15M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the OS Image Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    not_before_timeout: Optional[str] = rest_field(
        name="notBeforeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """Length of time a Virtual Machine being reimaged or having its OS upgraded will have to
     potentially approve the OS Image Scheduled Event before the event is auto approved (timed out).
     The configuration is specified in ISO 8601 format, and the value must be 15 minutes (PT15M)."""
    enable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies whether the OS Image Scheduled event is enabled or disabled."""

    @overload
    def __init__(
        self,
        *,
        not_before_timeout: Optional[str] = None,
        enable: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OSProfile(_Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be
    changed once VM is provisioned.

    :ivar computer_name: Specifies the host OS name of the virtual machine. This name cannot be
     updated after the VM is created. **Max-length (Windows):** 15 characters. **Max-length
     (Linux):** 64 characters. For naming conventions and restrictions see `Azure infrastructure
     services implementation guidelines
     <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
    :vartype computer_name: str
    :ivar admin_username: Specifies the name of the administrator account. <br><br> This property
     cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in
     "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2",
     "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup",
     "console", "david", "guest", "john", "owner", "root", "server", "sql", "support",
     "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length
     (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length
     (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account. <br><br>
     **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters
     <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72
     characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a
     special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd",
     "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22",
     "iloveyou!" <br><br> For resetting the password, see `How to reset the Remote Desktop service
     or its login password in a Windows VM
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_ <br><br> For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. **Note: Do not pass any secrets or passwords in
     customData property.** This property cannot be updated after the VM is created. The property
     'customData' is passed to the VM to be saved as a file, for more information see `Custom Data
     on Azure VMs <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_.
     For using cloud-init for your Linux VM, see `Using cloud-init to customize a Linux VM during
     creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.computebulkactions.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. For a list of supported Linux distributions, see `Linux on Azure-Endorsed
     Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.computebulkactions.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machine.
     To install certificates on a virtual machine it is recommended to use the `Azure Key Vault
     virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.computebulkactions.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine. This may only be set to False when no extensions are present on the
     virtual machine.
    :vartype allow_extension_operations: bool
    :ivar require_guest_provision_signal: Optional property which must either be set to True or
     omitted.
    :vartype require_guest_provision_signal: bool
    """

    computer_name: Optional[str] = rest_field(
        name="computerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the host OS name of the virtual machine. This name cannot be updated after the VM is
     created. **Max-length (Windows):** 15 characters. **Max-length (Linux):** 64 characters. For
     naming conventions and restrictions see `Azure infrastructure services implementation
     guidelines
     <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_."""
    admin_username: Optional[str] = rest_field(
        name="adminUsername", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the name of the administrator account. <br><br> This property cannot be updated after
     the VM is created. <br><br> **Windows-only restriction:** Cannot end in \".\" <br><br>
     **Disallowed values:** \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\",
     \"test1\", \"user3\", \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\",
     \"aspnet\", \"backup\", \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\",
     \"server\", \"sql\", \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\",
     \"user4\", \"user5\". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length
     (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters."""
    admin_password: Optional[str] = rest_field(
        name="adminPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8
     characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):**
     123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity
     requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters
     <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_])
     <br><br> **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\", \"P@ssword123\",
     \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\", \"Password22\", \"iloveyou!\"
     <br><br> For resetting the password, see `How to reset the Remote Desktop service or its login
     password in a Windows VM
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_ <br><br> For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_."""
    custom_data: Optional[str] = rest_field(
        name="customData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a
     binary array that is saved as a file on the Virtual Machine. The maximum length of the binary
     array is 65535 bytes. **Note: Do not pass any secrets or passwords in customData property.**
     This property cannot be updated after the VM is created. The property 'customData' is passed to
     the VM to be saved as a file, for more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_. For using
     cloud-init for your Linux VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_."""
    windows_configuration: Optional["_models.WindowsConfiguration"] = rest_field(
        name="windowsConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Windows operating system settings on the virtual machine."""
    linux_configuration: Optional["_models.LinuxConfiguration"] = rest_field(
        name="linuxConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the Linux operating system settings on the virtual machine. For a list of supported
     Linux distributions, see `Linux on Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_."""
    secrets: Optional[list["_models.VaultSecretGroup"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies set of certificates that should be installed onto the virtual machine. To install
     certificates on a virtual machine it is recommended to use the `Azure Key Vault virtual machine
     extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_."""
    allow_extension_operations: Optional[bool] = rest_field(
        name="allowExtensionOperations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether extension operations should be allowed on the virtual machine. This may only
     be set to False when no extensions are present on the virtual machine."""
    require_guest_provision_signal: Optional[bool] = rest_field(
        name="requireGuestProvisionSignal", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property which must either be set to True or omitted."""

    @overload
    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[list["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchSettings(_Model):
    """Specifies settings related to VM Guest Patching on Windows.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br
     /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a
     virtual machine. You do this by applying patches manually inside the VM. In this mode,
     automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must
     be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by
     the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br />
     **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
     properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Known
     values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.computebulkactions.models.WindowsVMGuestPatchMode
    :ivar enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
     reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
     be set to 'AutomaticByPlatform'.
    :vartype enable_hotpatching: bool
    :ivar assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing
     of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform
     will trigger periodic patch assessments. The property provisionVMAgent must be true. Known
     values are: "ImageDefault" and "AutomaticByPlatform".
    :vartype assessment_mode: str or
     ~azure.mgmt.computebulkactions.models.WindowsPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest Patching on Windows.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.computebulkactions.models.WindowsVMGuestPatchAutomaticByPlatformSettings
    """

    patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = rest_field(
        name="patchMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated
     to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values
     are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You
     do this by applying patches manually inside the VM. In this mode, automatic updates are
     disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br />
     **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
     WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform**
     - the virtual machine will automatically updated by the platform. The properties
     provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Known values
     are: \"Manual\", \"AutomaticByOS\", and \"AutomaticByPlatform\"."""
    enable_hotpatching: Optional[bool] = rest_field(
        name="enableHotpatching", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching,
     the 'provisionVMAgent' must be set to true and 'patchMode' must be set to
     'AutomaticByPlatform'."""
    assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = rest_field(
        name="assessmentMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br />
     Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments
     on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic
     patch assessments. The property provisionVMAgent must be true. Known values are:
     \"ImageDefault\" and \"AutomaticByPlatform\"."""
    automatic_by_platform_settings: Optional["_models.WindowsVMGuestPatchAutomaticByPlatformSettings"] = rest_field(
        name="automaticByPlatformSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on
     Windows."""

    @overload
    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = None,
        enable_hotpatching: Optional[bool] = None,
        assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.WindowsVMGuestPatchAutomaticByPlatformSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Plan(_Model):
    """Plan for the resource.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured. Required.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
     Required.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding. Required.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A user defined name of the 3rd Party Artifact that is being procured. Required."""
    publisher: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic. Required."""
    product: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID
     specified for the artifact at the time of Data Market onboarding. Required."""
    promotion_code: Optional[str] = rest_field(
        name="promotionCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A publisher provided promotion code as provisioned in Data Market for the said
     product/artifact."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the desired product/artifact."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PriorityProfile(_Model):
    """Contains properties that are applicable to both Spot and Regular.

    :ivar type: Specifies the type of Virtual Machine. Known values are: "Regular" and "Spot".
    :vartype type: str or ~azure.mgmt.computebulkactions.models.VirtualMachineType
    :ivar max_price_per_vm: Price per hour of each Spot VM will never exceed this.
    :vartype max_price_per_vm: float
    :ivar eviction_policy: Eviction Policy to follow when evicting Spot VMs. Known values are:
     "Delete" and "Deallocate".
    :vartype eviction_policy: str or ~azure.mgmt.computebulkactions.models.EvictionPolicy
    :ivar allocation_strategy: Allocation strategy to follow when determining the VM sizes
     distribution. Known values are: "LowestPrice", "CapacityOptimized", and "Prioritized".
    :vartype allocation_strategy: str or ~azure.mgmt.computebulkactions.models.AllocationStrategy
    """

    type: Optional[Union[str, "_models.VirtualMachineType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the type of Virtual Machine. Known values are: \"Regular\" and \"Spot\"."""
    max_price_per_vm: Optional[float] = rest_field(
        name="maxPricePerVM", visibility=["read", "create", "update", "delete", "query"]
    )
    """Price per hour of each Spot VM will never exceed this."""
    eviction_policy: Optional[Union[str, "_models.EvictionPolicy"]] = rest_field(
        name="evictionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Eviction Policy to follow when evicting Spot VMs. Known values are: \"Delete\" and
     \"Deallocate\"."""
    allocation_strategy: Optional[Union[str, "_models.AllocationStrategy"]] = rest_field(
        name="allocationStrategy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allocation strategy to follow when determining the VM sizes distribution. Known values are:
     \"LowestPrice\", \"CapacityOptimized\", and \"Prioritized\"."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.VirtualMachineType"]] = None,
        max_price_per_vm: Optional[float] = None,
        eviction_policy: Optional[Union[str, "_models.EvictionPolicy"]] = None,
        allocation_strategy: Optional[Union[str, "_models.AllocationStrategy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyAgentSettings(_Model):
    """Specifies ProxyAgent settings for the virtual machine or virtual machine scale set. Minimum
    api-version: 2023-09-01.

    :ivar enabled: Specifies whether ProxyAgent feature should be enabled on the virtual machine or
     virtual machine scale set.
    :vartype enabled: bool
    :ivar mode: Specifies the mode that ProxyAgent will execute on. Warning: this property has been
     deprecated, please specify 'mode' under particular hostendpoint setting. Known values are:
     "Audit" and "Enforce".
    :vartype mode: str or ~azure.mgmt.computebulkactions.models.Mode
    :ivar key_incarnation_id: Increase the value of this property allows users to reset the key
     used for securing communication channel between guest and host.
    :vartype key_incarnation_id: int
    :ivar wire_server: Specifies the Wire Server endpoint settings while creating the virtual
     machine or virtual machine scale set. Minimum api-version: 2024-03-01.
    :vartype wire_server: ~azure.mgmt.computebulkactions.models.HostEndpointSettings
    :ivar imds: Specifies the IMDS endpoint settings while creating the virtual machine or virtual
     machine scale set. Minimum api-version: 2024-03-01.
    :vartype imds: ~azure.mgmt.computebulkactions.models.HostEndpointSettings
    :ivar add_proxy_agent_extension: Specify whether to implicitly install the ProxyAgent
     Extension. This option is currently applicable only for Linux Os.
    :vartype add_proxy_agent_extension: bool
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual
     machine scale set."""
    mode: Optional[Union[str, "_models.Mode"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the mode that ProxyAgent will execute on. Warning: this property has been deprecated,
     please specify 'mode' under particular hostendpoint setting. Known values are: \"Audit\" and
     \"Enforce\"."""
    key_incarnation_id: Optional[int] = rest_field(
        name="keyIncarnationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Increase the value of this property allows users to reset the key used for securing
     communication channel between guest and host."""
    wire_server: Optional["_models.HostEndpointSettings"] = rest_field(
        name="wireServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the Wire Server endpoint settings while creating the virtual machine or virtual
     machine scale set. Minimum api-version: 2024-03-01."""
    imds: Optional["_models.HostEndpointSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the IMDS endpoint settings while creating the virtual machine or virtual machine
     scale set. Minimum api-version: 2024-03-01."""
    add_proxy_agent_extension: Optional[bool] = rest_field(
        name="addProxyAgentExtension", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify whether to implicitly install the ProxyAgent Extension. This option is currently
     applicable only for Linux Os."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        mode: Optional[Union[str, "_models.Mode"]] = None,
        key_incarnation_id: Optional[int] = None,
        wire_server: Optional["_models.HostEndpointSettings"] = None,
        imds: Optional["_models.HostEndpointSettings"] = None,
        add_proxy_agent_extension: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PublicIPAddressSku(_Model):
    """Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.

    :ivar name: Specify public IP sku name. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.computebulkactions.models.PublicIPAddressSkuName
    :ivar tier: Specify public IP sku tier. Known values are: "Regional" and "Global".
    :vartype tier: str or ~azure.mgmt.computebulkactions.models.PublicIPAddressSkuTier
    """

    name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify public IP sku name. Known values are: \"Basic\" and \"Standard\"."""
    tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify public IP sku tier. Known values are: \"Regional\" and \"Global\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = None,
        tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceOperation(_Model):
    """Top level response from an operation on a resource.

    :ivar resource_id: Unique identifier for the resource involved in the operation, eg Azure
     Resource Manager ID.
    :vartype resource_id: str
    :ivar error_code: Resource level error code if it exists.
    :vartype error_code: str
    :ivar error_details: Resource level error details if they exist.
    :vartype error_details: str
    :ivar operation: Details of the operation performed on a resource.
    :vartype operation: ~azure.mgmt.computebulkactions.models.ResourceOperationDetails
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unique identifier for the resource involved in the operation, eg Azure Resource Manager ID."""
    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """Resource level error code if it exists."""
    error_details: Optional[str] = rest_field(
        name="errorDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource level error details if they exist."""
    operation: Optional["_models.ResourceOperationDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of the operation performed on a resource."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        error_code: Optional[str] = None,
        error_details: Optional[str] = None,
        operation: Optional["_models.ResourceOperationDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceOperationDetails(_Model):
    """The details of a response from an operation on a resource.

    :ivar operation_id: Operation identifier for the unique operation. Required.
    :vartype operation_id: str
    :ivar resource_id: Unique identifier for the resource involved in the operation, eg Azure
     Resource Manager ID.
    :vartype resource_id: str
    :ivar op_type: Type of operation performed on the resources. Known values are: "Unknown",
     "Start", "Deallocate", "Hibernate", "Create", and "Delete".
    :vartype op_type: str or ~azure.mgmt.computebulkactions.models.ResourceOperationType
    :ivar subscription_id: Subscription id attached to the request.
    :vartype subscription_id: str
    :ivar deadline: Deadline for the operation.
    :vartype deadline: ~datetime.datetime
    :ivar deadline_type: Type of deadline of the operation. Known values are: "Unknown",
     "InitiateAt", and "CompleteBy".
    :vartype deadline_type: str or ~azure.mgmt.computebulkactions.models.DeadlineType
    :ivar state: Current state of the operation. Known values are: "Unknown", "PendingScheduling",
     "Scheduled", "PendingExecution", "Executing", "Succeeded", "Failed", "Cancelled", and
     "Blocked".
    :vartype state: str or ~azure.mgmt.computebulkactions.models.OperationState
    :ivar timezone: Timezone for the operation.
    :vartype timezone: str
    :ivar resource_operation_error: Operation level errors if they exist.
    :vartype resource_operation_error: ~azure.mgmt.computebulkactions.models.ResourceOperationError
    :ivar completed_at: Time the operation was complete if errors are null.
    :vartype completed_at: ~datetime.datetime
    :ivar retry_policy: Retry policy the user can pass.
    :vartype retry_policy: ~azure.mgmt.computebulkactions.models.RetryPolicy
    """

    operation_id: str = rest_field(name="operationId", visibility=["read", "create", "update", "delete", "query"])
    """Operation identifier for the unique operation. Required."""
    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unique identifier for the resource involved in the operation, eg Azure Resource Manager ID."""
    op_type: Optional[Union[str, "_models.ResourceOperationType"]] = rest_field(
        name="opType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of operation performed on the resources. Known values are: \"Unknown\", \"Start\",
     \"Deallocate\", \"Hibernate\", \"Create\", and \"Delete\"."""
    subscription_id: Optional[str] = rest_field(
        name="subscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Subscription id attached to the request."""
    deadline: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Deadline for the operation."""
    deadline_type: Optional[Union[str, "_models.DeadlineType"]] = rest_field(
        name="deadlineType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of deadline of the operation. Known values are: \"Unknown\", \"InitiateAt\", and
     \"CompleteBy\"."""
    state: Optional[Union[str, "_models.OperationState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Current state of the operation. Known values are: \"Unknown\", \"PendingScheduling\",
     \"Scheduled\", \"PendingExecution\", \"Executing\", \"Succeeded\", \"Failed\", \"Cancelled\",
     and \"Blocked\"."""
    timezone: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Timezone for the operation."""
    resource_operation_error: Optional["_models.ResourceOperationError"] = rest_field(
        name="resourceOperationError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation level errors if they exist."""
    completed_at: Optional[datetime.datetime] = rest_field(
        name="completedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time the operation was complete if errors are null."""
    retry_policy: Optional["_models.RetryPolicy"] = rest_field(
        name="retryPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retry policy the user can pass."""

    @overload
    def __init__(
        self,
        *,
        operation_id: str,
        resource_id: Optional[str] = None,
        op_type: Optional[Union[str, "_models.ResourceOperationType"]] = None,
        subscription_id: Optional[str] = None,
        deadline: Optional[datetime.datetime] = None,
        deadline_type: Optional[Union[str, "_models.DeadlineType"]] = None,
        state: Optional[Union[str, "_models.OperationState"]] = None,
        timezone: Optional[str] = None,
        resource_operation_error: Optional["_models.ResourceOperationError"] = None,
        completed_at: Optional[datetime.datetime] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceOperationError(_Model):
    """These describe errors that occur at the resource level.

    :ivar error_code: Code for the error eg 404, 500. Required.
    :vartype error_code: str
    :ivar error_details: Detailed message about the error. Required.
    :vartype error_details: str
    """

    error_code: str = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """Code for the error eg 404, 500. Required."""
    error_details: str = rest_field(name="errorDetails", visibility=["read", "create", "update", "delete", "query"])
    """Detailed message about the error. Required."""

    @overload
    def __init__(
        self,
        *,
        error_code: str,
        error_details: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceProvisionPayload(_Model):
    """Resource creation data model.

    :ivar base_profile: JSON object that contains VM properties that are common across all VMs in
     this batch (if you want to create 100 VMs in this request, and they all have same vmSize, then
     include vmSize in baseProfile).
    :vartype base_profile: dict[str, any]
    :ivar resource_overrides: JSON array, that contains VM properties that should to be overridden
     for each VM in the batch (if you want to create 100 VMs, they all need a distinct computerName
     property, you pass computerNames for each VM in batch in this array), service will merge
     baseProfile with VM specific overrides and create a merged VMProfile.
    :vartype resource_overrides: list[dict[str, any]]
    :ivar resource_count: Number of VMs to be created. Required.
    :vartype resource_count: int
    :ivar resource_prefix: if resourceOverrides doesn't contain "name", service will create name
     based of prefix and ResourceCount e.g. resourceprefix-0,resourceprefix-1..
    :vartype resource_prefix: str
    """

    base_profile: Optional[dict[str, Any]] = rest_field(
        name="baseProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """JSON object that contains VM properties that are common across all VMs in this batch (if you
     want to create 100 VMs in this request, and they all have same vmSize, then include vmSize in
     baseProfile)."""
    resource_overrides: Optional[list[dict[str, Any]]] = rest_field(
        name="resourceOverrides", visibility=["read", "create", "update", "delete", "query"]
    )
    """JSON array, that contains VM properties that should to be overridden for each VM in the batch
     (if you want to create 100 VMs, they all need a distinct computerName property, you pass
     computerNames for each VM in batch in this array), service will merge baseProfile with VM
     specific overrides and create a merged VMProfile."""
    resource_count: int = rest_field(name="resourceCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of VMs to be created. Required."""
    resource_prefix: Optional[str] = rest_field(
        name="resourcePrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """if resourceOverrides doesn't contain \"name\", service will create name based of prefix and
     ResourceCount e.g. resourceprefix-0,resourceprefix-1.."""

    @overload
    def __init__(
        self,
        *,
        resource_count: int,
        base_profile: Optional[dict[str, Any]] = None,
        resource_overrides: Optional[list[dict[str, Any]]] = None,
        resource_prefix: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resources(_Model):
    """The resources needed for the user request.

    :ivar ids: The resource ids used for the request. Required.
    :vartype ids: list[str]
    """

    ids: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource ids used for the request. Required."""

    @overload
    def __init__(
        self,
        *,
        ids: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RetryPolicy(_Model):
    """The retry policy for the user request.

    :ivar retry_count: Retry count for user request.
    :vartype retry_count: int
    :ivar retry_window_in_minutes: Retry window in minutes for user request.
    :vartype retry_window_in_minutes: int
    """

    retry_count: Optional[int] = rest_field(
        name="retryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retry count for user request."""
    retry_window_in_minutes: Optional[int] = rest_field(
        name="retryWindowInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retry window in minutes for user request."""

    @overload
    def __init__(
        self,
        *,
        retry_count: Optional[int] = None,
        retry_window_in_minutes: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduledEventsAdditionalPublishingTargets(_Model):  # pylint: disable=name-too-long
    """Specifies additional publishing targets for scheduled events.

    :ivar event_grid_and_resource_graph: The configuration parameters used while creating
     eventGridAndResourceGraph Scheduled Event setting.
    :vartype event_grid_and_resource_graph:
     ~azure.mgmt.computebulkactions.models.EventGridAndResourceGraph
    """

    event_grid_and_resource_graph: Optional["_models.EventGridAndResourceGraph"] = rest_field(
        name="eventGridAndResourceGraph", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration parameters used while creating eventGridAndResourceGraph Scheduled Event
     setting."""

    @overload
    def __init__(
        self,
        *,
        event_grid_and_resource_graph: Optional["_models.EventGridAndResourceGraph"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduledEventsPolicy(_Model):
    """Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets Scheduled Event
    related configurations.

    :ivar user_initiated_redeploy: The configuration parameters used while creating
     userInitiatedRedeploy scheduled event setting creation.
    :vartype user_initiated_redeploy: ~azure.mgmt.computebulkactions.models.UserInitiatedRedeploy
    :ivar user_initiated_reboot: The configuration parameters used while creating
     userInitiatedReboot scheduled event setting creation.
    :vartype user_initiated_reboot: ~azure.mgmt.computebulkactions.models.UserInitiatedReboot
    :ivar scheduled_events_additional_publishing_targets: The configuration parameters used while
     publishing scheduledEventsAdditionalPublishingTargets.
    :vartype scheduled_events_additional_publishing_targets:
     ~azure.mgmt.computebulkactions.models.ScheduledEventsAdditionalPublishingTargets
    :ivar all_instances_down: The configuration parameters used while creating AllInstancesDown
     scheduled event setting creation.
    :vartype all_instances_down: ~azure.mgmt.computebulkactions.models.AllInstancesDown
    """

    user_initiated_redeploy: Optional["_models.UserInitiatedRedeploy"] = rest_field(
        name="userInitiatedRedeploy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration parameters used while creating userInitiatedRedeploy scheduled event setting
     creation."""
    user_initiated_reboot: Optional["_models.UserInitiatedReboot"] = rest_field(
        name="userInitiatedReboot", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration parameters used while creating userInitiatedReboot scheduled event setting
     creation."""
    scheduled_events_additional_publishing_targets: Optional["_models.ScheduledEventsAdditionalPublishingTargets"] = (
        rest_field(
            name="scheduledEventsAdditionalPublishingTargets",
            visibility=["read", "create", "update", "delete", "query"],
        )
    )
    """The configuration parameters used while publishing scheduledEventsAdditionalPublishingTargets."""
    all_instances_down: Optional["_models.AllInstancesDown"] = rest_field(
        name="allInstancesDown", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration parameters used while creating AllInstancesDown scheduled event setting
     creation."""

    @overload
    def __init__(
        self,
        *,
        user_initiated_redeploy: Optional["_models.UserInitiatedRedeploy"] = None,
        user_initiated_reboot: Optional["_models.UserInitiatedReboot"] = None,
        scheduled_events_additional_publishing_targets: Optional[
            "_models.ScheduledEventsAdditionalPublishingTargets"
        ] = None,
        all_instances_down: Optional["_models.AllInstancesDown"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduledEventsProfile(_Model):
    """Profile for the scheduled events.

    :ivar terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :vartype terminate_notification_profile:
     ~azure.mgmt.computebulkactions.models.TerminateNotificationProfile
    :ivar os_image_notification_profile: Specifies OS Image Scheduled Event related configurations.
    :vartype os_image_notification_profile:
     ~azure.mgmt.computebulkactions.models.OSImageNotificationProfile
    """

    terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = rest_field(
        name="terminateNotificationProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Terminate Scheduled Event related configurations."""
    os_image_notification_profile: Optional["_models.OSImageNotificationProfile"] = rest_field(
        name="osImageNotificationProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies OS Image Scheduled Event related configurations."""

    @overload
    def __init__(
        self,
        *,
        terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = None,
        os_image_notification_profile: Optional["_models.OSImageNotificationProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityProfile(_Model):
    """Specifies the Security profile settings for the virtual machine or virtual machine scale set.

    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine. Minimum compute api-version: 2020-12-01.
    :vartype uefi_settings: ~azure.mgmt.computebulkactions.models.UefiSettings
    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host Encryption for the virtual machine or virtual machine scale set. This will enable the
     encryption for all the disks including Resource/Temp disk at host itself. The default behavior
     is: The Encryption at host will be disabled unless this property is set to true for the
     resource.
    :vartype encryption_at_host: bool
    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. The default behavior is: UefiSettings will not be
     enabled unless this property is set. Known values are: "TrustedLaunch" and "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.computebulkactions.models.SecurityTypes
    :ivar encryption_identity: Specifies the Managed Identity used by ADE to get access token for
     keyvault operations.
    :vartype encryption_identity: ~azure.mgmt.computebulkactions.models.EncryptionIdentity
    :ivar proxy_agent_settings: Specifies ProxyAgent settings while creating the virtual machine.
     Minimum compute api-version: 2023-09-01.
    :vartype proxy_agent_settings: ~azure.mgmt.computebulkactions.models.ProxyAgentSettings
    """

    uefi_settings: Optional["_models.UefiSettings"] = rest_field(
        name="uefiSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
     machine. Minimum compute api-version: 2020-12-01."""
    encryption_at_host: Optional[bool] = rest_field(
        name="encryptionAtHost", visibility=["read", "create", "update", "delete", "query"]
    )
    """This property can be used by user in the request to enable or disable the Host Encryption for
     the virtual machine or virtual machine scale set. This will enable the encryption for all the
     disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at
     host will be disabled unless this property is set to true for the resource."""
    security_type: Optional[Union[str, "_models.SecurityTypes"]] = rest_field(
        name="securityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the SecurityType of the virtual machine. It has to be set to any specified value to
     enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this
     property is set. Known values are: \"TrustedLaunch\" and \"ConfidentialVM\"."""
    encryption_identity: Optional["_models.EncryptionIdentity"] = rest_field(
        name="encryptionIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the Managed Identity used by ADE to get access token for keyvault operations."""
    proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = rest_field(
        name="proxyAgentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies ProxyAgent settings while creating the virtual machine. Minimum compute api-version:
     2023-09-01."""

    @overload
    def __init__(
        self,
        *,
        uefi_settings: Optional["_models.UefiSettings"] = None,
        encryption_at_host: Optional[bool] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        encryption_identity: Optional["_models.EncryptionIdentity"] = None,
        proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SshConfiguration(_Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.computebulkactions.models.SshPublicKey]
    """

    public_keys: Optional[list["_models.SshPublicKey"]] = rest_field(
        name="publicKeys", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of SSH public keys used to authenticate with linux based VMs."""

    @overload
    def __init__(
        self,
        *,
        public_keys: Optional[list["_models.SshPublicKey"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SshPublicKey(_Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH
     keys on Linux and Mac for Linux VMs in
     Azure]`https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed
     <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_).
    :vartype key_data: str
    """

    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the full path on the created VM where ssh public key is stored. If the file already
     exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys."""
    key_data: Optional[str] = rest_field(name="keyData", visibility=["read", "create", "update", "delete", "query"])
    """SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at
     least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH keys on Linux and
     Mac for Linux VMs in
     Azure]`https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed
     <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_)."""

    @overload
    def __init__(
        self,
        *,
        path: Optional[str] = None,
        key_data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StartResourceOperationResponse(_Model):
    """The response from a start request.

    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the request.
    :vartype results: list[~azure.mgmt.computebulkactions.models.ResourceOperation]
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the operation response. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of resources used in the request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the request eg westus. Required."""
    results: Optional[list["_models.ResourceOperation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results from the request."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[list["_models.ResourceOperation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageProfile(_Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.computebulkactions.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. For more information about disks, see `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.computebulkactions.models.OSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. For more information about disks, see `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.computebulkactions.models.DataDisk]
    :ivar disk_controller_type: Specifies the disk controller type configured for the VM. **Note:**
     This property will be set to the default disk controller type if not specified provided virtual
     machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the
     operating system disk and VM size from the the specified minimum api version. You need to
     deallocate the VM before updating its disk controller type unless you are updating the VM size
     in the VM configuration which implicitly deallocates and reallocates the VM. Minimum
     api-version: 2022-08-01. Known values are: "SCSI" and "NVMe".
    :vartype disk_controller_type: str or ~azure.mgmt.computebulkactions.models.DiskControllerTypes
    """

    image_reference: Optional["_models.ImageReference"] = rest_field(
        name="imageReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies information about the image to use. You can specify information about platform
     images, marketplace images, or virtual machine images. This element is required when you want
     to use a platform image, marketplace image, or virtual machine image, but is not used in other
     creation operations."""
    os_disk: Optional["_models.OSDisk"] = rest_field(
        name="osDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies information about the operating system disk used by the virtual machine. For more
     information about disks, see `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_."""
    data_disks: Optional[list["_models.DataDisk"]] = rest_field(
        name="dataDisks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the parameters that are used to add a data disk to a virtual machine. For more
     information about disks, see `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_."""
    disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = rest_field(
        name="diskControllerType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the disk controller type configured for the VM. **Note:** This property will be set
     to the default disk controller type if not specified provided virtual machine is being created
     with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM
     size from the the specified minimum api version. You need to deallocate the VM before updating
     its disk controller type unless you are updating the VM size in the VM configuration which
     implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01. Known values
     are: \"SCSI\" and \"NVMe\"."""

    @overload
    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        data_disks: Optional[list["_models.DataDisk"]] = None,
        disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.computebulkactions.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.computebulkactions.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TerminateNotificationProfile(_Model):
    """Profile properties for the Terminate Scheduled event.

    :ivar not_before_timeout: Configurable length of time a Virtual Machine being deleted will have
     to potentially approve the Terminate Scheduled Event before the event is auto approved (timed
     out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes
     (PT5M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    not_before_timeout: Optional[str] = rest_field(
        name="notBeforeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configurable length of time a Virtual Machine being deleted will have to potentially approve
     the Terminate Scheduled Event before the event is auto approved (timed out). The configuration
     must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)."""
    enable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies whether the Terminate Scheduled event is enabled or disabled."""

    @overload
    def __init__(
        self,
        *,
        not_before_timeout: Optional[str] = None,
        enable: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UefiSettings(_Model):
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
    machine. Minimum api-version: 2020-12-01.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine. Minimum compute api-version: 2020-12-01.
    :vartype secure_boot_enabled: bool
    :ivar v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Minimum
     compute api-version: 2020-12-01.
    :vartype v_tpm_enabled: bool
    """

    secure_boot_enabled: Optional[bool] = rest_field(
        name="secureBootEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether secure boot should be enabled on the virtual machine. Minimum compute
     api-version: 2020-12-01."""
    v_tpm_enabled: Optional[bool] = rest_field(
        name="vTpmEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether vTPM should be enabled on the virtual machine. Minimum compute api-version:
     2020-12-01."""

    @overload
    def __init__(
        self,
        *,
        secure_boot_enabled: Optional[bool] = None,
        v_tpm_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class UserInitiatedReboot(_Model):
    """Specifies Reboot related Scheduled Event related configurations.

    :ivar automatically_approve: Specifies Reboot Scheduled Event related configurations.
    :vartype automatically_approve: bool
    """

    automatically_approve: Optional[bool] = rest_field(
        name="automaticallyApprove", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Reboot Scheduled Event related configurations."""

    @overload
    def __init__(
        self,
        *,
        automatically_approve: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserInitiatedRedeploy(_Model):
    """Specifies Redeploy related Scheduled Event related configurations.

    :ivar automatically_approve: Specifies Redeploy Scheduled Event related configurations.
    :vartype automatically_approve: bool
    """

    automatically_approve: Optional[bool] = rest_field(
        name="automaticallyApprove", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Redeploy Scheduled Event related configurations."""

    @overload
    def __init__(
        self,
        *,
        automatically_approve: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultCertificate(_Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: <br><br> {<br>  'data':'<Base64-encoded-certificate>',<br>  'dataType':'pfx',<br>
     'password':'<pfx-file-password>'<br>} <br> To install certificates on a virtual machine it is
     recommended to use the `Azure Key Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. For Linux VMs, the certificate file is placed under the
     /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509
     certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem
     formatted.
    :vartype certificate_store: str
    """

    certificate_url: Optional[str] = rest_field(
        name="certificateUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a
     secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: <br><br> {<br>  'data':'<Base64-encoded-certificate>',<br>  'dataType':'pfx',<br>
     'password':'<pfx-file-password>'<br>} <br> To install certificates on a virtual machine it is
     recommended to use the `Azure Key Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_."""
    certificate_store: Optional[str] = rest_field(
        name="certificateStore", visibility=["read", "create", "update", "delete", "query"]
    )
    """For Windows VMs, specifies the certificate store on the Virtual Machine to which the
     certificate should be added. The specified certificate store is implicitly in the LocalMachine
     account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory,
     with the file name <UppercaseThumbprint>.crt for the X509 certificate file and
     <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted."""

    @overload
    def __init__(
        self,
        *,
        certificate_url: Optional[str] = None,
        certificate_store: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultSecretGroup(_Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.computebulkactions.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.computebulkactions.models.VaultCertificate]
    """

    source_vault: Optional["_models.SubResource"] = rest_field(
        name="sourceVault", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative URL of the Key Vault containing all of the certificates in VaultCertificates."""
    vault_certificates: Optional[list["_models.VaultCertificate"]] = rest_field(
        name="vaultCertificates", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of key vault references in SourceVault which contain certificates."""

    @overload
    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[list["_models.VaultCertificate"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDisk(_Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    uri: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the virtual hard disk's uri."""

    @overload
    def __init__(
        self,
        *,
        uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachine(_Model):
    """An instant Fleet's virtual machine.

    :ivar name: The name of the virtual machine. Required.
    :vartype name: str
    :ivar id: The compute RP resource id of the virtual machine.
     subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.Compute/virtualMachines/{vmName}.
     Required.
    :vartype id: str
    :ivar type: Type of the virtual machine.
    :vartype type: str
    :ivar operation_status: This represents the operationStatus of the virtual machine in response
     to the last operation that was performed on it by Azure Fleet resource. Required. Known values
     are: "Creating", "Canceled", "CancelFailedStatusUnknown", "Failed", "Succeeded", "Deleting",
     and "Cancelling".
    :vartype operation_status: str or ~azure.mgmt.computebulkactions.models.VMOperationStatus
    :ivar error: Error information when ``operationStatus`` is ``Failed``.
    :vartype error: ~azure.mgmt.computebulkactions.models.ApiError
    """

    name: str = rest_field(visibility=["read"])
    """The name of the virtual machine. Required."""
    id: str = rest_field(visibility=["read"])
    """The compute RP resource id of the virtual machine.
     subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.Compute/virtualMachines/{vmName}.
     Required."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Type of the virtual machine."""
    operation_status: Union[str, "_models.VMOperationStatus"] = rest_field(name="operationStatus", visibility=["read"])
    """This represents the operationStatus of the virtual machine in response to the last operation
     that was performed on it by Azure Fleet resource. Required. Known values are: \"Creating\",
     \"Canceled\", \"CancelFailedStatusUnknown\", \"Failed\", \"Succeeded\", \"Deleting\", and
     \"Cancelling\"."""
    error: Optional["_models.ApiError"] = rest_field(visibility=["read"])
    """Error information when ``operationStatus`` is ``Failed``."""


class VirtualMachineExtension(_Model):
    """Defines a virtual machine extension.

    :ivar name: The name of the virtual machine extension. Required.
    :vartype name: str
    :ivar properties: Properties of the virtual machine extension. Required.
    :vartype properties: ~azure.mgmt.computebulkactions.models.VirtualMachineExtensionProperties
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the virtual machine extension. Required."""
    properties: "_models.VirtualMachineExtensionProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the virtual machine extension. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: "_models.VirtualMachineExtensionProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineExtensionProperties(_Model):
    """Describes the properties of a Virtual Machine Extension.

    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is 'CustomScriptExtension'.
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: JSON formatted public settings for the extension.
    :vartype settings: dict[str, any]
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: dict[str, any]
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.computebulkactions.models.KeyVaultSecretReference
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    """

    force_update_tag: Optional[str] = rest_field(
        name="forceUpdateTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the extension handler should be forced to update even if the extension configuration has
     not changed."""
    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extension handler publisher."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the type of the extension; an example is 'CustomScriptExtension'."""
    type_handler_version: Optional[str] = rest_field(
        name="typeHandlerVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the version of the script handler."""
    auto_upgrade_minor_version: Optional[bool] = rest_field(
        name="autoUpgradeMinorVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should use a newer minor version if one is available at
     deployment time. Once deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true."""
    enable_automatic_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should be automatically upgraded by the platform if there is a
     newer version of the extension available."""
    settings: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """JSON formatted public settings for the extension."""
    protected_settings: Optional[dict[str, Any]] = rest_field(
        name="protectedSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no
     protected settings at all."""
    suppress_failures: Optional[bool] = rest_field(
        name="suppressFailures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether failures stemming from the extension will be suppressed (Operational failures
     such as not connecting to the VM will not be suppressed regardless of this value). The default
     is false."""
    protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = rest_field(
        name="protectedSettingsFromKeyVault", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extensions protected settings that are passed by reference, and consumed from key vault."""
    provision_after_extensions: Optional[list[str]] = rest_field(
        name="provisionAfterExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Collection of extension names after which this extension needs to be provisioned."""

    @overload
    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[dict[str, Any]] = None,
        protected_settings: Optional[dict[str, Any]] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        provision_after_extensions: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineIpTag(_Model):
    """Contains the IP tag associated with the public IP address.

    :ivar ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :vartype tag: str
    """

    ip_tag_type: Optional[str] = rest_field(
        name="ipTagType", visibility=["read", "create", "update", "delete", "query"]
    )
    """IP tag type. Example: FirstPartyUsage."""
    tag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """IP tag associated with the public IP. Example: SQL, Storage etc."""

    @overload
    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineNetworkInterfaceConfiguration(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machine network interface configurations.

    :ivar name: The network interface configuration name. Required.
    :vartype name: str
    :ivar properties: Describes a virtual machine network profile's IP configuration.
    :vartype properties:
     ~azure.mgmt.computebulkactions.models.VirtualMachineNetworkInterfaceConfigurationProperties
    :ivar tags: Resource tags applied to the networkInterface address created by this
     NetworkInterfaceConfiguration.
    :vartype tags: dict[str, str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The network interface configuration name. Required."""
    properties: Optional["_models.VirtualMachineNetworkInterfaceConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes a virtual machine network profile's IP configuration."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags applied to the networkInterface address created by this
     NetworkInterfaceConfiguration."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: Optional["_models.VirtualMachineNetworkInterfaceConfigurationProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineNetworkInterfaceConfigurationProperties(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machine network profile's IP configuration.

    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computebulkactions.models.DeleteOptions
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar disable_tcp_state_tracking: Specifies whether the network interface is disabled for tcp
     state tracking.
    :vartype disable_tcp_state_tracking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.computebulkactions.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.computebulkactions.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration
    :ivar ip_configurations: Specifies the IP configurations of the network interface. Required.
    :vartype ip_configurations:
     list[~azure.mgmt.computebulkactions.models.VirtualMachineNetworkInterfaceIPConfiguration]
    :ivar dscp_configuration: The DSCP configuration for the network interface.
    :vartype dscp_configuration: ~azure.mgmt.computebulkactions.models.SubResource
    :ivar auxiliary_mode: Specifies whether the Auxiliary mode is enabled for the Network Interface
     resource. Known values are: "None", "AcceleratedConnections", and "Floating".
    :vartype auxiliary_mode: str or
     ~azure.mgmt.computebulkactions.models.NetworkInterfaceAuxiliaryMode
    :ivar auxiliary_sku: Specifies whether the Auxiliary sku is enabled for the Network Interface
     resource. Known values are: "None", "A1", "A2", "A4", and "A8".
    :vartype auxiliary_sku: str or
     ~azure.mgmt.computebulkactions.models.NetworkInterfaceAuxiliarySku
    """

    primary: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the primary network interface in case the virtual machine has more than 1 network
     interface."""
    delete_option: Optional[Union[str, "_models.DeleteOptions"]] = rest_field(
        name="deleteOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify what happens to the network interface when the VM is deleted. Known values are:
     \"Delete\" and \"Detach\"."""
    enable_accelerated_networking: Optional[bool] = rest_field(
        name="enableAcceleratedNetworking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the network interface is accelerated networking-enabled."""
    disable_tcp_state_tracking: Optional[bool] = rest_field(
        name="disableTcpStateTracking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the network interface is disabled for tcp state tracking."""
    enable_fpga: Optional[bool] = rest_field(
        name="enableFpga", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the network interface is FPGA networking-enabled."""
    enable_ip_forwarding: Optional[bool] = rest_field(
        name="enableIPForwarding", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether IP forwarding enabled on this NIC."""
    network_security_group: Optional["_models.SubResource"] = rest_field(
        name="networkSecurityGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network security group."""
    dns_settings: Optional["_models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration"] = rest_field(
        name="dnsSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dns settings to be applied on the network interfaces."""
    ip_configurations: list["_models.VirtualMachineNetworkInterfaceIPConfiguration"] = rest_field(
        name="ipConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the IP configurations of the network interface. Required."""
    dscp_configuration: Optional["_models.SubResource"] = rest_field(
        name="dscpConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The DSCP configuration for the network interface."""
    auxiliary_mode: Optional[Union[str, "_models.NetworkInterfaceAuxiliaryMode"]] = rest_field(
        name="auxiliaryMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the Auxiliary mode is enabled for the Network Interface resource. Known
     values are: \"None\", \"AcceleratedConnections\", and \"Floating\"."""
    auxiliary_sku: Optional[Union[str, "_models.NetworkInterfaceAuxiliarySku"]] = rest_field(
        name="auxiliarySku", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the Auxiliary sku is enabled for the Network Interface resource. Known values
     are: \"None\", \"A1\", \"A2\", \"A4\", and \"A8\"."""

    @overload
    def __init__(
        self,
        *,
        ip_configurations: list["_models.VirtualMachineNetworkInterfaceIPConfiguration"],
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        enable_accelerated_networking: Optional[bool] = None,
        disable_tcp_state_tracking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration"] = None,
        dscp_configuration: Optional["_models.SubResource"] = None,
        auxiliary_mode: Optional[Union[str, "_models.NetworkInterfaceAuxiliaryMode"]] = None,
        auxiliary_sku: Optional[Union[str, "_models.NetworkInterfaceAuxiliarySku"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineNetworkInterfaceDnsSettingsConfiguration(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machines network configuration's DNS settings.

    :ivar dns_servers: List of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    dns_servers: Optional[list[str]] = rest_field(
        name="dnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of DNS servers IP addresses."""

    @overload
    def __init__(
        self,
        *,
        dns_servers: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineNetworkInterfaceIPConfiguration(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machine network profile's IP configuration.

    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar properties: Describes a virtual machine network interface IP configuration properties.
    :vartype properties:
     ~azure.mgmt.computebulkactions.models.VirtualMachineNetworkInterfaceIPConfigurationProperties
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The IP configuration name. Required."""
    properties: Optional["_models.VirtualMachineNetworkInterfaceIPConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes a virtual machine network interface IP configuration properties."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: Optional["_models.VirtualMachineNetworkInterfaceIPConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineNetworkInterfaceIPConfigurationProperties(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machine network interface IP configuration properties.

    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.computebulkactions.models.SubResource
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.computebulkactions.models.VirtualMachinePublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.computebulkactions.models.IPVersions
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.computebulkactions.models.SubResource]
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A virtual machine can reference backend address pools of
     multiple application gateways. Multiple virtual machines cannot use the same application
     gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.computebulkactions.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A virtual machine can reference backend address pools of one public
     and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load
     balancer].
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.computebulkactions.models.SubResource]
    """

    subnet: Optional["_models.SubResource"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the identifier of the subnet."""
    primary: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the primary network interface in case the virtual machine has more than 1 network
     interface."""
    public_ip_address_configuration: Optional["_models.VirtualMachinePublicIPAddressConfiguration"] = rest_field(
        name="publicIPAddressConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The publicIPAddressConfiguration."""
    private_ip_address_version: Optional[Union[str, "_models.IPVersions"]] = rest_field(
        name="privateIPAddressVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Available from Api-Version 2017-03-30 onwards, it represents whether the specific
     ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and
     'IPv6'. Known values are: \"IPv4\" and \"IPv6\"."""
    application_security_groups: Optional[list["_models.SubResource"]] = rest_field(
        name="applicationSecurityGroups", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies an array of references to application security group."""
    application_gateway_backend_address_pools: Optional[list["_models.SubResource"]] = rest_field(
        name="applicationGatewayBackendAddressPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies an array of references to backend address pools of application gateways. A virtual
     machine can reference backend address pools of multiple application gateways. Multiple virtual
     machines cannot use the same application gateway."""
    load_balancer_backend_address_pools: Optional[list["_models.SubResource"]] = rest_field(
        name="loadBalancerBackendAddressPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies an array of references to backend address pools of load balancers. A virtual machine
     can reference backend address pools of one public and one internal load balancer. [Multiple
     virtual machines cannot use the same basic sku load balancer]."""

    @overload
    def __init__(
        self,
        *,
        subnet: Optional["_models.SubResource"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["_models.VirtualMachinePublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersions"]] = None,
        application_security_groups: Optional[list["_models.SubResource"]] = None,
        application_gateway_backend_address_pools: Optional[list["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[list["_models.SubResource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineProfile(_Model):
    """Describes the properties of a Virtual Machine.

    :ivar scheduled_events_policy: Specifies Redeploy, Reboot and
     ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
     virtual machine.
    :vartype scheduled_events_policy: ~azure.mgmt.computebulkactions.models.ScheduledEventsPolicy
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.computebulkactions.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :vartype additional_capabilities: ~azure.mgmt.computebulkactions.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :vartype os_profile: ~azure.mgmt.computebulkactions.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.computebulkactions.models.NetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.computebulkactions.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state. Minimum compute
     api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.computebulkactions.models.DiagnosticsProfile
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. <br><br> Possible values for Windows Server operating system are: <br><br>
     Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating
     system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more
     information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     <br><br> `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_ <br><br>
     Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum compute api-version:
     2020-06-01.
    :vartype extensions_time_budget: str
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile: ~azure.mgmt.computebulkactions.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. Minimum compute api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. Minimum compute api-version: 2021-04-01.
    :vartype capacity_reservation: ~azure.mgmt.computebulkactions.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM.
    :vartype application_profile: ~azure.mgmt.computebulkactions.models.ApplicationProfile
    """

    scheduled_events_policy: Optional["_models.ScheduledEventsPolicy"] = rest_field(
        name="scheduledEventsPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets Scheduled Event
     related configurations for the virtual machine."""
    storage_profile: Optional["_models.StorageProfile"] = rest_field(
        name="storageProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the storage settings for the virtual machine disks."""
    additional_capabilities: Optional["_models.AdditionalCapabilities"] = rest_field(
        name="additionalCapabilities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies additional capabilities enabled or disabled on the virtual machine."""
    os_profile: Optional["_models.OSProfile"] = rest_field(
        name="osProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the operating system settings used while creating the virtual machine. Some of the
     settings cannot be changed once VM is provisioned."""
    network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the network interfaces of the virtual machine."""
    security_profile: Optional["_models.SecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the Security related profile settings for the virtual machine."""
    diagnostics_profile: Optional["_models.DiagnosticsProfile"] = rest_field(
        name="diagnosticsProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the boot diagnostic settings state. Minimum compute api-version: 2015-06-15."""
    license_type: Optional[str] = rest_field(
        name="licenseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible
     values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server
     <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL)
     <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see `Azure Hybrid Use Benefit for
     Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     <br><br> `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_ <br><br>
     Minimum api-version: 2015-06-15."""
    extensions_time_budget: Optional[str] = rest_field(
        name="extensionsTimeBudget", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the time alloted for all extensions to start. The time duration should be between 15
     minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default
     value is 90 minutes (PT1H30M). Minimum compute api-version: 2020-06-01."""
    scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = rest_field(
        name="scheduledEventsProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Scheduled Event related configurations."""
    user_data: Optional[str] = rest_field(name="userData", visibility=["read", "create", "update", "delete", "query"])
    """UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in
     here. Minimum compute api-version: 2021-03-01."""
    capacity_reservation: Optional["_models.CapacityReservationProfile"] = rest_field(
        name="capacityReservation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies information about the capacity reservation that is used to allocate virtual machine.
     Minimum compute api-version: 2021-04-01."""
    application_profile: Optional["_models.ApplicationProfile"] = rest_field(
        name="applicationProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the gallery applications that should be made available to the VM."""

    @overload
    def __init__(
        self,
        *,
        scheduled_events_policy: Optional["_models.ScheduledEventsPolicy"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachinePublicIPAddressConfiguration(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machines IP Configuration's PublicIPAddress configuration.

    :ivar name: The publicIP address configuration name. Required.
    :vartype name: str
    :ivar properties: Describes a virtual machines IP Configuration's PublicIPAddress
     configuration.
    :vartype properties:
     ~azure.mgmt.computebulkactions.models.VirtualMachinePublicIPAddressConfigurationProperties
    :ivar sku: Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
    :vartype sku: ~azure.mgmt.computebulkactions.models.PublicIPAddressSku
    :ivar tags: Resource tags applied to the publicIP address created by this
     PublicIPAddressConfiguration.
    :vartype tags: dict[str, str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publicIP address configuration name. Required."""
    properties: Optional["_models.VirtualMachinePublicIPAddressConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes a virtual machines IP Configuration's PublicIPAddress configuration."""
    sku: Optional["_models.PublicIPAddressSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags applied to the publicIP address created by this PublicIPAddressConfiguration."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: Optional["_models.VirtualMachinePublicIPAddressConfigurationProperties"] = None,
        sku: Optional["_models.PublicIPAddressSku"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachinePublicIPAddressConfigurationProperties(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machines IP Configuration's PublicIPAddress configuration.

    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar delete_option: Specify what happens to the public IP address when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computebulkactions.models.DeleteOptions
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.computebulkactions.models.VirtualMachinePublicIPAddressDnsSettingsConfiguration
    :ivar ip_tags: The list of IP tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.computebulkactions.models.VirtualMachineIpTag]
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.computebulkactions.models.SubResource
    :ivar public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.computebulkactions.models.IPVersions
    :ivar public_ip_allocation_method: Specify the public IP allocation type. Known values are:
     "Dynamic" and "Static".
    :vartype public_ip_allocation_method: str or
     ~azure.mgmt.computebulkactions.models.PublicIPAllocationMethod
    """

    idle_timeout_in_minutes: Optional[int] = rest_field(
        name="idleTimeoutInMinutes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The idle timeout of the public IP address."""
    delete_option: Optional[Union[str, "_models.DeleteOptions"]] = rest_field(
        name="deleteOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify what happens to the public IP address when the VM is deleted. Known values are:
     \"Delete\" and \"Detach\"."""
    dns_settings: Optional["_models.VirtualMachinePublicIPAddressDnsSettingsConfiguration"] = rest_field(
        name="dnsSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dns settings to be applied on the publicIP addresses ."""
    ip_tags: Optional[list["_models.VirtualMachineIpTag"]] = rest_field(
        name="ipTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of IP tags associated with the public IP address."""
    public_ip_prefix: Optional["_models.SubResource"] = rest_field(
        name="publicIPPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The PublicIPPrefix from which to allocate publicIP addresses."""
    public_ip_address_version: Optional[Union[str, "_models.IPVersions"]] = rest_field(
        name="publicIPAddressVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Available from Api-Version 2019-07-01 onwards, it represents whether the specific
     ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and
     'IPv6'. Known values are: \"IPv4\" and \"IPv6\"."""
    public_ip_allocation_method: Optional[Union[str, "_models.PublicIPAllocationMethod"]] = rest_field(
        name="publicIPAllocationMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify the public IP allocation type. Known values are: \"Dynamic\" and \"Static\"."""

    @overload
    def __init__(
        self,
        *,
        idle_timeout_in_minutes: Optional[int] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        dns_settings: Optional["_models.VirtualMachinePublicIPAddressDnsSettingsConfiguration"] = None,
        ip_tags: Optional[list["_models.VirtualMachineIpTag"]] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersions"]] = None,
        public_ip_allocation_method: Optional[Union[str, "_models.PublicIPAllocationMethod"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachinePublicIPAddressDnsSettingsConfiguration(_Model):  # pylint: disable=name-too-long
    """Describes a virtual machines network configuration's DNS settings.

    :ivar domain_name_label: The Domain name label prefix of the PublicIPAddress resources that
     will be created. The generated name label is the concatenation of the domain name label and vm
     network profile unique ID. Required.
    :vartype domain_name_label: str
    :ivar domain_name_label_scope: The Domain name label scope of the PublicIPAddress resources
     that will be created. The generated name label is the concatenation of the hashed domain name
     label with policy according to the domain name label scope and vm network profile unique ID.
     Known values are: "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
    :vartype domain_name_label_scope: str or
     ~azure.mgmt.computebulkactions.models.DomainNameLabelScopeTypes
    """

    domain_name_label: str = rest_field(
        name="domainNameLabel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Domain name label prefix of the PublicIPAddress resources that will be created. The
     generated name label is the concatenation of the domain name label and vm network profile
     unique ID. Required."""
    domain_name_label_scope: Optional[Union[str, "_models.DomainNameLabelScopeTypes"]] = rest_field(
        name="domainNameLabelScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Domain name label scope of the PublicIPAddress resources that will be created. The
     generated name label is the concatenation of the hashed domain name label with policy according
     to the domain name label scope and vm network profile unique ID. Known values are:
     \"TenantReuse\", \"SubscriptionReuse\", \"ResourceGroupReuse\", and \"NoReuse\"."""

    @overload
    def __init__(
        self,
        *,
        domain_name_label: str,
        domain_name_label_scope: Optional[Union[str, "_models.DomainNameLabelScopeTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMAttributeMinMaxDouble(_Model):
    """VMAttributes using double values.

    :ivar min: Minimum value. If not specified, no minimum filter is applied.
    :vartype min: float
    :ivar max: Maximum value. Must be greater than zero. Double.MaxValue(1.7976931348623157E+308).
    :vartype max: float
    """

    min: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Minimum value. If not specified, no minimum filter is applied."""
    max: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum value. Must be greater than zero. Double.MaxValue(1.7976931348623157E+308)."""

    @overload
    def __init__(
        self,
        *,
        min: Optional[float] = None,  # pylint: disable=redefined-builtin
        max: Optional[float] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMAttributeMinMaxInteger(_Model):
    """While retrieving VMSizes from CRS, Min = 0 (uint.MinValue) if not specified, Max = 4294967295
    (uint.MaxValue) if not specified. This allows to filter VMAttributes on all available VMSizes.

    :ivar min: Min VMSize from CRS, Min = 0 (uint.MinValue) if not specified.
    :vartype min: int
    :ivar max: Max VMSize from CRS, Max = 4294967295 (uint.MaxValue) if not specified.
    :vartype max: int
    """

    min: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Min VMSize from CRS, Min = 0 (uint.MinValue) if not specified."""
    max: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Max VMSize from CRS, Max = 4294967295 (uint.MaxValue) if not specified."""

    @overload
    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMAttributes(_Model):
    """VMAttributes that will be used to filter VMSizes which will be used to launch instances.

    :ivar v_cpu_count: The range of vCpuCount specified from Min to Max. Must be specified if
     VMAttributes are specified, either Min or Max is required if specified. Required.
    :vartype v_cpu_count: ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxInteger
    :ivar memory_in_gi_b: The range of memory specified from Min to Max. Must be specified if
     VMAttributes are specified, either Min or Max is required if specified. Required.
    :vartype memory_in_gi_b: ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxDouble
    :ivar architecture_types: The VM architecture types specified as a list. Must be specified if
     VMAttributes are specified. Must be compatible with image used. Required.
    :vartype architecture_types: list[str or
     ~azure.mgmt.computebulkactions.models.ArchitectureType]
    :ivar memory_in_gi_b_per_v_cpu: The range of memory in GiB per vCPU specified from min to max.
     Optional parameter. Either Min or Max is required if specified.
    :vartype memory_in_gi_b_per_v_cpu:
     ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxDouble
    :ivar local_storage_support: Specifies whether the VMSize supporting local storage should be
     used to launch instances or not. Included - Default if not specified as most Azure VMs support
     local storage. Known values are: "Excluded", "Included", and "Required".
    :vartype local_storage_support: str or ~azure.mgmt.computebulkactions.models.VMAttributeSupport
    :ivar local_storage_in_gi_b: LocalStorageSupport should be set to "Included" or "Required" to
     use this VMAttribute. If localStorageSupport is "Excluded", this VMAttribute can not be used.
    :vartype local_storage_in_gi_b: ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxDouble
    :ivar local_storage_disk_types: The local storage disk types specified as a list.
     LocalStorageSupport should be set to "Included" or "Required" to use this VMAttribute. If
     localStorageSupport is "Excluded", this VMAttribute can not be used.
    :vartype local_storage_disk_types: list[str or
     ~azure.mgmt.computebulkactions.models.LocalStorageDiskType]
    :ivar data_disk_count: The range of data disk count specified from Min to Max. Optional
     parameter. Either Min or Max is required if specified.
    :vartype data_disk_count: ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxInteger
    :ivar network_interface_count: The range of network interface count specified from Min to Max.
     Optional parameter. Either Min or Max is required if specified.
    :vartype network_interface_count:
     ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxInteger
    :ivar network_bandwidth_in_mbps: The range of network bandwidth in Mbps specified from Min to
     Max. Optional parameter. Either Min or Max is required if specified.
    :vartype network_bandwidth_in_mbps:
     ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxDouble
    :ivar rdma_support: Specifies whether the VMSize supporting RDMA (Remote Direct Memory Access)
     should be used to build launch instances or not. Known values are: "Excluded", "Included", and
     "Required".
    :vartype rdma_support: str or ~azure.mgmt.computebulkactions.models.VMAttributeSupport
    :ivar rdma_network_interface_count: The range of RDMA (Remote Direct Memory Access) network
     interface count specified from Min to Max. Optional parameter. Either Min or Max is required if
     specified. rdmaSupport should be set to "Included" or "Required" to use this VMAttribute. If
     rdmaSupport is "Excluded", this VMAttribute can not be used.
    :vartype rdma_network_interface_count:
     ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxInteger
    :ivar accelerator_support: Specifies whether the VMSize supporting accelerator should be used
     to launch instances or not. acceleratorSupport should be set to "Included" or "Required" to use
     this VMAttribute. If acceleratorSupport is "Excluded", this VMAttribute can not be used. Known
     values are: "Excluded", "Included", and "Required".
    :vartype accelerator_support: str or ~azure.mgmt.computebulkactions.models.VMAttributeSupport
    :ivar accelerator_manufacturers: The accelerator manufacturers specified as a list.
     acceleratorSupport should be set to "Included" or "Required" to use this VMAttribute. If
     acceleratorSupport is "Excluded", this VMAttribute can not be used.
    :vartype accelerator_manufacturers: list[str or
     ~azure.mgmt.computebulkactions.models.AcceleratorManufacturer]
    :ivar accelerator_types: The accelerator types specified as a list. acceleratorSupport should
     be set to "Included" or "Required" to use this VMAttribute. If acceleratorSupport is
     "Excluded", this VMAttribute can not be used.
    :vartype accelerator_types: list[str or ~azure.mgmt.computebulkactions.models.AcceleratorType]
    :ivar accelerator_count: The range of accelerator count specified from min to max. Optional
     parameter. Either Min or Max is required if specified. acceleratorSupport should be set to
     "Included" or "Required" to use this VMAttribute. If acceleratorSupport is "Excluded", this
     VMAttribute can not be used.
    :vartype accelerator_count: ~azure.mgmt.computebulkactions.models.VMAttributeMinMaxInteger
    :ivar vm_categories: The VM category specified as a list. Optional parameter.
    :vartype vm_categories: list[str or ~azure.mgmt.computebulkactions.models.VMCategory]
    :ivar cpu_manufacturers: The VM CPU manufacturers specified as a list. Optional parameter.
    :vartype cpu_manufacturers: list[str or ~azure.mgmt.computebulkactions.models.CpuManufacturer]
    :ivar hyper_v_generations: The hyperV generations specified as a list. Optional parameter.
    :vartype hyper_v_generations: list[str or
     ~azure.mgmt.computebulkactions.models.HyperVGeneration]
    :ivar burstable_support: Specifies whether the VMSize supporting burstable capability should be
     used to launch instances or not. Known values are: "Excluded", "Included", and "Required".
    :vartype burstable_support: str or ~azure.mgmt.computebulkactions.models.VMAttributeSupport
    :ivar allowed_vm_sizes: Specifies which VMSizes should be allowed while filtering on
     VMAttributes. Cannot be specified together with excludedVMSizes. Maximum of 10 VM sizes
     allowed. Optional parameter.
    :vartype allowed_vm_sizes: list[str]
    :ivar excluded_vm_sizes: Specifies which VMSizes should be excluded while filtering on
     VMAttributes. Cannot be specified together with allowedVMSizes. Maximum of 10 VM sizes allowed.
     Optional parameter.
    :vartype excluded_vm_sizes: list[str]
    """

    v_cpu_count: "_models.VMAttributeMinMaxInteger" = rest_field(
        name="vCpuCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of vCpuCount specified from Min to Max. Must be specified if VMAttributes are
     specified, either Min or Max is required if specified. Required."""
    memory_in_gi_b: "_models.VMAttributeMinMaxDouble" = rest_field(
        name="memoryInGiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of memory specified from Min to Max. Must be specified if VMAttributes are specified,
     either Min or Max is required if specified. Required."""
    architecture_types: list[Union[str, "_models.ArchitectureType"]] = rest_field(
        name="architectureTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The VM architecture types specified as a list. Must be specified if VMAttributes are specified.
     Must be compatible with image used. Required."""
    memory_in_gi_b_per_v_cpu: Optional["_models.VMAttributeMinMaxDouble"] = rest_field(
        name="memoryInGiBPerVCpu", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of memory in GiB per vCPU specified from min to max. Optional parameter. Either Min
     or Max is required if specified."""
    local_storage_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(
        name="localStorageSupport", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the VMSize supporting local storage should be used to launch instances or
     not. Included - Default if not specified as most Azure VMs support local storage. Known values
     are: \"Excluded\", \"Included\", and \"Required\"."""
    local_storage_in_gi_b: Optional["_models.VMAttributeMinMaxDouble"] = rest_field(
        name="localStorageInGiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """LocalStorageSupport should be set to \"Included\" or \"Required\" to use this VMAttribute. If
     localStorageSupport is \"Excluded\", this VMAttribute can not be used."""
    local_storage_disk_types: Optional[list[Union[str, "_models.LocalStorageDiskType"]]] = rest_field(
        name="localStorageDiskTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The local storage disk types specified as a list. LocalStorageSupport should be set to
     \"Included\" or \"Required\" to use this VMAttribute. If localStorageSupport is \"Excluded\",
     this VMAttribute can not be used."""
    data_disk_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(
        name="dataDiskCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of data disk count specified from Min to Max. Optional parameter. Either Min or Max
     is required if specified."""
    network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(
        name="networkInterfaceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of network interface count specified from Min to Max. Optional parameter. Either Min
     or Max is required if specified."""
    network_bandwidth_in_mbps: Optional["_models.VMAttributeMinMaxDouble"] = rest_field(
        name="networkBandwidthInMbps", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of network bandwidth in Mbps specified from Min to Max. Optional parameter. Either
     Min or Max is required if specified."""
    rdma_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(
        name="rdmaSupport", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the VMSize supporting RDMA (Remote Direct Memory Access) should be used to
     build launch instances or not. Known values are: \"Excluded\", \"Included\", and \"Required\"."""
    rdma_network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(
        name="rdmaNetworkInterfaceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of RDMA (Remote Direct Memory Access) network interface count specified from Min to
     Max. Optional parameter. Either Min or Max is required if specified. rdmaSupport should be set
     to \"Included\" or \"Required\" to use this VMAttribute. If rdmaSupport is \"Excluded\", this
     VMAttribute can not be used."""
    accelerator_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(
        name="acceleratorSupport", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the VMSize supporting accelerator should be used to launch instances or not.
     acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute. If
     acceleratorSupport is \"Excluded\", this VMAttribute can not be used. Known values are:
     \"Excluded\", \"Included\", and \"Required\"."""
    accelerator_manufacturers: Optional[list[Union[str, "_models.AcceleratorManufacturer"]]] = rest_field(
        name="acceleratorManufacturers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The accelerator manufacturers specified as a list. acceleratorSupport should be set to
     \"Included\" or \"Required\" to use this VMAttribute. If acceleratorSupport is \"Excluded\",
     this VMAttribute can not be used."""
    accelerator_types: Optional[list[Union[str, "_models.AcceleratorType"]]] = rest_field(
        name="acceleratorTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The accelerator types specified as a list. acceleratorSupport should be set to \"Included\" or
     \"Required\" to use this VMAttribute. If acceleratorSupport is \"Excluded\", this VMAttribute
     can not be used."""
    accelerator_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(
        name="acceleratorCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of accelerator count specified from min to max. Optional parameter. Either Min or Max
     is required if specified. acceleratorSupport should be set to \"Included\" or \"Required\" to
     use this VMAttribute. If acceleratorSupport is \"Excluded\", this VMAttribute can not be used."""
    vm_categories: Optional[list[Union[str, "_models.VMCategory"]]] = rest_field(
        name="vmCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """The VM category specified as a list. Optional parameter."""
    cpu_manufacturers: Optional[list[Union[str, "_models.CpuManufacturer"]]] = rest_field(
        name="cpuManufacturers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The VM CPU manufacturers specified as a list. Optional parameter."""
    hyper_v_generations: Optional[list[Union[str, "_models.HyperVGeneration"]]] = rest_field(
        name="hyperVGenerations", visibility=["read", "create", "update", "delete", "query"]
    )
    """The hyperV generations specified as a list. Optional parameter."""
    burstable_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(
        name="burstableSupport", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the VMSize supporting burstable capability should be used to launch instances
     or not. Known values are: \"Excluded\", \"Included\", and \"Required\"."""
    allowed_vm_sizes: Optional[list[str]] = rest_field(
        name="allowedVMSizes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies which VMSizes should be allowed while filtering on VMAttributes. Cannot be specified
     together with excludedVMSizes. Maximum of 10 VM sizes allowed. Optional parameter."""
    excluded_vm_sizes: Optional[list[str]] = rest_field(
        name="excludedVMSizes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies which VMSizes should be excluded while filtering on VMAttributes. Cannot be specified
     together with allowedVMSizes. Maximum of 10 VM sizes allowed. Optional parameter."""

    @overload
    def __init__(
        self,
        *,
        v_cpu_count: "_models.VMAttributeMinMaxInteger",
        memory_in_gi_b: "_models.VMAttributeMinMaxDouble",
        architecture_types: list[Union[str, "_models.ArchitectureType"]],
        memory_in_gi_b_per_v_cpu: Optional["_models.VMAttributeMinMaxDouble"] = None,
        local_storage_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        local_storage_in_gi_b: Optional["_models.VMAttributeMinMaxDouble"] = None,
        local_storage_disk_types: Optional[list[Union[str, "_models.LocalStorageDiskType"]]] = None,
        data_disk_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        network_bandwidth_in_mbps: Optional["_models.VMAttributeMinMaxDouble"] = None,
        rdma_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        rdma_network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        accelerator_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        accelerator_manufacturers: Optional[list[Union[str, "_models.AcceleratorManufacturer"]]] = None,
        accelerator_types: Optional[list[Union[str, "_models.AcceleratorType"]]] = None,
        accelerator_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        vm_categories: Optional[list[Union[str, "_models.VMCategory"]]] = None,
        cpu_manufacturers: Optional[list[Union[str, "_models.CpuManufacturer"]]] = None,
        hyper_v_generations: Optional[list[Union[str, "_models.HyperVGeneration"]]] = None,
        burstable_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        allowed_vm_sizes: Optional[list[str]] = None,
        excluded_vm_sizes: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMDiskSecurityProfile(_Model):
    """Specifies the security profile settings for the managed disk. **Note:** It can only be set for
    Confidential VMs.

    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. It is set to
     DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob,
     VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not
     persisting firmware state in the VMGuestState blob.. **Note:** It can be set for only
     Confidential VMs. Known values are: "VMGuestStateOnly", "DiskWithVMGuestState", and
     "NonPersistedTPM".
    :vartype security_encryption_type: str or
     ~azure.mgmt.computebulkactions.models.SecurityEncryptionTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and
     VMGuest blob.
    :vartype disk_encryption_set: ~azure.mgmt.computebulkactions.models.DiskEncryptionSetParameters
    """

    security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = rest_field(
        name="securityEncryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for
     encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of
     just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the
     VMGuestState blob.. **Note:** It can be set for only Confidential VMs. Known values are:
     \"VMGuestStateOnly\", \"DiskWithVMGuestState\", and \"NonPersistedTPM\"."""
    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(
        name="diskEncryptionSet", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the customer managed disk encryption set resource id for the managed disk that is
     used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob."""

    @overload
    def __init__(
        self,
        *,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMGalleryApplication(_Model):
    """Specifies the required information to reference a compute gallery application version.

    :ivar tags: Optional, Specifies a passthrough value for more generic context.
    :vartype tags: str
    :ivar order: Optional, Specifies the order in which the packages have to be installed.
    :vartype order: int
    :ivar package_reference_id: Specifies the GalleryApplicationVersion resource id on the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     Required.
    :vartype package_reference_id: str
    :ivar configuration_reference: Optional, Specifies the uri to an azure blob that will replace
     the default configuration for the package if provided.
    :vartype configuration_reference: str
    :ivar treat_failure_as_deployment_failure: Optional, If true, any failure for any operation in
     the VmApplication will fail the deployment.
    :vartype treat_failure_as_deployment_failure: bool
    :ivar enable_automatic_upgrade: If set to true, when a new Gallery Application version is
     available in PIR/SIG, it will be automatically updated for the VM/VMSS.
    :vartype enable_automatic_upgrade: bool
    """

    tags: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional, Specifies a passthrough value for more generic context."""
    order: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional, Specifies the order in which the packages have to be installed."""
    package_reference_id: str = rest_field(
        name="packageReferenceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the GalleryApplicationVersion resource id on the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     Required."""
    configuration_reference: Optional[str] = rest_field(
        name="configurationReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional, Specifies the uri to an azure blob that will replace the default configuration for
     the package if provided."""
    treat_failure_as_deployment_failure: Optional[bool] = rest_field(
        name="treatFailureAsDeploymentFailure", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional, If true, any failure for any operation in the VmApplication will fail the deployment."""
    enable_automatic_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set to true, when a new Gallery Application version is available in PIR/SIG, it will be
     automatically updated for the VM/VMSS."""

    @overload
    def __init__(
        self,
        *,
        package_reference_id: str,
        tags: Optional[str] = None,
        order: Optional[int] = None,
        configuration_reference: Optional[str] = None,
        treat_failure_as_deployment_failure: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VmSizeProfile(_Model):
    """Specifications about a VM Size. This will also contain the corresponding rank and weight in
    future.

    :ivar name: The Sku name (e.g. 'Standard_DS1_v2'). Required.
    :vartype name: str
    :ivar rank: The rank of the VM size. This is used with 'AllocationStrategy.Prioritized' The
     lower the number, the higher the priority. Starting with 0.
    :vartype rank: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Sku name (e.g. 'Standard_DS1_v2'). Required."""
    rank: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The rank of the VM size. This is used with 'AllocationStrategy.Prioritized' The lower the
     number, the higher the priority. Starting with 0."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        rank: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsConfiguration(_Model):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. When this property is not specified in the request body, it is set to true by
     default. This will ensure that VM Agent is installed on the VM so that extensions can be added
     to the VM later.
    :vartype provision_vm_agent: bool
    :ivar enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows
     virtual machine. Default value is true. For virtual machine scale sets, this property can be
     updated and updates will take effect on OS reprovisioning.
    :vartype enable_automatic_updates: bool
    :ivar time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
     Possible values can be `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
     from time zones returned by `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
    :vartype time_zone: str
    :ivar additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :vartype additional_unattend_content:
     list[~azure.mgmt.computebulkactions.models.AdditionalUnattendContent]
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Windows.
    :vartype patch_settings: ~azure.mgmt.computebulkactions.models.PatchSettings
    :ivar win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :vartype win_rm: ~azure.mgmt.computebulkactions.models.WinRMConfiguration
    """

    provision_vm_agent: Optional[bool] = rest_field(
        name="provisionVMAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether virtual machine agent should be provisioned on the virtual machine. When this
     property is not specified in the request body, it is set to true by default. This will ensure
     that VM Agent is installed on the VM so that extensions can be added to the VM later."""
    enable_automatic_updates: Optional[bool] = rest_field(
        name="enableAutomaticUpdates", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value
     is true. For virtual machine scale sets, this property can be updated and updates will take
     effect on OS reprovisioning."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create", "update", "delete", "query"])
    """Specifies the time zone of the virtual machine. e.g. \"Pacific Standard Time\". Possible values
     can be `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
     from time zones returned by `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_."""
    additional_unattend_content: Optional[list["_models.AdditionalUnattendContent"]] = rest_field(
        name="additionalUnattendContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies additional base-64 encoded XML formatted information that can be included in the
     Unattend.xml file, which is used by Windows Setup."""
    patch_settings: Optional["_models.PatchSettings"] = rest_field(
        name="patchSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """[Preview Feature] Specifies settings related to VM Guest Patching on Windows."""
    win_rm: Optional["_models.WinRMConfiguration"] = rest_field(
        name="winRM", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell."""

    @overload
    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[list["_models.AdditionalUnattendContent"]] = None,
        patch_settings: Optional["_models.PatchSettings"] = None,
        win_rm: Optional["_models.WinRMConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsVMGuestPatchAutomaticByPlatformSettings(_Model):  # pylint: disable=name-too-long
    """Specifies additional settings to be applied when patch mode AutomaticByPlatform is selected in
    Windows patch settings.

    :ivar reboot_setting: Specifies the reboot setting for all AutomaticByPlatform patch
     installation operations. Known values are: "Unknown", "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or
     ~azure.mgmt.computebulkactions.models.WindowsVMGuestPatchAutomaticByPlatformRebootSetting
    :ivar bypass_platform_safety_checks_on_user_schedule: Enables customer to schedule patching
     without accidental upgrades.
    :vartype bypass_platform_safety_checks_on_user_schedule: bool
    """

    reboot_setting: Optional[Union[str, "_models.WindowsVMGuestPatchAutomaticByPlatformRebootSetting"]] = rest_field(
        name="rebootSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations. Known
     values are: \"Unknown\", \"IfRequired\", \"Never\", and \"Always\"."""
    bypass_platform_safety_checks_on_user_schedule: Optional[bool] = rest_field(
        name="bypassPlatformSafetyChecksOnUserSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables customer to schedule patching without accidental upgrades."""

    @overload
    def __init__(
        self,
        *,
        reboot_setting: Optional[Union[str, "_models.WindowsVMGuestPatchAutomaticByPlatformRebootSetting"]] = None,
        bypass_platform_safety_checks_on_user_schedule: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WinRMConfiguration(_Model):
    """Describes Windows Remote Management configuration of the VM.

    :ivar listeners: The list of Windows Remote Management listeners.
    :vartype listeners: list[~azure.mgmt.computebulkactions.models.WinRMListener]
    """

    listeners: Optional[list["_models.WinRMListener"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of Windows Remote Management listeners."""

    @overload
    def __init__(
        self,
        *,
        listeners: Optional[list["_models.WinRMListener"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WinRMListener(_Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :ivar protocol: Specifies the protocol of WinRM listener. Possible values are: **http,**
     **https.**. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.computebulkactions.models.ProtocolTypes
    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be the Base64 encoding of the following JSON Object which is encoded in
     UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>
     "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is
     recommended to use the `Azure Key Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    """

    protocol: Optional[Union[str, "_models.ProtocolTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**. Known
     values are: \"Http\" and \"Https\"."""
    certificate_url: Optional[str] = rest_field(
        name="certificateUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a
     secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be the Base64 encoding of the following JSON Object which is encoded in
     UTF-8: <br><br> {<br>  \"data\":\"<Base64-encoded-certificate>\",<br>
     \"dataType\":\"pfx\",<br>  \"password\":\"<pfx-file-password>\"<br>} <br> To install
     certificates on a virtual machine it is recommended to use the `Azure Key Vault virtual machine
     extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_."""

    @overload
    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ZoneAllocationPolicy(_Model):
    """ZoneAllocationPolicy for LaunchBulkInstancesOperation.

    :ivar distribution_strategy: Distribution strategy used for zone allocation policy. Required.
     Known values are: "BestEffortSingleZone", "Prioritized", "BestEffortBalanced", and
     "StrictBalanced".
    :vartype distribution_strategy: str or
     ~azure.mgmt.computebulkactions.models.ZoneDistributionStrategy
    :ivar zone_preferences: Zone preferences, required when zone distribution strategy is
     Prioritized.
    :vartype zone_preferences: list[~azure.mgmt.computebulkactions.models.ZonePreference]
    """

    distribution_strategy: Union[str, "_models.ZoneDistributionStrategy"] = rest_field(
        name="distributionStrategy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Distribution strategy used for zone allocation policy. Required. Known values are:
     \"BestEffortSingleZone\", \"Prioritized\", \"BestEffortBalanced\", and \"StrictBalanced\"."""
    zone_preferences: Optional[list["_models.ZonePreference"]] = rest_field(
        name="zonePreferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """Zone preferences, required when zone distribution strategy is Prioritized."""

    @overload
    def __init__(
        self,
        *,
        distribution_strategy: Union[str, "_models.ZoneDistributionStrategy"],
        zone_preferences: Optional[list["_models.ZonePreference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ZonePreference(_Model):
    """Zone preferences for LaunchBulkInstancesOperation zone allocation policy.

    :ivar zone: Name of the zone. Required.
    :vartype zone: str
    :ivar rank:

     .. code-block:: indented

        The rank of the zone. This is used with 'Prioritized' ZoneDistributionStrategy.
        The lower the number, the higher the priority, starting with 0.
        0 is the highest rank. If not specified, defaults to lowest rank.
    :vartype rank: int
    """

    zone: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the zone. Required."""
    rank: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """
     
     .. code-block:: indented
     
        The rank of the zone. This is used with 'Prioritized' ZoneDistributionStrategy.
        The lower the number, the higher the priority, starting with 0.
        0 is the highest rank. If not specified, defaults to lowest rank."""

    @overload
    def __init__(
        self,
        *,
        zone: str,
        rank: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
