# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from typing import Any, Callable, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ... import models as _models
from ..._operations._operations import build_transcription_transcribe_request
from ..._utils.model_base import Model as _Model, _deserialize
from ..._utils.utils import ClientMixinABC, prepare_multipart_form_data
from .._configuration import TranscriptionClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _TranscriptionClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], TranscriptionClientConfiguration]
):

    @overload
    async def transcribe(self, body: _models.TranscriptionContent, **kwargs: Any) -> _models.TranscriptionResult:
        """Transcribes the provided audio stream.

        :param body: The body of the multipart request. Required.
        :type body: ~azure.ai.transcription.models.TranscriptionContent
        :return: TranscriptionResult. The TranscriptionResult is compatible with MutableMapping
        :rtype: ~azure.ai.transcription.models.TranscriptionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def transcribe(self, body: JSON, **kwargs: Any) -> _models.TranscriptionResult:
        """Transcribes the provided audio stream.

        :param body: The body of the multipart request. Required.
        :type body: JSON
        :return: TranscriptionResult. The TranscriptionResult is compatible with MutableMapping
        :rtype: ~azure.ai.transcription.models.TranscriptionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def transcribe(
        self, body: Union[_models.TranscriptionContent, JSON], **kwargs: Any
    ) -> _models.TranscriptionResult:
        """Transcribes the provided audio stream.

        :param body: The body of the multipart request. Is either a TranscriptionContent type or a JSON
         type. Required.
        :type body: ~azure.ai.transcription.models.TranscriptionContent or JSON
        :return: TranscriptionResult. The TranscriptionResult is compatible with MutableMapping
        :rtype: ~azure.ai.transcription.models.TranscriptionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranscriptionResult] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = ["audio"]
        _data_fields: list[str] = ["definition"]
        _files = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_transcription_transcribe_request(
            api_version=self._config.api_version,
            files=_files,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TranscriptionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
