# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AgriServiceConfig(_Model):
    """Config of the AgriService resource instance.

    :ivar instance_uri: Instance URI of the AgriService instance.
    :vartype instance_uri: str
    :ivar version: Version of AgriService instance.
    :vartype version: str
    :ivar app_service_resource_id: App service resource Id.
    :vartype app_service_resource_id: str
    :ivar cosmos_db_resource_id: Cosmos Db resource Id.
    :vartype cosmos_db_resource_id: str
    :ivar storage_account_resource_id: Storage account resource Id.
    :vartype storage_account_resource_id: str
    :ivar key_vault_resource_id: Key vault resource Id.
    :vartype key_vault_resource_id: str
    :ivar redis_cache_resource_id: Redis cache resource Id.
    :vartype redis_cache_resource_id: str
    """

    instance_uri: Optional[str] = rest_field(name="instanceUri", visibility=["read"])
    """Instance URI of the AgriService instance."""
    version: Optional[str] = rest_field(visibility=["read"])
    """Version of AgriService instance."""
    app_service_resource_id: Optional[str] = rest_field(name="appServiceResourceId", visibility=["read"])
    """App service resource Id."""
    cosmos_db_resource_id: Optional[str] = rest_field(name="cosmosDbResourceId", visibility=["read"])
    """Cosmos Db resource Id."""
    storage_account_resource_id: Optional[str] = rest_field(name="storageAccountResourceId", visibility=["read"])
    """Storage account resource Id."""
    key_vault_resource_id: Optional[str] = rest_field(name="keyVaultResourceId", visibility=["read"])
    """Key vault resource Id."""
    redis_cache_resource_id: Optional[str] = rest_field(name="redisCacheResourceId", visibility=["read"])
    """Redis cache resource Id."""


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agricultureplatform.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agricultureplatform.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgriServiceResource(TrackedResource):
    """Schema of the AgriService resource from Microsoft.AgriculturePlatform resource provider.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agricultureplatform.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.agricultureplatform.models.AgriServiceResourceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.agricultureplatform.models.ManagedServiceIdentity
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.agricultureplatform.models.Sku
    """

    properties: Optional["_models.AgriServiceResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.AgriServiceResourceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgriServiceResourceProperties(_Model):
    """Details of the Agriculture AgriDataManager.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.agricultureplatform.models.ProvisioningState
    :ivar config: Config of the AgriService instance.
    :vartype config: ~azure.mgmt.agricultureplatform.models.AgriServiceConfig
    :ivar managed_on_behalf_of_configuration: Managed On Behalf Of Configuration.
    :vartype managed_on_behalf_of_configuration:
     ~azure.mgmt.agricultureplatform.models.ManagedOnBehalfOfConfiguration
    :ivar data_connector_credentials: Data connector credentials of AgriService instance.
    :vartype data_connector_credentials:
     list[~azure.mgmt.agricultureplatform.models.DataConnectorCredentialMap]
    :ivar installed_solutions: AgriService installed solutions.
    :vartype installed_solutions: list[~azure.mgmt.agricultureplatform.models.InstalledSolutionMap]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    config: Optional["_models.AgriServiceConfig"] = rest_field(visibility=["read", "create", "update"])
    """Config of the AgriService instance."""
    managed_on_behalf_of_configuration: Optional["_models.ManagedOnBehalfOfConfiguration"] = rest_field(
        name="managedOnBehalfOfConfiguration", visibility=["read"]
    )
    """Managed On Behalf Of Configuration."""
    data_connector_credentials: Optional[list["_models.DataConnectorCredentialMap"]] = rest_field(
        name="dataConnectorCredentials", visibility=["read", "create", "update"]
    )
    """Data connector credentials of AgriService instance."""
    installed_solutions: Optional[list["_models.InstalledSolutionMap"]] = rest_field(
        name="installedSolutions", visibility=["read", "create", "update"]
    )
    """AgriService installed solutions."""

    @overload
    def __init__(
        self,
        *,
        config: Optional["_models.AgriServiceConfig"] = None,
        data_connector_credentials: Optional[list["_models.DataConnectorCredentialMap"]] = None,
        installed_solutions: Optional[list["_models.InstalledSolutionMap"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgriServiceResourceUpdate(_Model):
    """The type used for update operations of the AgriServiceResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.agricultureplatform.models.ManagedServiceIdentity
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.agricultureplatform.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.agricultureplatform.models.AgriServiceResourceUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.AgriServiceResourceUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.AgriServiceResourceUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgriServiceResourceUpdateProperties(_Model):
    """The updatable properties of the AgriServiceResource.

    :ivar config: Config of the AgriService instance.
    :vartype config: ~azure.mgmt.agricultureplatform.models.AgriServiceConfig
    :ivar data_connector_credentials: Data connector credentials of AgriService instance.
    :vartype data_connector_credentials:
     list[~azure.mgmt.agricultureplatform.models.DataConnectorCredentialMap]
    :ivar installed_solutions: AgriService installed solutions.
    :vartype installed_solutions: list[~azure.mgmt.agricultureplatform.models.InstalledSolutionMap]
    """

    config: Optional["_models.AgriServiceConfig"] = rest_field(visibility=["read", "create", "update"])
    """Config of the AgriService instance."""
    data_connector_credentials: Optional[list["_models.DataConnectorCredentialMap"]] = rest_field(
        name="dataConnectorCredentials", visibility=["read", "create", "update"]
    )
    """Data connector credentials of AgriService instance."""
    installed_solutions: Optional[list["_models.InstalledSolutionMap"]] = rest_field(
        name="installedSolutions", visibility=["read", "create", "update"]
    )
    """AgriService installed solutions."""

    @overload
    def __init__(
        self,
        *,
        config: Optional["_models.AgriServiceConfig"] = None,
        data_connector_credentials: Optional[list["_models.DataConnectorCredentialMap"]] = None,
        installed_solutions: Optional[list["_models.InstalledSolutionMap"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvailableAgriSolutionListResult(_Model):
    """The list of available agri solutions.

    :ivar solutions: Agri solutions list. Required.
    :vartype solutions:
     list[~azure.mgmt.agricultureplatform.models.DataManagerForAgricultureSolution]
    """

    solutions: list["_models.DataManagerForAgricultureSolution"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Agri solutions list. Required."""

    @overload
    def __init__(
        self,
        *,
        solutions: list["_models.DataManagerForAgricultureSolution"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataConnectorCredentialMap(_Model):
    """Mapping of data connector credentials.

    :ivar key: The key representing the credential. Required.
    :vartype key: str
    :ivar value: The data connector credential value. Required.
    :vartype value: ~azure.mgmt.agricultureplatform.models.DataConnectorCredentials
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key representing the credential. Required."""
    value: "_models.DataConnectorCredentials" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The data connector credential value. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        value: "_models.DataConnectorCredentials",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataConnectorCredentials(_Model):
    """The properties related to an AgriService data connector.

    :ivar kind: Type of credential. Known values are: "OAuthClientCredentials" and
     "ApiKeyAuthCredentials".
    :vartype kind: str or ~azure.mgmt.agricultureplatform.models.AuthCredentialsKind
    :ivar client_id: Client Id associated with the provider, if type of credentials is
     OAuthClientCredentials.
    :vartype client_id: str
    :ivar key_vault_uri: Uri of the key vault.
    :vartype key_vault_uri: str
    :ivar key_name: Name of the key vault key.
    :vartype key_name: str
    :ivar key_version: Version of the key vault key.
    :vartype key_version: str
    """

    kind: Optional[Union[str, "_models.AuthCredentialsKind"]] = rest_field(visibility=["read", "create", "update"])
    """Type of credential. Known values are: \"OAuthClientCredentials\" and \"ApiKeyAuthCredentials\"."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read", "create", "update"])
    """Client Id associated with the provider, if type of credentials is OAuthClientCredentials."""
    key_vault_uri: Optional[str] = rest_field(name="keyVaultUri", visibility=["read", "create", "update"])
    """Uri of the key vault."""
    key_name: Optional[str] = rest_field(name="keyName", visibility=["read", "create", "update"])
    """Name of the key vault key."""
    key_version: Optional[str] = rest_field(name="keyVersion", visibility=["read", "create", "update"])
    """Version of the key vault key."""

    @overload
    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.AuthCredentialsKind"]] = None,
        client_id: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataManagerForAgricultureSolution(_Model):
    """Data Manager for Agriculture solution.

    :ivar partner_id: Partner Id. Required.
    :vartype partner_id: str
    :ivar solution_id: Solution Id. Required.
    :vartype solution_id: str
    :ivar partner_tenant_id: Partner tenant Id. Required.
    :vartype partner_tenant_id: str
    :ivar data_access_scopes: Data access scopes. Required.
    :vartype data_access_scopes: list[str]
    :ivar market_place_offer_details: Marketplace offer details. Required.
    :vartype market_place_offer_details:
     ~azure.mgmt.agricultureplatform.models.MarketPlaceOfferDetails
    :ivar saas_application_id: Saas application Id. Required.
    :vartype saas_application_id: str
    :ivar access_azure_data_manager_for_agriculture_application_id: Entra application Id used to
     access azure data manager for agriculture instance. Required.
    :vartype access_azure_data_manager_for_agriculture_application_id: str
    :ivar access_azure_data_manager_for_agriculture_application_name: Entra application name used
     to access azure data manager for agriculture instance. Required.
    :vartype access_azure_data_manager_for_agriculture_application_name: str
    :ivar is_validate_input: Whether solution inference will validate input. Required.
    :vartype is_validate_input: bool
    """

    partner_id: str = rest_field(name="partnerId", visibility=["read", "create", "update", "delete", "query"])
    """Partner Id. Required."""
    solution_id: str = rest_field(name="solutionId", visibility=["read", "create", "update", "delete", "query"])
    """Solution Id. Required."""
    partner_tenant_id: str = rest_field(
        name="partnerTenantId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Partner tenant Id. Required."""
    data_access_scopes: list[str] = rest_field(
        name="dataAccessScopes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data access scopes. Required."""
    market_place_offer_details: "_models.MarketPlaceOfferDetails" = rest_field(
        name="marketPlaceOfferDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Marketplace offer details. Required."""
    saas_application_id: str = rest_field(
        name="saasApplicationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Saas application Id. Required."""
    access_azure_data_manager_for_agriculture_application_id: str = rest_field(
        name="accessAzureDataManagerForAgricultureApplicationId",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Entra application Id used to access azure data manager for agriculture instance. Required."""
    access_azure_data_manager_for_agriculture_application_name: str = rest_field(
        name="accessAzureDataManagerForAgricultureApplicationName",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Entra application name used to access azure data manager for agriculture instance. Required."""
    is_validate_input: bool = rest_field(
        name="isValidateInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether solution inference will validate input. Required."""

    @overload
    def __init__(
        self,
        *,
        partner_id: str,
        solution_id: str,
        partner_tenant_id: str,
        data_access_scopes: list[str],
        market_place_offer_details: "_models.MarketPlaceOfferDetails",
        saas_application_id: str,
        access_azure_data_manager_for_agriculture_application_id: str,
        access_azure_data_manager_for_agriculture_application_name: str,
        is_validate_input: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.agricultureplatform.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.agricultureplatform.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.agricultureplatform.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstalledSolutionMap(_Model):
    """Mapping of installed solutions.

    :ivar key: The key representing the installed solution. Required.
    :vartype key: str
    :ivar value: The installed solution value. Required.
    :vartype value: ~azure.mgmt.agricultureplatform.models.Solution
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key representing the installed solution. Required."""
    value: "_models.Solution" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The installed solution value. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        value: "_models.Solution",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedOnBehalfOfConfiguration(_Model):
    """Configuration of the managed on behalf of resource.

    :ivar mobo_broker_resources: Associated MoboBrokerResources. Required.
    :vartype mobo_broker_resources: list[~azure.mgmt.agricultureplatform.models.MoboBrokerResource]
    """

    mobo_broker_resources: list["_models.MoboBrokerResource"] = rest_field(
        name="moboBrokerResources", visibility=["read"]
    )
    """Associated MoboBrokerResources. Required."""


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.agricultureplatform.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.agricultureplatform.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketPlaceOfferDetails(_Model):
    """Marketplace offer details of Agri solution.

    :ivar saas_offer_id: Saas offer Id. Required.
    :vartype saas_offer_id: str
    :ivar publisher_id: Publisher Id. Required.
    :vartype publisher_id: str
    """

    saas_offer_id: str = rest_field(name="saasOfferId", visibility=["read", "create", "update", "delete", "query"])
    """Saas offer Id. Required."""
    publisher_id: str = rest_field(name="publisherId", visibility=["read", "create", "update", "delete", "query"])
    """Publisher Id. Required."""

    @overload
    def __init__(
        self,
        *,
        saas_offer_id: str,
        publisher_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MoboBrokerResource(_Model):
    """MoboBroker resource.

    :ivar id: The fully qualified resource ID of the MoboBroker resource. Example:
     ``/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}``.
     Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read"])
    """The fully qualified resource ID of the MoboBroker resource. Example:
     ``/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}``.
     Required."""


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.agricultureplatform.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.agricultureplatform.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.agricultureplatform.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for an operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Sku(_Model):
    """The resource model definition representing SKU.

    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.agricultureplatform.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU. Ex - P3. It is typically a letter+number code. Required."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """This field is required to be implemented by the Resource Provider if the service has more than
     one tier, but is not required on a PUT. Known values are: \"Free\", \"Basic\", \"Standard\",
     and \"Premium\"."""
    size: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU size. When the name field is the combination of tier and some other value, this would
     be the standalone code."""
    family: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If the service has different generations of hardware, for the same SKU, then that can be
     captured here."""
    capacity: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If the SKU supports scale out/in then the capacity integer should be included. If scale out/in
     is not possible for the resource this may be omitted."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Solution(_Model):
    """Installed data manager for Agriculture solution detail.

    :ivar application_name: Application name of the solution.
    :vartype application_name: str
    :ivar partner_id: Partner Id.
    :vartype partner_id: str
    :ivar market_place_publisher_id: Marketplace publisher Id.
    :vartype market_place_publisher_id: str
    :ivar saas_subscription_id: Saas subscription Id.
    :vartype saas_subscription_id: str
    :ivar saas_subscription_name: Saas subscription name.
    :vartype saas_subscription_name: str
    :ivar plan_id: Plan Id.
    :vartype plan_id: str
    """

    application_name: Optional[str] = rest_field(name="applicationName", visibility=["read", "create", "update"])
    """Application name of the solution."""
    partner_id: Optional[str] = rest_field(name="partnerId", visibility=["read", "create", "update"])
    """Partner Id."""
    market_place_publisher_id: Optional[str] = rest_field(
        name="marketPlacePublisherId", visibility=["read", "create", "update"]
    )
    """Marketplace publisher Id."""
    saas_subscription_id: Optional[str] = rest_field(name="saasSubscriptionId", visibility=["read", "create", "update"])
    """Saas subscription Id."""
    saas_subscription_name: Optional[str] = rest_field(
        name="saasSubscriptionName", visibility=["read", "create", "update"]
    )
    """Saas subscription name."""
    plan_id: Optional[str] = rest_field(name="planId", visibility=["read", "create", "update"])
    """Plan Id."""

    @overload
    def __init__(
        self,
        *,
        application_name: Optional[str] = None,
        partner_id: Optional[str] = None,
        market_place_publisher_id: Optional[str] = None,
        saas_subscription_id: Optional[str] = None,
        saas_subscription_name: Optional[str] = None,
        plan_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.agricultureplatform.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.agricultureplatform.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
