/*
 * Copyright (c) 2008-2026 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3.0 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3.0 along with this program. If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* This file is automatically generated from amiga-library.xml */

#include "config.h"

#import "ObjFWRT.h"
#import "private.h"

extern struct Library *ObjFWRTBase;

#if OF_GCC_VERSION >= 1100
# pragma GCC diagnostic ignored "-Warray-parameter"
#endif

bool __attribute__((__weak__))
objc_init(unsigned int version, struct objc_linklib_context *_Nonnull ctx)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(unsigned int, struct objc_linklib_context *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 28))(version, ctx);
}

void __attribute__((__weak__))
__objc_exec_class(struct objc_module *_Nonnull module)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(struct objc_module *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 34))(module);
}

IMP _Nonnull __attribute__((__weak__))
objc_msg_lookup(id _Nullable object, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nonnull (*)(id _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 40))(object, selector);
}

IMP _Nonnull __attribute__((__weak__))
objc_msg_lookup_stret(id _Nullable object, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nonnull (*)(id _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 46))(object, selector);
}

IMP _Nonnull __attribute__((__weak__))
objc_msg_lookup_super(struct objc_super *_Nonnull super, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nonnull (*)(struct objc_super *_Nonnull, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 52))(super, selector);
}

IMP _Nonnull __attribute__((__weak__))
objc_msg_lookup_super_stret(struct objc_super *_Nonnull super, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nonnull (*)(struct objc_super *_Nonnull, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 58))(super, selector);
}

Class _Nullable __attribute__((__weak__))
objc_lookUpClass(const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nullable (*)(const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 64))(name);
}

Class _Nullable __attribute__((__weak__))
objc_getClass(const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nullable (*)(const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 70))(name);
}

Class _Nonnull __attribute__((__weak__))
objc_getRequiredClass(const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nonnull (*)(const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 76))(name);
}

Class _Nullable __attribute__((__weak__))
objc_lookup_class(const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nullable (*)(const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 82))(name);
}

Class _Nonnull __attribute__((__weak__))
objc_get_class(const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nonnull (*)(const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 88))(name);
}

void __attribute__((__weak__))
objc_exception_throw(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 94))(object);

	OF_UNREACHABLE
}

int __attribute__((__weak__))
objc_sync_enter(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((int (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 100))(object);
}

int __attribute__((__weak__))
objc_sync_exit(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((int (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 106))(object);
}

id _Nullable __attribute__((__weak__))
objc_getProperty(id _Nonnull self, SEL _Nonnull _cmd, ptrdiff_t offset, bool atomic)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nonnull, SEL _Nonnull, ptrdiff_t, bool))*(void **)(((uintptr_t)ObjFWRTBase) - 112))(self, _cmd, offset, atomic);
}

void __attribute__((__weak__))
objc_setProperty(id _Nonnull self, SEL _Nonnull _cmd, ptrdiff_t offset, id _Nullable value, bool atomic, signed char copy)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nonnull, SEL _Nonnull, ptrdiff_t, id _Nullable, bool, signed char))*(void **)(((uintptr_t)ObjFWRTBase) - 118))(self, _cmd, offset, value, atomic, copy);
}

void __attribute__((__weak__))
objc_getPropertyStruct(void *_Nonnull dest, const void *_Nonnull src, ptrdiff_t size, bool atomic, bool strong)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(void *_Nonnull, const void *_Nonnull, ptrdiff_t, bool, bool))*(void **)(((uintptr_t)ObjFWRTBase) - 124))(dest, src, size, atomic, strong);
}

void __attribute__((__weak__))
objc_setPropertyStruct(void *_Nonnull dest, const void *_Nonnull src, ptrdiff_t size, bool atomic, bool strong)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(void *_Nonnull, const void *_Nonnull, ptrdiff_t, bool, bool))*(void **)(((uintptr_t)ObjFWRTBase) - 130))(dest, src, size, atomic, strong);
}

void __attribute__((__weak__))
objc_enumerationMutation(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 136))(object);
}

int __attribute__((__weak__))
__gnu_objc_personality_v0(int version, int actions, uint64_t _Nonnull exClass, void *_Nonnull ex, void *_Nonnull ctx)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((int (*)(int, int, uint64_t _Nonnull, void *_Nonnull, void *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 142))(version, actions, exClass, ex, ctx);
}

id _Nullable __attribute__((__weak__))
objc_retain(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 148))(object);
}

id _Nullable __attribute__((__weak__))
objc_retainBlock(id _Nullable block)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 154))(block);
}

id _Nullable __attribute__((__weak__))
objc_retainAutorelease(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 160))(object);
}

void __attribute__((__weak__))
objc_release(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 166))(object);
}

id _Nullable __attribute__((__weak__))
objc_autorelease(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 172))(object);
}

id _Nullable __attribute__((__weak__))
objc_autoreleaseReturnValue(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 178))(object);
}

id _Nullable __attribute__((__weak__))
objc_retainAutoreleaseReturnValue(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 184))(object);
}

id _Nullable __attribute__((__weak__))
objc_retainAutoreleasedReturnValue(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 190))(object);
}

id _Nullable __attribute__((__weak__))
objc_storeStrong(id _Nullable *_Nonnull object, id _Nullable value)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable *_Nonnull, id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 196))(object, value);
}

id _Nullable __attribute__((__weak__))
objc_storeWeak(id _Nullable *_Nonnull object, id _Nullable value)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable *_Nonnull, id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 202))(object, value);
}

id _Nullable __attribute__((__weak__))
objc_loadWeakRetained(id _Nullable *_Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 208))(object);
}

id _Nullable __attribute__((__weak__))
objc_initWeak(id _Nullable *_Nonnull object, id _Nullable value)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable *_Nonnull, id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 214))(object, value);
}

void __attribute__((__weak__))
objc_destroyWeak(id _Nullable *_Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nullable *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 220))(object);
}

id _Nullable __attribute__((__weak__))
objc_loadWeak(id _Nullable *_Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 226))(object);
}

void __attribute__((__weak__))
objc_copyWeak(id _Nullable *_Nonnull dest, id _Nullable *_Nonnull src)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nullable *_Nonnull, id _Nullable *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 232))(dest, src);
}

void __attribute__((__weak__))
objc_moveWeak(id _Nullable *_Nonnull dest, id _Nullable *_Nonnull src)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nullable *_Nonnull, id _Nullable *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 238))(dest, src);
}

SEL _Nonnull __attribute__((__weak__))
sel_registerName(const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((SEL _Nonnull (*)(const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 244))(name);
}

const char *_Nonnull __attribute__((__weak__))
sel_getName(SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nonnull (*)(SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 250))(selector);
}

bool __attribute__((__weak__))
sel_isEqual(SEL _Nonnull selector1, SEL _Nonnull selector2)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(SEL _Nonnull, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 256))(selector1, selector2);
}

Class _Nonnull __attribute__((__weak__))
objc_allocateClassPair(Class _Nullable superclass, const char *_Nonnull name, size_t extraBytes)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nonnull (*)(Class _Nullable, const char *_Nonnull, size_t))*(void **)(((uintptr_t)ObjFWRTBase) - 262))(superclass, name, extraBytes);
}

void __attribute__((__weak__))
objc_registerClassPair(Class _Nonnull class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(Class _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 268))(class_);
}

unsigned int __attribute__((__weak__))
objc_getClassList(Class _Nonnull *_Nullable buffer, unsigned int count)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((unsigned int (*)(Class _Nonnull *_Nullable, unsigned int))*(void **)(((uintptr_t)ObjFWRTBase) - 274))(buffer, count);
}

Class _Nonnull *_Nonnull __attribute__((__weak__))
objc_copyClassList(unsigned int *_Nullable length)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nonnull *_Nonnull (*)(unsigned int *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 280))(length);
}

bool __attribute__((__weak__))
class_isMetaClass(Class _Nullable class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(Class _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 286))(class_);
}

const char *_Nullable __attribute__((__weak__))
class_getName(Class _Nullable class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nullable (*)(Class _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 292))(class_);
}

Class _Nullable __attribute__((__weak__))
class_getSuperclass(Class _Nullable class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nullable (*)(Class _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 298))(class_);
}

unsigned long __attribute__((__weak__))
class_getInstanceSize(Class _Nullable class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((unsigned long (*)(Class _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 304))(class_);
}

bool __attribute__((__weak__))
class_respondsToSelector(Class _Nullable class_, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(Class _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 310))(class_, selector);
}

bool __attribute__((__weak__))
class_conformsToProtocol(Class _Nullable class_, Protocol *_Nonnull p)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(Class _Nullable, Protocol *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 316))(class_, p);
}

IMP _Nullable __attribute__((__weak__))
class_getMethodImplementation(Class _Nullable class_, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nullable (*)(Class _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 322))(class_, selector);
}

IMP _Nullable __attribute__((__weak__))
class_getMethodImplementation_stret(Class _Nullable class_, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nullable (*)(Class _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 328))(class_, selector);
}

const char *_Nullable __attribute__((__weak__))
_class_getMethodTypeEncoding(Class _Nullable class_, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nullable (*)(Class _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 334))(class_, selector);
}

bool __attribute__((__weak__))
class_addMethod(Class _Nonnull class_, SEL _Nonnull selector, IMP _Nonnull implementation, const char *_Nullable typeEncoding)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(Class _Nonnull, SEL _Nonnull, IMP _Nonnull, const char *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 340))(class_, selector, implementation, typeEncoding);
}

IMP _Nullable __attribute__((__weak__))
class_replaceMethod(Class _Nonnull class_, SEL _Nonnull selector, IMP _Nonnull implementation, const char *_Nullable typeEncoding)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((IMP _Nullable (*)(Class _Nonnull, SEL _Nonnull, IMP _Nonnull, const char *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 346))(class_, selector, implementation, typeEncoding);
}

Class _Nullable __attribute__((__weak__))
object_getClass(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 352))(object);
}

Class _Nullable __attribute__((__weak__))
object_setClass(id _Nullable object, Class _Nonnull class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Class _Nullable (*)(id _Nullable, Class _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 358))(object, class_);
}

const char *_Nullable __attribute__((__weak__))
object_getClassName(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 364))(object);
}

const char *_Nonnull __attribute__((__weak__))
protocol_getName(Protocol *_Nonnull protocol)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nonnull (*)(Protocol *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 370))(protocol);
}

bool __attribute__((__weak__))
protocol_isEqual(Protocol *_Nonnull protocol1, Protocol *_Nonnull protocol2)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(Protocol *_Nonnull, Protocol *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 376))(protocol1, protocol2);
}

bool __attribute__((__weak__))
protocol_conformsToProtocol(Protocol *_Nonnull protocol1, Protocol *_Nonnull protocol2)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(Protocol *_Nonnull, Protocol *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 382))(protocol1, protocol2);
}

_Nullable objc_uncaught_exception_handler __attribute__((__weak__))
objc_setUncaughtExceptionHandler(objc_uncaught_exception_handler _Nullable handler)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((_Nullable objc_uncaught_exception_handler (*)(objc_uncaught_exception_handler _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 388))(handler);
}

void __attribute__((__weak__))
objc_setForwardHandler(IMP _Nullable forward, IMP _Nullable stretForward)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(IMP _Nullable, IMP _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 394))(forward, stretForward);
}

void __attribute__((__weak__))
objc_setEnumerationMutationHandler(objc_enumeration_mutation_handler _Nullable handler)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(objc_enumeration_mutation_handler _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 400))(handler);
}

void __attribute__((__weak__))
_objc_zeroWeakReferences(id _Nullable value)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 406))(value);
}

void __attribute__((__weak__))
objc_deinit()
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)())*(void **)(((uintptr_t)ObjFWRTBase) - 412))();
}

Ivar _Nullable *_Nullable __attribute__((__weak__))
class_copyIvarList(Class _Nullable class_, unsigned int *_Nullable outCount)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Ivar _Nullable *_Nullable (*)(Class _Nullable, unsigned int *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 418))(class_, outCount);
}

const char *_Nonnull __attribute__((__weak__))
ivar_getName(Ivar _Nonnull ivar)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nonnull (*)(Ivar _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 424))(ivar);
}

const char *_Nonnull __attribute__((__weak__))
ivar_getTypeEncoding(Ivar _Nonnull ivar)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nonnull (*)(Ivar _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 430))(ivar);
}

ptrdiff_t __attribute__((__weak__))
ivar_getOffset(Ivar _Nonnull ivar)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((ptrdiff_t (*)(Ivar _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 436))(ivar);
}

void __attribute__((__weak__))
class_registerAlias_np(Class _Nonnull class_, const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(Class _Nonnull, const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 442))(class_, name);
}

Method _Nullable __attribute__((__weak__))
class_getInstanceMethod(Class _Nullable class_, SEL _Nonnull selector)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Method _Nullable (*)(Class _Nullable, SEL _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 448))(class_, selector);
}

Method _Nullable *_Nullable __attribute__((__weak__))
class_copyMethodList(Class _Nullable class_, unsigned int *_Nullable outCount)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((Method _Nullable *_Nullable (*)(Class _Nullable, unsigned int *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 454))(class_, outCount);
}

SEL _Nonnull __attribute__((__weak__))
method_getName(Method _Nonnull method)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((SEL _Nonnull (*)(Method _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 460))(method);
}

const char *_Nullable __attribute__((__weak__))
method_getTypeEncoding(Method _Nonnull method)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nullable (*)(Method _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 466))(method);
}

objc_property_t _Nullable *_Nullable __attribute__((__weak__))
class_copyPropertyList(Class _Nullable class_, unsigned int *_Nullable outCount)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((objc_property_t _Nullable *_Nullable (*)(Class _Nullable, unsigned int *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 472))(class_, outCount);
}

const char *_Nonnull __attribute__((__weak__))
property_getName(objc_property_t _Nonnull property)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((const char *_Nonnull (*)(objc_property_t _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 478))(property);
}

char *_Nullable __attribute__((__weak__))
property_copyAttributeValue(objc_property_t _Nonnull property, const char *_Nonnull name)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((char *_Nullable (*)(objc_property_t _Nonnull, const char *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 484))(property, name);
}

id _Nullable __attribute__((__weak__))
objc_constructInstance(Class _Nullable class_, void *_Nullable bytes)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(Class _Nullable, void *_Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 490))(class_, bytes);
}

void *_Nullable __attribute__((__weak__))
objc_destructInstance(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((void *_Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 496))(object);
}

id _Nullable __attribute__((__weak__))
class_createInstance(Class _Nullable class_, size_t extraBytes)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(Class _Nullable, size_t))*(void **)(((uintptr_t)ObjFWRTBase) - 502))(class_, extraBytes);
}

id _Nullable __attribute__((__weak__))
object_dispose(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 508))(object);
}

id _Nonnull __attribute__((__weak__))
_objc_rootRetain(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nonnull (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 514))(object);
}

unsigned int __attribute__((__weak__))
_objc_rootRetainCount(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((unsigned int (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 520))(object);
}

void __attribute__((__weak__))
_objc_rootRelease(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 526))(object);
}

void *_Null_unspecified __attribute__((__weak__))
objc_autoreleasePoolPush()
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((void *_Null_unspecified (*)())*(void **)(((uintptr_t)ObjFWRTBase) - 532))();
}

void __attribute__((__weak__))
objc_autoreleasePoolPop(void *_Null_unspecified pool)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(void *_Null_unspecified))*(void **)(((uintptr_t)ObjFWRTBase) - 538))(pool);
}

id _Nullable __attribute__((__weak__))
_objc_rootAutorelease(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 544))(object);
}

void __attribute__((__weak__))
objc_setTaggedPointerSecret(uintptr_t secret)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(uintptr_t))*(void **)(((uintptr_t)ObjFWRTBase) - 550))(secret);
}

int __attribute__((__weak__))
objc_registerTaggedPointerClass(Class _Nonnull class_)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((int (*)(Class _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 556))(class_);
}

bool __attribute__((__weak__))
object_isTaggedPointer(id _Nullable object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((bool (*)(id _Nullable))*(void **)(((uintptr_t)ObjFWRTBase) - 562))(object);
}

uintptr_t __attribute__((__weak__))
object_getTaggedPointerValue(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((uintptr_t (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 568))(object);
}

id _Nullable __attribute__((__weak__))
objc_createTaggedPointer(int class_, uintptr_t value)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(int, uintptr_t))*(void **)(((uintptr_t)ObjFWRTBase) - 574))(class_, value);
}

void __attribute__((__weak__))
objc_setAssociatedObject(id _Nonnull object, const void *_Nonnull key, id _Nullable value, objc_associationPolicy policy)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nonnull, const void *_Nonnull, id _Nullable, objc_associationPolicy))*(void **)(((uintptr_t)ObjFWRTBase) - 580))(object, key, value, policy);
}

id _Nullable __attribute__((__weak__))
objc_getAssociatedObject(id _Nonnull object, const void *_Nonnull key)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	return __extension__ ((id _Nullable (*)(id _Nonnull, const void *_Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 586))(object, key);
}

void __attribute__((__weak__))
objc_removeAssociatedObjects(id _Nonnull object)
{
	__asm__ __volatile__ (
	    "mr		%%r12, %0"
	    :: "r" (ObjFWRTBase) : "r12"
	);

	__extension__ ((void (*)(id _Nonnull))*(void **)(((uintptr_t)ObjFWRTBase) - 592))(object);
}
