## Bibliography of the ACM Turing Award Lectures

- PrismJS version: 1.20.0
- PrismJS theme: prism (default light theme)

Source: <ftp://ftp.math.utah.edu/pub/tex/bib/acm-turing-awards.bib>

```bib
{% raw %}%%% -*-BibTeX-*-
%%% ====================================================================
%%%  BibTeX-file{
%%%     author          = "Nelson H. F. Beebe",
%%%     version         = "1.35",
%%%     date            = "31 January 2019",
%%%     time            = "11:37:11 MST",
%%%     filename        = "acm-turing-awards.bib",
%%%     address         = "University of Utah
%%%                        Department of Mathematics, 110 LCB
%%%                        155 S 1400 E RM 233
%%%                        Salt Lake City, UT 84112-0090
%%%                        USA",
%%%     telephone       = "+1 801 581 5254",
%%%     FAX             = "+1 801 581 4148",
%%%     URL             = "http://www.math.utah.edu/~beebe",
%%%     checksum        = "13894 3280 14033 146737",
%%%     email           = "beebe at math.utah.edu, beebe at acm.org,
%%%                        beebe at computer.org (Internet)",
%%%     codetable       = "ISO/ASCII",
%%%     keywords        = "ACM Turing Award; bibliography; BibTeX",
%%%     license         = "public domain",
%%%     supported       = "yes",
%%%     docstring       = "This is a bibliography of the ACM Turing
%%%                        Award Lectures.  The official Web site for
%%%                        these awards is:
%%%
%%%                            http://www.acm.org/awards/taward.html
%%%
%%%                        Links to Web pages about each awardee are
%%%                        here:
%%%
%%%                            http://amturing.acm.org/byyear.cfm
%%%
%%%                        There are Web pages for the Turing Lectures
%%%                        here:
%%%
%%%                            http://amturing.acm.org/lectures.cfm
%%%
%%%                        There is also a list with links to author
%%%                        publication lists at
%%%
%%%                            http://www.informatik.uni-trier.de/~ley/db/journals/cacm/turing.html
%%%
%%%                        For convenience, here is a summary of the
%%%                        awards, with URLs for the official
%%%                        announcements of recent awards. Lectures are
%%%                        published in the same or following year,
%%%                        except as noted, and from 2002, some are
%%%                        available in online video formats:
%%%
%%%                            1966    Alan J. Perlis
%%%                            1967    Maurice V. Wilkes
%%%                            1968    Richard W. Hamming
%%%                            1969    Marvin L. Minsky
%%%                            1970    James H. Wilkinson
%%%                            1971    John McCarthy (published 1987)
%%%                            1972    Edsger W. Dijkstra
%%%                            1973    Charles W. Bachman
%%%                            1974    Donald E. Knuth
%%%                            1975    Allen Newell and Herbert A. Simon
%%%                            1976    Dana S. Scott
%%%                            1977    John Backus
%%%                            1978    Robert W. Floyd
%%%                            1979    Kenneth E. Iverson
%%%                            1980    Charles Anthony Richard Hoare
%%%                            1981    Edgar F. Codd
%%%                            1982    Stephen A. Cook
%%%                            1983    Dennis M. Ritchie and Ken Thompson
%%%                            1984    Niklaus Wirth
%%%                            1985    Richard M. Karp
%%%                            1986    John E. Hopcroft and Robert E. Tarjan
%%%                            1987    John Cocke
%%%                            1988    Ivan E. Sutherland
%%%                            1989    William (Velvel) M. Kahan (unpublished)
%%%                            1990    Fernando J. Corbat{\'o}
%%%                            1991    Robin Milner
%%%                            1992    Butler Lampson (unpublished??)
%%%                            1993    Juris Hartmanis and Richard Edwin Stearns
%%%                            1994    Edward A. Feigenbaum and Raj Reddy
%%%                            1995    Manuel Blum (unpublished)
%%%                                    http://www.acm.org/announcements/95turingaward.html
%%%                                    http://www.csc.villanova.edu/html/csc96/
%%%                            1996    Amir Pnueli (only abstract published)
%%%                                    http://www.acm.org/announcements/turing.html
%%%                            1997    Douglas Engelbart (unpublished??)
%%%                                    http://www.acm.org/announcements/turing98.html
%%%                            1998    Jim Gray
%%%                                    http://www.acm.org/announcements/turing2.html
%%%                            1999    Frederick P. Brooks, Jr. (unpublished)
%%%                                    http://www.acm.org/announcements/turing99.html
%%%                            2000    Andrew Chi-Chih Yao (unpublished)
%%%                                    http://www.acm.org/announcements/turing2000.html
%%%                            2001    Ole Johan Dahl and Kristen Nygaard (unpublished)
%%%                                    http://www.acm.org/announcements/turing_2001.html
%%%                            2002    Ronald L. Rivest, Adi Shamir and Leonard M. Adleman
%%%                                    http://www.acm.org/awards/turing_citations/rivest-shamir-adleman.html
%%%                                    http://www.acm.org/announcements/turing_2002.html
%%%                            2003    Alan Kay
%%%                                    http://www.acm.org/announcements/turingaward.4-21-2004.html
%%%                                    http://www.acm.org/talks/AlanKay/KayTuring.htm
%%%                                    2004 Kyoto Prize for Advanced Technology
%%%                            2004    Vinton Cerf and Robert Kahn
%%%                                    http://campus.acm.org/public/pressroom/press_releases/2_2005/turing_2_14_2005.cfm
%%%                            2005    Peter Naur
%%%                            2006    Frances E. Allen
%%%                            2007    Edmund M. Clarke, E. Allen Emerson, and Joseph Sifakis
%%%                            2008    Barbara H. Liskov
%%%                            2009    Charles P. Thacker
%%%                            2010    Leslie G. Valiant
%%%                            2011    Judea Pearl
%%%                            2012    Shafi Goldwasser and Silvio Micali
%%%                            2013    Leslie Lamport
%%%                            2014    Michael Stonebraker
%%%                            2015    Whitfield Diffie and Martin Hellman
%%%                            2016    Sir Tim Berners-Lee
%%%                            2017    John L. Hennessy and David A. Patterson
%%%
%%%                        At version 1.35, the year coverage looked
%%%                        like this:
%%%
%%%                             1967 (   1)    1985 (   1)    2003 (   3)
%%%                             1968 (   1)    1986 (   1)    2004 (   1)
%%%                             1969 (   1)    1987 (  48)    2005 (   1)
%%%                             1970 (   1)    1988 (   2)    2006 (   0)
%%%                             1971 (   1)    1989 (   1)    2007 (   0)
%%%                             1972 (   1)    1990 (   1)    2008 (   0)
%%%                             1973 (   1)    1991 (   2)    2009 (   7)
%%%                             1974 (   1)    1992 (   1)    2010 (   3)
%%%                             1975 (   0)    1993 (   2)    2011 (   2)
%%%                             1976 (   1)    1994 (   2)    2012 (   3)
%%%                             1977 (   1)    1995 (   0)    2013 (   3)
%%%                             1978 (   2)    1996 (   2)    2014 (   1)
%%%                             1979 (   1)    1997 (   2)    2015 (   4)
%%%                             1980 (   1)    1998 (   1)    2016 (   4)
%%%                             1981 (   1)    1999 (   3)    2017 (   2)
%%%                             1982 (   1)    2000 (   0)    2018 (   4)
%%%                             1983 (   1)    2001 (   0)
%%%                             1984 (   2)    2002 (   3)
%%%
%%%                             Article:         59
%%%                             Book:             2
%%%                             InCollection:    44
%%%                             InProceedings:    2
%%%                             Misc:            13
%%%                             PhdThesis:        2
%%%                             Proceedings:      3
%%%                             TechReport:       2
%%%                             Unpublished:      2
%%%
%%%                             Total entries:  129
%%%
%%%                        The checksum field above contains a CRC-16
%%%                        checksum as the first value, followed by the
%%%                        equivalent of the standard UNIX wc (word
%%%                        count) utility output of lines, words, and
%%%                        characters.  This is produced by Robert
%%%                        Solovay's checksum utility.",
%%%  }
%%% ====================================================================

%%% ====================================================================
%%% Acknowledgement abbreviations:

@String{ack-nhfb = "Nelson H. F. Beebe,
                    University of Utah,
                    Department of Mathematics, 110 LCB,
                    155 S 1400 E RM 233,
                    Salt Lake City, UT 84112-0090, USA,
                    Tel: +1 801 581 5254,
                    FAX: +1 801 581 4148,
                    e-mail: \path|beebe@math.utah.edu|,
                            \path|beebe@acm.org|,
                            \path|beebe@computer.org| (Internet),
                    URL: \path|http://www.math.utah.edu/~beebe/|"}

%%% ====================================================================
%%% Institution abbreviations:

@String{inst-BERKELEY-CS        = "Department of Computer Science, University
                                  of California"}
@String{inst-BERKELEY-CS:adr    = "Berkeley, CA, USA"}

%%% ====================================================================
%%% Journal abbreviations:

@String{j-J-ACM                 = "Journal of the ACM"}

@String{j-CACM                  = "Communications of the ACM"}

@String{j-NY-TIMES              = "New York Times"}

@String{j-SCIENTOMETRICS        = "Scientometrics"}

@String{j-SIGMOD                = "SIGMOD Record (ACM Special Interest
                                  Group on Management of Data)"}

%%% ====================================================================
%%% Publishers and their addresses:

@String{pub-ACM                 = "ACM Press"}
@String{pub-ACM:adr             = "New York, NY 10036, USA"}

@String{pub-AW                  = "Ad{\-d}i{\-s}on-Wes{\-l}ey"}
@String{pub-AW:adr              = "Reading, MA, USA"}

@String{pub-SUCSLI              = "Stanford University Center for the
                                  Study of Language and Information"}
@String{pub-SUCSLI:adr          = "Stanford, CA, USA"}

@String{pub-SV                  = "Spring{\-}er-Ver{\-}lag"}
@String{pub-SV:adr              = "Berlin, Germany~/ Heidelberg,
                                  Germany~/ London, UK~/ etc."}

%%% ====================================================================
%%% Bibliography entries sorted by year and then by citation key:

@Article{Perlis:1967:SAS,
  author =       "Alan J. Perlis",
  title =        "The Synthesis of Algorithmic Systems",
  journal =      j-J-ACM,
  volume =       "14",
  number =       "1",
  pages =        "1--9",
  month =        jan,
  year =         "1967",
  CODEN =        "JACOAH",
  DOI =          "https://doi.org/10.1145/321371.321372",
  ISSN =         "0004-5411",
  ISSN-L =       "0004-5411",
  bibdate =      "Mon Dec 05 19:37:58 1994",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Journal of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J401",
  remark =       "This is the 1966 ACM Turing Award Lecture, and the
                 first award.",
}

@Article{Wilkes:1968:CTN,
  author =       "Maurice V. Wilkes",
  title =        "Computers Then and Now",
  journal =      j-J-ACM,
  volume =       "15",
  number =       "1",
  pages =        "1--7",
  month =        jan,
  year =         "1968",
  CODEN =        "JACOAH",
  DOI =          "https://doi.org/10.1145/321439.321440",
  ISSN =         "0004-5411",
  ISSN-L =       "0004-5411",
  bibdate =      "Mon Dec 05 19:45:38 1994",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Reminiscences on the early developments leading to
                 large scale electronic computers show that it took much
                 longer than was expected for the first of the more
                 ambitious and fully engineered computers to be
                 completed and prove themselves in practical operation.
                 Comments on the present computer field assess the needs
                 for future development.",
  acknowledgement = ack-nhfb,
  fjournal =     "Journal of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J401",
  remark =       "This is the 1967 ACM Turing Award Lecture.",
}

@Article{Hamming:1969:OMV,
  author =       "R. W. Hamming",
  title =        "One Man's View of Computer Science",
  journal =      j-J-ACM,
  volume =       "16",
  number =       "1",
  pages =        "3--12",
  month =        jan,
  year =         "1969",
  CODEN =        "JACOAH",
  DOI =          "https://doi.org/10.1145/321495.321497",
  ISSN =         "0004-5411",
  ISSN-L =       "0004-5411",
  bibdate =      "Mon Dec 05 19:49:19 1994",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "A number of observations and comments are directed
                 toward suggesting that more than the usual engineering
                 flavor be given to computer science. The engineering
                 aspect is important because most present difficulties
                 in this field do not involve the theoretical question
                 of whether certain things can be done, but rather the
                 practical question of how can they be accomplished well
                 and simply. The teaching of computer science could be
                 made more effective by various alterations, for
                 example, the inclusion of a laboratory course in
                 programming, the requirement for a strong minor in
                 something other than mathematics, and more practical
                 coding and less abstract theory, as well as more
                 seriousness and less game playing.",
  acknowledgement = ack-nhfb,
  fjournal =     "Journal of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J401",
  remark =       "This is the 1968 ACM Turing Award Lecture.",
}

@Article{Minsky:1970:FCC,
  author =       "Marvin L. Minsky",
  title =        "Form and Content in Computer Science",
  journal =      j-J-ACM,
  volume =       "17",
  number =       "2",
  pages =        "197--215",
  month =        apr,
  year =         "1970",
  CODEN =        "JACOAH",
  DOI =          "https://doi.org/10.1145/321574.321575",
  ISSN =         "0004-5411",
  ISSN-L =       "0004-5411",
  bibdate =      "Mon Dec 5 19:52:01 1994",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Compiler/semantics.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Journal of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J401",
  remark =       "This is the 1969 ACM Turing Award Lecture.",
}

@Article{Wilkinson:1971:SCN,
  author =       "J. H. Wilkinson",
  title =        "Some Comments from a Numerical Analyst",
  journal =      j-J-ACM,
  volume =       "18",
  number =       "2",
  pages =        "137--147",
  month =        apr,
  year =         "1971",
  CODEN =        "JACOAH",
  DOI =          "https://doi.org/10.1145/321637.321638",
  ISSN =         "0004-5411",
  ISSN-L =       "0004-5411",
  bibdate =      "Sat Dec 10 15:00:46 1994",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Journal of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J401",
  remark =       "This is the 1970 ACM Turing Award Lecture. Subsequent
                 lectures are published in {\em Communications of the
                 ACM}. Wilkinson comments ``It is perhaps salutary to be
                 reminded that as early as 1946 Turing had considered
                 the possibility of working with both interval and
                 significant digit arithmetic and the report recalled
                 forgotten conversations, not to mention heated
                 arguments, which we had on this topic.'' He also says
                 ``I think it is of vital importance that all the work
                 that has been expended on the development of
                 satisfactory algorithms should be made fully available
                 to the people who need to use it. I would go further
                 than this and claim that it is a social duty to see
                 that this is achieved.''",
}

@Article{Dijkstra:1972:HP,
  author =       "Edsger W. Dijkstra",
  title =        "The Humble Programmer",
  journal =      j-CACM,
  volume =       "15",
  number =       "10",
  pages =        "859--866",
  month =        oct,
  year =         "1972",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/355604.361591",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 06:36:07 MST 2001",
  bibsource =    "http://dblp.uni-trier.de/db/journals/cacm/cacm15.html#Dijkstra72;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "We shall do a much better programming job, provided
                 that we approach the task with a full appreciation if
                 its tremendous difficulty, provided that we stick to
                 modest and elegant programming languages, provided that
                 we respect the intrinsic limitations of the human mind
                 and approach the task as Very Humble Programmers.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  oldlabel =     "Dijkstra72",
  remark =       "This is the 1972 ACM Turing Award Lecture. The 1971
                 ACM Turing Award Lecture was not published until 1987
                 \cite{McCarthy:1987:GAI}.",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Dijkstra72",
}

@Article{Bachman:1973:PN,
  author =       "Charles W. Bachman",
  title =        "The Programmer as Navigator",
  journal =      j-CACM,
  volume =       "16",
  number =       "11",
  pages =        "653--658",
  month =        nov,
  year =         "1973",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/355611.362534",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 06:22:31 MST 2001",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Database/Graefe.bib;
                 ftp://ftp.ira.uka.de/pub/bibliography/Database/Wiederhold.bib;
                 http://dblp.uni-trier.de/db/journals/cacm/cacm16.html#Bachman73;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "This is the 1973 ACM Turing Award Lecture.",
  acknowledgement = ack-nhfb,
  annote =       "Turing Award acceptance speech-general view of the
                 state of database work from a DBTG originator.",
  classcodes =   "C6110 (Systems analysis and programming); C6120 (File
                 organisation); C6130 (Data handling techniques)",
  corpsource =   "Honeywell Information Systems Inc., Waltham, MA, USA",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "access; addressing; data handling; database; file
                 organisation; network hierarchical data model CACM;
                 programmer; programming",
  oldlabel =     "Bachman73",
  treatment =    "G General Review",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Bachman73",
}

@Article{Knuth:1974:CPA,
  author =       "Donald E. Knuth",
  title =        "Computer Programming as an Art",
  journal =      j-CACM,
  volume =       "17",
  number =       "12",
  pages =        "667--673",
  month =        dec,
  year =         "1974",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/361604.361612",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 06:55:26 MST 2001",
  bibsource =    "Compendex database;
                 http://dblp.uni-trier.de/db/journals/cacm/cacm17.html#Knuth74;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "French translation, with three supplementary
                 paragraphs, in {\sl L'Informatique Nouvelle}, No.\ 64
                 (June 1975), 20--27. Japanese translation by Makoto
                 Arisawa in {\sl bit\/ \bf 7} (1975), 434--444;
                 reprinted in {\sl Kunusu Sensei no Program-Ron\/} (see
                 under Books), 2--19. English version reprinted with the
                 supplementary paragraphs in {\sl ACM Turing Award
                 Lectures: The First Twenty Years} (New York: ACM Press,
                 1987), 33--46; reprinted with corrections in
                 \cite[pp.~1--16]{Knuth:1992:LP}. Russian translation by
                 V. V. Martyn\t iuk in {\sl Lektsii laureatov premii
                 T'\t\i uringa\/} (Moscow: Mir, 1993), 48--64.",
  abstract =     "Discussion emphasizes that computer programming is an
                 art as well as a science.",
  acknowledgement = ack-nhfb,
  classcodes =   "C6110 (Systems analysis and programming)",
  classification = "723",
  corpsource =   "Stanford Univ., CA, USA",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  journalabr =   "Commun ACM",
  keywords =     "art; computer; computer programming; programming;
                 quality",
  oldlabel =     "Knuth74",
  remark =       "This is the 1974 ACM Turing Award Lecture.",
  treatment =    "G General Review; P Practical",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Knuth74",
}

@Article{Newell:1976:CSE,
  author =       "Allen Newell and Herbert A. Simon",
  title =        "Computer Science as Empirical Inquiry: Symbols and
                 Search",
  journal =      j-CACM,
  volume =       "19",
  number =       "3",
  pages =        "113--126",
  month =        mar,
  year =         "1976",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/360018.360022",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68-01",
  MRnumber =     "57 4555",
  bibdate =      "Mon Jan 22 07:09:14 MST 2001",
  bibsource =    "http://dblp.uni-trier.de/db/journals/cacm/cacm19.html#NewellS76;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  classcodes =   "C1230 (Artificial intelligence); C6130 (Data handling
                 techniques)",
  corpsource =   "Carnegie-Mellon Univ., Pittsburgh, PA, USA",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "artificial intelligence; cognition; computer science;
                 empirical inquiry; heuristic programming; heuristic
                 search; list; list processing; physical symbol systems;
                 problem solving; processing; symbols; Turing",
  oldlabel =     "NewellS76",
  remark =       "This is the 1975 ACM Turing Award Lecture.",
  treatment =    "A Application; P Practical",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/NewellS76",
}

@Article{Scott:1977:LPL,
  author =       "Dana S. Scott",
  title =        "Logic and Programming Languages",
  journal =      j-CACM,
  volume =       "20",
  number =       "9",
  pages =        "634--641",
  month =        sep,
  year =         "1977",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/359810.359826",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68A05",
  MRnumber =     "56 10114",
  MRreviewer =   "Horst Reichel",
  bibdate =      "Mon Jan 22 07:20:11 MST 2001",
  bibsource =    "Compendex database;
                 ftp://ftp.ira.uka.de/pub/bibliography/Compiler/semantics.bib;
                 http://dblp.uni-trier.de/db/journals/cacm/cacm20.html#Scott77;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Logic has been long interested in whether answers to
                 certain questions are computable in principle, since
                 the outcome puts bounds on the possibilities of
                 formalization. It would seem that the understanding of
                 higher-level program features involves one with
                 infinite objects and forces one to pass through several
                 levels of explanation to go from the conceptual ideas
                 to the final simulation on a real machine. These levels
                 can be made mathematically exact if the right
                 abstractions can be found to represent the necessary
                 structures. In this paper, the author outlines his
                 approach to these problems, specifically his lambda
                 -calculus orientation.",
  acknowledgement = ack-nhfb,
  classcodes =   "C4210 (Formal logic); C6140 (Programming languages)",
  classification = "721; 723",
  corpsource =   "Math. Inst., Univ. of Oxford, Oxford, UK",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  journalabr =   "Commun ACM",
  keywords =     "automata theory --- Computability and Decidability;
                 computability and decidability; computability theory;
                 computational linguistics; computer metatheory;
                 computer programming languages; decision methods;
                 formal logic; methods of logic; programming languages;
                 semantical; syntactic formalization; theory",
  oldlabel =     "Scott77",
  remark =       "This is the 1976 ACM Turing Award Lecture.",
  treatment =    "A Application; T Theoretical or Mathematical",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Scott77",
}

@Article{Backus:1978:CPL,
  author =       "John Backus",
  title =        "Can Programming Be Liberated From the {von Neumann}
                 Style? {A} Functional Style and its Algebra of
                 Programs",
  journal =      j-CACM,
  volume =       "21",
  number =       "8",
  pages =        "613--641",
  month =        aug,
  year =         "1978",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/359576.359579",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 06:22:32 MST 2001",
  bibsource =    "Compendex database;
                 ftp://ftp.ira.uka.de/pub/bibliography/Distributed/QLD/1978.bib;
                 ftp://ftp.ira.uka.de/pub/bibliography/Parallel/par.misc.bib;
                 http://dblp.uni-trier.de/db/journals/cacm/cacm21.html#Backus78;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "Reproduced in ``Selected Reprints on Dataflow and
                 Reduction Architectures'' ed. S. S. Thakkar, IEEE,
                 1987, pp. 215-243.",
  abstract =     "Conventional programming languages are growing ever
                 more enormous, but not stronger. Inherent defects at
                 the most basic level cause them to be both fat and
                 weak: their primitive word-at-a-time style of
                 programming inherited from their common ancestor, the
                 von Neumann computer; their division of programming
                 into a world of expressions and a world of statements;
                 their inability to effectively use powerful combining
                 forms for building new programs from existing ones; and
                 their lack of useful mathematical properties for
                 reasoning about programs. An alternative functional
                 style of programming is founded on the use of combining
                 forms for creating programs. Functional programs deal
                 with structured data, are often nonrepetitive and
                 nonrecursive, are hierarchically constructed, do not
                 name their arguments, and do not require the complex
                 machinery of procedure declarations to become generally
                 applicable. Combining forms can use high level programs
                 to build still higher level ones in a style not
                 possible in conventional languages.",
  acknowledgement = ack-nhfb,
  annote =       "Conventional programming languages are growing ever
                 more enormous, but not stronger. Inherent defects at
                 the most basic level cause them to be both fat and
                 weak: their primitive word-at-a-time style of
                 programming inherited from their common ancestor - the
                 von Neumann computer, their close coupling of semantics
                 to state transitions, their division of programming
                 into a world of expressions and a world of statements,
                 their inability to effectively \ldots{}",
  classcodes =   "C6140 (Programming languages)",
  classification = "723",
  corpsource =   "IMB Res. Lab., San Jose, CA, USA",
  descriptors =  "Programming language; reliability; future outlook; von
                 Neumann computer; applicative computing system",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  journalabr =   "Commun ACM",
  keywords =     "4.29; 5.20; 5.24; 5.26; algebra of programs;
                 applicative computing systems; combining forms;
                 computer metatheory; conventional languages; CR
                 categories: 4.20; functional style; grecommended91; Key
                 words and phrases: functional programming;
                 metacomposition; models of computing systems; program
                 correctness; program termination; program
                 transformation; programming languages; Rhighnam;
                 structured data; theory ak; Turing Award Lecture; von
                 Neuman style; von Neumann computers; von Neumann
                 languages",
  oldlabel =     "Backus78",
  remark =       "This is the 1977 ACM Turing Award Lecture.",
  treatment =    "T Theoretical or Mathematical",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Backus78",
}

@Unpublished{Dijkstra:1978:RTA,
  author =       "Edsger W. Dijkstra",
  title =        "A review of the 1977 {Turing Award Lecture} by {John
                 Backus}",
  pages =        "5",
  year =         "1978",
  bibdate =      "Mon Mar 16 08:14:00 2015",
  bibsource =    "http://www.math.utah.edu/pub/bibnet/authors/d/dijkstra-edsger-w.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "Circulated privately.",
  URL =          "http://www.cs.utexas.edu/users/EWD/ewd06xx/EWD692.PDF",
  acknowledgement = ack-nhfb,
  filesize =     "143 KB",
  oldlabel =     "EWD:EWD692",
}

@Article{Floyd:1979:PP,
  author =       "Robert W. Floyd",
  title =        "The Paradigms of Programming",
  journal =      j-CACM,
  volume =       "22",
  number =       "8",
  pages =        "455--460",
  month =        aug,
  year =         "1979",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/359138.359140",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 06:40:01 MST 2001",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Ai/constr.logic.bib;
                 http://dblp.uni-trier.de/db/journals/cacm/cacm22.html#Floyd79;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  classcodes =   "C6110 (Systems analysis and programming)",
  corpsource =   "Dept. of Computer Sci., Stanford Univ., Stanford, CA,
                 USA",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "computer programs; languages; paradigms; programming;
                 structural programming",
  oldlabel =     "Floyd79",
  remark =       "This is the 1978 ACM Turing Award Lecture.",
  treatment =    "G General Review",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Floyd79",
}

@Article{Iverson:1980:NTT,
  author =       "Kenneth E. Iverson",
  title =        "Notation as a Tool of Thought",
  journal =      j-CACM,
  volume =       "23",
  number =       "8",
  pages =        "444--465",
  month =        aug,
  year =         "1980",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/358896.358899",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "00A25 (68-02)",
  MRnumber =     "82b:00007",
  MRreviewer =   "B. Brainerd",
  bibdate =      "Tue Dec 26 13:35:07 1995",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Database/Graefe.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "CACM apl programming languages",
  remark =       "This is the 1979 ACM Turing Award Lecture.",
}

@Article{Hoare:1981:EOC,
  author =       "Charles Anthony Richard Hoare",
  title =        "The {Emperor}'s Old Clothes",
  journal =      j-CACM,
  volume =       "24",
  number =       "2",
  pages =        "75--83",
  year =         "1981",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/358549.358561",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 06:50:25 MST 2001",
  bibsource =    "http://dblp.uni-trier.de/db/journals/cacm/cacm24.html#Hoare81;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "This is the 1980 ACM Turing Award Lecture, delivered
                 at ACM'80, Nashville, Tennessee, October 27, 1980.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  oldlabel =     "Hoare81",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Hoare81",
}

@Article{Codd:1982:RDP,
  author =       "E. F. Codd",
  title =        "Relational Database: a Practical Foundation for
                 Productivity",
  journal =      j-CACM,
  volume =       "25",
  number =       "2",
  pages =        "109--117",
  month =        feb,
  year =         "1982",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/358396.358400",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Feb 12 14:34:33 1996",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Database/Wiederhold.bib;
                 ftp://ftp.ira.uka.de/pub/bibliography/Database/Graefe.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  annote =       "This is the 1981 ACM Turing Award Lecture, delivered
                 at ACM, Los Angeles, CA, Nov. 9, 1981.",
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Cook:1983:OCC,
  author =       "Stephen A. Cook",
  title =        "An Overview of Computational Complexity",
  journal =      j-CACM,
  volume =       "26",
  number =       "6",
  pages =        "400--408",
  month =        jun,
  year =         "1983",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/358141.358144",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68C25",
  MRnumber =     "84m:68035",
  MRreviewer =   "R. E. Ladner",
  bibdate =      "Tue Dec 26 13:35:07 1995",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "complexity of computing the matrix permanent",
  remark =       "This is the 1982 ACM Turing Award Lecture.",
}

@Article{Ritchie:1984:RSR,
  author =       "Dennis M. Ritchie",
  title =        "Reflections on Software Research",
  journal =      j-CACM,
  volume =       "27",
  number =       "8",
  pages =        "758--760",
  month =        aug,
  year =         "1984",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/358198.358207",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 27 13:18:03 1997",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  remark =       "This is part one of the 1983 Turing Award Lecture.",
}

@Article{Thompson:1984:RTT,
  author =       "Ken Thompson",
  title =        "Reflections on Trusting Trust",
  journal =      j-CACM,
  volume =       "27",
  number =       "8",
  pages =        "761--763",
  month =        aug,
  year =         "1984",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/358198.358210",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Object/Nierstrasz.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "security unix",
  remark =       "This is part two of the 1983 Turing Award Lecture.",
}

@Article{Wirth:1985:PLD,
  author =       "Niklaus Wirth",
  title =        "From programming language design to computer
                 construction",
  journal =      j-CACM,
  volume =       "28",
  number =       "2",
  pages =        "160--164",
  month =        feb,
  year =         "1985",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2786.2789",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu May 30 09:41:10 MDT 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/2789.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "design; human factors; languages",
  remark =       "This is the 1984 Turing Award Lecture.",
  subject =      "{\bf K.2}: Computing Milieux, HISTORY OF COMPUTING,
                 Software. {\bf D.3.2}: Software, PROGRAMMING LANGUAGES,
                 Language Classifications.",
}

@Article{Karp:1986:CCR,
  author =       "Richard M. Karp",
  title =        "Combinatorics, complexity, and randomness",
  journal =      j-CACM,
  volume =       "29",
  number =       "2",
  pages =        "98--109",
  month =        feb,
  year =         "1986",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/5657.5658",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68Q15 (68Q25 68R05 68R10 90B10)",
  MRnumber =     "824 352",
  bibdate =      "Fri Apr 5 10:03:00 MST 1996",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Theory/ProbAlgs.bib;
                 http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "This is the 1985 ACM Turing Award Lecture. It traces
                 the development of combinatorial optimization and
                 computational complexity theory. It discusses
                 probabilistic algorithms and probabilistic analysis of
                 approximation algorithms for {\em NP}-complete
                 optimization problems.",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/5658.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "algorithms; performance; theory",
  review =       "ACM CR 8610-0921",
  subject =      "{\bf F.1.0}: Theory of Computation, COMPUTATION BY
                 ABSTRACT DEVICES, General. {\bf G.2.1}: Mathematics of
                 Computing, DISCRETE MATHEMATICS, Combinatorics. {\bf
                 K.2}: Computing Milieux, HISTORY OF COMPUTING, People.
                 {\bf F.0}: Theory of Computation, GENERAL. {\bf F.2.0}:
                 Theory of Computation, ANALYSIS OF ALGORITHMS AND
                 PROBLEM COMPLEXITY, General. {\bf G.2.2}: Mathematics
                 of Computing, DISCRETE MATHEMATICS, Graph Theory. {\bf
                 F.1.3}: Theory of Computation, COMPUTATION BY ABSTRACT
                 DEVICES, Complexity Classes, Reducibility and
                 completeness. {\bf F.1.3}: Theory of Computation,
                 COMPUTATION BY ABSTRACT DEVICES, Complexity Classes,
                 Relations among complexity classes. {\bf K.2}:
                 Computing Milieux, HISTORY OF COMPUTING.",
}

@InCollection{Adleman:1987:PRD,
  author =       "Leonard Adleman",
  title =        "Pre-{RSA} Days: History and Lessons",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961904",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Allen:1987:CPP,
  author =       "Frances Allen",
  title =        "Compiling for Performance: a Personal Tour",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961922",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Bachman:1987:PN,
  author =       "Charles W. Bachman",
  title =        "The programmer as navigator",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283928",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Backus:1987:CPL,
  author =       "John Backus",
  title =        "Can programming be liberated from the {von Neumann}
                 style?: a functional style and its algebra of
                 programs",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283933",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Cerf:1987:AIL,
  author =       "Vinton Cerf and Robert E. Kahn",
  title =        "Assessing the {Internet}: Lessons Learned, Strategies
                 for Evolution, and Future Possibilities",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961919",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Clarke:1987:MCM,
  author =       "Edmund M. Clarke",
  title =        "Model checking: my 27-year quest to overcome the state
                 explosion problem",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1962298",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Cocke:1987:SPS,
  author =       "John Cocke",
  title =        "The search for performance in scientific processors",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283945",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Codd:1987:RDP,
  author =       "E. F. Codd",
  title =        "Relational database: a practical foundation for
                 productivity",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283937",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Cook:1987:OCC,
  author =       "Stephen A. Cook",
  title =        "An overview of computational complexity",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283938",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Corbato:1987:BSW,
  author =       "Fernando J. Corbat{\'o}",
  title =        "On building systems that will fail",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283947",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Dijkstra:1987:HP,
  author =       "Edsger W. Dijkstra",
  title =        "The humble programmer",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283927",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Emerson:1987:MCP,
  author =       "E. Allen Emerson",
  title =        "Model checking: a Personal Perspective",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1962299",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Feigenbaum:1987:HWB,
  author =       "Edward A. Feigenbaum",
  title =        "How the `what' becomes the `how'",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283951",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Floyd:1987:PP,
  author =       "Robert W. Floyd",
  title =        "The paradigms of programming",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283934",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Hamming:1987:OMV,
  author =       "R. W. Hamming",
  title =        "One man's view of computer science",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283923",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Hartmanis:1987:TAL,
  author =       "Juris Hartmanis",
  title =        "{Turing Award Lecture}: on computational complexity
                 and the nature of computer science",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283949",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Hoare:1987:EOC,
  author =       "Charles Antony Richard Hoare",
  title =        "The emperor's old clothes",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283936",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@Article{Hopcroft:1987:CSEa,
  author =       "John E. Hopcroft",
  title =        "Computer Science: The Emergence of a Discipline",
  journal =      j-CACM,
  volume =       "30",
  number =       "3",
  pages =        "198--202",
  month =        mar,
  year =         "1987",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/214748.214750",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68-00",
  MRnumber =     "886 124",
  bibdate =      "Sat Apr 06 08:06:23 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/214750.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "human factors",
  remark =       "This is part one of the 1986 ACM Turing Award
                 Lecture.",
  subject =      "{\bf K.2}: Computing Milieux, HISTORY OF COMPUTING,
                 People. {\bf A.0}: General Literature, GENERAL,
                 Biographies/autobiographies. {\bf A.0}: General
                 Literature, GENERAL.",
}

@InCollection{Hopcroft:1987:CSEb,
  author =       "John E. Hopcroft",
  title =        "Computer science: the emergence of a discipline",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283943",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Iverson:1987:NTT,
  author =       "Kenneth E. Iverson",
  title =        "Notation as a tool of thought",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283935",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Karp:1987:CCR,
  author =       "Richard M. Karp",
  title =        "Combinatorics, complexity, and randomness",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283942",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Kay:1987:TAL,
  author =       "Alan Kay",
  title =        "{Turing Award Lecture}",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961918",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Knuth:1987:CPA,
  author =       "Donald E. Knuth",
  title =        "Computer programming as an art",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283929",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Liskov:1987:PA,
  author =       "Barbara Liskov",
  title =        "The Power of Abstraction",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1962421",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@Article{McCarthy:1987:GAIa,
  author =       "John McCarthy",
  title =        "Generality in artificial intelligence",
  journal =      j-CACM,
  volume =       "30",
  number =       "12",
  pages =        "1030--1035",
  month =        dec,
  year =         "1987",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/33447.33448",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68T01 (68T05 68T20 68T30)",
  MRnumber =     "89k:68128",
  MRreviewer =   "Alexander George",
  bibdate =      "Sat Apr 06 08:06:23 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/33448.html",
  abstract =     "My 1971 Turing Award Lecture was entitled ``Generality
                 in Artificial Intelligence.'' The topic turned out to
                 have been overambitious in that I discovered I was
                 unable to put my thoughts on the subject in a
                 satisfactory written form at that time. It would have
                 been better to have reviewed my previous work rather
                 than attempt something new, but such was not my custom
                 at that time. I am grateful to ACM for the opportunity
                 to try again. Unfortunately for our science, although
                 perhaps fortunately for this project, the problem of
                 generality in artificial intelligence (AI) is almost as
                 unsolved as ever, although we now have many ideas not
                 available in 1971. This paper relies heavily on such
                 ideas, but it is far from a full 1987 survey of
                 approaches for achieving generality. Ideas are
                 therefore discussed at a length proportional to my
                 familiarity with them rather than according to some
                 objective criterion. It was obvious in 1971 and even in
                 1958 that AI programs suffered from a lack of
                 generality. It is still obvious; there are many more
                 details. The first gross symptom is that a small
                 addition to the idea of a program often involves a
                 complete rewrite beginning with the data structures.
                 Some progress has been made in modularizing data
                 structures, but small modifications of the search
                 strategies are even less likely to be accomplished
                 without rewriting. Another symptom is no one knows how
                 to make a general database of commonsense knowledge
                 that could be used by any program that needed the
                 knowledge. Along with other information, such a
                 database would contain what a robot would need to know
                 about the effects of moving objects around, what a
                 person can be expected to know about his family, and
                 the facts about buying and selling. This does not
                 depend on whether the knowledge is to be expressed in a
                 logical language or in some other formalism. When we
                 take the logic approach to AI, lack of generality shows
                 up in that the axioms we devise to express commonsense
                 knowledge are too restricted in their applicability for
                 a general commonsense database. In my opinion, getting
                 a language for expressing general commonsense knowledge
                 for inclusion in a general database is the key problem
                 of generality in AI. Here are some ideas for achieving
                 generality proposed both before and after 1971. I
                 repeat my disclaimer of comprehensiveness.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "design; languages",
  remark =       "This is the 1971 Turing Award Lecture, sixteen years
                 late.",
  review =       "ACM CR 8807-0539",
  subject =      "{\bf I.2.0}: Computing Methodologies, ARTIFICIAL
                 INTELLIGENCE, General. {\bf K.2}: Computing Milieux,
                 HISTORY OF COMPUTING, Theory.",
}

@InCollection{McCarthy:1987:GAIb,
  author =       "John McCarthy",
  title =        "Generality in artificial intelligence",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283926",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Milner:1987:EI,
  author =       "Robin Milner",
  title =        "Elements of interaction",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283948",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Minsky:1987:FCC,
  author =       "Marvin Minsky",
  title =        "Form and content in computer science",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283924",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Naur:1987:CVH,
  author =       "Peter Naur",
  title =        "Computing vs. Human Thinking",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961921",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Newell:1987:CSE,
  author =       "Allen Newell and Herbert A. Simon",
  title =        "Computer science as empirical inquiry: symbols and
                 search",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283930",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Perlis:1987:SAS,
  author =       "Alan J. Perlis",
  title =        "The synthesis of algorithmic systems",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283921",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Rabin:1987:CC,
  author =       "Michael O. Rabin",
  title =        "Complexity of computations",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283931",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Reddy:1987:DPD,
  author =       "Raj Reddy",
  title =        "To dream the possible dream",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283952",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Ritchie:1987:RSR,
  author =       "Dennis M. Ritchie",
  title =        "Reflections on software research",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283939",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Rivest:1987:EDR,
  author =       "Ronald L. Rivest",
  title =        "The Early Days of {RSA}: History and Lessons",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961920",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Scott:1987:LPL,
  author =       "Dana S. Scott",
  title =        "Logic and programming languages",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283932",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Shamir:1987:CSS,
  author =       "Adi Shamir",
  title =        "Cryptography: State of the science",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1961903",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Sifakis:1987:QCB,
  author =       "Joseph Sifakis",
  title =        "The Quest for Correctness Beyond Verification",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1962393",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Stearns:1987:TAL,
  author =       "Richard Edwin Stearns",
  title =        "{Turing Award Lecture}: it's time to reconsider time",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283950",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Sutherland:1987:M,
  author =       "Ivan E. Sutherland",
  title =        "Micropipelines",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283946",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@Article{Tarjan:1987:ADa,
  author =       "Robert E. Tarjan",
  title =        "Algorithm Design",
  journal =      j-CACM,
  volume =       "30",
  number =       "3",
  pages =        "204--212",
  month =        mar,
  year =         "1987",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/214748.214752",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  MRclass =      "68Q20 (68Q25)",
  MRnumber =     "886 125",
  bibdate =      "Tue Dec 26 13:35:07 1995",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/214752.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "algorithms; design",
  remark =       "This is part two of the 1986 ACM Turing Award
                 Lecture.",
  subject =      "{\bf F.2.0}: Theory of Computation, ANALYSIS OF
                 ALGORITHMS AND PROBLEM COMPLEXITY, General. {\bf K.2}:
                 Computing Milieux, HISTORY OF COMPUTING, People. {\bf
                 A.0}: General Literature, GENERAL,
                 Biographies/autobiographies.",
}

@InCollection{Tarjan:1987:ADb,
  author =       "Robert E. Tarjan",
  title =        "Algorithm design",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283944",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Thack:1987:IFE,
  author =       "Charles P. Thack",
  title =        "Improving the Future by Examining the Past",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1964198",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Thompson:1987:RTT,
  author =       "Ken Thompson",
  title =        "Reflections on trusting trust",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283940",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Wilkes:1987:CTN,
  author =       "Maurice V. Wilkes",
  title =        "Computers then and now",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283922",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Wilkinson:1987:SCN,
  author =       "J. H. Wilkinson",
  title =        "Some comments from a numerical analyst",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283925",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@InCollection{Wirth:1987:PLD,
  author =       "Niklaus Wirth",
  title =        "From programming language design to computer
                 construction",
  crossref =     "Ashenhurst:1987:ATA",
  pages =        "??--??",
  year =         "1987",
  DOI =          "https://doi.org/10.1145/1283920.1283941",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "ACM Turing Award lecture.",
  acknowledgement = ack-nhfb,
}

@Article{Cocke:1988:SPS,
  author =       "John Cocke",
  title =        "The search for performance in scientific processors:
                 the {Turing Award Lecture}",
  journal =      j-CACM,
  volume =       "31",
  number =       "3",
  pages =        "250--253",
  month =        mar,
  year =         "1988",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/42392.42394",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu May 30 09:41:10 MDT 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/42394.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "algorithms; design; experimentation; languages;
                 performance",
  remark =       "This is the 1987 ACM Turing Award Lecture.",
  review =       "ACM CR 8907-0507",
  subject =      "{\bf K.2}: Computing Milieux, HISTORY OF COMPUTING,
                 Systems. {\bf A.0}: General Literature, GENERAL,
                 Biographies/autobiographies. {\bf K.2}: Computing
                 Milieux, HISTORY OF COMPUTING, Hardware. {\bf C.4}:
                 Computer Systems Organization, PERFORMANCE OF SYSTEMS.
                 {\bf C.1.0}: Computer Systems Organization, PROCESSOR
                 ARCHITECTURES, General.",
}

@Article{Peled:1988:JCA,
  author =       "Abraham Peled",
  title =        "{John Cocke}: {The} 1987 {ACM A. M. Turing Award}
                 recipient",
  journal =      j-CACM,
  volume =       "31",
  number =       "3",
  pages =        "249--249",
  month =        mar,
  year =         "1988",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/42392.42393",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 22 07:12:04 MST 2001",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Misc/IMMD_IV.bib;
                 http://dblp.uni-trier.de/db/journals/cacm/cacm31.html#Peled88;
                 http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/42393.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "human factors",
  oldlabel =     "Peled88",
  subject =      "{\bf A.0}: General Literature, GENERAL,
                 Biographies/autobiographies. {\bf K.2}: Computing
                 Milieux, HISTORY OF COMPUTING.",
  XMLdata =      "ftp://ftp.informatik.uni-trier.de/pub/users/Ley/bib/records.tar.gz#journals/cacm/Peled88",
}

@Article{Sutherland:1989:M,
  author =       "I. E. Sutherland",
  title =        "Micropipelines",
  journal =      j-CACM,
  volume =       "32",
  number =       "6",
  pages =        "720--738",
  month =        jun,
  year =         "1989",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/63526.63532",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu May 30 09:41:10 MDT 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/63532.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "design; performance",
  remark =       "This is the 1988 ACM Turing Award Lecture. The 1989
                 ACM Turing Award was given to William Kahan, but his
                 lecture was never published.",
  subject =      "{\bf B.5.1}: Hardware, REGISTER-TRANSFER-LEVEL
                 IMPLEMENTATION, Design, Control design. {\bf B.5.1}:
                 Hardware, REGISTER-TRANSFER-LEVEL IMPLEMENTATION,
                 Design, Data-path design. {\bf B.5.1}: Hardware,
                 REGISTER-TRANSFER-LEVEL IMPLEMENTATION, Design, Styles.
                 {\bf B.1.1}: Hardware, CONTROL STRUCTURES AND
                 MICROPROGRAMMING, Control Design Styles, Hardwired
                 control. {\bf B.7.1}: Hardware, INTEGRATED CIRCUITS,
                 Types and Design Styles, VLSI (very large scale
                 integration).",
}

@TechReport{Kahan:1990:BPA,
  author =       "W. Kahan",
  title =        "Better to prescribe arithmetic than describe it",
  institution =  inst-BERKELEY-CS,
  address =      inst-BERKELEY-CS:adr,
  day =          "21",
  month =        feb,
  year =         "1990",
  bibdate =      "Mon Apr 25 18:24:02 2005",
  bibsource =    "ftp://ftp.math.utah.edu/pub/bibnet/subjects/acc-stab-num-alg.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "Turing Award Lecture presented at the ACM 18th Annual
                 Computer Science Conference on Cooperation, February
                 20--22, 1990, Sheraton Washington Hotel, Washington,
                 DC, USA, but never published. Some material from this
                 talk appears in later publications by W. Kahan.",
  URL =          "http://www.math.utah.edu/pub/bibnet/authors/k/kahan-william-m.html",
  acknowledgement = ack-nhfb,
  mynote =       "Same talk given at Toronto 10 April 1990.",
}

@Article{Corbato:1991:BSW,
  author =       "Fernando J. Corbat{\'o}",
  title =        "On building systems that will fail",
  journal =      j-CACM,
  volume =       "34",
  number =       "9",
  pages =        "72--81",
  month =        sep,
  year =         "1991",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/114669.114686",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu May 30 09:41:10 MDT 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/114686.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "design; human factors; management; performance;
                 reliability; security",
  remark =       "This is the 1990 ACM Turing Award Lecture.",
  subject =      "{\bf C.4}: Computer Systems Organization, PERFORMANCE
                 OF SYSTEMS, Reliability, availability, and
                 serviceability. {\bf C.2.0}: Computer Systems
                 Organization, COMPUTER-COMMUNICATION NETWORKS, General.
                 {\bf K.6.1}: Computing Milieux, MANAGEMENT OF COMPUTING
                 AND INFORMATION SYSTEMS, Project and People Management.
                 {\bf D.4.5}: Software, OPERATING SYSTEMS,
                 Reliability.",
}

@Article{Frenkel:1991:IFJ,
  author =       "Karen A. Frenkel",
  title =        "An Interview with {Fernando Jos{\'e} Corbat{\'o}}",
  journal =      j-CACM,
  volume =       "34",
  number =       "9",
  pages =        "82--90",
  month =        sep,
  year =         "1991",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/114669.114688",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Sat Apr 06 08:06:44 1996",
  bibsource =    "ftp://ftp.ira.uka.de/pub/bibliography/Misc/IMMD_IV.bib;
                 http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/114688.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "design; human factors; management; performance;
                 reliability",
  subject =      "{\bf K.2}: Computing Milieux, HISTORY OF COMPUTING.
                 {\bf C.4}: Computer Systems Organization, PERFORMANCE
                 OF SYSTEMS. {\bf C.2.0}: Computer Systems Organization,
                 COMPUTER-COMMUNICATION NETWORKS, General. {\bf D.4.0}:
                 Software, OPERATING SYSTEMS, General.",
}

@Article{Frenkel:1993:IRM,
  author =       "Karen A. Frenkel",
  title =        "An interview with {Robin Milner}",
  journal =      j-CACM,
  volume =       "36",
  number =       "1",
  pages =        "90--97",
  month =        jan,
  year =         "1993",
  CODEN =        "CACMA2",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu May 30 09:41:10 MDT 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/151241.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "theory",
  subject =      "{\bf F.0}: Theory of Computation, GENERAL. {\bf K.2}:
                 Computing Milieux, HISTORY OF COMPUTING, People.",
}

@Article{Milner:1993:EIT,
  author =       "Robin Milner",
  title =        "Elements of interaction: {Turing Award Lecture}",
  journal =      j-CACM,
  volume =       "36",
  number =       "1",
  pages =        "78--89",
  month =        jan,
  year =         "1993",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/151233.151240",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu May 30 09:41:10 MDT 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/151240.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "languages; theory",
  remark =       "This is the 1991 ACM Turing Award Lecture.",
  subject =      "{\bf D.3.1}: Software, PROGRAMMING LANGUAGES, Formal
                 Definitions and Theory, Semantics. {\bf D.3.2}:
                 Software, PROGRAMMING LANGUAGES, Language
                 Classifications, Concurrent, distributed, and parallel
                 languages. {\bf F.1.2}: Theory of Computation,
                 COMPUTATION BY ABSTRACT DEVICES, Modes of Computation,
                 Parallelism and concurrency. {\bf F.3.2}: Theory of
                 Computation, LOGICS AND MEANINGS OF PROGRAMS, Semantics
                 of Programming Languages, Algebraic approaches to
                 semantics. {\bf F.3.3}: Theory of Computation, LOGICS
                 AND MEANINGS OF PROGRAMS, Studies of Program
                 Constructs, Control primitives. {\bf F.3.3}: Theory of
                 Computation, LOGICS AND MEANINGS OF PROGRAMS, Studies
                 of Program Constructs, Functional constructs. {\bf
                 F.4.1}: Theory of Computation, MATHEMATICAL LOGIC AND
                 FORMAL LANGUAGES, Mathematical Logic, Lambda calculus
                 and related systems.",
}

@Article{Hartmanis:1994:TAL,
  author =       "Juris Hartmanis",
  title =        "{Turing Award Lecture}: On Computational Complexity
                 and the Nature of Computer Science",
  journal =      j-CACM,
  volume =       "37",
  number =       "10",
  pages =        "37--43",
  month =        oct,
  year =         "1994",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/194313.214781",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Sat Apr 06 08:07:15 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/214781.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "human factors; theory",
  remark =       "This is part one of the 1993 ACM Turing Award
                 Lecture.",
  subject =      "{\bf F.0}: Theory of Computation, GENERAL. {\bf K.2}:
                 Computing Milieux, HISTORY OF COMPUTING, People.",
}

@Article{Stearns:1994:TAL,
  author =       "Richard Edwin Stearns",
  title =        "{Turing} Award Lecture: It's Time to Reconsider Time",
  journal =      j-CACM,
  volume =       "37",
  number =       "11",
  pages =        "95--99",
  month =        nov,
  year =         "1994",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/188280.188379",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Sat Apr 06 08:07:20 1996",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/0001-0782/188379.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "algorithms; measurement; performance; theory",
  remark =       "This is part two of the 1993 ACM Turing Award
                 Lecture.",
  subject =      "{\bf F.1.3}: Theory of Computation, COMPUTATION BY
                 ABSTRACT DEVICES, Complexity Classes. {\bf F.0}: Theory
                 of Computation, GENERAL.",
}

@Article{Feigenbaum:1996:TAL,
  author =       "Edward A. Feigenbaum",
  title =        "{Turing Award Lecture}: How the ``What'' Becomes the
                 ``How''",
  journal =      j-CACM,
  volume =       "39",
  number =       "5",
  pages =        "97--104",
  month =        may,
  year =         "1996",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/229459.229471",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 6 09:19:11 MST 1997",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/cacm/229471.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  remark =       "This is part one of the 1995 ACM Turing Award
                 Lecture.",
  subject =      "{\bf I.2.1}: Computing Methodologies, ARTIFICIAL
                 INTELLIGENCE, Applications and Expert Systems. {\bf
                 F.1.1}: Theory of Computation, COMPUTATION BY ABSTRACT
                 DEVICES, Models of Computation, Bounded-action devices.
                 {\bf I.2.0}: Computing Methodologies, ARTIFICIAL
                 INTELLIGENCE, General.",
}

@Article{Reddy:1996:TAL,
  author =       "Raj Reddy",
  title =        "{Turing Award Lecture}: To Dream The Possible Dream",
  journal =      j-CACM,
  volume =       "39",
  number =       "5",
  pages =        "105--112",
  month =        may,
  year =         "1996",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/229459.233436",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Mon Jan 6 09:19:11 MST 1997",
  bibsource =    "http://www.acm.org/pubs/toc/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/pubs/toc/Abstracts/cacm/233436.html",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "algorithms; humanfactors",
  remark =       "This is part two of the 1995 ACM Turing Award
                 Lecture.",
  subject =      "{\bf I.2.0}: Computing Methodologies, ARTIFICIAL
                 INTELLIGENCE, General. {\bf I.2.6}: Computing
                 Methodologies, ARTIFICIAL INTELLIGENCE, Learning.",
}

@InProceedings{Pnueli:1997:MTA,
  author =       "Amir Pnueli",
  title =        "{A. M. Turing Award Lecture}: Verification
                 engineering: a future profession",
  crossref =     "ACM:1997:PSA",
  pages =        "7--7",
  year =         "1997",
  DOI =          "https://doi.org/10.1145/259380.259407",
  bibdate =      "Sat Nov 19 08:36:36 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "This is the 1996 ACM Turing Award Lecture, but only
                 the abstract is published.",
  acknowledgement = ack-nhfb,
}

@Misc{Engelbart:1998:CIF,
  author =       "Douglas Engelbart",
  title =        "Collective {IQ} and a Framework for Bootstrapping our
                 Society --- {ACM Turing Award Lecture}",
  howpublished = "Talk at 1998 ACM Conference on Computer Supported
                 Cooperative Work (CSCW'98), Seattle, Washington, USA.
                 Also presented June 24, 1998 at Hypertext (HT'98) and
                 Digital Libraries (DL'98) combined conference, Marriott
                 City Center, Pittsburgh, PA, USA, but does not appear
                 in the proceedings of either conference",
  month =        nov,
  year =         "1998",
  bibdate =      "Sat Nov 19 08:12:37 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/sigchi/cscw98/;
                 http://www.acm.org/sigchi/cscw98/program/plenaries.html#engelbart",
  acknowledgement = ack-nhfb,
  keywords =     "Mr. Mouse",
}

@Unpublished{Brooks:1999:DDA,
  author =       "Frederick P. {Brooks, Jr.}",
  title =        "The Design of Design: {ACM Turing Award Lecture}",
  year =         "1999",
  bibdate =      "Sat Nov 19 07:20:07 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  note =         "The Lecture was presented at the SIGGRAPH 2000
                 Conference. It was reported in \cite{Brooks:2002:IOS}
                 to appear in Communications of the ACM, but has yet to
                 be published.",
  URL =          "http://terra.cs.nps.navy.mil/DistanceEducation/online.siggraph.org/2001/SpecialSessions/2000TuringLecture-DesignOfDesign/session.html",
  acknowledgement = ack-nhfb,
}

@TechReport{Gray:1999:WND,
  author =       "Jim Gray",
  title =        "What next? {A} dozen remaining {IT} problems",
  type =         "Technical report",
  number =       "TR-99-50",
  institution =  "Microsoft Research",
  address =      "San Francisco, CA, USA",
  year =         "1999",
  bibdate =      "Fri Nov 18 20:10:25 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.research.microsoft.com/~gray/",
  note =         "Also presented at SIGMOD '99 Conference, Philadelphia,
                 PA, USA, June 1--3, 1999, but not published as a paper
                 in the proceedings. A video of the lecture is included
                 in the electronic proceedings \cite{Delis:1999:PAS},
                 but is not accessible without a SIGMOD Authenticator
                 username and password.",
  URL =          "ftp://ftp.research.microsoft.com/pub/tr/tr-99-50.pdf;
                 http://research.microsoft.com/scripts/pubs/view.asp?TR_ID=MSR-TR-99-50",
  acknowledgement = ack-nhfb,
}

@InProceedings{Brooks:2002:IOS,
  author =       "Frederick P. {Brooks, Jr.}",
  title =        "The {IBM Operating System\slash 360}",
  crossref =     "Broy:2002:SPC",
  pages =        "170--178",
  year =         "2002",
  bibdate =      "Sat Nov 19 07:28:29 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
}

@Misc{Madsen:2002:SSO,
  author =       "Ole Lehrmann Madsen",
  title =        "The {Scandinavian School of Object-Orientation --- in
                 memory of Ole-Johan Dahl and Kristen Nygaard}",
  howpublished = "OOPSLA 2002 talk.",
  day =          "7",
  month =        nov,
  year =         "2002",
  bibdate =      "Sat Nov 19 07:34:38 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://heim.ifi.uio.no/~kristen/;
                 http://oopsla.acm.org/oopsla2002/fp/files/spe-concepts.html;
                 http://www.ifi.uio.no/in_memoriam_kristen/;
                 http://www.interesting-people.org/archives/interesting-people/200208/msg00032.html",
  abstract =     "Ole-Johan Dahl and Kristen Nygaard---the founders of
                 object-oriented programming---passed away this summer
                 within just a few weeks of each other. The software
                 community has lost two great pioneers who, through
                 their collaboration in the 1960s leading to the Simula
                 language and object-oriented programming, have had
                 enormous influence on software technology. ``For their
                 role in the invention of object-oriented programming,
                 the most widely used programming model today,'' they
                 were given the A. M. Turing Award. (From the ACM press
                 release on February 6, 2002).\par

                 Kristen Nygaard was to give his Turing Award Lecture at
                 OOPSLA 2002 on Simula and its development. Simula was
                 originally designed as a simulation language, with the
                 purpose of supporting analysis of large and complex
                 systems. Because of this, the modelling capabilities of
                 languages always have been central to the Scandinavian
                 school of object orientation.",
  acknowledgement = ack-nhfb,
  subjectdates = "Ole-Johan Dahl (1931 -- June 29, 2002); Kristen
                 Nygaard (1926 -- August 10, 2002)",
}

@Misc{Adleman:2003:TLP,
  author =       "Leonard M. Adleman",
  title =        "{Turing Lecture} on Pre {RSA} Days",
  howpublished = "World-Wide Web slide presentation, video, and audio.",
  year =         "2003",
  bibdate =      "Sat Nov 19 07:46:28 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/turingawardlecture/RSA/",
  acknowledgement = ack-nhfb,
}

@Misc{Rivest:2003:TLE,
  author =       "Ronald L. Rivest",
  title =        "{Turing Lecture} on Early {RSA} Days",
  howpublished = "World-Wide Web slide presentation, video, and audio.",
  year =         "2003",
  bibdate =      "Sat Nov 19 07:46:28 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/turingawardlecture/RSA/",
  acknowledgement = ack-nhfb,
}

@Misc{Shamir:2003:TLC,
  author =       "Adi Shamir",
  title =        "{Turing Lecture} on Cryptology: a Status Report",
  howpublished = "World-Wide Web slide presentation, video, and audio.",
  year =         "2003",
  bibdate =      "Sat Nov 19 07:46:28 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/turingawardlecture/RSA/",
  acknowledgement = ack-nhfb,
}

@Misc{Kay:2004:ATL,
  author =       "Alan Kay",
  title =        "{ACM Turing Lecture}: Introductions To Computing
                 Should Be Child's Play",
  howpublished = "World-Wide Web document.",
  day =          "26",
  month =        oct,
  year =         "2004",
  bibdate =      "Sat Nov 19 07:53:20 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.oopsla.org/2004/ShowEvent.do?id=421",
  abstract =     "Perhaps the most disturbing ``trend which became
                 reality'' over the last 25 years has been a
                 recharacterization and professing of the various
                 computing fields as though Computer Science and
                 Software Engineering have actually been invented and
                 can be taught in ways that parallel fields such as
                 physics and structural engineering. This is ``science
                 \& engineering envy'' pure and simple!\par

                 The result is that so much of what is taught in high
                 schools and universities looks backwards?not for
                 historical interest, which is almost absent, or even to
                 great ideas of the past?but (a) to emphasize what all
                 too often have been workarounds for what we don't yet
                 know how to do, and (b) to substitute vocational
                 training for real knowledge and perspective.\par

                 One of the most interesting characteristics of
                 computing in the best universities of the 1960s was
                 that the professors told the students that nothing much
                 of importance was known, and it was the duty of all to
                 try to invent a real computing science and software
                 engineering. This was a very healthy attitude and led
                 to many good starts towards qualitatively better
                 approaches to our exciting area of interest. Just as
                 ``civilization'' is not a place or state, but a process
                 of people who are trying to be more civilized, real
                 computing is the process of people trying to make a
                 better notion of computing. The most progress will be
                 made by young people who have been encouraged to
                 criticize old conceptions and invent new ones with an
                 elevated notion of what constitutes a high threshold
                 for a good idea.\par

                 It is the duty of all enfranchised computerists to help
                 this happen. Since our paths of thinking are so
                 conditioned by the early environments we put so much
                 effort into learning, it is of critical importance to
                 pay the highest attention to the introductions to our
                 field for children, young adults and college students.
                 This talk is about how we might introduce computing to
                 beginners to help them see the real beauties and
                 possibilities of our field in a way that will both get
                 them fluent in the small amout of good stuff that is
                 known, and most importantly to encourage them to make
                 qualitative improvements in computing.",
  acknowledgement = ack-nhfb,
}

@Misc{Cerf:2005:ATL,
  author =       "Vinton Cerf and Robert Kahn",
  title =        "{ACM Turing Lecture}: Assessing the {Internet}:
                 Lessons Learned, Strategies for Evolution, and Future
                 Possibilities",
  howpublished = "World-Wide Web document",
  day =          "22",
  month =        aug,
  year =         "2005",
  bibdate =      "Sat Nov 19 08:06:33 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://beansidhe.isc-net.upenn.edu:8080/ramgen/seas/Turing.rm;
                 http://www.sigcomm.org/sigcomm2005/turinglecture.html;
                 http://www.sigcomm.org/sigcomm2005/webcast.html",
  acknowledgement = ack-nhfb,
}

@Article{Clarke:2009:MCA,
  author =       "Edmund M. Clarke and E. Allen Emerson and Joseph
                 Sifakis",
  title =        "Model checking: algorithmic verification and
                 debugging",
  journal =      j-CACM,
  volume =       "52",
  number =       "11",
  pages =        "74--84",
  month =        nov,
  year =         "2009",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1592761.1592781",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Fri Oct 23 15:03:46 MDT 2009",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Turing Lecture from the winners of the 2007 ACM A. M.
                 Turing Award.

                 In 1981, Edmund M. Clarke and E. Allen Emerson, working
                 in the USA, and Joseph Sifakis working independently in
                 France, authored seminal papers that founded what has
                 become the highly successful field of model checking.
                 This verification technology provides an algorithmic
                 means of determining whether an abstract
                 model---representing, for example, a hardware or
                 software design---satisfies a formal specification
                 expressed as a temporal logic (TL) formula. Moreover,
                 if the property does not hold, the method identifies a
                 counterexample execution that shows the source of the
                 problem.

                 The progression of model checking to the point where it
                 can be successfully used for complex systems has
                 required the development of sophisticated means of
                 coping with what is known as the state explosion
                 problem. Great strides have been made on this problem
                 over the past 28 years by what is now a very large
                 international research community. As a result many
                 major hardware and software companies are beginning to
                 use model checking in practice. Examples of its use
                 include the verification of VLSI circuits,
                 communication protocols, software device drivers,
                 real-time embedded systems, and security
                 algorithms.

                 The work of Clarke, Emerson, and Sifakis continues to
                 be central to the success of this research area. Their
                 work over the years has led to the creation of new
                 logics for specification, new verification algorithms,
                 and surprising theoretical results. Model checking
                 tools, created by both academic and industrial teams,
                 have resulted in an entirely novel approach to
                 verification and test case generation. This approach,
                 for example, often enables engineers in the electronics
                 industry to design complex systems with considerable
                 assurance regarding the correctness of their initial
                 designs. Model checking promises to have an even
                 greater impact on the hardware and software industries
                 in the future. --- {\em Moshe Y. Vardi,
                 Editor-in-Chief\/}",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Frenkel:2009:NLC,
  author =       "Karen A. Frenkel",
  title =        "News: {Liskov}'s creative joy",
  journal =      j-CACM,
  volume =       "52",
  number =       "7",
  pages =        "20--22",
  month =        jul,
  year =         "2009",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1538788.1538797",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Jul 2 16:54:21 MDT 2009",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Barbara Liskov muses about the creative process of
                 problem solving, finding the perfect design point, and
                 pursuing a research path.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Hoffmann:2009:LBQb,
  author =       "Leah Hoffmann",
  title =        "Last byte: {Q\&A}: {Liskov} on {Liskov}",
  journal =      j-CACM,
  volume =       "52",
  number =       "7",
  pages =        "120--ff",
  month =        jul,
  year =         "2009",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1538788.1538815",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Jul 2 16:54:21 MDT 2009",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Barbara Liskov talks about her ground breaking work in
                 data abstraction and distributed computing.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Staff:2009:NAA,
  author =       "{CACM Staff}",
  title =        "News: {ACM} award winners",
  journal =      j-CACM,
  volume =       "52",
  number =       "7",
  pages =        "25--25",
  month =        jul,
  year =         "2009",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1538788.1538799",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Jul 2 16:54:21 MDT 2009",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Among this year's distinguished honorees are Barbara
                 Liskov of Massachusetts Institute of Technology and Jon
                 Kleinberg of Cornell University.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Staff:2009:NLW,
  author =       "{CACM Staff}",
  title =        "News: {Liskov} wins {Turing Award}",
  journal =      j-CACM,
  volume =       "52",
  number =       "5",
  pages =        "21--21",
  month =        may,
  year =         "2009",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1506409.1506433",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Apr 23 12:42:30 MDT 2009",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "MIT's Barbara Liskov is the 55th person, and the
                 second woman, to win the ACM A. M. Turing Award.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Wright:2009:NCA,
  author =       "Alex Wright",
  title =        "News: Contemporary approaches to fault tolerance",
  journal =      j-CACM,
  volume =       "52",
  number =       "7",
  pages =        "13--15",
  month =        jul,
  year =         "2009",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1538788.1538794",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Jul 2 16:54:21 MDT 2009",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Thanks to computer scientists like Barbara Liskov,
                 researchers are making major progress with
                 cost-efficient fault tolerance for Web-based systems.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Anthes:2010:NCS,
  author =       "Gary Anthes",
  title =        "News: Committed to success",
  journal =      j-CACM,
  volume =       "53",
  number =       "7",
  pages =        "22--23",
  month =        jul,
  year =         "2010",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1785414.1785424",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Jul 15 17:10:30 MDT 2010",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Charles P. Thacker talks about the importance of
                 simplicity, reusable tools, thinking broadly, and his
                 practice of Tom Sawyering.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Hoffmann:2010:LBQ,
  author =       "Leah Hoffmann",
  title =        "Last byte: {Q\&A}",
  journal =      j-CACM,
  volume =       "53",
  number =       "7",
  pages =        "112, 111",
  month =        jul,
  year =         "2010",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1785414.1785444",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Thu Jul 15 17:10:30 MDT 2010",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  abstract =     "Charles P. Thacker discusses the legendary Alto
                 personal computer, the invention of the Ethernet, and
                 his current research on multicore architectures.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Misc{Thacker:2010:TLT,
  author =       "Charles P. Thacker",
  title =        "{Turing Lecture}: Trends in Computing Systems",
  howpublished = "Web video",
  year =         "2010",
  bibdate =      "Sat Aug 14 09:53:04 2010",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://awards.acm.org/turing/2009",
  acknowledgement = ack-nhfb,
}

@Article{Anthes:2011:BEL,
  author =       "Gary Anthes",
  title =        "Beauty and elegance: {Leslie Valiant} talks about
                 machine learning, parallel computing, and his quest for
                 simplicity",
  journal =      j-CACM,
  volume =       "54",
  number =       "6",
  pages =        "14--15",
  month =        jun,
  year =         "2011",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1953122.1953131",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed Jun 1 18:12:20 MDT 2011",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Hoffmann:2011:QLL,
  author =       "Leah Hoffmann",
  title =        "{Q\&A}: {A} Lifelong Learner: {Leslie Valiant}
                 discusses machine learning, parallel computing, and
                 computational neuroscience",
  journal =      j-CACM,
  volume =       "54",
  number =       "6",
  pages =        "128, 127",
  month =        jun,
  year =         "2011",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/1953122.1953152",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed Jun 1 18:12:20 MDT 2011",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Hyman:2012:HAT,
  author =       "Paul Hyman",
  title =        "In honor of {Alan Turing}",
  journal =      j-CACM,
  volume =       "55",
  number =       "9",
  pages =        "20--23",
  month =        sep,
  year =         "2012",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2330667.2330675",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Oct 23 06:56:18 MDT 2012",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/bibnet/authors/t/turing-alan-mathison.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  abstract =     "Thirty-two of the 39 living A. M. Turing Award
                 laureates gathered in San Francisco to pay tribute to
                 ``the father of CS'' and discuss the past, present, and
                 future of computing.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@PhdThesis{Nikiforova:2012:TAS,
  author =       "Irina Nikiforova",
  title =        "{Turing} award scientists: contribution and
                 recognition in computer science",
  type =         "Thesis ({Ph.D.})",
  school =       "Georgia Institute of Technology",
  address =      "Atlanta, GA, USA",
  pages =        "????",
  day =          "18",
  month =        may,
  year =         "2012",
  LCCN =         "T15.G45",
  bibdate =      "Thu Oct 1 07:53:46 MDT 2015",
  bibsource =    "fsz3950.oclc.org:210/WorldCat;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://hdl.handle.net/1853/44756",
  abstract =     "One of the most significant rewards in science is peer
                 recognition, often bestowed in the form of awards.
                 However, little is known about what sets apart
                 award-winning contributions, how award committees
                 determine prize-worthy contributions, and why some
                 scientists are more likely to be recognized than
                 others, particularly in the field of computer science.
                 Using a mixed method approach that includes qualitative
                 and quantitative techniques, this study investigates
                 the characteristics of award-winning contributions, and
                 the education and career factors associated with
                 recipients of the Turing Award, a Nobel equivalent
                 award in computer science, and compares them to those
                 of a matched group of non-winning scientists. In regard
                 to award-winning contributions, the study finds that
                 the Turing Committee was just as likely to recognize
                 contributions related to practice (``applied
                 research'') as to theory (``basic research''). In
                 regard to education and career factors, the study
                 reveals that neither scientific productivity nor the
                 quality of contributions differentiated winning from
                 non-winning scientists and their contributions.
                 However, early advantages, visibility to the awarding
                 association, prior eminence, and affiliation with a top
                 computer science department distinguished award
                 winners. These findings suggest that excellence in
                 computer science is a quality that has not been
                 defined, explained, or communicated by the award
                 committee to the computing community or to the public.
                 The findings call attention to the limitations of peer
                 reviews and the importance of improving the design of
                 nomination, evaluation, and selection procedures as
                 well as citations accompanying the Turing Award and
                 other computer science awards.",
  acknowledgement = ack-nhfb,
  remark =       "Committee Chair: Dr. Mary Frank Fox; Committee Member:
                 Dr. Amanda Damarin; Committee Member: Dr. Gerhard
                 Sonnert; Committee Member: Dr. John Walsh; Committee
                 Member: Dr. Kenneth Knoespel; Committee Member: Dr.
                 Wenda Bauchspies. Part of the SMARTech Electronic
                 Thesis and Dissertation Collection.",
  subject =      "Evaluation; Awards; Computer science; Evaluation.;
                 Awards.; Computer science.",
}

@Article{Savage:2012:GC,
  author =       "Neil Savage",
  title =        "Game changer",
  journal =      j-CACM,
  volume =       "55",
  number =       "6",
  pages =        "22--23",
  month =        jun,
  year =         "2012",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2184319.2184327",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed Jun 6 15:21:16 MDT 2012",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  abstract =     "Judea Pearl's passionate advocacy of the importance of
                 probability and causality helped revolutionize
                 artificial intelligence.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  remark =       "The journal issue cover is a portrait of Judea
                 Pearl.",
}

@Article{Cerf:2013:PHO,
  author =       "Vinton G. Cerf",
  title =        "From the {President}: Honoring our best",
  journal =      j-CACM,
  volume =       "56",
  number =       "6",
  pages =        "7--7",
  month =        jun,
  year =         "2013",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2461256.2461258",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Jun 18 16:08:03 MDT 2013",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "A. M. Turing Award; The Queen Elizabeth II Prize for
                 Engineering",
}

@Article{Hoffmann:2013:QCC,
  author =       "Leah Hoffmann",
  title =        "{Q\&A}: Cracking the Code",
  journal =      j-CACM,
  volume =       "56",
  number =       "6",
  pages =        "120--ff",
  month =        jun,
  year =         "2013",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2461256.2461281",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Jun 18 16:08:03 MDT 2013",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  abstract =     "Turing Award recipients Shafi Goldwasser and Silvio
                 Micali talk about proofs, probability, and poker.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "A. M. Turing Award recipients; Shafi Goldwasser;
                 Silvio Micali",
}

@Article{Savage:2013:PP,
  author =       "Neil Savage",
  title =        "Proofs probable",
  journal =      j-CACM,
  volume =       "56",
  number =       "6",
  pages =        "22--24",
  month =        jun,
  year =         "2013",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2461256.2461265",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Jun 18 16:08:03 MDT 2013",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  abstract =     "Shafi Goldwasser and Silvio Micali laid the
                 foundations for modern cryptography, with contributions
                 including interactive and zero-knowledge proofs.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  keywords =     "A. M. Turing Award recipients; Shafi Goldwasser;
                 Silvio Micali",
}

@Misc{ACM:2014:MLC,
  author =       "{ACM}",
  title =        "{Microsoft}'s {Lamport} Contributed to Theory and
                 Practice of Building Distributed Computing Systems that
                 Work",
  howpublished = "Web document",
  day =          "18",
  month =        mar,
  year =         "2014",
  bibdate =      "Tue Mar 18 08:35:04 2014",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/press-room/news-releases/2014/pdfs/turing-award-13b.pdf;
                 http://www.acm.org/press-room/news-releases/2014/pdfs/turing-award-lt-13a.pdf;
                 http://www.acm.org/press-room/news-releases/2014/turing-award-13/",
  acknowledgement = ack-nhfb,
}

@Article{ACM:2015:NPC,
  author =       "{ACM}",
  title =        "{``Nobel Prize in Computing''} goes to {MIT} Database
                 Systems Architecture Pioneer",
  journal =      "{R\&D} Magazine",
  volume =       "??",
  number =       "??",
  pages =        "??--??",
  day =          "25",
  month =        mar,
  year =         "2015",
  bibdate =      "Thu Mar 26 09:32:12 2015",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.scientificcomputing.com/news/2015/03/nobel-prize-computing-goes-mit-database-systems-architecture-pioneer",
  acknowledgement = ack-nhfb,
}

@Article{Fields:2015:CAP,
  author =       "Chris Fields",
  title =        "Co-authorship proximity of {A. M. Turing Award} and
                 {John von Neumann Medal} winners to the disciplinary
                 boundaries of computer science",
  journal =      j-SCIENTOMETRICS,
  volume =       "104",
  number =       "3",
  pages =        "809--825",
  month =        sep,
  year =         "2015",
  CODEN =        "SCNTDX",
  DOI =          "https://doi.org/10.1007/s11192-015-1575-9",
  ISSN =         "0138-9130 (print), 1588-2861 (electronic)",
  ISSN-L =       "0138-9130",
  bibdate =      "Wed Sep 2 12:06:14 MDT 2015",
  bibsource =    "http://www.math.utah.edu/pub/bibnet/authors/t/turing-alan-mathison.bib;
                 http://www.math.utah.edu/pub/bibnet/authors/v/von-neumann-john.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/scientometrics2010.bib",
  URL =          "http://link.springer.com/article/10.1007/s11192-015-1575-9",
  acknowledgement = ack-nhfb,
  fjournal =     "Scientometrics",
  journal-URL =  "http://link.springer.com/journal/11192",
}

@Article{Lamport:2015:TLC,
  author =       "Leslie Lamport",
  title =        "{Turing} lecture: {The} computer science of
                 concurrency: the early years",
  journal =      j-CACM,
  volume =       "58",
  number =       "6",
  pages =        "71--76",
  month =        jun,
  year =         "2015",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2771951",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed Jun 10 08:40:37 MDT 2015",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  URL =          "http://cacm.acm.org/magazines/2015/6/187316/fulltext",
  abstract =     "Leslie Lamport is the recipient of the 2013 ACM A. M.
                 Turing Award.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Misc{Shriver:2015:ATA,
  author =       "Bruce Shriver and Marie Gentile",
  title =        "{ACM Turing Award} Goes to Pioneer in Database Systems
                 Architecture: {MIT}'s {Stonebraker} Brought Relational
                 Database Systems from Concept to Commercial Success,
                 Set the Research Agenda for the Multibillion-Dollar
                 Database Field for Decades",
  howpublished = "Web document",
  day =          "25",
  month =        mar,
  year =         "2015",
  bibdate =      "Wed Mar 25 10:59:34 2015",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://amturing.acm.org/stonebraker_1172121.pdf",
  acknowledgement = ack-nhfb,
}

@Article{Hoffmann:2016:LBQb,
  author =       "Leah Hoffmann",
  title =        "Last byte: {Q\&A}: Finding new directions in
                 cryptography: {Whitfield Diffie} and {Martin Hellman}
                 on their meeting, their research, and the results that
                 billions use every day",
  journal =      j-CACM,
  volume =       "59",
  number =       "6",
  pages =        "112--ff",
  month =        jun,
  year =         "2016",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2911977",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed May 25 17:07:29 MDT 2016",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib;
                 http://www.math.utah.edu/pub/tex/bib/cryptography2010.bib",
  URL =          "http://cacm.acm.org/magazines/2016/6/202666/fulltext",
  abstract =     "Whitfield Diffie and Martin Hellman on their meeting,
                 their research, and the results that billions use every
                 day.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Misc{Ormond:2016:CPR,
  author =       "Jim Ormond",
  title =        "Cryptography Pioneers Receive {ACM A. M. Turing
                 Award}: {Diffie} and {Hellman}'s Invention of
                 Public-Key Cryptography and Digital Signatures
                 Revolutionized Computer Security and Made {Internet}
                 Commerce Possible",
  howpublished = "Web document",
  day =          "1",
  month =        mar,
  year =         "2016",
  bibdate =      "Tue Mar 01 11:55:25 2016",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cryptography2010.bib",
  URL =          "http://www.acm.org/media-center/2016/march/turing-award-2015",
  acknowledgement = ack-nhfb,
}

@Article{Savage:2016:NKP,
  author =       "Neil Savage",
  title =        "News: The key to privacy",
  journal =      j-CACM,
  volume =       "59",
  number =       "6",
  pages =        "12--14",
  month =        jun,
  year =         "2016",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2911979",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed May 25 17:07:29 MDT 2016",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  URL =          "http://cacm.acm.org/magazines/2016/6/202654/fulltext",
  abstract =     "40 years ago, Whitfield Diffie and Martin E. Hellman
                 introduced the public key cryptography used to secure
                 today's online transactions.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Stonebraker:2016:TLL,
  author =       "Michael Stonebraker",
  title =        "{Turing Lecture}: The land sharks are on the squawk
                 box",
  journal =      j-CACM,
  volume =       "59",
  number =       "2",
  pages =        "74--83",
  month =        feb,
  year =         "2016",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/2869958",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Feb 16 15:45:15 MST 2016",
  bibsource =    "http://www.acm.org/pubs/contents/journals/cacm/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  URL =          "http://cacm.acm.org/magazines/2016/2/197423/fulltext",
  abstract =     "It turns out riding across America is more than a
                 handy metaphor for building system software.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Hellman:2017:TLC,
  author =       "Martin E. Hellman",
  title =        "{Turing Lecture}: Cybersecurity, Nuclear Security,
                 {Alan Turing}, and Illogical Logic",
  journal =      j-CACM,
  volume =       "60",
  number =       "12",
  pages =        "52--59",
  month =        dec,
  year =         "2017",
  CODEN =        "CACMA2",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Wed Nov 29 18:47:03 MST 2017",
  bibsource =    "http://www.math.utah.edu/pub/bibnet/authors/t/turing-alan-mathison.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib;
                 http://www.math.utah.edu/pub/tex/bib/cryptography2010.bib",
  URL =          "https://cacm.acm.org/magazines/2017/12/223042-cybersecurity-nuclear-security-alan-turing-and-illogical-logic",
  abstract =     "Cyber deterrence, like nuclear deterrence, depends on
                 our adversaries being rational enough to be deterred by
                 our threats but us not by theirs.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
  remark =       "This 2015 Turing Award lecture is a 40-year
                 retrospective on the development of public-key
                 cryptography by Martin Hellman, Whitfield Diffie, and
                 Ralph Merkel, and the subsequent fight, against US
                 security agencies, for open publication of
                 cryptographic research. It also offers analogies
                 between cryptographic deterrence and security, and
                 nuclear deterrence and security.",
}

@Misc{Ormond:2017:IWW,
  author =       "Jim Ormond",
  title =        "Inventor of {World Wide Web} Receives {ACM A. M.
                 Turing Award}: {Sir Tim Berners-Lee} Designed
                 Integrated Architecture and Technologies that Underpin
                 the {Web}",
  howpublished = "ACM press release.",
  day =          "4",
  month =        apr,
  year =         "2017",
  bibdate =      "Tue Apr 04 09:46:44 2017",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "http://www.acm.org/media-center/2017/april/turing-award-2016",
  acknowledgement = ack-nhfb,
}

@Misc{Anonymous:2018:PMC,
  author =       "Anonymous",
  title =        "Pioneers of Modern Computer Architecture Receive {ACM
                 A. M. Turing Award}: {Hennessy} and {Patterson}'s
                 Foundational Contributions to Today's Microprocessors
                 Helped Usher in Mobile and {IoT} Revolutions",
  howpublished = "ACM press release.",
  day =          "21",
  month =        mar,
  year =         "2018",
  bibdate =      "Wed Mar 21 12:30:01 2018",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "https://amturing.acm.org/",
  acknowledgement = ack-nhfb,
}

@Article{Hoffmann:2018:LBR,
  author =       "Leah Hoffmann",
  title =        "Last byte: {RISC} management",
  journal =      j-CACM,
  volume =       "61",
  number =       "6",
  pages =        "104--ff",
  month =        jun,
  year =         "2018",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/3204453",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Jun 5 14:47:04 MDT 2018",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  URL =          "https://cacm.acm.org/magazines/2018/6/228042/fulltext",
  abstract =     "ACM A. M. Turing award recipients John Hennessy and
                 David Patterson have introduced generations of students
                 to reduced instruction set computing.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

@Article{Metz:2018:CCV,
  author =       "Cade Metz",
  title =        "Computer Chip Visionaries Win {Turing Award}",
  journal =      j-NY-TIMES,
  volume =       "??",
  number =       "??",
  pages =        "??--??",
  day =          "21",
  month =        mar,
  year =         "2018",
  CODEN =        "NYTIAO",
  ISSN =         "0362-4331 (print), 1542-667X, 1553-8095",
  ISSN-L =       "0362-4331",
  bibdate =      "Wed Mar 21 15:35:16 2018",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  URL =          "https://www.nytimes.com/2018/03/21/technology/computer-chips-turing-award.html",
  acknowledgement = ack-nhfb,
  fjournal =     "New York Times",
  journal-URL =  "http://www.nytimes.com/",
}

@Article{Savage:2018:NRR,
  author =       "Neil Savage",
  title =        "News: Rewarded for {RISC}",
  journal =      j-CACM,
  volume =       "61",
  number =       "6",
  pages =        "10--12",
  month =        jun,
  year =         "2018",
  CODEN =        "CACMA2",
  DOI =          "https://doi.org/10.1145/3204451",
  ISSN =         "0001-0782 (print), 1557-7317 (electronic)",
  ISSN-L =       "0001-0782",
  bibdate =      "Tue Jun 5 14:47:04 MDT 2018",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm2010.bib",
  URL =          "https://cacm.acm.org/magazines/2018/6/228029/fulltext",
  abstract =     "ACM A.M. Turing Award recipients David Patterson and
                 John Hennessy developed the ``dangerous'' idea that
                 software should be simpler so it can be executed more
                 quickly, which evolved into the Reduced Instruction Set
                 Computer architecture.",
  acknowledgement = ack-nhfb,
  fjournal =     "Communications of the ACM",
  journal-URL =  "http://portal.acm.org/browse_dl.cfm?idx=J79",
}

%%% ====================================================================
%%% Cross-referenced entries must come last:

@Book{Ashenhurst:1987:ATA,
  editor =       "Robert L. Ashenhurst",
  booktitle =    "{ACM Turing Award Lectures}: the first twenty years,
                 1966--1985",
  title =        "{ACM Turing Award Lectures}: the first twenty years,
                 1966--1985",
  publisher =    pub-ACM # " and " # pub-AW,
  address =      pub-ACM:adr # " and " # pub-AW:adr,
  pages =        "xviii + 483",
  year =         "1987",
  ISBN =         "0-201-07794-9",
  ISBN-13 =      "978-0-201-07794-0",
  LCCN =         "QA76.24 .A33 1987",
  bibdate =      "Tue Jun 21 11:01:04 2011",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 z3950.loc.gov:7090/Voyager",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  series =       "ACM Press anthology series",
  acknowledgement = ack-nhfb,
  subject =      "Electronic data processing; Computers",
  tableofcontents = "The synthesis of algorithmic systems / Alan J.
                 Perlis \\
                 Computers then and now / Maurice V. Wilkes \\
                 One man's view of computer science / R. W. Hamming \\
                 Form and content in computer science / Marvin Minsky
                 \\
                 Some comments from a numerical analyst / J. H.
                 Wilkinson \\
                 Generality in artificial intelligence / John McCarthy
                 \\
                 The humble programmer / Edsger W. Dijkstra \\
                 The programmer as navigator / Charles W. Bachman \\
                 Computer programming as an art / Donald E. Knuth \\
                 Computer science as empirical inquiry: symbols and
                 search / Allen Newell and Herbert A. Simon \\
                 Complexity of computations / Michael O. Rabin \\
                 Logic and programming languages / Dana S. Scott \\
                 Can programming be liberated from the von Neumann
                 style?: a functional style and its algebra of programs
                 / John Backus \\
                 The paradigms of programming / Robert W. Floyd \\
                 Notation as a tool of thought / Kenneth E. Iverson \\
                 The emperor's old clothes / Charles Antony Richard
                 Hoare \\
                 Relational database: a practical foundation for
                 productivity / E. F. Codd \\
                 An overview of computational complexity / Stephen A.
                 Cook \\
                 Reflections on software research / Dennis M. Ritchie
                 \\
                 Reflections on trusting trust / Ken Thompson \\
                 From programming language design to computer
                 construction / Niklaus Wirth \\
                 Combinatorics, complexity, and randomness / Richard M.
                 Karp \\
                 Algorithm design / Robert E. Tarjan \\
                 Computer science: the emergence of a discipline / John
                 E. Hopcroft \\
                 The search for performance in scientific processors /
                 John Cocke \\
                 Micropipelines / Ivan E. Sutherland \\
                 On building systems that will fail / Fernando J.
                 Corbat{\'o} \\
                 Elements of interaction / Robin Milner \\
                 Turing Award Lecture: it's time to reconsider time /
                 Richard Edwin Stearns \\
                 Turing Award Lecture: on computational complexity and
                 the nature of computer science / Juris Hartmanis \\
                 How the `what' becomes the `how' / Edward A. Feigenbaum
                 \\
                 To dream the possible dream / Raj Reddy \\
                 The Early Days of RSA: History and Lessons / Ronald L.
                 Rivest \\
                 Pre-RSA Days: History and Lessons / Leonard Adleman \\
                 Cryptography: State of the science / Adi Shamir \\
                 Turing Award Lecture / Alan Kay \\
                 Assessing the Internet: Lessons Learned, Strategies for
                 Evolution, and Future Possibilities / Vinton Cerf,
                 Robert E. Kahn \\
                 Computing vs. Human Thinking / Peter Naur \\
                 Compiling for Performance: A Personal Tour / Frances
                 Allen \\
                 Model checking: my 27-year quest to overcome the state
                 explosion problem / Edmund M. Clarke \\
                 Model checking: A Personal Perspective / E. Allen
                 Emerson \\
                 The Quest for Correctness Beyond Verification / Joseph
                 Sifakis \\
                 The Power of Abstraction / Barbara Liskov \\
                 Improving the Future by Examining the Past / Charles P.
                 Thacker",
}

@Book{Knuth:1992:LP,
  author =       "Donald E. Knuth",
  title =        "Literate Programming",
  volume =       "27",
  publisher =    pub-SUCSLI,
  address =      pub-SUCSLI:adr,
  pages =        "xv + 368",
  year =         "1992",
  ISBN =         "0-937073-80-6 (paperback), 0-937073-81-4 (hardcover)",
  ISBN-13 =      "978-0-937073-80-3 (paperback), 978-0-937073-81-0
                 (hardcover)",
  LCCN =         "QA76.6.K644",
  bibdate =      "Tue Mar 03 12:24:41 1998",
  bibsource =    "http://www.math.utah.edu/pub/bibnet/authors/d/dijkstra-edsger-w.bib;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm1970.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm1980.bib;
                 http://www.math.utah.edu/pub/tex/bib/css.bib;
                 http://www.math.utah.edu/pub/tex/bib/litprog.bib;
                 http://www.math.utah.edu/pub/tex/bib/master.bib;
                 http://www.math.utah.edu/pub/tex/bib/spell.bib;
                 http://www.math.utah.edu/pub/tex/bib/texbook3.bib",
  series =       "CSLI Lecture Notes",
  URL =          "http://csli-www.stanford.edu/publications/literate.html",
  acknowledgement = ack-nhfb,
  keywords =     "electronic digital computers --- programming",
  remark =       "See translation \cite{Knuth:1994:BP}.",
  tableofcontents = "1: Computer programming as an art / 1 \\
                 2: Structured programming with go to statements / 17
                 \\
                 3: A structured program to generate all topological
                 sorting arrangements / 91 \\
                 4: Literate programming / 99 \\
                 5: Programming pearls: Sampling / 137 \\
                 6: Programming pearls, continued: Common Words / 151
                 \\
                 7: How to read a WEB / 179 \\
                 8: Excerpts from the programs for \TeX{} and METAFONT /
                 185 \\
                 9: Mathematical writing / 235 \\
                 10: Errors of \TeX{} / 243 \\
                 11: Error log of \TeX{} / 293 \\
                 12: Example of CWEB / 341 \\
                 Further Reading / 349 \\
                 Index / 359",
}

@Proceedings{ACM:1997:PSA,
  editor =       "{ACM}",
  booktitle =    "{Proceedings of the sixteenth annual ACM symposium on
                 Principles of distributed computing 1997, Santa
                 Barbara, California, USA, August 21--24, 1997}",
  title =        "{Proceedings of the sixteenth annual ACM symposium on
                 Principles of distributed computing 1997, Santa
                 Barbara, California, USA, August 21--24, 1997}",
  publisher =    pub-ACM,
  address =      pub-ACM:adr,
  pages =        "viii + 297",
  year =         "1997",
  ISBN =         "0-89791-952-1",
  ISBN-13 =      "978-0-89791-952-4",
  LCCN =         "QA76.9.D5 A33 1997",
  bibdate =      "Sat Nov 19 08:33:14 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 z3950.loc.gov:7090/Voyager",
  note =         "ACM order number 536970.",
  acknowledgement = ack-nhfb,
  subject =      "Electronic data processing; Distributed processing;
                 Congresses",
}

@Proceedings{Delis:1999:PAS,
  editor =       "Alex Delis and Christos Faloutsos and Shahram
                 Ghandeharizadeh",
  booktitle =    "Proceedings of the 1999 ACM SIGMOD International
                 Conference on Management of Data: SIGMOD '99,
                 Philadelphia, PA, USA, June 1--3, 1999",
  title =        "Proceedings of the 1999 {ACM} {SIGMOD} International
                 Conference on Management of Data: {SIGMOD} '99,
                 Philadelphia, {PA}, {USA}, June 1--3, 1999",
  volume =       "28(2)",
  publisher =    pub-ACM,
  address =      pub-ACM:adr,
  pages =        "xii + 602",
  year =         "1999",
  ISBN =         "????",
  ISBN-13 =      "????",
  ISSN =         "0163-5808 (print), 1943-5835 (electronic)",
  LCCN =         "QA1 .A87",
  bibdate =      "Wed Oct 25 08:47:40 MDT 2000",
  bibsource =    "http://www.acm.org/pubs/contents/proceedings/series/sigmod_pods/;
                 http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib",
  series =       j-SIGMOD,
  URL =          "http://www.sigmod.org/sigmod/disc/m_plenary_talks.htm;
                 http://www.sigmod.org/sigmod/disc/m_search.htm",
  acknowledgement = ack-nhfb,
  keywords =     "SIGMOD '99",
}

@Proceedings{Broy:2002:SPC,
  editor =       "M. Broy and Ernst Denert",
  booktitle =    "Software pioneers: contributions to software
                 engineering",
  title =        "Software pioneers: contributions to software
                 engineering",
  publisher =    pub-SV,
  address =      pub-SV:adr,
  pages =        "728",
  year =         "2002",
  ISBN =         "3-540-43081-4",
  ISBN-13 =      "978-3-540-43081-0",
  LCCN =         "QA76.2.A2 S62 2002",
  bibdate =      "Sat Nov 19 07:27:22 MST 2005",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 z3950.loc.gov:7090/Voyager",
  acknowledgement = ack-nhfb,
  remark =       "Based on a conference organized by sd and m in Bonn,
                 Germany, June 2001.",
  subject =      "Computers; Biography; Electronic data processing
                 personnel; Biography; Software engineering; History",
}

@PhdThesis{Wheeler:2009:FCT,
  author =       "David A. Wheeler",
  title =        "Fully Countering Trusting Trust through Diverse
                 Double-Compiling",
  type =         "{Ph.D.} dissertation",
  school =       "George Mason University",
  address =      "Fairfax, VA, USA",
  month =        "Fall",
  year =         "2009",
  bibdate =      "Thu Nov 30 18:23:48 2017",
  bibsource =    "http://www.math.utah.edu/pub/tex/bib/acm-turing-awards.bib;
                 http://www.math.utah.edu/pub/tex/bib/cacm1980.bib",
  URL =          "https://www.dwheeler.com/trusting-trust",
  acknowledgement = ack-nhfb,
  remark =       "This dissertation addresses the hard-to-detect attack
                 described in Ken Thompson's 1984 ACM Turing Award
                 lecture \cite{Thompson:1984:RTT}.",
}{% endraw %}
```

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.20.0/themes/prism.min.css"
      integrity="sha512-WERl1x0JzN/zpqp4wEdPaj46VQN53xCySFEtgv+Tl8y52McULwF2pkzBmAH35xJqkDiCmlyeWx0U1khsU10ydw==" crossorigin="anonymous" />

<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.20.0/prism.min.js"
        integrity="sha512-rYNMWcr8EuYc/6mSBu0wD+hSoA4KkHvYRlmJEJGQI4bsho0OiX8fPOVB822QQZizkTUdkUCnJLnN8SAUBg9y9w==" crossorigin="anonymous">
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.20.0/plugins/autolinker/prism-autolinker.min.js"
        integrity="sha512-/uypNVmpEQdCQLYz3mq7J2HPBpHkkg23FV4i7/WSUyEuTJrWJ2uZ3gXx1IBPUyB3qbIAY+AODbanXLkIar0NBQ==" crossorigin="anonymous">
</script>

<script src="https://cdn.jsdelivr.net/npm/prismjs-bibtex@2.1.0/prism-bibtex.js"
        integrity="sha256-A5GMUmGHpY8mVpfcaRLQFeHtmdjZLumKBOMpf81FXX0="
        crossorigin="anonymous" referrerpolicy="no-referrer">
</script>
