; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le-unknown-linux-gnu | FileCheck %s

declare { i8, i1 } @llvm.sadd.with.overflow.i8(i8, i8) nounwind readnone
declare { i16, i1 } @llvm.sadd.with.overflow.i16(i16, i16) nounwind readnone
declare { i32, i1 } @llvm.sadd.with.overflow.i32(i32, i32) nounwind readnone
declare { i64, i1 } @llvm.sadd.with.overflow.i64(i64, i64) nounwind readnone
declare { <4 x i32>, <4 x i1> } @llvm.sadd.with.overflow.v4i32(<4 x i32>, <4 x i32>) nounwind readnone
declare { i8, i1 } @llvm.ssub.with.overflow.i8(i8, i8) nounwind readnone
declare { i16, i1 } @llvm.ssub.with.overflow.i16(i16, i16) nounwind readnone
declare { i32, i1 } @llvm.ssub.with.overflow.i32(i32, i32) nounwind readnone
declare { i64, i1 } @llvm.ssub.with.overflow.i64(i64, i64) nounwind readnone
declare { <4 x i32>, <4 x i1> } @llvm.ssub.with.overflow.v4i32(<4 x i32>, <4 x i32>) nounwind readnone

define i1 @test_saddo_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: test_saddo_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    add 3, 3, 4
; CHECK-NEXT:    extsb 4, 3
; CHECK-NEXT:    cmpw 4, 3
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    iseleq 3, 0, 3
; CHECK-NEXT:    blr
entry:
  %res = call { i8, i1 } @llvm.sadd.with.overflow.i8(i8 %a, i8 %b) nounwind
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_saddo_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: test_saddo_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh 4, 4
; CHECK-NEXT:    extsh 3, 3
; CHECK-NEXT:    add 3, 3, 4
; CHECK-NEXT:    extsh 4, 3
; CHECK-NEXT:    cmpw 4, 3
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    iseleq 3, 0, 3
; CHECK-NEXT:    blr
entry:
  %res = call { i16, i1 } @llvm.sadd.with.overflow.i16(i16 %a, i16 %b) nounwind
  %overflow = extractvalue { i16, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_saddo_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: test_saddo_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor 5, 3, 4
; CHECK-NEXT:    add 4, 3, 4
; CHECK-NEXT:    xor 3, 4, 3
; CHECK-NEXT:    andc 3, 3, 5
; CHECK-NEXT:    srwi 3, 3, 31
; CHECK-NEXT:    blr
entry:
  %res = call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 %a, i32 %b) nounwind
  %overflow = extractvalue { i32, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_saddo_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: test_saddo_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor 5, 3, 4
; CHECK-NEXT:    add 4, 3, 4
; CHECK-NEXT:    xor 3, 4, 3
; CHECK-NEXT:    andc 3, 3, 5
; CHECK-NEXT:    rldicl 3, 3, 1, 63
; CHECK-NEXT:    blr
entry:
  %res = call { i64, i1 } @llvm.sadd.with.overflow.i64(i64 %a, i64 %b) nounwind
  %overflow = extractvalue { i64, i1 } %res, 1
  ret i1 %overflow
}

define <4 x i1> @test_saddo_v4i32(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: test_saddo_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vaddsws 4, 2, 3
; CHECK-NEXT:    vadduwm 2, 2, 3
; CHECK-NEXT:    vcmpequw 2, 2, 4
; CHECK-NEXT:    xxlnor 34, 34, 34
; CHECK-NEXT:    blr
entry:
  %res = call { <4 x i32>, <4 x i1> } @llvm.sadd.with.overflow.v4i32(<4 x i32> %a, <4 x i32> %b) nounwind
  %overflow = extractvalue { <4 x i32>, <4 x i1> } %res, 1
  ret <4 x i1> %overflow
}

define i1 @test_ssubo_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: test_ssubo_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    extsb 4, 4
; CHECK-NEXT:    sub 3, 3, 4
; CHECK-NEXT:    extsb 4, 3
; CHECK-NEXT:    cmpw 4, 3
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    iseleq 3, 0, 3
; CHECK-NEXT:    blr
entry:
  %res = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 %b) nounwind
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_ssubo_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: test_ssubo_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh 3, 3
; CHECK-NEXT:    extsh 4, 4
; CHECK-NEXT:    sub 3, 3, 4
; CHECK-NEXT:    extsh 4, 3
; CHECK-NEXT:    cmpw 4, 3
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    iseleq 3, 0, 3
; CHECK-NEXT:    blr
entry:
  %res = call { i16, i1 } @llvm.ssub.with.overflow.i16(i16 %a, i16 %b) nounwind
  %overflow = extractvalue { i16, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_ssubo_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: test_ssubo_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor 5, 4, 3
; CHECK-NEXT:    sub 4, 3, 4
; CHECK-NEXT:    xor 3, 4, 3
; CHECK-NEXT:    and 3, 5, 3
; CHECK-NEXT:    srwi 3, 3, 31
; CHECK-NEXT:    blr
entry:
  %res = call { i32, i1 } @llvm.ssub.with.overflow.i32(i32 %a, i32 %b) nounwind
  %overflow = extractvalue { i32, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_ssubo_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: test_ssubo_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor 5, 4, 3
; CHECK-NEXT:    sub 4, 3, 4
; CHECK-NEXT:    xor 3, 4, 3
; CHECK-NEXT:    and 3, 5, 3
; CHECK-NEXT:    rldicl 3, 3, 1, 63
; CHECK-NEXT:    blr
entry:
  %res = call { i64, i1 } @llvm.ssub.with.overflow.i64(i64 %a, i64 %b) nounwind
  %overflow = extractvalue { i64, i1 } %res, 1
  ret i1 %overflow
}

define <4 x i1> @test_ssubo_v4i32(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: test_ssubo_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsubsws 4, 2, 3
; CHECK-NEXT:    vsubuwm 2, 2, 3
; CHECK-NEXT:    vcmpequw 2, 2, 4
; CHECK-NEXT:    xxlnor 34, 34, 34
; CHECK-NEXT:    blr
entry:
  %res = call { <4 x i32>, <4 x i1> } @llvm.ssub.with.overflow.v4i32(<4 x i32> %a, <4 x i32> %b) nounwind
  %overflow = extractvalue { <4 x i32>, <4 x i1> } %res, 1
  ret <4 x i1> %overflow
}
