; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -mtriple=powerpc64le-unknown-linux-gnu < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-LE-P9
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -mtriple=powerpc64-unknown-linux-gnu < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-BE-P9
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:    -mtriple=powerpc64-ibm-aix < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-AIX-64-P9

define noundef i32 @_Z11memcmp_testPKvS0_m(ptr noundef readonly captures(none) %ptr1, ptr noundef readonly captures(none) %ptr2, i64 noundef %num) nounwind {
; CHECK-LE-P9-LABEL: _Z11memcmp_testPKvS0_m:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mflr r0
; CHECK-LE-P9-NEXT:    stdu r1, -32(r1)
; CHECK-LE-P9-NEXT:    std r0, 48(r1)
; CHECK-LE-P9-NEXT:    bl memcmp
; CHECK-LE-P9-NEXT:    nop
; CHECK-LE-P9-NEXT:    addi r1, r1, 32
; CHECK-LE-P9-NEXT:    ld r0, 16(r1)
; CHECK-LE-P9-NEXT:    mtlr r0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P9-LABEL: _Z11memcmp_testPKvS0_m:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mflr r0
; CHECK-BE-P9-NEXT:    stdu r1, -112(r1)
; CHECK-BE-P9-NEXT:    std r0, 128(r1)
; CHECK-BE-P9-NEXT:    bl memcmp
; CHECK-BE-P9-NEXT:    nop
; CHECK-BE-P9-NEXT:    addi r1, r1, 112
; CHECK-BE-P9-NEXT:    ld r0, 16(r1)
; CHECK-BE-P9-NEXT:    mtlr r0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: _Z11memcmp_testPKvS0_m:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mflr r0
; CHECK-AIX-64-P9-NEXT:    stdu r1, -112(r1)
; CHECK-AIX-64-P9-NEXT:    std r0, 128(r1)
; CHECK-AIX-64-P9-NEXT:    bl .___memcmp64[PR]
; CHECK-AIX-64-P9-NEXT:    nop
; CHECK-AIX-64-P9-NEXT:    addi r1, r1, 112
; CHECK-AIX-64-P9-NEXT:    ld r0, 16(r1)
; CHECK-AIX-64-P9-NEXT:    mtlr r0
; CHECK-AIX-64-P9-NEXT:    blr
entry:
  %call = tail call i32 @memcmp(ptr noundef %ptr1, ptr noundef %ptr2, i64 noundef %num)
  ret i32 %call
}

declare i32 @memcmp(ptr noundef captures(none), ptr noundef captures(none), i64 noundef) nounwind

define i64 @strlen_test(ptr noundef %str) nounwind {
; CHECK-LE-P9-LABEL: strlen_test:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mflr r0
; CHECK-LE-P9-NEXT:    stdu r1, -48(r1)
; CHECK-LE-P9-NEXT:    std r0, 64(r1)
; CHECK-LE-P9-NEXT:    std r3, 40(r1)
; CHECK-LE-P9-NEXT:    bl strlen
; CHECK-LE-P9-NEXT:    nop
; CHECK-LE-P9-NEXT:    addi r1, r1, 48
; CHECK-LE-P9-NEXT:    ld r0, 16(r1)
; CHECK-LE-P9-NEXT:    mtlr r0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P9-LABEL: strlen_test:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mflr r0
; CHECK-BE-P9-NEXT:    stdu r1, -128(r1)
; CHECK-BE-P9-NEXT:    std r0, 144(r1)
; CHECK-BE-P9-NEXT:    std r3, 120(r1)
; CHECK-BE-P9-NEXT:    bl strlen
; CHECK-BE-P9-NEXT:    nop
; CHECK-BE-P9-NEXT:    addi r1, r1, 128
; CHECK-BE-P9-NEXT:    ld r0, 16(r1)
; CHECK-BE-P9-NEXT:    mtlr r0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: strlen_test:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mflr r0
; CHECK-AIX-64-P9-NEXT:    stdu r1, -128(r1)
; CHECK-AIX-64-P9-NEXT:    std r0, 144(r1)
; CHECK-AIX-64-P9-NEXT:    std r3, 120(r1)
; CHECK-AIX-64-P9-NEXT:    bl .___strlen64[PR]
; CHECK-AIX-64-P9-NEXT:    nop
; CHECK-AIX-64-P9-NEXT:    addi r1, r1, 128
; CHECK-AIX-64-P9-NEXT:    ld r0, 16(r1)
; CHECK-AIX-64-P9-NEXT:    mtlr r0
; CHECK-AIX-64-P9-NEXT:    blr
entry:
  %str.addr = alloca ptr, align 8
  store ptr %str, ptr %str.addr, align 8
  %0 = load ptr, ptr %str.addr, align 8
  %call = call i64 @strlen(ptr noundef %0)
  ret i64 %call
}

declare i64 @strlen(ptr noundef) nounwind

define ptr @test_memmove(ptr noundef %destination, ptr noundef %source, i64 noundef %num) #0 {
; CHECK-LE-P9-LABEL: test_memmove:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mflr r0
; CHECK-LE-P9-NEXT:    .cfi_def_cfa_offset 80
; CHECK-LE-P9-NEXT:    .cfi_offset lr, 16
; CHECK-LE-P9-NEXT:    .cfi_offset r30, -16
; CHECK-LE-P9-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; CHECK-LE-P9-NEXT:    stdu r1, -80(r1)
; CHECK-LE-P9-NEXT:    std r0, 96(r1)
; CHECK-LE-P9-NEXT:    mr r30, r3
; CHECK-LE-P9-NEXT:    std r3, 56(r1)
; CHECK-LE-P9-NEXT:    std r4, 48(r1)
; CHECK-LE-P9-NEXT:    std r5, 40(r1)
; CHECK-LE-P9-NEXT:    bl memmove
; CHECK-LE-P9-NEXT:    nop
; CHECK-LE-P9-NEXT:    mr r3, r30
; CHECK-LE-P9-NEXT:    addi r1, r1, 80
; CHECK-LE-P9-NEXT:    ld r0, 16(r1)
; CHECK-LE-P9-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; CHECK-LE-P9-NEXT:    mtlr r0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_memmove:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mflr r0
; CHECK-BE-P9-NEXT:    stdu r1, -160(r1)
; CHECK-BE-P9-NEXT:    std r0, 176(r1)
; CHECK-BE-P9-NEXT:    .cfi_def_cfa_offset 160
; CHECK-BE-P9-NEXT:    .cfi_offset lr, 16
; CHECK-BE-P9-NEXT:    .cfi_offset r30, -16
; CHECK-BE-P9-NEXT:    std r30, 144(r1) # 8-byte Folded Spill
; CHECK-BE-P9-NEXT:    mr r30, r3
; CHECK-BE-P9-NEXT:    std r3, 136(r1)
; CHECK-BE-P9-NEXT:    std r4, 128(r1)
; CHECK-BE-P9-NEXT:    std r5, 120(r1)
; CHECK-BE-P9-NEXT:    bl memmove
; CHECK-BE-P9-NEXT:    nop
; CHECK-BE-P9-NEXT:    mr r3, r30
; CHECK-BE-P9-NEXT:    ld r30, 144(r1) # 8-byte Folded Reload
; CHECK-BE-P9-NEXT:    addi r1, r1, 160
; CHECK-BE-P9-NEXT:    ld r0, 16(r1)
; CHECK-BE-P9-NEXT:    mtlr r0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_memmove:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mflr r0
; CHECK-AIX-64-P9-NEXT:    stdu r1, -144(r1)
; CHECK-AIX-64-P9-NEXT:    std r0, 160(r1)
; CHECK-AIX-64-P9-NEXT:    std r31, 136(r1) # 8-byte Folded Spill
; CHECK-AIX-64-P9-NEXT:    mr r31, r3
; CHECK-AIX-64-P9-NEXT:    std r3, 128(r1)
; CHECK-AIX-64-P9-NEXT:    std r4, 120(r1)
; CHECK-AIX-64-P9-NEXT:    std r5, 112(r1)
; CHECK-AIX-64-P9-NEXT:    bl .___memmove64[PR]
; CHECK-AIX-64-P9-NEXT:    nop
; CHECK-AIX-64-P9-NEXT:    mr r3, r31
; CHECK-AIX-64-P9-NEXT:    ld r31, 136(r1) # 8-byte Folded Reload
; CHECK-AIX-64-P9-NEXT:    addi r1, r1, 144
; CHECK-AIX-64-P9-NEXT:    ld r0, 16(r1)
; CHECK-AIX-64-P9-NEXT:    mtlr r0
; CHECK-AIX-64-P9-NEXT:    blr
entry:
  %destination.addr = alloca ptr, align 8
  %source.addr = alloca ptr, align 8
  %num.addr = alloca i64, align 8
  store ptr %destination, ptr %destination.addr, align 8
  store ptr %source, ptr %source.addr, align 8
  store i64 %num, ptr %num.addr, align 8
  %0 = load ptr, ptr %destination.addr, align 8
  %1 = load ptr, ptr %source.addr, align 8
  %2 = load i64, ptr %num.addr, align 8
  call void @llvm.memmove.p0.p0.i64(ptr align 1 %0, ptr align 1 %1, i64 %2, i1 false)
  ret ptr %0
}

declare void @llvm.memmove.p0.p0.i32(ptr writeonly captures(none), ptr readonly captures(none), i32, i1 immarg)

define dso_local ptr @strcpy_test(ptr noundef %dest, ptr noundef %src) nounwind {
; CHECK-LE-P9-LABEL: strcpy_test:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mflr r0
; CHECK-LE-P9-NEXT:    stdu r1, -32(r1)
; CHECK-LE-P9-NEXT:    std r0, 48(r1)
; CHECK-LE-P9-NEXT:    bl strcpy
; CHECK-LE-P9-NEXT:    nop
; CHECK-LE-P9-NEXT:    addi r1, r1, 32
; CHECK-LE-P9-NEXT:    ld r0, 16(r1)
; CHECK-LE-P9-NEXT:    mtlr r0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P9-LABEL: strcpy_test:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mflr r0
; CHECK-BE-P9-NEXT:    stdu r1, -112(r1)
; CHECK-BE-P9-NEXT:    std r0, 128(r1)
; CHECK-BE-P9-NEXT:    bl strcpy
; CHECK-BE-P9-NEXT:    nop
; CHECK-BE-P9-NEXT:    addi r1, r1, 112
; CHECK-BE-P9-NEXT:    ld r0, 16(r1)
; CHECK-BE-P9-NEXT:    mtlr r0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: strcpy_test:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mflr r0
; CHECK-AIX-64-P9-NEXT:    stdu r1, -112(r1)
; CHECK-AIX-64-P9-NEXT:    std r0, 128(r1)
; CHECK-AIX-64-P9-NEXT:    bl .___strcpy64[PR]
; CHECK-AIX-64-P9-NEXT:    nop
; CHECK-AIX-64-P9-NEXT:    addi r1, r1, 112
; CHECK-AIX-64-P9-NEXT:    ld r0, 16(r1)
; CHECK-AIX-64-P9-NEXT:    mtlr r0
; CHECK-AIX-64-P9-NEXT:    blr
entry:
  %call = call ptr @strcpy(ptr noundef %dest, ptr noundef %src)
  ret ptr %call
}

declare ptr @strcpy(ptr noundef, ptr noundef)

define dso_local ptr @stpcpy_test(ptr noundef %dest, ptr noundef %src) nounwind {
; CHECK-LE-P9-LABEL: stpcpy_test:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mflr r0
; CHECK-LE-P9-NEXT:    stdu r1, -32(r1)
; CHECK-LE-P9-NEXT:    std r0, 48(r1)
; CHECK-LE-P9-NEXT:    bl stpcpy
; CHECK-LE-P9-NEXT:    nop
; CHECK-LE-P9-NEXT:    addi r1, r1, 32
; CHECK-LE-P9-NEXT:    ld r0, 16(r1)
; CHECK-LE-P9-NEXT:    mtlr r0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P9-LABEL: stpcpy_test:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mflr r0
; CHECK-BE-P9-NEXT:    stdu r1, -112(r1)
; CHECK-BE-P9-NEXT:    std r0, 128(r1)
; CHECK-BE-P9-NEXT:    bl stpcpy
; CHECK-BE-P9-NEXT:    nop
; CHECK-BE-P9-NEXT:    addi r1, r1, 112
; CHECK-BE-P9-NEXT:    ld r0, 16(r1)
; CHECK-BE-P9-NEXT:    mtlr r0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: stpcpy_test:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mflr r0
; CHECK-AIX-64-P9-NEXT:    stdu r1, -112(r1)
; CHECK-AIX-64-P9-NEXT:    std r0, 128(r1)
; CHECK-AIX-64-P9-NEXT:    bl .stpcpy[PR]
; CHECK-AIX-64-P9-NEXT:    nop
; CHECK-AIX-64-P9-NEXT:    addi r1, r1, 112
; CHECK-AIX-64-P9-NEXT:    ld r0, 16(r1)
; CHECK-AIX-64-P9-NEXT:    mtlr r0
; CHECK-AIX-64-P9-NEXT:    blr
entry:
  %call = call ptr @stpcpy(ptr noundef %dest, ptr noundef %src)
  ret ptr %call
}


declare ptr @stpcpy(ptr noundef, ptr noundef)
