; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=armv7-unknown-linux < %s | FileCheck -check-prefix=LINUX %s

define fp128 @testExpl(fp128 %val, i32 %a) {
; LINUX-LABEL: testExpl:
; LINUX:       @ %bb.0:
; LINUX-NEXT:    push {r11, lr}
; LINUX-NEXT:    sub sp, sp, #8
; LINUX-NEXT:    ldr r12, [sp, #16]
; LINUX-NEXT:    str r12, [sp]
; LINUX-NEXT:    bl ldexpl
; LINUX-NEXT:    add sp, sp, #8
; LINUX-NEXT:    pop {r11, pc}
  %call = tail call fp128 @ldexpl(fp128 %val, i32 %a)
  ret fp128 %call
}

declare fp128 @ldexpl(fp128, i32) memory(none)

define fp128 @test_ldexp_f128_i32(fp128 %val, i32 %a) {
; LINUX-LABEL: test_ldexp_f128_i32:
; LINUX:       @ %bb.0:
; LINUX-NEXT:    push {r11, lr}
; LINUX-NEXT:    sub sp, sp, #8
; LINUX-NEXT:    ldr r12, [sp, #16]
; LINUX-NEXT:    str r12, [sp]
; LINUX-NEXT:    bl ldexpl
; LINUX-NEXT:    add sp, sp, #8
; LINUX-NEXT:    pop {r11, pc}
  %call = tail call fp128 @llvm.ldexp.f128.i32(fp128 %val, i32 %a)
  ret fp128 %call
}

define <2 x fp128> @test_ldexp_v2f128_v2i32(<2 x fp128> %val, <2 x i32> %a) {
; LINUX-LABEL: test_ldexp_v2f128_v2i32:
; LINUX:       @ %bb.0:
; LINUX-NEXT:    push {r4, r5, r6, lr}
; LINUX-NEXT:    vpush {d8}
; LINUX-NEXT:    sub sp, sp, #8
; LINUX-NEXT:    mov r5, r3
; LINUX-NEXT:    add r3, sp, #40
; LINUX-NEXT:    mov r6, r2
; LINUX-NEXT:    mov r4, r0
; LINUX-NEXT:    ldm r3, {r0, r1, r2, r3}
; LINUX-NEXT:    vldr d8, [sp, #56]
; LINUX-NEXT:    vst1.32 {d8[1]}, [sp:32]
; LINUX-NEXT:    bl ldexpl
; LINUX-NEXT:    ldr r12, [sp, #32]
; LINUX-NEXT:    vst1.32 {d8[0]}, [sp:32]
; LINUX-NEXT:    ldr lr, [sp, #36]
; LINUX-NEXT:    str r0, [r4, #16]
; LINUX-NEXT:    mov r0, r6
; LINUX-NEXT:    str r1, [r4, #20]
; LINUX-NEXT:    mov r1, r5
; LINUX-NEXT:    str r2, [r4, #24]
; LINUX-NEXT:    mov r2, r12
; LINUX-NEXT:    str r3, [r4, #28]
; LINUX-NEXT:    mov r3, lr
; LINUX-NEXT:    bl ldexpl
; LINUX-NEXT:    stm r4, {r0, r1, r2, r3}
; LINUX-NEXT:    add sp, sp, #8
; LINUX-NEXT:    vpop {d8}
; LINUX-NEXT:    pop {r4, r5, r6, pc}
  %call = tail call <2 x fp128> @llvm.ldexp.v2f128.v2i32(<2 x fp128> %val, <2 x i32> %a)
  ret <2 x fp128> %call
}
