= KMSCON Release News =

## CHANGES WITH 9.3.2
* New features:
  - Unifont scale by @kdj0c in https://github.com/kmscon/kmscon/pull/275

* Bug fixes:
  - bbulk: fix using unitialized memory. by @kdj0c in https://github.com/kmscon/kmscon/pull/272
  - genunifont: Fix memory leak by @kdj0c in https://github.com/kmscon/kmscon/pull/274
  - docs: move kmscon.conf to section 5 of the man pages by @1ace in https://github.com/kmscon/kmscon/pull/281
  - meson: add subproject fallback for libtsm by @1ace in https://github.com/kmscon/kmscon/pull/244
  - Pango: Add default monospace font fallback by @kdj0c in https://github.com/kmscon/kmscon/pull/278
  - Change default TERM to linux by @kdj0c in https://github.com/kmscon/kmscon/pull/280
  - bbulk: Fix if a font has a single-width glyph for a double-width char by @kdj0c in https://github.com/kmscon/kmscon/pull/283

## New Contributors
* @1ace made their first contribution in https://github.com/kmscon/kmscon/pull/281

**Full Changelog**: https://github.com/kmscon/kmscon/compare/v9.3.1...v9.3.2


## CHANGES WITH 9.3.1
* Bug fixes:
  - Fix build on i686 by @kdj0c in https://github.com/kmscon/kmscon/pull/242
  - conf: Fix help text formatting and typos by @jtollet in https://github.com/kmscon/kmscon/pull/247
  - conf: Add --version/-V command-line option by @jtollet in https://github.com/kmscon/kmscon/pull/243
  - units: drop unnecessary templating of units by @keszybz in https://github.com/kmscon/kmscon/pull/246
  - units: fill out [Install] section by @keszybz in https://github.com/kmscon/kmscon/pull/245
  - start script: get local from localectl too by @kdj0c in https://github.com/kmscon/kmscon/pull/252
  - agetty: Add -8 arguments to accept full 8-bits characters by @kdj0c in https://github.com/kmscon/kmscon/pull/261
  - Read /proc/sys/kernel/ctrl-alt-del for reboot behavior by @jtollet in https://github.com/kmscon/kmscon/pull/264
  - drm: Fix black screen when switching back to kmscon by @kdj0c in https://github.com/kmscon/kmscon/pull/266
  - unifont: use sparse table, to be able to use codepoints after 0xFFFF by @kdj0c in https://github.com/kmscon/kmscon/pull/265
  - unifont: Add bold and underline support by @kdj0c in https://github.com/kmscon/kmscon/pull/267
  - Only take drm master if needed by @kdj0c in https://github.com/kmscon/kmscon/pull/269

## New Contributors
* @keszybz made their first contribution in https://github.com/kmscon/kmscon/pull/246

**Full Changelog**: https://github.com/kmscon/kmscon/compare/v9.3.0...v9.3.1


## CHANGES WITH 9.3.0
* New features:
  - Enable mouse support by default by @kdj0c in https://github.com/kmscon/kmscon/pull/175
  - Add --grab-reboot option to trigger system reboot via keyboard shortcut by @jtollet in https://github.com/kmscon/kmscon/pull/176
  - Add drm atomic modeset support by @kdj0c in https://github.com/kmscon/kmscon/pull/184
  - Bbulk damage by @kdj0c in https://github.com/kmscon/kmscon/pull/185
  - Add DPMS screen timeout feature by @jtollet in https://github.com/kmscon/kmscon/pull/212
  - Add FB_DAMAGE_CLIPS support to bbulk renderer by @kdj0c in https://github.com/kmscon/kmscon/pull/210
  - bracketed paste by @kdj0c in https://github.com/kmscon/kmscon/pull/218

* Bug fixes:
  - Fix TERM when launched with agetty by @kdj0c in https://github.com/kmscon/kmscon/pull/160
  - Remove bashism in kmscon-launch-gui.sh by @aruhier in https://github.com/kmscon/kmscon/pull/161
  - Format the code with clang-format by @kdj0c in https://github.com/kmscon/kmscon/pull/159
  - More extensive kmscon-launch-gui.sh tweaks, inotifywait by @Vladimir-csp in https://github.com/kmscon/kmscon/pull/163
  - Rework display and video by @kdj0c in https://github.com/kmscon/kmscon/pull/165
  - Convert backspace delete to a runtime option, and enable it. by @kdj0c in https://github.com/kmscon/kmscon/pull/172
  - Update drm api by @kdj0c in https://github.com/kmscon/kmscon/pull/173
  - Forward mouse wheel events to applications in mouse tracking mode by @jtollet in https://github.com/kmscon/kmscon/pull/178
  - Don't print function/file for log_notice by @kdj0c in https://github.com/kmscon/kmscon/pull/182
  - Reset selection on key press, or wheel up/down by @kdj0c in https://github.com/kmscon/kmscon/pull/183
  - Fix mouse when using multiple monitor. by @kdj0c in https://github.com/kmscon/kmscon/pull/181
  - logind: doesn't monitor seats if started with VT by @kdj0c in https://github.com/kmscon/kmscon/pull/171
  - Fix typo in kmscon.conf by @howl in https://github.com/kmscon/kmscon/pull/196
  - Fix typo in kmscon.1 by @hosiet in https://github.com/kmscon/kmscon/pull/199
  - Prepare atomic modesetting by @kdj0c in https://github.com/kmscon/kmscon/pull/179
  - Add grab-reboot option to example config file by @jtollet in https://github.com/kmscon/kmscon/pull/202
  - bbulk: Fix cell under the cursor. by @kdj0c in https://github.com/kmscon/kmscon/pull/203
  - Fix mouse selection can crash kmscon by @kdj0c in https://github.com/kmscon/kmscon/pull/204
  - text: add default attribute to prepare() by @kdj0c in https://github.com/kmscon/kmscon/pull/207
  - Avoid overwriting `kmscon.conf` (#209) by @ruby-R53 in https://github.com/kmscon/kmscon/pull/211
  - Fix mouse drag tracking in terminal applications by @jtollet in https://github.com/kmscon/kmscon/pull/214
  - Don't warn on pageflip failed on -EBUSY by @kdj0c in https://github.com/kmscon/kmscon/pull/216
  - kmscon launcher script: redirect dbus-send errors to /dev/null by @kdj0c in https://github.com/kmscon/kmscon/pull/217
  - terminal: fix paste with empty copy by @kdj0c in https://github.com/kmscon/kmscon/pull/224
  - kmscon_conf.c: Fix llvm compilation failure by @aduskett in https://github.com/kmscon/kmscon/pull/225
  - Remove render-engine configuration by @kdj0c in https://github.com/kmscon/kmscon/pull/220
  - drm: Fix when no display is connected at startup by @kdj0c in https://github.com/kmscon/kmscon/pull/222
  - Fix DPMS timer not resetting when display activates by @jtollet in https://github.com/kmscon/kmscon/pull/233
  - README.md: fix the kms.conf link by @schdie in https://github.com/kmscon/kmscon/pull/231
  - Unifont font_unifont_data.hex => 17.0.3 hex. by @satmandu in https://github.com/kmscon/kmscon/pull/228
  - Better touchscreen support by @kdj0c in https://github.com/kmscon/kmscon/pull/223
  - drm: Add legacy modesetting fallback support. by @kdj0c in https://github.com/kmscon/kmscon/pull/234
  - Fix XDG_VTNR not set: by @kdj0c in https://github.com/kmscon/kmscon/pull/237
  - conf: ignore unknown options by @kdj0c in https://github.com/kmscon/kmscon/pull/240

## New Contributors
* @aruhier made their first contribution in https://github.com/kmscon/kmscon/pull/161
* @Vladimir-csp made their first contribution in https://github.com/kmscon/kmscon/pull/163
* @jtollet made their first contribution in https://github.com/kmscon/kmscon/pull/176
* @howl made their first contribution in https://github.com/kmscon/kmscon/pull/196
* @hosiet made their first contribution in https://github.com/kmscon/kmscon/pull/199
* @ruby-R53 made their first contribution in https://github.com/kmscon/kmscon/pull/211
* @aduskett made their first contribution in https://github.com/kmscon/kmscon/pull/225
* @schdie made their first contribution in https://github.com/kmscon/kmscon/pull/231
* @satmandu made their first contribution in https://github.com/kmscon/kmscon/pull/228

**Full Changelog**: https://github.com/kmscon/kmscon/compare/v9.2.1...v9.3.0

## CHANGES WITH 9.2.1
	* Bug fixes:
		- Remove release github workflow @kdj0c in https://github.com/kmscon/kmscon/pull/155
		- Fix kmscon version @kdj0c in https://github.com/kmscon/kmscon/pull/158

## CHANGES WITH 9.2.0
	* New features!
		- Add kmscon-launch-gui to start gui from kmscon @kdj0c in https://github.com/Aetf/kmscon/pull/118
		- Add retry count and retry time to login program by @michael-oberpriller in https://github.com/Aetf/kmscon/pull/134
		- Add rotation support by @kdj0c in https://github.com/Aetf/kmscon/pull/147
		- Add mouse support by @kdj0c in https://github.com/Aetf/kmscon/pull/149
		- Double width overflow support by @michael-oberpriller in https://github.com/Aetf/kmscon/pull/135

	* Bug fixes
		- Fix build of conf.c with xkbcommon by @kdj0c in https://github.com/Aetf/kmscon/pull/116
		- Add basic CI for all pull request by @kdj0c in https://github.com/Aetf/kmscon/pull/117
		- github-ci: update package list before installing by @kdj0c in https://github.com/Aetf/kmscon/pull/119
		- Hide hardware cursor on vt switching by @michael-oberpriller in https://github.com/Aetf/kmscon/pull/123
		- Fix github CI, after renaming develop to main by @kdj0c in https://github.com/Aetf/kmscon/pull/127
		- Make sure the main thread gets SIGCHLD by @Vogtinator in https://github.com/Aetf/kmscon/pull/106
		- Revert hup workaround by @kdj0c in https://github.com/Aetf/kmscon/pull/126
		- Readme: add systemd-dev requirement on debian systems by @kdj0c in https://github.com/Aetf/kmscon/pull/128
		- Remove custom SELinux module by @Vogtinator in https://github.com/Aetf/kmscon/pull/130
		- Add a man-page for the kmscon.conf file. by @kdj0c in https://github.com/Aetf/kmscon/pull/131
		- Disable session-control when running with real VTs by @michael-oberpriller in https://github.com/Aetf/kmscon/pull/137
		- Pango: use font cache to check if the font overflows by @kdj0c in https://github.com/Aetf/kmscon/pull/141
		- Pango: align stride to 4 bytes by @kdj0c in https://github.com/Aetf/kmscon/pull/142
		- Update CI as libtsm has switched to meson by @kdj0c in https://github.com/Aetf/kmscon/pull/144
		- Fix character overflow with JetBrainsMono Nerd Font Mono by @kdj0c in https://github.com/Aetf/kmscon/pull/146
		- kmscon-launch-gui: don't use eval by @martinetd in https://github.com/Aetf/kmscon/pull/156
		- Add a default kmscon.conf in /etc by @kdj0c in https://github.com/Aetf/kmscon/pull/154
		- Build video_drm3d as a module by @kdj0c in https://github.com/Aetf/kmscon/pull/153
		- Fix kmscon using 100% CPU when trying to read systemd seats configuration by @kdj0c in https://github.com/Aetf/kmscon/pull/157
		- Set env variable KMS_START_SCRIPT  and TERM_SESSION_TYPE by @kdj0c in https://github.com/Aetf/kmscon/pull/160
		- print backends by @kdj0c in https://github.com/Aetf/kmscon/pull/165
		- Remove the pixman renderer by @kdj0c in https://github.com/Aetf/kmscon/pull/163
		- Remove bblit renderer, and make bbulk built-ins by @kdj0c in https://github.com/Aetf/kmscon/pull/166
		- Update Readme.md after moving back to github/kmscon/kmscon by @kdj0c https://github.com/kmscon/kmscon/pull/152
		-  Remove render timing by @kdj0c https://github.com/kmscon/kmscon/pull/153
		- Fix typo in README.md by @kdj0c https://github.com/kmscon/kmscon/pull/154

## New Contributors
- @martinetd made their first contribution in https://github.com/Aetf/kmscon/pull/156

**Full Changelog**: https://github.com/kmscon/kmscon/compare/v9.1.0...v9.2.0


CHANGES WITH 9.1.0:
	* New features!
	    - Add selinux permissions (#109)
	    - Add argument to set the resolution (#71)
	    - Use current KMS videomode by default (#66)
	    - Add elogind support (#67)
	    - Allow quoting to preserve spaces in the login option in config file (#59)
	    - Make code sent by backspace key configurable (#55)

	* Bug fixes
	    - Fix running with simpledrm
	    - Fix default x11 keyboard layout
	    - Fix the login shell not restarting
	    - Fix systemd unit file

	* Update unifont to 16.0.01

CHANGES WITH 9.0.0:
	* Modernized build system from autotools to meson.

	* Note that many features rely on newer version of libtsm,
	  thus we now requires libtsm >= 4.0.0 from the maintained fork at
	  https://github.com/Aetf/libtsm.

	* New features!
	    - Custom palette support (#39)
	    - Compose (dead-key) support (#36)
	    - 24bit fbdev support (#8)
	    - Detect XKB layout from localed (#7)
	    - Underline and italic font (#3)

	* Bug fixes
	    - Fixed thin pixel lines at some screen edges (dac3c31b9e78ab28545caf88cbd8105a8c62052e)
	    - Fixed many undefined behaviors and other minor bugs
	    - Modernized codebase by moving away from deprecated symbols

	* Many small fixes to documentation.

CHANGES WITH 8:
	* Several build-tools changes. Please adjust your build-scripts
	  accoringly:
	    - xz instead of bz2 tarballs
	    - tarballs moved to: www.freedesktop.org/software/kmscon/releases
	    - linking with ld.gold now supported
	    - libtsm was extracted into a separate library, available at:
	        www.freedesktop.org/wiki/Software/kmscon/libtsm
	    - Several dependencies are mandatory now. See README.
	    - --prefix=/usr is no longer the default. You need to pass it
	      yourself!

	* Removed wlterm. A GTK+ variant of wlterm is now available at:
	    www.freedesktop.org/wiki/Software/kmscon/wlterm

	* Removed uvtd and uvt. They were unused.

	* Removed cdev-sessions

	* Removed freetype2 font-backend

	* Removed cairo text renderer

	* eloop and uterm are now linked statically

	* Dynamic font resizing is now supported. Use ctrl+'+' and ctrl+'-' as
	  default shortcuts to resize your font on-the-fly.

	* Lots of bug-fixes!

CHANGES WITH 7:
	* TSM, font and text subsystems have been extended to support
	  multi-width fonts (via wcwidth(3)). This allows using CJK characters
	  if your font provides the requested glyphs.

	* COLORTERM is now set to "kmscon" to allow applications to detect
	  whether they run in kmscon.

	* /bin/login is now called with -p by default to reset the environment.
	  This prevents kmscon from passing weird environment variables to the
	  clients but still allows to start KMSCON with a customized
	  environment.
	  The new --reset-env variable controls this behavior (default: on).

	* Add kmsconvt@.service systemd template. This replaces the
	  kmscon@.service template and can now fully replace autovt@.service
	  which is provided by systemd-logind.

	* The DRM3D backend now uses gbm-surfaces and now longer depends on the
	  custom EGL extensions. Everything is now handled inside of mesa so we
	  are safe if the extensions are changed in the future.

	* Modularize kmscon. Most of the dependencies can now be loaded during
	  runtime and are no longer mandatory. This allows package-managers to
	  provide the kmscon binary as default package and all the backends in a
	  separate package to avoid huge dependencies.
	  Please note that this modularization still needs to be applied to
	  uterm so you shouldn't split the package yet, but instead wait for the
	  next release.

	* Freetype2 backend is now deprecated. Use the built-in 8x16 backend,
	  the unifont backend or the fully-featured pango backend.

	* bblit renderer is now built-in. You cannot deselect it, anymore.

	* libuterm reads boot_vga values now via udev. libpciaccess is no longer
	  needed and was removed entirely.

	* uterm video backends are now split into different modules. They still
	  need to be selected during compile-time, though. The next kmscon
	  release will finish this uterm split.
	  The dumb-video backend was renamed to drm2d. The drm-video backend was
	  renamed to drm3d.

	* libeloop now supports ONESHOT idle sources

	* Experimental cairo+pixman renderers. These should not be used in any
	  production systems! They are only provided for performance-testing and
	  to show how cairo/pixman modules can be included.

	* unifont font backend is now enabled by default. The build was heavily
	  improved to avoid long compilation times.

	* Symbol-versioning was added to all libraries. Library interfaces are
	  still not considered stable so don't package them separately! Feel
	  free to link them statically.

	* An experimental unfinished version of the UVT library has been added.
	  Use it only for testing purposes. The next kmscon release will include
	  documentation and more.
	  UVT implements virtual terminals in user-space. It will soon replace
	  the cdev-sessions in kmscon.

	* Lots of bug-fixes!

CHANGES WITH 6:
	* Allow arbitrary paths with --vt (kmscon)

	* xkbcommon is now mandatory. We need it to handle keyboard input
	  properly and since xkbcommon-0.2.0 is released, there is no reason to
	  not depend on it.
	  We also removed the plain-input backend with this change.

	* Snap window to console/font-size on resize (wlterm)

	* Adjust to new libwayland-1.0 (wlterm)

	* Many new command-line options for wlterm including --term, --login,
	  --palette, --sb-size and many --grab-* options.

	* fake-VTs no longer react on SIGUSR1/2. This was always broken and now
	  removed.

	* --switchvt works again and is now enabled by default.

	* --xkb-model was introduced. The other --xkb-<rmlvo> options also use
	  system-defaults instead of us-keymap as default value now.

	* wlterm works properly in maximized and fullscreen mode now

	* key-presses are now properly marked as "handled" so it is no longer
	  possible for two subsystems to handle the same key-press.

	* wlterm can now zoom the font size with ctrl+Plus/Minus

	* TSM now supports screen selections. wlterm is hooked up with this and
	  supports this, too. However, the VTE layer has not seen this yet so
	  everything is computed in the terminal for now. Next kmscon release
	  will include client-side mouse-protocol support.

	* Copy/Paste now works with wlterm

	* Key-repeat has been reworked and now allows adjusting repeat and delay
	  times.

	* Session support allows for multiple terminals (sessions) inside of
	  each seat. You can switch between the sessions, kill them and create
	  new terminals via keyboard shortcuts. Also several other sessions than
	  terminal sessions were introduced. However, all of them are
	  experimental and shouldn't be used.

	* TSM now supports alternate screen buffers. They're enabled by default.

	* Configuration handling has been reworked. Multiple config-files can
	  now be parsed and each seat has its own configuration file in
	  /etc/kmscon/<seat>.seat.conf.

	* The build-tools have been reworked. They should now work properly with
	  any option-combination imaginable.

	* --login option can now be used in config-files.

	* We print hints if keyboard-shortcut names are written with wrong
	  capitalization.

	* Improve systemd integration

	* CDev sessions emulate enough of the VT API to make X-Server run as
	  kmscon session. You can even run kmscon in default-mode as client in
	  another kmscon manager.

	* Bold fonts are now supported.

	* kmscon.1 manpage is available now.

	* ... and a lot of bugfixes

CHANGES WITH 5:
	* Idle sources are now faster registered and unregistered so they can
	  be used for any scheduling tasks

	* eloop got pre- and post-dispatch hooks to integrate external
	  event-loops better

	* Added pkg-config files for eloop, tsm and uterm

	* Added xkbcommon-keysyms.h as fallback

	* fakevt got removed. It is now integrated into kmscon core and is no
	  longer needed.

	* Cleaned up unicode, console and vte layer. It is now a fully
	  independent library calles TSM.

	* All helpers were prefixed with SHL_* and can be used in any project
	  inside of this repository. They are linked statically and mostly
	  inlined code.

	* VTE layer now handles ALT key

	* fbdev devices are automatically used if they are not run by DRM
	  drivers. Use --fbdev to force the use of fbdev devices only.

	* --vt=<num> now selects the TTY to use by kmscon on seat0

	* Added wlterm, a native terminal emulator for Wayland

	* Lots of bugfixes! Thanks to all the bug-reporters!

CHANGES WITH 4:
	* The "conf" subsystem was modularized so we can use it in other
	  binaries as well. It is also much easier to add new parameters now.

	* Remove internal dependencies. Several subsystems will be split into
	  separate libraries (like eloop, uterm, vte+console) so we should avoid
	  any internal dependencies between these. This shouldn't affect
	  performance, though.

	* New --seats argument which allows to specify what seats kmscon is
	  running on.

	* The old vt.[ch] subsystem is now merged into uterm_vt.c and a fake VT
	  backend was added. This allows to activate/deactivate kmscon via
	  keyboard shortcuts. This is for debugging only, though.

	* The VTE layer was extended a lot to support more advanced control
	  sequences and fix several bugs.

	* --dumb now forces kmscon to use non-accelerated rendering

	* The scrollback buffer now works. You can specify keyboard shortcuts
	  via --grab-* options. Default is: <Shift>Up/Down/Prior/Next

	* GL_EXT_unpack_subimage is not required anymore.

	* _Lots_ of speed improvements in the rendering path.

	* The unifont font backend was added. This is similar to 8x16 but has a
	  lot more characters.

	* ... and a lot of bugfixes

CHANGES WITH 3: (development release)
	* VTE support has been improved greatly. vt220 should be supported fully
	  except for multi-line characters.

	* glib dependency removed. Hashtables and unicode support is now
	  implemented in kmscon.

	* Configfiles are now supported. /etc/kmscon.conf and ~/.kmscon.conf are
	  read by kmscon on startup. They can include the same options as the
	  command line options of kmscon. However, command-line options have
	  precedence.

	* Multiple video objects are now supported per seat. That is, if you
	  have more than one graphics card per seat, all of them will be used by
	  kmscon. Multiple displays were supported from the beginning.

	* Modularized input backend. The XKB backend is fully optional and can
	  be activated/deactivated during runtime. The Dumb backend has been
	  renamed to "plain".

	* The eloop library is fully documented and should be API stable from
	  now on.

	* The font renderer subsystem has been rewritten and replaced with a new
	  subsystem which can load different font-renderers during runtime.
	  Several backends including static 8x16 backend has been added. It is
	  possible to compile kmscon without freetype2/pango dependencies now.

	* 2D blitting to framebuffers has been improved greatly. More devices
	  are supported now and blending is available, too. The 3D devices have
	  been updated to support these blitting operations via OpenGL. This may
	  be slow on older devices, though.

	* New text renderer subsystem has been added. It can load multiple
	  different text-renderers during runtime. The default renderer (bblit)
	  uses 2D blitting operations to render text. However, the gltex
	  renderer is also available (optionally) which renders with OpenGL
	  textures. This can improve performance greatly on modern devices.

	* Gcc optimizations are now enabled by default to improve rendering
	  performance.

CHANGES WITH 2: (development release)
	* Build scripts were improved and simplified. They also allow much more
	  control about the build process now. The source was split into several
	  different libraries.

	* Added llog.h helper for logging in libraries.

	* Eloop was moved into separate library and supports more more
	  use-cases now. It can be used as a standalone project.

	* Terminal emulator (vte.c) was improved a lot and can run vim now.

	* Console layer was rewritten and is now much faster and much more
	  standards compliant.

	* Uterm monitor was added. The monitor uses udev and systemd-logind to
	  watch the system for new seats and devices. This allows us to run on
	  multiple seats simultaneously and being hotplug-capable.

	* Uterm vt layer was added. This simply wraps the older VT layer so we
	  can switch to different VT systems on-the-fly.

	* New uterm video backends: The fbdev backend is now fully functional
	  kmscon can run on any fbdev device now. Furthermore, the dumb backend
	  was added which is simply an unaccelerated DRM backend that should
	  work even without EGL, GL, gbm, etc.

	* New 2D rendering API. In case OpenGL is not available, we now allow
	  blitting images into the framebuffer. This is used for fbdev and dumb
	  video devices.

	* Font renderer now depends on pango. This is is needed only until I get
	  the time to rewrite the freetype backend. But for now we depend on
	  pango so have full font support.

	* lots of small fixes

CHANGES WITH 1: (development release)
	* First kmscon release. For testing purposes only. Includes a rendering
	  pipeline and a very rudimentary terminal emulator.
