// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/site_search_engine.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible target site types.
type TargetSite_Type int32

const (
	// This value is unused. In this case, server behavior defaults to
	// [Type.INCLUDE][google.cloud.discoveryengine.v1alpha.TargetSite.Type.INCLUDE].
	TargetSite_TYPE_UNSPECIFIED TargetSite_Type = 0
	// Include the target site.
	TargetSite_INCLUDE TargetSite_Type = 1
	// Exclude the target site.
	TargetSite_EXCLUDE TargetSite_Type = 2
)

// Enum value maps for TargetSite_Type.
var (
	TargetSite_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INCLUDE",
		2: "EXCLUDE",
	}
	TargetSite_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"INCLUDE":          1,
		"EXCLUDE":          2,
	}
)

func (x TargetSite_Type) Enum() *TargetSite_Type {
	p := new(TargetSite_Type)
	*p = x
	return p
}

func (x TargetSite_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetSite_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes[0].Descriptor()
}

func (TargetSite_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes[0]
}

func (x TargetSite_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetSite_Type.Descriptor instead.
func (TargetSite_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{1, 0}
}

// Target site indexing status enumeration.
type TargetSite_IndexingStatus int32

const (
	// Defaults to SUCCEEDED.
	TargetSite_INDEXING_STATUS_UNSPECIFIED TargetSite_IndexingStatus = 0
	// The target site is in the update queue and will be picked up by indexing
	// pipeline.
	TargetSite_PENDING TargetSite_IndexingStatus = 1
	// The target site fails to be indexed.
	TargetSite_FAILED TargetSite_IndexingStatus = 2
	// The target site has been indexed.
	TargetSite_SUCCEEDED TargetSite_IndexingStatus = 3
	// The previously indexed target site has been marked to be deleted. This is
	// a transitioning state which will resulted in either:
	// 1. target site deleted if unindexing is successful;
	// 2. state reverts to SUCCEEDED if the unindexing fails.
	TargetSite_DELETING TargetSite_IndexingStatus = 4
)

// Enum value maps for TargetSite_IndexingStatus.
var (
	TargetSite_IndexingStatus_name = map[int32]string{
		0: "INDEXING_STATUS_UNSPECIFIED",
		1: "PENDING",
		2: "FAILED",
		3: "SUCCEEDED",
		4: "DELETING",
	}
	TargetSite_IndexingStatus_value = map[string]int32{
		"INDEXING_STATUS_UNSPECIFIED": 0,
		"PENDING":                     1,
		"FAILED":                      2,
		"SUCCEEDED":                   3,
		"DELETING":                    4,
	}
)

func (x TargetSite_IndexingStatus) Enum() *TargetSite_IndexingStatus {
	p := new(TargetSite_IndexingStatus)
	*p = x
	return p
}

func (x TargetSite_IndexingStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetSite_IndexingStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes[1].Descriptor()
}

func (TargetSite_IndexingStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes[1]
}

func (x TargetSite_IndexingStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetSite_IndexingStatus.Descriptor instead.
func (TargetSite_IndexingStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{1, 1}
}

// Site verification state.
type SiteVerificationInfo_SiteVerificationState int32

const (
	// Defaults to VERIFIED.
	SiteVerificationInfo_SITE_VERIFICATION_STATE_UNSPECIFIED SiteVerificationInfo_SiteVerificationState = 0
	// Site ownership verified.
	SiteVerificationInfo_VERIFIED SiteVerificationInfo_SiteVerificationState = 1
	// Site ownership pending verification or verification failed.
	SiteVerificationInfo_UNVERIFIED SiteVerificationInfo_SiteVerificationState = 2
	// Site exempt from verification, e.g., a public website that opens to all.
	SiteVerificationInfo_EXEMPTED SiteVerificationInfo_SiteVerificationState = 3
)

// Enum value maps for SiteVerificationInfo_SiteVerificationState.
var (
	SiteVerificationInfo_SiteVerificationState_name = map[int32]string{
		0: "SITE_VERIFICATION_STATE_UNSPECIFIED",
		1: "VERIFIED",
		2: "UNVERIFIED",
		3: "EXEMPTED",
	}
	SiteVerificationInfo_SiteVerificationState_value = map[string]int32{
		"SITE_VERIFICATION_STATE_UNSPECIFIED": 0,
		"VERIFIED":                            1,
		"UNVERIFIED":                          2,
		"EXEMPTED":                            3,
	}
)

func (x SiteVerificationInfo_SiteVerificationState) Enum() *SiteVerificationInfo_SiteVerificationState {
	p := new(SiteVerificationInfo_SiteVerificationState)
	*p = x
	return p
}

func (x SiteVerificationInfo_SiteVerificationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SiteVerificationInfo_SiteVerificationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes[2].Descriptor()
}

func (SiteVerificationInfo_SiteVerificationState) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes[2]
}

func (x SiteVerificationInfo_SiteVerificationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SiteVerificationInfo_SiteVerificationState.Descriptor instead.
func (SiteVerificationInfo_SiteVerificationState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{2, 0}
}

// SiteSearchEngine captures DataStore level site search persisting
// configurations. It is a singleton value per data store.
type SiteSearchEngine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully qualified resource name of the site search engine.
	// Format: `projects/*/locations/*/dataStores/*/siteSearchEngine`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SiteSearchEngine) Reset() {
	*x = SiteSearchEngine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SiteSearchEngine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SiteSearchEngine) ProtoMessage() {}

func (x *SiteSearchEngine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SiteSearchEngine.ProtoReflect.Descriptor instead.
func (*SiteSearchEngine) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{0}
}

func (x *SiteSearchEngine) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A target site for the SiteSearchEngine.
type TargetSite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
	// The `target_site_id` is system-generated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Input only. The user provided URI pattern from which the
	// `generated_uri_pattern` is generated.
	ProvidedUriPattern string `protobuf:"bytes,2,opt,name=provided_uri_pattern,json=providedUriPattern,proto3" json:"provided_uri_pattern,omitempty"`
	// The type of the target site, e.g., whether the site is to be included or
	// excluded.
	Type TargetSite_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.discoveryengine.v1alpha.TargetSite_Type" json:"type,omitempty"`
	// Input only. If set to false, a uri_pattern is generated to include all
	// pages whose address contains the provided_uri_pattern. If set to true, an
	// uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to
	// generate the URI pattern to be used by the search engine.
	ExactMatch bool `protobuf:"varint,6,opt,name=exact_match,json=exactMatch,proto3" json:"exact_match,omitempty"`
	// Output only. This is system-generated based on the provided_uri_pattern.
	GeneratedUriPattern string `protobuf:"bytes,4,opt,name=generated_uri_pattern,json=generatedUriPattern,proto3" json:"generated_uri_pattern,omitempty"`
	// Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `protobuf:"bytes,10,opt,name=root_domain_uri,json=rootDomainUri,proto3" json:"root_domain_uri,omitempty"`
	// Output only. Site ownership and validity verification status.
	SiteVerificationInfo *SiteVerificationInfo `protobuf:"bytes,7,opt,name=site_verification_info,json=siteVerificationInfo,proto3" json:"site_verification_info,omitempty"`
	// Output only. Indexing status.
	IndexingStatus TargetSite_IndexingStatus `protobuf:"varint,8,opt,name=indexing_status,json=indexingStatus,proto3,enum=google.cloud.discoveryengine.v1alpha.TargetSite_IndexingStatus" json:"indexing_status,omitempty"`
	// Output only. The target site's last updated time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Failure reason.
	FailureReason *TargetSite_FailureReason `protobuf:"bytes,9,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
}

func (x *TargetSite) Reset() {
	*x = TargetSite{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetSite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetSite) ProtoMessage() {}

func (x *TargetSite) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetSite.ProtoReflect.Descriptor instead.
func (*TargetSite) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{1}
}

func (x *TargetSite) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TargetSite) GetProvidedUriPattern() string {
	if x != nil {
		return x.ProvidedUriPattern
	}
	return ""
}

func (x *TargetSite) GetType() TargetSite_Type {
	if x != nil {
		return x.Type
	}
	return TargetSite_TYPE_UNSPECIFIED
}

func (x *TargetSite) GetExactMatch() bool {
	if x != nil {
		return x.ExactMatch
	}
	return false
}

func (x *TargetSite) GetGeneratedUriPattern() string {
	if x != nil {
		return x.GeneratedUriPattern
	}
	return ""
}

func (x *TargetSite) GetRootDomainUri() string {
	if x != nil {
		return x.RootDomainUri
	}
	return ""
}

func (x *TargetSite) GetSiteVerificationInfo() *SiteVerificationInfo {
	if x != nil {
		return x.SiteVerificationInfo
	}
	return nil
}

func (x *TargetSite) GetIndexingStatus() TargetSite_IndexingStatus {
	if x != nil {
		return x.IndexingStatus
	}
	return TargetSite_INDEXING_STATUS_UNSPECIFIED
}

func (x *TargetSite) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TargetSite) GetFailureReason() *TargetSite_FailureReason {
	if x != nil {
		return x.FailureReason
	}
	return nil
}

// Verification information for target sites in advanced site search.
type SiteVerificationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Site verification state indicating the ownership and validity.
	SiteVerificationState SiteVerificationInfo_SiteVerificationState `protobuf:"varint,1,opt,name=site_verification_state,json=siteVerificationState,proto3,enum=google.cloud.discoveryengine.v1alpha.SiteVerificationInfo_SiteVerificationState" json:"site_verification_state,omitempty"`
	// Latest site verification time.
	VerifyTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=verify_time,json=verifyTime,proto3" json:"verify_time,omitempty"`
}

func (x *SiteVerificationInfo) Reset() {
	*x = SiteVerificationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SiteVerificationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SiteVerificationInfo) ProtoMessage() {}

func (x *SiteVerificationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SiteVerificationInfo.ProtoReflect.Descriptor instead.
func (*SiteVerificationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{2}
}

func (x *SiteVerificationInfo) GetSiteVerificationState() SiteVerificationInfo_SiteVerificationState {
	if x != nil {
		return x.SiteVerificationState
	}
	return SiteVerificationInfo_SITE_VERIFICATION_STATE_UNSPECIFIED
}

func (x *SiteVerificationInfo) GetVerifyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VerifyTime
	}
	return nil
}

// Site search indexing failure reasons.
type TargetSite_FailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Failure reason.
	//
	// Types that are assignable to Failure:
	//
	//	*TargetSite_FailureReason_QuotaFailure_
	Failure isTargetSite_FailureReason_Failure `protobuf_oneof:"failure"`
}

func (x *TargetSite_FailureReason) Reset() {
	*x = TargetSite_FailureReason{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetSite_FailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetSite_FailureReason) ProtoMessage() {}

func (x *TargetSite_FailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetSite_FailureReason.ProtoReflect.Descriptor instead.
func (*TargetSite_FailureReason) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{1, 0}
}

func (m *TargetSite_FailureReason) GetFailure() isTargetSite_FailureReason_Failure {
	if m != nil {
		return m.Failure
	}
	return nil
}

func (x *TargetSite_FailureReason) GetQuotaFailure() *TargetSite_FailureReason_QuotaFailure {
	if x, ok := x.GetFailure().(*TargetSite_FailureReason_QuotaFailure_); ok {
		return x.QuotaFailure
	}
	return nil
}

type isTargetSite_FailureReason_Failure interface {
	isTargetSite_FailureReason_Failure()
}

type TargetSite_FailureReason_QuotaFailure_ struct {
	// Failed due to insufficient quota.
	QuotaFailure *TargetSite_FailureReason_QuotaFailure `protobuf:"bytes,1,opt,name=quota_failure,json=quotaFailure,proto3,oneof"`
}

func (*TargetSite_FailureReason_QuotaFailure_) isTargetSite_FailureReason_Failure() {}

// Failed due to insufficient quota.
type TargetSite_FailureReason_QuotaFailure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This number is an estimation on how much total quota this project needs
	// to successfully complete indexing.
	TotalRequiredQuota int64 `protobuf:"varint,1,opt,name=total_required_quota,json=totalRequiredQuota,proto3" json:"total_required_quota,omitempty"`
}

func (x *TargetSite_FailureReason_QuotaFailure) Reset() {
	*x = TargetSite_FailureReason_QuotaFailure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetSite_FailureReason_QuotaFailure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetSite_FailureReason_QuotaFailure) ProtoMessage() {}

func (x *TargetSite_FailureReason_QuotaFailure) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetSite_FailureReason_QuotaFailure.ProtoReflect.Descriptor instead.
func (*TargetSite_FailureReason_QuotaFailure) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *TargetSite_FailureReason_QuotaFailure) GetTotalRequiredQuota() int64 {
	if x != nil {
		return x.TotalRequiredQuota
	}
	return 0
}

var File_google_cloud_discoveryengine_v1alpha_site_search_engine_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x9b, 0x02, 0x0a, 0x10, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0xf2, 0x01, 0xea, 0x41,
	0xee, 0x01, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x69, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f,
	0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x22, 0xe2, 0x0a, 0x0a, 0x0a, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0x52, 0x12,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x55, 0x72, 0x69, 0x50, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x6e, 0x12, 0x49, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a,
	0x0b, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0a, 0x65, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x37, 0x0a, 0x15, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x55, 0x72, 0x69, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x2b, 0x0a, 0x0f,
	0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x6f, 0x6f, 0x74,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x75, 0x0a, 0x16, 0x73, 0x69, 0x74,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x69, 0x74, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x73, 0x69, 0x74, 0x65,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x6d, 0x0a, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x6a, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x1a, 0xd0, 0x01,
	0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x72, 0x0a, 0x0d, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x1a, 0x40, 0x0a, 0x0c, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x09, 0x0a, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x22, 0x36, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10, 0x02, 0x22, 0x67, 0x0a, 0x0e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x04, 0x3a, 0xa1, 0x02, 0xea, 0x41, 0x9d, 0x02, 0x0a, 0x29, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x69, 0x74, 0x65, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x7d, 0x12,
	0x83, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x73, 0x69, 0x74, 0x65, 0x7d, 0x22, 0xcc, 0x02, 0x0a, 0x14, 0x53, 0x69, 0x74, 0x65, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x88,
	0x01, 0x0a, 0x17, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x69, 0x74,
	0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x15, 0x73, 0x69, 0x74, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x15, 0x53, 0x69, 0x74, 0x65, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x27, 0x0a, 0x23, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x45, 0x52, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x56, 0x45, 0x52, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x45, 0x4d, 0x50, 0x54,
	0x45, 0x44, 0x10, 0x03, 0x42, 0xa1, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x42, 0x15, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02,
	0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45,
	0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02,
	0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_goTypes = []interface{}{
	(TargetSite_Type)(0),                            // 0: google.cloud.discoveryengine.v1alpha.TargetSite.Type
	(TargetSite_IndexingStatus)(0),                  // 1: google.cloud.discoveryengine.v1alpha.TargetSite.IndexingStatus
	(SiteVerificationInfo_SiteVerificationState)(0), // 2: google.cloud.discoveryengine.v1alpha.SiteVerificationInfo.SiteVerificationState
	(*SiteSearchEngine)(nil),                        // 3: google.cloud.discoveryengine.v1alpha.SiteSearchEngine
	(*TargetSite)(nil),                              // 4: google.cloud.discoveryengine.v1alpha.TargetSite
	(*SiteVerificationInfo)(nil),                    // 5: google.cloud.discoveryengine.v1alpha.SiteVerificationInfo
	(*TargetSite_FailureReason)(nil),                // 6: google.cloud.discoveryengine.v1alpha.TargetSite.FailureReason
	(*TargetSite_FailureReason_QuotaFailure)(nil),   // 7: google.cloud.discoveryengine.v1alpha.TargetSite.FailureReason.QuotaFailure
	(*timestamppb.Timestamp)(nil),                   // 8: google.protobuf.Timestamp
}
var file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_depIdxs = []int32{
	0, // 0: google.cloud.discoveryengine.v1alpha.TargetSite.type:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite.Type
	5, // 1: google.cloud.discoveryengine.v1alpha.TargetSite.site_verification_info:type_name -> google.cloud.discoveryengine.v1alpha.SiteVerificationInfo
	1, // 2: google.cloud.discoveryengine.v1alpha.TargetSite.indexing_status:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite.IndexingStatus
	8, // 3: google.cloud.discoveryengine.v1alpha.TargetSite.update_time:type_name -> google.protobuf.Timestamp
	6, // 4: google.cloud.discoveryengine.v1alpha.TargetSite.failure_reason:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite.FailureReason
	2, // 5: google.cloud.discoveryengine.v1alpha.SiteVerificationInfo.site_verification_state:type_name -> google.cloud.discoveryengine.v1alpha.SiteVerificationInfo.SiteVerificationState
	8, // 6: google.cloud.discoveryengine.v1alpha.SiteVerificationInfo.verify_time:type_name -> google.protobuf.Timestamp
	7, // 7: google.cloud.discoveryengine.v1alpha.TargetSite.FailureReason.quota_failure:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite.FailureReason.QuotaFailure
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_site_search_engine_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SiteSearchEngine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetSite); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SiteVerificationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetSite_FailureReason); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetSite_FailureReason_QuotaFailure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*TargetSite_FailureReason_QuotaFailure_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_site_search_engine_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_depIdxs = nil
}
