// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/dataflow/v1beta3/environment.proto

package dataflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the processing model used by a
// [google.dataflow.v1beta3.Job], which determines the way the Job is
// managed by the Cloud Dataflow service (how workers are scheduled, how
// inputs are sharded, etc).
type JobType int32

const (
	// The type of the job is unspecified, or unknown.
	JobType_JOB_TYPE_UNKNOWN JobType = 0
	// A batch job with a well-defined end point: data is read, data is
	// processed, data is written, and the job is done.
	JobType_JOB_TYPE_BATCH JobType = 1
	// A continuously streaming job with no end: data is read,
	// processed, and written continuously.
	JobType_JOB_TYPE_STREAMING JobType = 2
)

// Enum value maps for JobType.
var (
	JobType_name = map[int32]string{
		0: "JOB_TYPE_UNKNOWN",
		1: "JOB_TYPE_BATCH",
		2: "JOB_TYPE_STREAMING",
	}
	JobType_value = map[string]int32{
		"JOB_TYPE_UNKNOWN":   0,
		"JOB_TYPE_BATCH":     1,
		"JOB_TYPE_STREAMING": 2,
	}
)

func (x JobType) Enum() *JobType {
	p := new(JobType)
	*p = x
	return p
}

func (x JobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[0].Descriptor()
}

func (JobType) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[0]
}

func (x JobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobType.Descriptor instead.
func (JobType) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{0}
}

// Specifies the resource to optimize for in Flexible Resource Scheduling.
type FlexResourceSchedulingGoal int32

const (
	// Run in the default mode.
	FlexResourceSchedulingGoal_FLEXRS_UNSPECIFIED FlexResourceSchedulingGoal = 0
	// Optimize for lower execution time.
	FlexResourceSchedulingGoal_FLEXRS_SPEED_OPTIMIZED FlexResourceSchedulingGoal = 1
	// Optimize for lower cost.
	FlexResourceSchedulingGoal_FLEXRS_COST_OPTIMIZED FlexResourceSchedulingGoal = 2
)

// Enum value maps for FlexResourceSchedulingGoal.
var (
	FlexResourceSchedulingGoal_name = map[int32]string{
		0: "FLEXRS_UNSPECIFIED",
		1: "FLEXRS_SPEED_OPTIMIZED",
		2: "FLEXRS_COST_OPTIMIZED",
	}
	FlexResourceSchedulingGoal_value = map[string]int32{
		"FLEXRS_UNSPECIFIED":     0,
		"FLEXRS_SPEED_OPTIMIZED": 1,
		"FLEXRS_COST_OPTIMIZED":  2,
	}
)

func (x FlexResourceSchedulingGoal) Enum() *FlexResourceSchedulingGoal {
	p := new(FlexResourceSchedulingGoal)
	*p = x
	return p
}

func (x FlexResourceSchedulingGoal) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FlexResourceSchedulingGoal) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[1].Descriptor()
}

func (FlexResourceSchedulingGoal) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[1]
}

func (x FlexResourceSchedulingGoal) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FlexResourceSchedulingGoal.Descriptor instead.
func (FlexResourceSchedulingGoal) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{1}
}

// Specifies what happens to a resource when a Cloud Dataflow
// [google.dataflow.v1beta3.Job][google.dataflow.v1beta3.Job] has completed.
type TeardownPolicy int32

const (
	// The teardown policy isn't specified, or is unknown.
	TeardownPolicy_TEARDOWN_POLICY_UNKNOWN TeardownPolicy = 0
	// Always teardown the resource.
	TeardownPolicy_TEARDOWN_ALWAYS TeardownPolicy = 1
	// Teardown the resource on success. This is useful for debugging
	// failures.
	TeardownPolicy_TEARDOWN_ON_SUCCESS TeardownPolicy = 2
	// Never teardown the resource. This is useful for debugging and
	// development.
	TeardownPolicy_TEARDOWN_NEVER TeardownPolicy = 3
)

// Enum value maps for TeardownPolicy.
var (
	TeardownPolicy_name = map[int32]string{
		0: "TEARDOWN_POLICY_UNKNOWN",
		1: "TEARDOWN_ALWAYS",
		2: "TEARDOWN_ON_SUCCESS",
		3: "TEARDOWN_NEVER",
	}
	TeardownPolicy_value = map[string]int32{
		"TEARDOWN_POLICY_UNKNOWN": 0,
		"TEARDOWN_ALWAYS":         1,
		"TEARDOWN_ON_SUCCESS":     2,
		"TEARDOWN_NEVER":          3,
	}
)

func (x TeardownPolicy) Enum() *TeardownPolicy {
	p := new(TeardownPolicy)
	*p = x
	return p
}

func (x TeardownPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TeardownPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[2].Descriptor()
}

func (TeardownPolicy) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[2]
}

func (x TeardownPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TeardownPolicy.Descriptor instead.
func (TeardownPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{2}
}

// The default set of packages to be staged on a pool of workers.
type DefaultPackageSet int32

const (
	// The default set of packages to stage is unknown, or unspecified.
	DefaultPackageSet_DEFAULT_PACKAGE_SET_UNKNOWN DefaultPackageSet = 0
	// Indicates that no packages should be staged at the worker unless
	// explicitly specified by the job.
	DefaultPackageSet_DEFAULT_PACKAGE_SET_NONE DefaultPackageSet = 1
	// Stage packages typically useful to workers written in Java.
	DefaultPackageSet_DEFAULT_PACKAGE_SET_JAVA DefaultPackageSet = 2
	// Stage packages typically useful to workers written in Python.
	DefaultPackageSet_DEFAULT_PACKAGE_SET_PYTHON DefaultPackageSet = 3
)

// Enum value maps for DefaultPackageSet.
var (
	DefaultPackageSet_name = map[int32]string{
		0: "DEFAULT_PACKAGE_SET_UNKNOWN",
		1: "DEFAULT_PACKAGE_SET_NONE",
		2: "DEFAULT_PACKAGE_SET_JAVA",
		3: "DEFAULT_PACKAGE_SET_PYTHON",
	}
	DefaultPackageSet_value = map[string]int32{
		"DEFAULT_PACKAGE_SET_UNKNOWN": 0,
		"DEFAULT_PACKAGE_SET_NONE":    1,
		"DEFAULT_PACKAGE_SET_JAVA":    2,
		"DEFAULT_PACKAGE_SET_PYTHON":  3,
	}
)

func (x DefaultPackageSet) Enum() *DefaultPackageSet {
	p := new(DefaultPackageSet)
	*p = x
	return p
}

func (x DefaultPackageSet) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DefaultPackageSet) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[3].Descriptor()
}

func (DefaultPackageSet) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[3]
}

func (x DefaultPackageSet) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DefaultPackageSet.Descriptor instead.
func (DefaultPackageSet) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{3}
}

// Specifies the algorithm used to determine the number of worker
// processes to run at any given point in time, based on the amount of
// data left to process, the number of workers, and how quickly
// existing workers are processing data.
type AutoscalingAlgorithm int32

const (
	// The algorithm is unknown, or unspecified.
	AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_UNKNOWN AutoscalingAlgorithm = 0
	// Disable autoscaling.
	AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_NONE AutoscalingAlgorithm = 1
	// Increase worker count over time to reduce job execution time.
	AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_BASIC AutoscalingAlgorithm = 2
)

// Enum value maps for AutoscalingAlgorithm.
var (
	AutoscalingAlgorithm_name = map[int32]string{
		0: "AUTOSCALING_ALGORITHM_UNKNOWN",
		1: "AUTOSCALING_ALGORITHM_NONE",
		2: "AUTOSCALING_ALGORITHM_BASIC",
	}
	AutoscalingAlgorithm_value = map[string]int32{
		"AUTOSCALING_ALGORITHM_UNKNOWN": 0,
		"AUTOSCALING_ALGORITHM_NONE":    1,
		"AUTOSCALING_ALGORITHM_BASIC":   2,
	}
)

func (x AutoscalingAlgorithm) Enum() *AutoscalingAlgorithm {
	p := new(AutoscalingAlgorithm)
	*p = x
	return p
}

func (x AutoscalingAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[4].Descriptor()
}

func (AutoscalingAlgorithm) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[4]
}

func (x AutoscalingAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingAlgorithm.Descriptor instead.
func (AutoscalingAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{4}
}

// Specifies how IP addresses should be allocated to the worker machines.
type WorkerIPAddressConfiguration int32

const (
	// The configuration is unknown, or unspecified.
	WorkerIPAddressConfiguration_WORKER_IP_UNSPECIFIED WorkerIPAddressConfiguration = 0
	// Workers should have public IP addresses.
	WorkerIPAddressConfiguration_WORKER_IP_PUBLIC WorkerIPAddressConfiguration = 1
	// Workers should have private IP addresses.
	WorkerIPAddressConfiguration_WORKER_IP_PRIVATE WorkerIPAddressConfiguration = 2
)

// Enum value maps for WorkerIPAddressConfiguration.
var (
	WorkerIPAddressConfiguration_name = map[int32]string{
		0: "WORKER_IP_UNSPECIFIED",
		1: "WORKER_IP_PUBLIC",
		2: "WORKER_IP_PRIVATE",
	}
	WorkerIPAddressConfiguration_value = map[string]int32{
		"WORKER_IP_UNSPECIFIED": 0,
		"WORKER_IP_PUBLIC":      1,
		"WORKER_IP_PRIVATE":     2,
	}
)

func (x WorkerIPAddressConfiguration) Enum() *WorkerIPAddressConfiguration {
	p := new(WorkerIPAddressConfiguration)
	*p = x
	return p
}

func (x WorkerIPAddressConfiguration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkerIPAddressConfiguration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[5].Descriptor()
}

func (WorkerIPAddressConfiguration) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[5]
}

func (x WorkerIPAddressConfiguration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkerIPAddressConfiguration.Descriptor instead.
func (WorkerIPAddressConfiguration) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{5}
}

// Specifies the shuffle mode used by a
// [google.dataflow.v1beta3.Job], which determines the approach data is shuffled
// during processing. More details in:
// https://cloud.google.com/dataflow/docs/guides/deploying-a-pipeline#dataflow-shuffle
type ShuffleMode int32

const (
	// Shuffle mode information is not available.
	ShuffleMode_SHUFFLE_MODE_UNSPECIFIED ShuffleMode = 0
	// Shuffle is done on the worker VMs.
	ShuffleMode_VM_BASED ShuffleMode = 1
	// Shuffle is done on the service side.
	ShuffleMode_SERVICE_BASED ShuffleMode = 2
)

// Enum value maps for ShuffleMode.
var (
	ShuffleMode_name = map[int32]string{
		0: "SHUFFLE_MODE_UNSPECIFIED",
		1: "VM_BASED",
		2: "SERVICE_BASED",
	}
	ShuffleMode_value = map[string]int32{
		"SHUFFLE_MODE_UNSPECIFIED": 0,
		"VM_BASED":                 1,
		"SERVICE_BASED":            2,
	}
)

func (x ShuffleMode) Enum() *ShuffleMode {
	p := new(ShuffleMode)
	*p = x
	return p
}

func (x ShuffleMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShuffleMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_environment_proto_enumTypes[6].Descriptor()
}

func (ShuffleMode) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_environment_proto_enumTypes[6]
}

func (x ShuffleMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShuffleMode.Descriptor instead.
func (ShuffleMode) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{6}
}

// Describes the environment in which a Dataflow Job runs.
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prefix of the resources the system should use for temporary
	// storage.  The system will append the suffix "/temp-{JOBNAME} to
	// this resource prefix, where {JOBNAME} is the value of the
	// job_name field.  The resulting bucket and object prefix is used
	// as the prefix of the resources used to store temporary data
	// needed during the job execution.  NOTE: This will override the
	// value in taskrunner_settings.
	// The supported resource type is:
	//
	// Google Cloud Storage:
	//
	//	storage.googleapis.com/{bucket}/{object}
	//	bucket.storage.googleapis.com/{object}
	TempStoragePrefix string `protobuf:"bytes,1,opt,name=temp_storage_prefix,json=tempStoragePrefix,proto3" json:"temp_storage_prefix,omitempty"`
	// The type of cluster manager API to use.  If unknown or
	// unspecified, the service will attempt to choose a reasonable
	// default.  This should be in the form of the API service name,
	// e.g. "compute.googleapis.com".
	ClusterManagerApiService string `protobuf:"bytes,2,opt,name=cluster_manager_api_service,json=clusterManagerApiService,proto3" json:"cluster_manager_api_service,omitempty"`
	// The list of experiments to enable. This field should be used for SDK
	// related experiments and not for service related experiments. The proper
	// field for service related experiments is service_options.
	Experiments []string `protobuf:"bytes,3,rep,name=experiments,proto3" json:"experiments,omitempty"`
	// The list of service options to enable. This field should be used for
	// service related experiments only. These experiments, when graduating to GA,
	// should be replaced by dedicated fields or become default (i.e. always on).
	ServiceOptions []string `protobuf:"bytes,16,rep,name=service_options,json=serviceOptions,proto3" json:"service_options,omitempty"`
	// If set, contains the Cloud KMS key identifier used to encrypt data
	// at rest, AKA a Customer Managed Encryption Key (CMEK).
	//
	// Format:
	//
	//	projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
	ServiceKmsKeyName string `protobuf:"bytes,12,opt,name=service_kms_key_name,json=serviceKmsKeyName,proto3" json:"service_kms_key_name,omitempty"`
	// The worker pools. At least one "harness" worker pool must be
	// specified in order for the job to have workers.
	WorkerPools []*WorkerPool `protobuf:"bytes,4,rep,name=worker_pools,json=workerPools,proto3" json:"worker_pools,omitempty"`
	// A description of the process that generated the request.
	UserAgent *structpb.Struct `protobuf:"bytes,5,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// A structure describing which components and their versions of the service
	// are required in order to run the job.
	Version *structpb.Struct `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
	// The dataset for the current project where various workflow
	// related tables are stored.
	//
	// The supported resource type is:
	//
	// Google BigQuery:
	//
	//	bigquery.googleapis.com/{dataset}
	Dataset string `protobuf:"bytes,7,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The Cloud Dataflow SDK pipeline options specified by the user. These
	// options are passed through the service and are used to recreate the
	// SDK pipeline options on the worker in a language agnostic and platform
	// independent way.
	SdkPipelineOptions *structpb.Struct `protobuf:"bytes,8,opt,name=sdk_pipeline_options,json=sdkPipelineOptions,proto3" json:"sdk_pipeline_options,omitempty"`
	// Experimental settings.
	InternalExperiments *anypb.Any `protobuf:"bytes,9,opt,name=internal_experiments,json=internalExperiments,proto3" json:"internal_experiments,omitempty"`
	// Identity to run virtual machines as. Defaults to the default account.
	ServiceAccountEmail string `protobuf:"bytes,10,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Which Flexible Resource Scheduling mode to run in.
	FlexResourceSchedulingGoal FlexResourceSchedulingGoal `protobuf:"varint,11,opt,name=flex_resource_scheduling_goal,json=flexResourceSchedulingGoal,proto3,enum=google.dataflow.v1beta3.FlexResourceSchedulingGoal" json:"flex_resource_scheduling_goal,omitempty"`
	// The Compute Engine region
	// (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
	// which worker processing should occur, e.g. "us-west1". Mutually exclusive
	// with worker_zone. If neither worker_region nor worker_zone is specified,
	// default to the control plane's region.
	WorkerRegion string `protobuf:"bytes,13,opt,name=worker_region,json=workerRegion,proto3" json:"worker_region,omitempty"`
	// The Compute Engine zone
	// (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
	// which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
	// with worker_region. If neither worker_region nor worker_zone is specified,
	// a zone in the control plane's region is chosen based on available capacity.
	WorkerZone string `protobuf:"bytes,14,opt,name=worker_zone,json=workerZone,proto3" json:"worker_zone,omitempty"`
	// Output only. The shuffle mode used for the job.
	ShuffleMode ShuffleMode `protobuf:"varint,15,opt,name=shuffle_mode,json=shuffleMode,proto3,enum=google.dataflow.v1beta3.ShuffleMode" json:"shuffle_mode,omitempty"`
	// Any debugging options to be supplied to the job.
	DebugOptions *DebugOptions `protobuf:"bytes,17,opt,name=debug_options,json=debugOptions,proto3" json:"debug_options,omitempty"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{0}
}

func (x *Environment) GetTempStoragePrefix() string {
	if x != nil {
		return x.TempStoragePrefix
	}
	return ""
}

func (x *Environment) GetClusterManagerApiService() string {
	if x != nil {
		return x.ClusterManagerApiService
	}
	return ""
}

func (x *Environment) GetExperiments() []string {
	if x != nil {
		return x.Experiments
	}
	return nil
}

func (x *Environment) GetServiceOptions() []string {
	if x != nil {
		return x.ServiceOptions
	}
	return nil
}

func (x *Environment) GetServiceKmsKeyName() string {
	if x != nil {
		return x.ServiceKmsKeyName
	}
	return ""
}

func (x *Environment) GetWorkerPools() []*WorkerPool {
	if x != nil {
		return x.WorkerPools
	}
	return nil
}

func (x *Environment) GetUserAgent() *structpb.Struct {
	if x != nil {
		return x.UserAgent
	}
	return nil
}

func (x *Environment) GetVersion() *structpb.Struct {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *Environment) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *Environment) GetSdkPipelineOptions() *structpb.Struct {
	if x != nil {
		return x.SdkPipelineOptions
	}
	return nil
}

func (x *Environment) GetInternalExperiments() *anypb.Any {
	if x != nil {
		return x.InternalExperiments
	}
	return nil
}

func (x *Environment) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *Environment) GetFlexResourceSchedulingGoal() FlexResourceSchedulingGoal {
	if x != nil {
		return x.FlexResourceSchedulingGoal
	}
	return FlexResourceSchedulingGoal_FLEXRS_UNSPECIFIED
}

func (x *Environment) GetWorkerRegion() string {
	if x != nil {
		return x.WorkerRegion
	}
	return ""
}

func (x *Environment) GetWorkerZone() string {
	if x != nil {
		return x.WorkerZone
	}
	return ""
}

func (x *Environment) GetShuffleMode() ShuffleMode {
	if x != nil {
		return x.ShuffleMode
	}
	return ShuffleMode_SHUFFLE_MODE_UNSPECIFIED
}

func (x *Environment) GetDebugOptions() *DebugOptions {
	if x != nil {
		return x.DebugOptions
	}
	return nil
}

// The packages that must be installed in order for a worker to run the
// steps of the Cloud Dataflow job that will be assigned to its worker
// pool.
//
// This is the mechanism by which the Cloud Dataflow SDK causes code to
// be loaded onto the workers. For example, the Cloud Dataflow Java SDK
// might use this to install jars containing the user's code and all of the
// various dependencies (libraries, data files, etc.) required in order
// for that code to run.
type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource to read the package from. The supported resource type is:
	//
	// Google Cloud Storage:
	//
	//	storage.googleapis.com/{bucket}
	//	bucket.storage.googleapis.com/
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{1}
}

func (x *Package) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Package) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Describes the data disk used by a workflow job.
type Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Size of disk in GB.  If zero or unspecified, the service will
	// attempt to choose a reasonable default.
	SizeGb int32 `protobuf:"varint,1,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// Disk storage type, as defined by Google Compute Engine.  This
	// must be a disk type appropriate to the project and zone in which
	// the workers will run.  If unknown or unspecified, the service
	// will attempt to choose a reasonable default.
	//
	// For example, the standard persistent disk type is a resource name
	// typically ending in "pd-standard".  If SSD persistent disks are
	// available, the resource name typically ends with "pd-ssd".  The
	// actual valid values are defined the Google Compute Engine API,
	// not by the Cloud Dataflow API; consult the Google Compute Engine
	// documentation for more information about determining the set of
	// available disk types for a particular project and zone.
	//
	// Google Compute Engine Disk types are local to a particular
	// project in a particular zone, and so the resource name will
	// typically look something like this:
	//
	// compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
	DiskType string `protobuf:"bytes,2,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Directory in a VM where disk is mounted.
	MountPoint string `protobuf:"bytes,3,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
}

func (x *Disk) Reset() {
	*x = Disk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Disk) ProtoMessage() {}

func (x *Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Disk.ProtoReflect.Descriptor instead.
func (*Disk) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{2}
}

func (x *Disk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *Disk) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *Disk) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

// Provides data to pass through to the worker harness.
type WorkerSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base URL for accessing Google Cloud APIs.
	//
	// When workers access Google Cloud APIs, they logically do so via
	// relative URLs.  If this field is specified, it supplies the base
	// URL to use for resolving these relative URLs.  The normative
	// algorithm used is defined by RFC 1808, "Relative Uniform Resource
	// Locators".
	//
	// If not specified, the default value is "http://www.googleapis.com/"
	BaseUrl string `protobuf:"bytes,1,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// Whether to send work progress updates to the service.
	ReportingEnabled bool `protobuf:"varint,2,opt,name=reporting_enabled,json=reportingEnabled,proto3" json:"reporting_enabled,omitempty"`
	// The Cloud Dataflow service path relative to the root URL, for example,
	// "dataflow/v1b3/projects".
	ServicePath string `protobuf:"bytes,3,opt,name=service_path,json=servicePath,proto3" json:"service_path,omitempty"`
	// The Shuffle service path relative to the root URL, for example,
	// "shuffle/v1beta1".
	ShuffleServicePath string `protobuf:"bytes,4,opt,name=shuffle_service_path,json=shuffleServicePath,proto3" json:"shuffle_service_path,omitempty"`
	// The ID of the worker running this pipeline.
	WorkerId string `protobuf:"bytes,5,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	// The prefix of the resources the system should use for temporary
	// storage.
	//
	// The supported resource type is:
	//
	// Google Cloud Storage:
	//
	//	storage.googleapis.com/{bucket}/{object}
	//	bucket.storage.googleapis.com/{object}
	TempStoragePrefix string `protobuf:"bytes,6,opt,name=temp_storage_prefix,json=tempStoragePrefix,proto3" json:"temp_storage_prefix,omitempty"`
}

func (x *WorkerSettings) Reset() {
	*x = WorkerSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerSettings) ProtoMessage() {}

func (x *WorkerSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerSettings.ProtoReflect.Descriptor instead.
func (*WorkerSettings) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{3}
}

func (x *WorkerSettings) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *WorkerSettings) GetReportingEnabled() bool {
	if x != nil {
		return x.ReportingEnabled
	}
	return false
}

func (x *WorkerSettings) GetServicePath() string {
	if x != nil {
		return x.ServicePath
	}
	return ""
}

func (x *WorkerSettings) GetShuffleServicePath() string {
	if x != nil {
		return x.ShuffleServicePath
	}
	return ""
}

func (x *WorkerSettings) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

func (x *WorkerSettings) GetTempStoragePrefix() string {
	if x != nil {
		return x.TempStoragePrefix
	}
	return ""
}

// Taskrunner configuration settings.
type TaskRunnerSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The UNIX user ID on the worker VM to use for tasks launched by
	// taskrunner; e.g. "root".
	TaskUser string `protobuf:"bytes,1,opt,name=task_user,json=taskUser,proto3" json:"task_user,omitempty"`
	// The UNIX group ID on the worker VM to use for tasks launched by
	// taskrunner; e.g. "wheel".
	TaskGroup string `protobuf:"bytes,2,opt,name=task_group,json=taskGroup,proto3" json:"task_group,omitempty"`
	// The OAuth2 scopes to be requested by the taskrunner in order to
	// access the Cloud Dataflow API.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The base URL for the taskrunner to use when accessing Google Cloud APIs.
	//
	// When workers access Google Cloud APIs, they logically do so via
	// relative URLs.  If this field is specified, it supplies the base
	// URL to use for resolving these relative URLs.  The normative
	// algorithm used is defined by RFC 1808, "Relative Uniform Resource
	// Locators".
	//
	// If not specified, the default value is "http://www.googleapis.com/"
	BaseUrl string `protobuf:"bytes,4,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// The API version of endpoint, e.g. "v1b3"
	DataflowApiVersion string `protobuf:"bytes,5,opt,name=dataflow_api_version,json=dataflowApiVersion,proto3" json:"dataflow_api_version,omitempty"`
	// The settings to pass to the parallel worker harness.
	ParallelWorkerSettings *WorkerSettings `protobuf:"bytes,6,opt,name=parallel_worker_settings,json=parallelWorkerSettings,proto3" json:"parallel_worker_settings,omitempty"`
	// The location on the worker for task-specific subdirectories.
	BaseTaskDir string `protobuf:"bytes,7,opt,name=base_task_dir,json=baseTaskDir,proto3" json:"base_task_dir,omitempty"`
	// Whether to continue taskrunner if an exception is hit.
	ContinueOnException bool `protobuf:"varint,8,opt,name=continue_on_exception,json=continueOnException,proto3" json:"continue_on_exception,omitempty"`
	// Whether to send taskrunner log info to Google Compute Engine VM serial
	// console.
	LogToSerialconsole bool `protobuf:"varint,9,opt,name=log_to_serialconsole,json=logToSerialconsole,proto3" json:"log_to_serialconsole,omitempty"`
	// Whether to also send taskrunner log info to stderr.
	Alsologtostderr bool `protobuf:"varint,10,opt,name=alsologtostderr,proto3" json:"alsologtostderr,omitempty"`
	// Indicates where to put logs.  If this is not specified, the logs
	// will not be uploaded.
	//
	// The supported resource type is:
	//
	// Google Cloud Storage:
	//
	//	storage.googleapis.com/{bucket}/{object}
	//	bucket.storage.googleapis.com/{object}
	LogUploadLocation string `protobuf:"bytes,11,opt,name=log_upload_location,json=logUploadLocation,proto3" json:"log_upload_location,omitempty"`
	// The directory on the VM to store logs.
	LogDir string `protobuf:"bytes,12,opt,name=log_dir,json=logDir,proto3" json:"log_dir,omitempty"`
	// The prefix of the resources the taskrunner should use for
	// temporary storage.
	//
	// The supported resource type is:
	//
	// Google Cloud Storage:
	//
	//	storage.googleapis.com/{bucket}/{object}
	//	bucket.storage.googleapis.com/{object}
	TempStoragePrefix string `protobuf:"bytes,13,opt,name=temp_storage_prefix,json=tempStoragePrefix,proto3" json:"temp_storage_prefix,omitempty"`
	// The command to launch the worker harness.
	HarnessCommand string `protobuf:"bytes,14,opt,name=harness_command,json=harnessCommand,proto3" json:"harness_command,omitempty"`
	// The file to store the workflow in.
	WorkflowFileName string `protobuf:"bytes,15,opt,name=workflow_file_name,json=workflowFileName,proto3" json:"workflow_file_name,omitempty"`
	// The file to store preprocessing commands in.
	CommandlinesFileName string `protobuf:"bytes,16,opt,name=commandlines_file_name,json=commandlinesFileName,proto3" json:"commandlines_file_name,omitempty"`
	// The ID string of the VM.
	VmId string `protobuf:"bytes,17,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// The suggested backend language.
	LanguageHint string `protobuf:"bytes,18,opt,name=language_hint,json=languageHint,proto3" json:"language_hint,omitempty"`
	// The streaming worker main class name.
	StreamingWorkerMainClass string `protobuf:"bytes,19,opt,name=streaming_worker_main_class,json=streamingWorkerMainClass,proto3" json:"streaming_worker_main_class,omitempty"`
}

func (x *TaskRunnerSettings) Reset() {
	*x = TaskRunnerSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskRunnerSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskRunnerSettings) ProtoMessage() {}

func (x *TaskRunnerSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskRunnerSettings.ProtoReflect.Descriptor instead.
func (*TaskRunnerSettings) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{4}
}

func (x *TaskRunnerSettings) GetTaskUser() string {
	if x != nil {
		return x.TaskUser
	}
	return ""
}

func (x *TaskRunnerSettings) GetTaskGroup() string {
	if x != nil {
		return x.TaskGroup
	}
	return ""
}

func (x *TaskRunnerSettings) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *TaskRunnerSettings) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *TaskRunnerSettings) GetDataflowApiVersion() string {
	if x != nil {
		return x.DataflowApiVersion
	}
	return ""
}

func (x *TaskRunnerSettings) GetParallelWorkerSettings() *WorkerSettings {
	if x != nil {
		return x.ParallelWorkerSettings
	}
	return nil
}

func (x *TaskRunnerSettings) GetBaseTaskDir() string {
	if x != nil {
		return x.BaseTaskDir
	}
	return ""
}

func (x *TaskRunnerSettings) GetContinueOnException() bool {
	if x != nil {
		return x.ContinueOnException
	}
	return false
}

func (x *TaskRunnerSettings) GetLogToSerialconsole() bool {
	if x != nil {
		return x.LogToSerialconsole
	}
	return false
}

func (x *TaskRunnerSettings) GetAlsologtostderr() bool {
	if x != nil {
		return x.Alsologtostderr
	}
	return false
}

func (x *TaskRunnerSettings) GetLogUploadLocation() string {
	if x != nil {
		return x.LogUploadLocation
	}
	return ""
}

func (x *TaskRunnerSettings) GetLogDir() string {
	if x != nil {
		return x.LogDir
	}
	return ""
}

func (x *TaskRunnerSettings) GetTempStoragePrefix() string {
	if x != nil {
		return x.TempStoragePrefix
	}
	return ""
}

func (x *TaskRunnerSettings) GetHarnessCommand() string {
	if x != nil {
		return x.HarnessCommand
	}
	return ""
}

func (x *TaskRunnerSettings) GetWorkflowFileName() string {
	if x != nil {
		return x.WorkflowFileName
	}
	return ""
}

func (x *TaskRunnerSettings) GetCommandlinesFileName() string {
	if x != nil {
		return x.CommandlinesFileName
	}
	return ""
}

func (x *TaskRunnerSettings) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *TaskRunnerSettings) GetLanguageHint() string {
	if x != nil {
		return x.LanguageHint
	}
	return ""
}

func (x *TaskRunnerSettings) GetStreamingWorkerMainClass() string {
	if x != nil {
		return x.StreamingWorkerMainClass
	}
	return ""
}

// Settings for WorkerPool autoscaling.
type AutoscalingSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The algorithm to use for autoscaling.
	Algorithm AutoscalingAlgorithm `protobuf:"varint,1,opt,name=algorithm,proto3,enum=google.dataflow.v1beta3.AutoscalingAlgorithm" json:"algorithm,omitempty"`
	// The maximum number of workers to cap scaling at.
	MaxNumWorkers int32 `protobuf:"varint,2,opt,name=max_num_workers,json=maxNumWorkers,proto3" json:"max_num_workers,omitempty"`
}

func (x *AutoscalingSettings) Reset() {
	*x = AutoscalingSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingSettings) ProtoMessage() {}

func (x *AutoscalingSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingSettings.ProtoReflect.Descriptor instead.
func (*AutoscalingSettings) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{5}
}

func (x *AutoscalingSettings) GetAlgorithm() AutoscalingAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_UNKNOWN
}

func (x *AutoscalingSettings) GetMaxNumWorkers() int32 {
	if x != nil {
		return x.MaxNumWorkers
	}
	return 0
}

// Defines a SDK harness container for executing Dataflow pipelines.
type SdkHarnessContainerImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A docker container image that resides in Google Container Registry.
	ContainerImage string `protobuf:"bytes,1,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
	// If true, recommends the Dataflow service to use only one core per SDK
	// container instance with this image. If false (or unset) recommends using
	// more than one core per SDK container instance with this image for
	// efficiency. Note that Dataflow service may choose to override this property
	// if needed.
	UseSingleCorePerContainer bool `protobuf:"varint,2,opt,name=use_single_core_per_container,json=useSingleCorePerContainer,proto3" json:"use_single_core_per_container,omitempty"`
	// Environment ID for the Beam runner API proto Environment that corresponds
	// to the current SDK Harness.
	EnvironmentId string `protobuf:"bytes,3,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
	// The set of capabilities enumerated in the above Environment proto. See also
	// https://github.com/apache/beam/blob/master/model/pipeline/src/main/proto/beam_runner_api.proto
	Capabilities []string `protobuf:"bytes,4,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
}

func (x *SdkHarnessContainerImage) Reset() {
	*x = SdkHarnessContainerImage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SdkHarnessContainerImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdkHarnessContainerImage) ProtoMessage() {}

func (x *SdkHarnessContainerImage) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdkHarnessContainerImage.ProtoReflect.Descriptor instead.
func (*SdkHarnessContainerImage) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{6}
}

func (x *SdkHarnessContainerImage) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

func (x *SdkHarnessContainerImage) GetUseSingleCorePerContainer() bool {
	if x != nil {
		return x.UseSingleCorePerContainer
	}
	return false
}

func (x *SdkHarnessContainerImage) GetEnvironmentId() string {
	if x != nil {
		return x.EnvironmentId
	}
	return ""
}

func (x *SdkHarnessContainerImage) GetCapabilities() []string {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

// Describes one particular pool of Cloud Dataflow workers to be
// instantiated by the Cloud Dataflow service in order to perform the
// computations required by a job.  Note that a workflow job may use
// multiple pools, in order to match the various computational
// requirements of the various stages of the job.
type WorkerPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of the worker pool; currently only `harness` and `shuffle`
	// are supported.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Number of Google Compute Engine workers in this pool needed to
	// execute the job.  If zero or unspecified, the service will
	// attempt to choose a reasonable default.
	NumWorkers int32 `protobuf:"varint,2,opt,name=num_workers,json=numWorkers,proto3" json:"num_workers,omitempty"`
	// Packages to be installed on workers.
	Packages []*Package `protobuf:"bytes,3,rep,name=packages,proto3" json:"packages,omitempty"`
	// The default package set to install.  This allows the service to
	// select a default set of packages which are useful to worker
	// harnesses written in a particular language.
	DefaultPackageSet DefaultPackageSet `protobuf:"varint,4,opt,name=default_package_set,json=defaultPackageSet,proto3,enum=google.dataflow.v1beta3.DefaultPackageSet" json:"default_package_set,omitempty"`
	// Machine type (e.g. "n1-standard-1").  If empty or unspecified, the
	// service will attempt to choose a reasonable default.
	MachineType string `protobuf:"bytes,5,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Sets the policy for determining when to turndown worker pool.
	// Allowed values are: `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and
	// `TEARDOWN_NEVER`.
	// `TEARDOWN_ALWAYS` means workers are always torn down regardless of whether
	// the job succeeds. `TEARDOWN_ON_SUCCESS` means workers are torn down
	// if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn
	// down.
	//
	// If the workers are not torn down by the service, they will
	// continue to run and use Google Compute Engine VM resources in the
	// user's project until they are explicitly terminated by the user.
	// Because of this, Google recommends using the `TEARDOWN_ALWAYS`
	// policy except for small, manually supervised test jobs.
	//
	// If unknown or unspecified, the service will attempt to choose a reasonable
	// default.
	TeardownPolicy TeardownPolicy `protobuf:"varint,6,opt,name=teardown_policy,json=teardownPolicy,proto3,enum=google.dataflow.v1beta3.TeardownPolicy" json:"teardown_policy,omitempty"`
	// Size of root disk for VMs, in GB.  If zero or unspecified, the service will
	// attempt to choose a reasonable default.
	DiskSizeGb int32 `protobuf:"varint,7,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Type of root disk for VMs.  If empty or unspecified, the service will
	// attempt to choose a reasonable default.
	DiskType string `protobuf:"bytes,16,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Fully qualified source image for disks.
	DiskSourceImage string `protobuf:"bytes,8,opt,name=disk_source_image,json=diskSourceImage,proto3" json:"disk_source_image,omitempty"`
	// Zone to run the worker pools in.  If empty or unspecified, the service
	// will attempt to choose a reasonable default.
	Zone string `protobuf:"bytes,9,opt,name=zone,proto3" json:"zone,omitempty"`
	// Settings passed through to Google Compute Engine workers when
	// using the standard Dataflow task runner.  Users should ignore
	// this field.
	TaskrunnerSettings *TaskRunnerSettings `protobuf:"bytes,10,opt,name=taskrunner_settings,json=taskrunnerSettings,proto3" json:"taskrunner_settings,omitempty"`
	// The action to take on host maintenance, as defined by the Google
	// Compute Engine API.
	OnHostMaintenance string `protobuf:"bytes,11,opt,name=on_host_maintenance,json=onHostMaintenance,proto3" json:"on_host_maintenance,omitempty"`
	// Data disks that are used by a VM in this workflow.
	DataDisks []*Disk `protobuf:"bytes,12,rep,name=data_disks,json=dataDisks,proto3" json:"data_disks,omitempty"`
	// Metadata to set on the Google Compute Engine VMs.
	Metadata map[string]string `protobuf:"bytes,13,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Settings for autoscaling of this WorkerPool.
	AutoscalingSettings *AutoscalingSettings `protobuf:"bytes,14,opt,name=autoscaling_settings,json=autoscalingSettings,proto3" json:"autoscaling_settings,omitempty"`
	// Extra arguments for this worker pool.
	PoolArgs *anypb.Any `protobuf:"bytes,15,opt,name=pool_args,json=poolArgs,proto3" json:"pool_args,omitempty"`
	// Network to which VMs will be assigned.  If empty or unspecified,
	// the service will use the network "default".
	Network string `protobuf:"bytes,17,opt,name=network,proto3" json:"network,omitempty"`
	// Subnetwork to which VMs will be assigned, if desired.  Expected to be of
	// the form "regions/REGION/subnetworks/SUBNETWORK".
	Subnetwork string `protobuf:"bytes,19,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Required. Docker container image that executes the Cloud Dataflow worker
	// harness, residing in Google Container Registry.
	//
	// Deprecated for the Fn API path. Use sdk_harness_container_images instead.
	WorkerHarnessContainerImage string `protobuf:"bytes,18,opt,name=worker_harness_container_image,json=workerHarnessContainerImage,proto3" json:"worker_harness_container_image,omitempty"`
	// The number of threads per worker harness. If empty or unspecified, the
	// service will choose a number of threads (according to the number of cores
	// on the selected machine type for batch, or 1 by convention for streaming).
	NumThreadsPerWorker int32 `protobuf:"varint,20,opt,name=num_threads_per_worker,json=numThreadsPerWorker,proto3" json:"num_threads_per_worker,omitempty"`
	// Configuration for VM IPs.
	IpConfiguration WorkerIPAddressConfiguration `protobuf:"varint,21,opt,name=ip_configuration,json=ipConfiguration,proto3,enum=google.dataflow.v1beta3.WorkerIPAddressConfiguration" json:"ip_configuration,omitempty"`
	// Set of SDK harness containers needed to execute this pipeline. This will
	// only be set in the Fn API path. For non-cross-language pipelines this
	// should have only one entry. Cross-language pipelines will have two or more
	// entries.
	SdkHarnessContainerImages []*SdkHarnessContainerImage `protobuf:"bytes,22,rep,name=sdk_harness_container_images,json=sdkHarnessContainerImages,proto3" json:"sdk_harness_container_images,omitempty"`
}

func (x *WorkerPool) Reset() {
	*x = WorkerPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerPool) ProtoMessage() {}

func (x *WorkerPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerPool.ProtoReflect.Descriptor instead.
func (*WorkerPool) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{7}
}

func (x *WorkerPool) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *WorkerPool) GetNumWorkers() int32 {
	if x != nil {
		return x.NumWorkers
	}
	return 0
}

func (x *WorkerPool) GetPackages() []*Package {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *WorkerPool) GetDefaultPackageSet() DefaultPackageSet {
	if x != nil {
		return x.DefaultPackageSet
	}
	return DefaultPackageSet_DEFAULT_PACKAGE_SET_UNKNOWN
}

func (x *WorkerPool) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *WorkerPool) GetTeardownPolicy() TeardownPolicy {
	if x != nil {
		return x.TeardownPolicy
	}
	return TeardownPolicy_TEARDOWN_POLICY_UNKNOWN
}

func (x *WorkerPool) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *WorkerPool) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *WorkerPool) GetDiskSourceImage() string {
	if x != nil {
		return x.DiskSourceImage
	}
	return ""
}

func (x *WorkerPool) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *WorkerPool) GetTaskrunnerSettings() *TaskRunnerSettings {
	if x != nil {
		return x.TaskrunnerSettings
	}
	return nil
}

func (x *WorkerPool) GetOnHostMaintenance() string {
	if x != nil {
		return x.OnHostMaintenance
	}
	return ""
}

func (x *WorkerPool) GetDataDisks() []*Disk {
	if x != nil {
		return x.DataDisks
	}
	return nil
}

func (x *WorkerPool) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *WorkerPool) GetAutoscalingSettings() *AutoscalingSettings {
	if x != nil {
		return x.AutoscalingSettings
	}
	return nil
}

func (x *WorkerPool) GetPoolArgs() *anypb.Any {
	if x != nil {
		return x.PoolArgs
	}
	return nil
}

func (x *WorkerPool) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *WorkerPool) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *WorkerPool) GetWorkerHarnessContainerImage() string {
	if x != nil {
		return x.WorkerHarnessContainerImage
	}
	return ""
}

func (x *WorkerPool) GetNumThreadsPerWorker() int32 {
	if x != nil {
		return x.NumThreadsPerWorker
	}
	return 0
}

func (x *WorkerPool) GetIpConfiguration() WorkerIPAddressConfiguration {
	if x != nil {
		return x.IpConfiguration
	}
	return WorkerIPAddressConfiguration_WORKER_IP_UNSPECIFIED
}

func (x *WorkerPool) GetSdkHarnessContainerImages() []*SdkHarnessContainerImage {
	if x != nil {
		return x.SdkHarnessContainerImages
	}
	return nil
}

// Describes any options that have an effect on the debugging of pipelines.
type DebugOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When true, enables the logging of the literal hot key to the user's Cloud
	// Logging.
	EnableHotKeyLogging bool `protobuf:"varint,1,opt,name=enable_hot_key_logging,json=enableHotKeyLogging,proto3" json:"enable_hot_key_logging,omitempty"`
}

func (x *DebugOptions) Reset() {
	*x = DebugOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugOptions) ProtoMessage() {}

func (x *DebugOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_environment_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugOptions.ProtoReflect.Descriptor instead.
func (*DebugOptions) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_environment_proto_rawDescGZIP(), []int{8}
}

func (x *DebugOptions) GetEnableHotKeyLogging() bool {
	if x != nil {
		return x.EnableHotKeyLogging
	}
	return false
}

var File_google_dataflow_v1beta3_environment_proto protoreflect.FileDescriptor

var file_google_dataflow_v1beta3_environment_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe5,
	0x07, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2e,
	0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x74, 0x65, 0x6d,
	0x70, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x3d,
	0x0a, 0x1b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x18, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x0c, 0x77, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x12, 0x36, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x49, 0x0a, 0x14, 0x73, 0x64, 0x6b, 0x5f, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x12, 0x73,
	0x64, 0x6b, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x47, 0x0a, 0x14, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x76,
	0x0a, 0x1d, 0x66, 0x6c, 0x65, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x46, 0x6c, 0x65, 0x78, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x47, 0x6f, 0x61, 0x6c, 0x52, 0x1a, 0x66, 0x6c, 0x65, 0x78,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69,
	0x6e, 0x67, 0x47, 0x6f, 0x61, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x4c, 0x0a, 0x0c,
	0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x68, 0x75,
	0x66, 0x66, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73,
	0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x65, 0x62, 0x75,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x62, 0x75, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x39, 0x0a, 0x07, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5d, 0x0a, 0x04, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x67, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65,
	0x47, 0x62, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x22, 0xfa, 0x01, 0x0a, 0x0e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x2b,
	0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x30,
	0x0a, 0x14, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x68,
	0x75, 0x66, 0x66, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x1b, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2e, 0x0a,
	0x13, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0xd6, 0x06,
	0x0a, 0x12, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x55, 0x73, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x30,
	0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x61, 0x0a, 0x18, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x5f, 0x77, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x16, 0x70, 0x61, 0x72,
	0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x64, 0x69, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x65,
	0x54, 0x61, 0x73, 0x6b, 0x44, 0x69, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x69,
	0x6e, 0x75, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65,
	0x4f, 0x6e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x6c,
	0x6f, 0x67, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6e, 0x73,
	0x6f, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x6c, 0x6f, 0x67, 0x54, 0x6f,
	0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x12, 0x28, 0x0a,
	0x0f, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x6f, 0x67, 0x74, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x6f, 0x67, 0x74,
	0x6f, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x6c, 0x6f, 0x67, 0x5f, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6c, 0x6f, 0x67, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x5f, 0x64,
	0x69, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f, 0x67, 0x44, 0x69, 0x72,
	0x12, 0x2e, 0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x74,
	0x65, 0x6d, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x27, 0x0a, 0x0f, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x68, 0x61, 0x72, 0x6e, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x77, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x46,
	0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x13, 0x0a,
	0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x6d,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x68,
	0x69, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x69, 0x6e,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4d, 0x61, 0x69,
	0x6e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4b,
	0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x26, 0x0a, 0x0f, 0x6d,
	0x61, 0x78, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x4e, 0x75, 0x6d, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x18, 0x53, 0x64, 0x6b, 0x48, 0x61, 0x72, 0x6e, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x40, 0x0a, 0x1d, 0x75, 0x73, 0x65,
	0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x19, 0x75, 0x73, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x50,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0xc5, 0x0a, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x75, 0x6d,
	0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x6e, 0x75, 0x6d, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x3c, 0x0a, 0x08, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x08,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x65,
	0x74, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x53, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x0f, 0x74, 0x65, 0x61, 0x72, 0x64,
	0x6f, 0x77, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x54, 0x65, 0x61, 0x72, 0x64,
	0x6f, 0x77, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0e, 0x74, 0x65, 0x61, 0x72, 0x64,
	0x6f, 0x77, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x1b, 0x0a, 0x09, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x5c, 0x0a, 0x13, 0x74, 0x61, 0x73, 0x6b,
	0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x12, 0x74, 0x61, 0x73, 0x6b, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64,
	0x69, 0x73, 0x6b, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x44,
	0x69, 0x73, 0x6b, 0x73, 0x12, 0x4d, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x13, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x72, 0x67,
	0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x08, 0x70,
	0x6f, 0x6f, 0x6c, 0x41, 0x72, 0x67, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x43, 0x0a, 0x1e, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x68, 0x61, 0x72, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x48, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x64, 0x73, 0x50, 0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x12, 0x60, 0x0a, 0x10, 0x69,
	0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x50, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x69, 0x70,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a,
	0x1c, 0x73, 0x64, 0x6b, 0x5f, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x16, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x64,
	0x6b, 0x48, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x19, 0x73, 0x64, 0x6b, 0x48, 0x61, 0x72, 0x6e, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x73, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x43,
	0x0a, 0x0c, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33,
	0x0a, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x6f, 0x74, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x6f, 0x74, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2a, 0x4b, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x42, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4a, 0x4f, 0x42, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x2a, 0x6b, 0x0a, 0x1a, 0x46, 0x6c, 0x65, 0x78, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x47, 0x6f, 0x61, 0x6c, 0x12, 0x16,
	0x0a, 0x12, 0x46, 0x4c, 0x45, 0x58, 0x52, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x4c, 0x45, 0x58, 0x52, 0x53,
	0x5f, 0x53, 0x50, 0x45, 0x45, 0x44, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x4c, 0x45, 0x58, 0x52, 0x53, 0x5f, 0x43, 0x4f, 0x53,
	0x54, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x6f, 0x0a,
	0x0e, 0x54, 0x65, 0x61, 0x72, 0x64, 0x6f, 0x77, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x1b, 0x0a, 0x17, 0x54, 0x45, 0x41, 0x52, 0x44, 0x4f, 0x57, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f,
	0x54, 0x45, 0x41, 0x52, 0x44, 0x4f, 0x57, 0x4e, 0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10,
	0x01, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x45, 0x41, 0x52, 0x44, 0x4f, 0x57, 0x4e, 0x5f, 0x4f, 0x4e,
	0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x45,
	0x41, 0x52, 0x44, 0x4f, 0x57, 0x4e, 0x5f, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x03, 0x2a, 0x90,
	0x01, 0x0a, 0x11, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x53, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f,
	0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54,
	0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x4e, 0x4f, 0x4e,
	0x45, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x50,
	0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x10,
	0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x50, 0x41, 0x43,
	0x4b, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10,
	0x03, 0x2a, 0x7a, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x55, 0x54,
	0x4f, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54,
	0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a,
	0x41, 0x55, 0x54, 0x4f, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f,
	0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b,
	0x41, 0x55, 0x54, 0x4f, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f,
	0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x2a, 0x66, 0x0a,
	0x1c, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x50, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x15, 0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x5f, 0x49, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x4f, 0x52, 0x4b,
	0x45, 0x52, 0x5f, 0x49, 0x50, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x10, 0x01, 0x12, 0x15,
	0x0a, 0x11, 0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x5f, 0x49, 0x50, 0x5f, 0x50, 0x52, 0x49, 0x56,
	0x41, 0x54, 0x45, 0x10, 0x02, 0x2a, 0x4c, 0x0a, 0x0b, 0x53, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x48, 0x55, 0x46, 0x46, 0x4c, 0x45, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x4d, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x42, 0x41, 0x53, 0x45,
	0x44, 0x10, 0x02, 0x42, 0xd3, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x42, 0x10, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56,
	0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_dataflow_v1beta3_environment_proto_rawDescOnce sync.Once
	file_google_dataflow_v1beta3_environment_proto_rawDescData = file_google_dataflow_v1beta3_environment_proto_rawDesc
)

func file_google_dataflow_v1beta3_environment_proto_rawDescGZIP() []byte {
	file_google_dataflow_v1beta3_environment_proto_rawDescOnce.Do(func() {
		file_google_dataflow_v1beta3_environment_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_dataflow_v1beta3_environment_proto_rawDescData)
	})
	return file_google_dataflow_v1beta3_environment_proto_rawDescData
}

var file_google_dataflow_v1beta3_environment_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_dataflow_v1beta3_environment_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_dataflow_v1beta3_environment_proto_goTypes = []interface{}{
	(JobType)(0),                      // 0: google.dataflow.v1beta3.JobType
	(FlexResourceSchedulingGoal)(0),   // 1: google.dataflow.v1beta3.FlexResourceSchedulingGoal
	(TeardownPolicy)(0),               // 2: google.dataflow.v1beta3.TeardownPolicy
	(DefaultPackageSet)(0),            // 3: google.dataflow.v1beta3.DefaultPackageSet
	(AutoscalingAlgorithm)(0),         // 4: google.dataflow.v1beta3.AutoscalingAlgorithm
	(WorkerIPAddressConfiguration)(0), // 5: google.dataflow.v1beta3.WorkerIPAddressConfiguration
	(ShuffleMode)(0),                  // 6: google.dataflow.v1beta3.ShuffleMode
	(*Environment)(nil),               // 7: google.dataflow.v1beta3.Environment
	(*Package)(nil),                   // 8: google.dataflow.v1beta3.Package
	(*Disk)(nil),                      // 9: google.dataflow.v1beta3.Disk
	(*WorkerSettings)(nil),            // 10: google.dataflow.v1beta3.WorkerSettings
	(*TaskRunnerSettings)(nil),        // 11: google.dataflow.v1beta3.TaskRunnerSettings
	(*AutoscalingSettings)(nil),       // 12: google.dataflow.v1beta3.AutoscalingSettings
	(*SdkHarnessContainerImage)(nil),  // 13: google.dataflow.v1beta3.SdkHarnessContainerImage
	(*WorkerPool)(nil),                // 14: google.dataflow.v1beta3.WorkerPool
	(*DebugOptions)(nil),              // 15: google.dataflow.v1beta3.DebugOptions
	nil,                               // 16: google.dataflow.v1beta3.WorkerPool.MetadataEntry
	(*structpb.Struct)(nil),           // 17: google.protobuf.Struct
	(*anypb.Any)(nil),                 // 18: google.protobuf.Any
}
var file_google_dataflow_v1beta3_environment_proto_depIdxs = []int32{
	14, // 0: google.dataflow.v1beta3.Environment.worker_pools:type_name -> google.dataflow.v1beta3.WorkerPool
	17, // 1: google.dataflow.v1beta3.Environment.user_agent:type_name -> google.protobuf.Struct
	17, // 2: google.dataflow.v1beta3.Environment.version:type_name -> google.protobuf.Struct
	17, // 3: google.dataflow.v1beta3.Environment.sdk_pipeline_options:type_name -> google.protobuf.Struct
	18, // 4: google.dataflow.v1beta3.Environment.internal_experiments:type_name -> google.protobuf.Any
	1,  // 5: google.dataflow.v1beta3.Environment.flex_resource_scheduling_goal:type_name -> google.dataflow.v1beta3.FlexResourceSchedulingGoal
	6,  // 6: google.dataflow.v1beta3.Environment.shuffle_mode:type_name -> google.dataflow.v1beta3.ShuffleMode
	15, // 7: google.dataflow.v1beta3.Environment.debug_options:type_name -> google.dataflow.v1beta3.DebugOptions
	10, // 8: google.dataflow.v1beta3.TaskRunnerSettings.parallel_worker_settings:type_name -> google.dataflow.v1beta3.WorkerSettings
	4,  // 9: google.dataflow.v1beta3.AutoscalingSettings.algorithm:type_name -> google.dataflow.v1beta3.AutoscalingAlgorithm
	8,  // 10: google.dataflow.v1beta3.WorkerPool.packages:type_name -> google.dataflow.v1beta3.Package
	3,  // 11: google.dataflow.v1beta3.WorkerPool.default_package_set:type_name -> google.dataflow.v1beta3.DefaultPackageSet
	2,  // 12: google.dataflow.v1beta3.WorkerPool.teardown_policy:type_name -> google.dataflow.v1beta3.TeardownPolicy
	11, // 13: google.dataflow.v1beta3.WorkerPool.taskrunner_settings:type_name -> google.dataflow.v1beta3.TaskRunnerSettings
	9,  // 14: google.dataflow.v1beta3.WorkerPool.data_disks:type_name -> google.dataflow.v1beta3.Disk
	16, // 15: google.dataflow.v1beta3.WorkerPool.metadata:type_name -> google.dataflow.v1beta3.WorkerPool.MetadataEntry
	12, // 16: google.dataflow.v1beta3.WorkerPool.autoscaling_settings:type_name -> google.dataflow.v1beta3.AutoscalingSettings
	18, // 17: google.dataflow.v1beta3.WorkerPool.pool_args:type_name -> google.protobuf.Any
	5,  // 18: google.dataflow.v1beta3.WorkerPool.ip_configuration:type_name -> google.dataflow.v1beta3.WorkerIPAddressConfiguration
	13, // 19: google.dataflow.v1beta3.WorkerPool.sdk_harness_container_images:type_name -> google.dataflow.v1beta3.SdkHarnessContainerImage
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_dataflow_v1beta3_environment_proto_init() }
func file_google_dataflow_v1beta3_environment_proto_init() {
	if File_google_dataflow_v1beta3_environment_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_dataflow_v1beta3_environment_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Environment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Disk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskRunnerSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalingSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SdkHarnessContainerImage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_environment_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_dataflow_v1beta3_environment_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_dataflow_v1beta3_environment_proto_goTypes,
		DependencyIndexes: file_google_dataflow_v1beta3_environment_proto_depIdxs,
		EnumInfos:         file_google_dataflow_v1beta3_environment_proto_enumTypes,
		MessageInfos:      file_google_dataflow_v1beta3_environment_proto_msgTypes,
	}.Build()
	File_google_dataflow_v1beta3_environment_proto = out.File
	file_google_dataflow_v1beta3_environment_proto_rawDesc = nil
	file_google_dataflow_v1beta3_environment_proto_goTypes = nil
	file_google_dataflow_v1beta3_environment_proto_depIdxs = nil
}
